@if(setting('kyc_verification', 'permission'))
    <div class="kyc-status-alert mb-3">
        @if(auth()->user()->kyc == \App\Enums\KYCStatus::Verified->value)
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <strong>KYC Verified:</strong> Your account is verified and you can withdraw funds.
            </div>
        @elseif(auth()->user()->kyc == \App\Enums\KYCStatus::Pending->value)
            <div class="alert alert-warning">
                <i class="fas fa-clock"></i>
                <strong>KYC Pending:</strong> Your KYC verification is under review. You cannot withdraw funds until verified.
                <a href="{{ route('user.kyc') }}" class="btn btn-sm btn-warning ml-2">Check Status</a>
            </div>
        @elseif(auth()->user()->kyc == \App\Enums\KYCStatus::Failed->value)
            <div class="alert alert-danger">
                <i class="fas fa-times-circle"></i>
                <strong>KYC Failed:</strong> Your KYC verification was rejected. Please resubmit your documents.
                <a href="{{ route('user.kyc') }}" class="btn btn-sm btn-danger ml-2">Resubmit KYC</a>
            </div>
        @else
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                <strong>KYC Required:</strong> You need to complete KYC verification to withdraw funds.
                <a href="{{ route('user.kyc') }}" class="btn btn-sm btn-info ml-2">Complete KYC</a>
            </div>
        @endif
    </div>
@endif

