<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Register - {{ setting('site_name','Block Wave Trade') }}</title>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
	<style>
		:root {
			--bg: #000000;
			--bg2: #1a1a1a;
			--card: #1a1a1a;
			--stroke: #333333;
			--text: #f8fafc;
			--muted: #94a3b8;
			--brand: #fbbf24;
			--brand2: #f59e0b;
			--lime: #fbbf24;
			--neon: #f59e0b;
		}

		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		html, body {
			height: 100%;
			margin: 0;
			padding: 0;
			background: radial-gradient(1200px 700px at 10% -10%, rgba(251,191,36,.08), transparent 50%), 
						radial-gradient(1200px 700px at 110% 10%, rgba(245,158,11,.05), transparent 50%), 
						linear-gradient(180deg, #000000, #1a1a1a);
			color: var(--text);
			font-family: Inter, system-ui, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
			overflow-x: hidden;
		}

		/* Mobile App Container */
		.mobile-app-container {
			min-height: 100vh;
			display: flex;
			flex-direction: column;
			position: relative;
			overflow: hidden;
		}

		/* Background Effects */
		.bg-effects {
			position: absolute;
			inset: 0;
			overflow: hidden;
			pointer-events: none;
			z-index: 1;
		}

		.bg-glow {
			position: absolute;
			inset: -20%;
			background: radial-gradient(closest-side, rgba(251,191,36,.05), transparent 70%);
			filter: blur(40px);
			animation: float 14s ease-in-out infinite;
		}

		.bg-grid {
			position: absolute;
			left: -10%;
			right: -10%;
			bottom: -5%;
			height: 60%;
			background: linear-gradient(transparent, rgba(251,191,36,.03)), 
						repeating-linear-gradient(0deg, rgba(251,191,36,.06) 0 1px, transparent 1px 40px);
			transform: perspective(800px) rotateX(60deg) translateY(40px);
			mask-image: linear-gradient(to top, black, transparent);
		}

		@keyframes float {
			0%, 100% { transform: translateY(0); }
			50% { transform: translateY(16px); }
		}

		/* Header */
		.app-header {
			position: relative;
			z-index: 10;
			padding: 20px;
			text-align: center;
		}

		.logo-container {
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 16px;
			margin-bottom: 20px;
		}

		.logo {
			width: 60px;
			height: 60px;
			border-radius: 16px;
			background: linear-gradient(135deg, #fbbf24, #f59e0b);
			box-shadow: 0 8px 25px rgba(251,191,36,.4), inset 0 0 15px rgba(251,191,36,.2);
			display: flex;
			align-items: center;
			justify-content: center;
			color: #000;
			font-size: 28px;
			animation: logoGlow 3s ease-in-out infinite;
		}

		@keyframes logoGlow {
			0%, 100% { box-shadow: 0 8px 25px rgba(251,191,36,.4), inset 0 0 15px rgba(251,191,36,.2); }
			50% { box-shadow: 0 12px 35px rgba(251,191,36,.6), inset 0 0 20px rgba(251,191,36,.3); }
		}

		.brand-name {
			font-weight: 800;
			font-size: 28px;
			color: white;
			text-transform: uppercase;
			letter-spacing: 2px;
			text-shadow: 0 2px 8px rgba(0,0,0,.5);
		}

		/* Main Content */
		.app-content {
			flex: 1;
			display: flex;
			flex-direction: column;
			align-items: center;
			justify-content: center;
			padding: 20px;
			position: relative;
			z-index: 5;
		}

		/* Auth Card */
		.auth-card {
			width: 100%;
			max-width: 450px;
			background: rgba(26,26,26,.9);
			border: 1px solid rgba(251,191,36,.2);
			border-radius: 24px;
			padding: 32px;
			box-shadow: 0 20px 50px rgba(0,0,0,.4), 0 0 0 1px rgba(251,191,36,.1) inset;
			backdrop-filter: blur(20px);
			position: relative;
			overflow: hidden;
		}

		.auth-card::before {
			content: '';
			position: absolute;
			top: 0;
			left: 0;
			right: 0;
			height: 3px;
			background: linear-gradient(90deg, transparent, #fbbf24, transparent);
		}

		.auth-title {
			font-size: 28px;
			font-weight: 800;
			text-align: center;
			margin: 0 0 8px;
			color: white;
			text-transform: uppercase;
			letter-spacing: 1px;
		}

		.auth-subtitle {
			font-size: 16px;
			text-align: center;
			margin: 0 0 32px;
			color: rgba(255,255,255,.7);
		}

		/* Form Styles */
		.form-group {
			margin-bottom: 20px;
		}

		.form-label {
			display: block;
			font-size: 14px;
			font-weight: 600;
			color: #fbbf24;
			margin-bottom: 8px;
			text-transform: uppercase;
			letter-spacing: 0.5px;
		}

		.required {
			color: #ef4444;
			margin-left: 4px;
		}

		.input-wrapper {
			position: relative;
		}

		.form-input {
			width: 100%;
			padding: 14px 18px 14px 48px;
			background: rgba(0,0,0,.6);
			border: 1px solid rgba(251,191,36,.3);
			border-radius: 12px;
			color: white;
			font-size: 15px;
			font-weight: 500;
			transition: all 0.3s ease;
			outline: none;
		}

		.form-input:focus {
			border-color: #fbbf24;
			box-shadow: 0 0 0 3px rgba(251,191,36,.2);
			background: rgba(0,0,0,.8);
		}

		.form-input::placeholder {
			color: rgba(255,255,255,.5);
		}

		.input-icon {
			position: absolute;
			left: 16px;
			top: 50%;
			transform: translateY(-50%);
			color: #fbbf24;
			font-size: 15px;
			z-index: 2;
		}

		/* Select Field */
		select.form-input {
			appearance: none;
			background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='%23fbbf24' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6,9 12,15 18,9'%3e%3c/polyline%3e%3c/svg%3e");
			background-repeat: no-repeat;
			background-position: right 16px center;
			background-size: 16px;
			padding-right: 45px;
			cursor: pointer;
		}

		select.form-input option {
			background: #1a1a1a;
			color: white;
			padding: 8px;
		}

		/* Password Toggle */
		.password-toggle {
			position: absolute;
			right: 16px;
			top: 50%;
			transform: translateY(-50%);
			color: rgba(255,255,255,.6);
			font-size: 15px;
			cursor: pointer;
			transition: color 0.3s ease;
			z-index: 2;
		}

		.password-toggle:hover {
			color: #fbbf24;
		}

		/* Terms and Conditions */
		.terms-group {
			display: flex;
			align-items: flex-start;
			gap: 12px;
			margin-bottom: 24px;
		}

		.terms-checkbox {
			width: 18px;
			height: 18px;
			accent-color: #fbbf24;
			margin-top: 2px;
		}

		.terms-label {
			font-size: 14px;
			color: rgba(255,255,255,.8);
			line-height: 1.4;
		}

		.terms-link {
			color: #fbbf24;
			text-decoration: none;
			font-weight: 600;
			transition: color 0.3s ease;
		}

		.terms-link:hover {
			color: #f59e0b;
		}

		/* Submit Button */
		.submit-btn {
			width: 100%;
			background: linear-gradient(135deg, #fbbf24, #f59e0b);
			color: #000;
			border: none;
			border-radius: 12px;
			padding: 16px;
			font-weight: 800;
			font-size: 16px;
			text-transform: uppercase;
			letter-spacing: 1px;
			box-shadow: 0 8px 25px rgba(251,191,36,.4);
			position: relative;
			overflow: hidden;
			transition: all 0.3s ease;
			cursor: pointer;
			margin-bottom: 20px;
		}

		.submit-btn::before {
			content: '';
			position: absolute;
			top: 0;
			left: -100%;
			width: 100%;
			height: 100%;
			background: linear-gradient(90deg, transparent, rgba(255,255,255,.3), transparent);
			transition: left 0.6s ease;
		}

		.submit-btn:hover::before {
			left: 100%;
		}

		.submit-btn:hover {
			transform: translateY(-2px);
			box-shadow: 0 12px 35px rgba(251,191,36,.5);
		}

		.submit-btn:active {
			transform: translateY(0);
		}

		/* Divider */
		.divider {
			display: flex;
			align-items: center;
			margin: 20px 0;
		}

		.divider::before,
		.divider::after {
			content: '';
			flex: 1;
			height: 1px;
			background: rgba(251,191,36,.3);
		}

		.divider-text {
			padding: 0 16px;
			font-size: 14px;
			color: rgba(255,255,255,.6);
			text-transform: uppercase;
			letter-spacing: 1px;
		}

		/* Login Link */
		.login-link {
			text-align: center;
			font-size: 14px;
			color: rgba(255,255,255,.7);
		}

		.login-link a {
			color: #fbbf24;
			text-decoration: none;
			font-weight: 700;
			transition: color 0.3s ease;
		}

		.login-link a:hover {
			color: #f59e0b;
		}

		/* Error Messages */
		.alert-error {
			background: rgba(239,68,68,.1);
			border: 1px solid rgba(239,68,68,.3);
			border-radius: 8px;
			padding: 12px;
			margin-bottom: 20px;
			color: #ef4444;
			font-size: 14px;
			font-weight: 500;
		}

		/* Success Messages */
		.alert-success {
			background: rgba(16,185,129,.1);
			border: 1px solid rgba(16,185,129,.3);
			border-radius: 8px;
			padding: 12px;
			margin-bottom: 20px;
			color: #10b981;
			font-size: 14px;
			font-weight: 500;
		}

		/* Mobile Responsive */
		@media (max-width: 768px) {
			.app-header {
				padding: 15px;
			}

			.logo {
				width: 50px;
				height: 50px;
				font-size: 24px;
			}

			.brand-name {
				font-size: 24px;
			}

			.app-content {
				padding: 15px;
			}

			.auth-card {
				padding: 28px 24px;
			}

			.auth-title {
				font-size: 24px;
			}

			.form-group {
				margin-bottom: 18px;
			}
		}

		@media (max-width: 480px) {
			.app-header {
				padding: 10px;
			}

			.logo {
				width: 45px;
				height: 45px;
				font-size: 20px;
			}

			.brand-name {
				font-size: 20px;
			}

			.app-content {
				padding: 10px;
			}

			.auth-card {
				padding: 24px 20px;
			}

			.auth-title {
				font-size: 22px;
			}
		}

		/* Loading Animation */
		.loading-overlay {
			position: fixed;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			background: rgba(0,0,0,.9);
			display: none;
			align-items: center;
			justify-content: center;
			z-index: 9999;
			opacity: 0;
			transition: opacity 0.5s ease;
		}

		.loading-overlay.show {
			display: flex;
			opacity: 1;
		}

		.loading-spinner {
			width: 50px;
			height: 50px;
			border: 4px solid rgba(251,191,36,.2);
			border-top: 4px solid #fbbf24;
			border-radius: 50%;
			animation: spin 1s linear infinite;
		}

		@keyframes spin {
			0% { transform: rotate(0deg); }
			100% { transform: rotate(360deg); }
		}

		.loading-text {
			color: #fbbf24;
			font-size: 16px;
			font-weight: 600;
			margin-top: 16px;
			text-align: center;
		}
	</style>
</head>
<body>
	<!-- Loading Overlay -->
	<div class="loading-overlay" id="loadingOverlay">
		<div style="text-align: center;">
			<div class="loading-spinner"></div>
			<div class="loading-text">Creating Account...</div>
		</div>
	</div>

	<!-- Background Effects -->
	<div class="bg-effects">
		<div class="bg-glow"></div>
		<div class="bg-grid"></div>
	</div>

	<!-- Mobile App Container -->
	<div class="mobile-app-container">
		<!-- Header -->
		<header class="app-header">
			<div class="logo-container">
				<div class="logo">
					<i class="fas fa-coins"></i>
				</div>
				<div class="brand-name">{{ setting('site_name','Block Wave Trade') }}</div>
			</div>
		</header>

		<!-- Main Content -->
		<main class="app-content">
			<div class="auth-card">
				<h1 class="auth-title">Join Us Today!</h1>
				<p class="auth-subtitle">Create your account and start investing</p>

				@if ($errors->any())
					<div class="alert-error">
						@foreach($errors->all() as $error)
							<span>{{ $error }}</span>
						@endforeach
					</div>
				@endif

				@if (session('success'))
					<div class="alert-success">
						{{ session('success') }}
					</div>
				@endif

				<form method="POST" action="{{ route('register') }}" id="registerForm">
					@csrf
					
					<div class="form-group">
						<label for="first_name" class="form-label">First Name<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="text" id="first_name" name="first_name" class="form-input" placeholder="Enter your first name" value="{{ old('first_name') }}" required>
							<i class="fas fa-user input-icon"></i>
						</div>
					</div>

					<div class="form-group">
						<label for="last_name" class="form-label">Last Name<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="text" id="last_name" name="last_name" class="form-input" placeholder="Enter your last name" value="{{ old('last_name') }}" required>
							<i class="fas fa-user input-icon"></i>
						</div>
					</div>

					<div class="form-group">
						<label for="email" class="form-label">Email Address<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="email" id="email" name="email" class="form-input" placeholder="Enter your email" value="{{ old('email') }}" required>
							<i class="fas fa-envelope input-icon"></i>
						</div>
					</div>

					<div class="form-group">
						<label for="username" class="form-label">Username<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="text" id="username" name="username" class="form-input" placeholder="Choose a username" value="{{ old('username') }}" required>
							<i class="fas fa-at input-icon"></i>
						</div>
					</div>

					<div class="form-group">
						<label for="country" class="form-label">Country<span class="required">*</span></label>
						<div class="input-wrapper">
							<select id="country" name="country" class="form-input" required>
								<option value="">Select your country</option>
								<option value="Pakistan" {{ old('country') == 'Pakistan' ? 'selected' : '' }}>Pakistan</option>
								<option value="India" {{ old('country') == 'India' ? 'selected' : '' }}>India</option>
								<option value="United States" {{ old('country') == 'United States' ? 'selected' : '' }}>United States</option>
								<option value="United Kingdom" {{ old('country') == 'United Kingdom' ? 'selected' : '' }}>United Kingdom</option>
								<option value="Canada" {{ old('country') == 'Canada' ? 'selected' : '' }}>Canada</option>
								<option value="Australia" {{ old('country') == 'Australia' ? 'selected' : '' }}>Australia</option>
								<option value="Germany" {{ old('country') == 'Germany' ? 'selected' : '' }}>Germany</option>
								<option value="France" {{ old('country') == 'France' ? 'selected' : '' }}>France</option>
								<option value="Other" {{ old('country') == 'Other' ? 'selected' : '' }}>Other</option>
							</select>
							<i class="fas fa-globe input-icon"></i>
						</div>
					</div>

					<div class="form-group">
						<label for="phone" class="form-label">Phone Number<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="tel" id="phone" name="phone" class="form-input" placeholder="Enter your phone number" value="{{ old('phone') }}" required>
							<i class="fas fa-phone input-icon"></i>
						</div>
					</div>

					<div class="form-group">
						<label for="password" class="form-label">Password<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="password" id="password" name="password" class="form-input" placeholder="Create a password" required>
							<i class="fas fa-lock input-icon"></i>
							<span class="password-toggle" onclick="togglePassword()">
								<i class="fas fa-eye" id="passwordToggleIcon"></i>
							</span>
						</div>
					</div>

					<div class="form-group">
						<label for="password_confirmation" class="form-label">Confirm Password<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="password" id="password_confirmation" name="password_confirmation" class="form-input" placeholder="Confirm your password" required>
							<i class="fas fa-lock input-icon"></i>
							<span class="password-toggle" onclick="toggleConfirmPassword()">
								<i class="fas fa-eye" id="confirmPasswordToggleIcon"></i>
							</span>
						</div>
					</div>

					<div class="terms-group">
						<input type="checkbox" id="i_agree" name="i_agree" class="terms-checkbox" required>
						<label for="i_agree" class="terms-label">
							I agree to the <a href="#" class="terms-link">Terms of Service</a> and <a href="#" class="terms-link">Privacy Policy</a>
						</label>
					</div>

					<button type="submit" class="submit-btn">
						<i class="fas fa-user-plus"></i>
						Create Account
					</button>
				</form>

				<div class="divider">
					<span class="divider-text">Already have an account?</span>
				</div>

				<div class="login-link">
					<a href="{{ route('login') }}">
						<i class="fas fa-sign-in-alt"></i>
						Sign In
					</a>
				</div>
			</div>
		</main>
	</div>

	<script>
		// Password toggle functionality
		function togglePassword() {
			const passwordInput = document.getElementById('password');
			const toggleIcon = document.getElementById('passwordToggleIcon');
			
			if (passwordInput.type === 'password') {
				passwordInput.type = 'text';
				toggleIcon.classList.remove('fa-eye');
				toggleIcon.classList.add('fa-eye-slash');
			} else {
				passwordInput.type = 'password';
				toggleIcon.classList.remove('fa-eye-slash');
				toggleIcon.classList.add('fa-eye');
			}
		}

		function toggleConfirmPassword() {
			const passwordInput = document.getElementById('password_confirmation');
			const toggleIcon = document.getElementById('confirmPasswordToggleIcon');
			
			if (passwordInput.type === 'password') {
				passwordInput.type = 'text';
				toggleIcon.classList.remove('fa-eye');
				toggleIcon.classList.add('fa-eye-slash');
			} else {
				passwordInput.type = 'password';
				toggleIcon.classList.remove('fa-eye-slash');
				toggleIcon.classList.add('fa-eye');
			}
		}

		// Form submission with loading
		document.getElementById('registerForm').addEventListener('submit', function(e) {
			const loadingOverlay = document.getElementById('loadingOverlay');
			loadingOverlay.classList.add('show');
		});

		// Add ripple effect to buttons
		document.querySelectorAll('.submit-btn').forEach(btn => {
			btn.addEventListener('click', function(e) {
				const ripple = document.createElement('span');
				const rect = this.getBoundingClientRect();
				const size = Math.max(rect.width, rect.height);
				const x = e.clientX - rect.left - size / 2;
				const y = e.clientY - rect.top - size / 2;
				
				ripple.style.width = ripple.style.height = size + 'px';
				ripple.style.left = x + 'px';
				ripple.style.top = y + 'px';
				ripple.style.position = 'absolute';
				ripple.style.borderRadius = '50%';
				ripple.style.background = 'rgba(255,255,255,0.3)';
				ripple.style.transform = 'scale(0)';
				ripple.style.animation = 'ripple 0.6s linear';
				ripple.style.pointerEvents = 'none';
				
				this.style.position = 'relative';
				this.style.overflow = 'hidden';
				this.appendChild(ripple);
				
				setTimeout(() => {
					ripple.remove();
				}, 600);
			});
		});

		// Add ripple animation
		const style = document.createElement('style');
		style.textContent = `
			@keyframes ripple {
				to {
					transform: scale(4);
					opacity: 0;
				}
			}
		`;
		document.head.appendChild(style);

		// Auto-hide alerts after 5 seconds
		setTimeout(() => {
			const alerts = document.querySelectorAll('.alert-error, .alert-success');
			alerts.forEach(alert => {
				alert.style.opacity = '0';
				alert.style.transform = 'translateY(-10px)';
				setTimeout(() => {
					alert.remove();
				}, 300);
			});
		}, 5000);

		// Password strength indicator
		document.getElementById('password').addEventListener('input', function() {
			const password = this.value;
			const strength = getPasswordStrength(password);
			// You can add visual feedback here if needed
		});

		function getPasswordStrength(password) {
			let strength = 0;
			if (password.length >= 8) strength++;
			if (/[a-z]/.test(password)) strength++;
			if (/[A-Z]/.test(password)) strength++;
			if (/[0-9]/.test(password)) strength++;
			if (/[^A-Za-z0-9]/.test(password)) strength++;
			return strength;
		}
	</script>
</body>
</html>