@extends('frontend::layouts.user')

@section('title')
    {{ __('Achievement Dashboard') }}
@endsection

@section('content')
<div class="achievement-container">
    <!-- Hero Section -->
    <div class="achievement-hero">
        <div class="hero-content">
            <div class="hero-icon">🏆</div>
            <h1 class="hero-title">{{ __('Achievement Dashboard') }}</h1>
            <p class="hero-subtitle">{{ __('Track your progress, unlock new ranks, and dominate the leaderboard') }}</p>
        </div>
    </div>

    <!-- Main Content -->
    <div class="achievement-main">
        <!-- Current Rank Progress -->
        <div class="glass-card rank-progress-card">
            <div class="card-header">
                <h3 class="card-title">🎯 {{ __('Current Rank Progress') }}</h3>
                <p class="card-subtitle">{{ __('Your journey to the next level') }}</p>
            </div>
            
            <div class="rank-overview">
                <div class="rank-grid">
                    <div class="rank-item current-rank">
                        <div class="rank-icon">👑</div>
                        <div class="rank-info">
                            <h4 class="rank-label">{{ __('CURRENT RANK') }}</h4>
                            <div class="rank-name">
                                @if(isset($currentRankName) && $currentRankName)
                                    {{ $currentRankName }}
                                @else
                                    {{ __('No Rank') }}
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div class="rank-item next-rank">
                        <div class="rank-icon">⭐</div>
                        <div class="rank-info">
                            <h4 class="rank-label">{{ __('NEXT TARGET') }}</h4>
                            <div class="rank-name">
                                @if(isset($nextRankName) && $nextRankName)
                                    {{ $nextRankName }}
                                @else
                                    {{ __('Max Rank Achieved') }}
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="progress-section">
                    <div class="progress-header">
                        <span class="progress-label">
                            @if(isset($currentRankName) && $currentRankName)
                                {{ $currentRankName }}
                            @else
                                {{ __('No Rank') }}
                            @endif
                        </span>
                        <span class="progress-label">
                            @if(isset($nextRankName) && $nextRankName)
                                {{ $nextRankName }}
                            @else
                                {{ __('Max Rank') }}
                            @endif
                        </span>
                    </div>
                    
                    <div class="progress-bar-container">
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: {{ $progressPercentage ?? 0 }}%"></div>
                        </div>
                        <div class="progress-text">
                            @if(isset($currentProgress) && isset($targetAmount) && $targetAmount > 0)
                                ${{ number_format($currentProgress) }}/${{ number_format($targetAmount) }} USD ({{ $progressPercentage ?? 0 }}%)
                            @else
                                {{ __('No progress data available') }}
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="stats-section">
            <div class="stats-grid">
                <div class="stat-card referrals-card">
                    <div class="stat-icon">👥</div>
                    <div class="stat-content">
                        <div class="stat-number">{{ $totalReferrals ?? 0 }}</div>
                        <div class="stat-label">{{ __('Total Referrals') }}</div>
                    </div>
                    <div class="stat-glow"></div>
                </div>
                
                <div class="stat-card earnings-card">
                    <div class="stat-icon">💰</div>
                    <div class="stat-content">
                        <div class="stat-number">${{ number_format($totalEarnings ?? 0) }}</div>
                        <div class="stat-label">{{ __('Total Earnings') }}</div>
                    </div>
                    <div class="stat-glow"></div>
                </div>
                
                <div class="stat-card target-card">
                    <div class="stat-icon">🎯</div>
                    <div class="stat-content">
                        <div class="stat-number">${{ number_format($targetAmount ?? 3600) }}</div>
                        <div class="stat-label">{{ __('Required Total') }}</div>
                    </div>
                    <div class="stat-glow"></div>
                </div>
            </div>
        </div>

        <!-- Ranks Table -->
        <div class="glass-card ranks-card">
            <div class="card-header">
                <h3 class="card-title">🏅 {{ __('Available Ranks') }}</h3>
                <p class="card-subtitle">{{ __('Unlock new levels and earn greater rewards') }}</p>
            </div>
            
            <div class="ranks-table-container">
                <div class="ranks-table">
                    <div class="table-header">
                        <div class="header-cell rank-header">{{ __('Rank') }}</div>
                        <div class="header-cell volume-header">{{ __('Team Volume (x4)') }}</div>
                        <div class="header-cell total-header">{{ __('Total Volume') }}</div>
                        <div class="header-cell reward-header">{{ __('Reward') }}</div>
                        <div class="header-cell salary-header">{{ __('Salary') }}</div>
                    </div>
                    
                    <div class="table-body">
                        <div class="table-row">
                            <div class="table-cell rank-cell">
                                <div class="rank-badge leader">🥇 {{ __('Leader') }}</div>
                            </div>
                            <div class="table-cell">$900 × 4</div>
                            <div class="table-cell">$3,600</div>
                            <div class="table-cell">$200</div>
                            <div class="table-cell">$20</div>
                        </div>
                        
                        <div class="table-row">
                            <div class="table-cell rank-cell">
                                <div class="rank-badge senior-leader">🥈 {{ __('Senior Team Leader') }}</div>
                            </div>
                            <div class="table-cell">$3,600 × 4</div>
                            <div class="table-cell">$14,400</div>
                            <div class="table-cell">$400</div>
                            <div class="table-cell">$40</div>
                        </div>
                        
                        <div class="table-row">
                            <div class="table-cell rank-cell">
                                <div class="rank-badge sales-manager">🥉 {{ __('Sales Manager') }}</div>
                            </div>
                            <div class="table-cell">$14,400 × 4</div>
                            <div class="table-cell">$57,600</div>
                            <div class="table-cell">$1,600</div>
                            <div class="table-cell">$80</div>
                        </div>
                        
                        <div class="table-row">
                            <div class="table-cell rank-cell">
                                <div class="rank-badge senior-sales">🏅 {{ __('Senior Sales Manager') }}</div>
                            </div>
                            <div class="table-cell">$57,600 × 4</div>
                            <div class="table-cell">$230,400</div>
                            <div class="table-cell">$6,400</div>
                            <div class="table-cell">$160</div>
                        </div>
                        
                        <div class="table-row">
                            <div class="table-cell rank-cell">
                                <div class="rank-badge director">🎖 {{ __('Director') }}</div>
                            </div>
                            <div class="table-cell">$230,400 × 4</div>
                            <div class="table-cell">$921,600</div>
                            <div class="table-cell">$25,600</div>
                            <div class="table-cell">$320</div>
                        </div>
                        
                        <div class="table-row">
                            <div class="table-cell rank-cell">
                                <div class="rank-badge ambassador">🌍 {{ __('Global Ambassador') }}</div>
                            </div>
                            <div class="table-cell">$921,600 × 4</div>
                            <div class="table-cell">$3,686,400</div>
                            <div class="table-cell">$102,400</div>
                            <div class="table-cell">$1,000</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Referral Users -->
        <div class="glass-card referrals-card">
            <div class="card-header">
                <h3 class="card-title">👥 {{ __('Referral Users Progress') }}</h3>
                <p class="card-subtitle">{{ __('Track your team\'s achievements and growth') }}</p>
            </div>
            
            @if(isset($referralUsers) && count($referralUsers) > 0)
                <div class="referrals-grid">
                    @foreach($referralUsers as $referralUser)
                    <div class="referral-item">
                        <div class="referral-header">
                            <div class="user-avatar">
                                <div class="avatar-icon">👤</div>
                            </div>
                            <div class="user-info">
                                <div class="user-name">{{ $referralUser->username ?? 'Unknown' }}</div>
                                <div class="user-email">{{ $referralUser->email ?? 'No email' }}</div>
                            </div>
                        </div>
                        
                        <div class="referral-stats">
                            <div class="stat-row">
                                <span class="stat-label">{{ __('Balance') }}</span>
                                <span class="stat-value">${{ number_format($referralUser->total_deposit ?? 0) }}</span>
                            </div>
                            <div class="stat-row">
                                <span class="stat-label">{{ __('Investment') }}</span>
                                <span class="stat-value">${{ number_format($referralUser->total_invest ?? 0) }}</span>
                            </div>
                            <div class="stat-row">
                                <span class="stat-label">{{ __('Profit') }}</span>
                                <span class="stat-value">${{ number_format($referralUser->total_profit ?? 0) }}</span>
                            </div>
                            <div class="stat-row">
                                <span class="stat-label">{{ __('Join Date') }}</span>
                                <span class="stat-value">{{ $referralUser->join_date ? \Carbon\Carbon::parse($referralUser->join_date)->format('M d, Y') : 'N/A' }}</span>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            @else
                <div class="empty-state">
                    <div class="empty-icon">📭</div>
                    <h4 class="empty-title">{{ __('No Referral Users Yet') }}</h4>
                    <p class="empty-desc">{{ __('Start referring users to see their progress and achievements here') }}</p>
                    <div class="empty-action">
                        <a href="{{ route('user.dashboard') }}" class="action-btn">{{ __('Invite Friends') }}</a>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
/* Achievement Page Styles */
.achievement-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 20px;
}

.achievement-hero {
    text-align: center;
    margin-bottom: 40px;
    padding: 40px 20px;
}

.hero-content {
    max-width: 600px;
    margin: 0 auto;
}

.hero-icon {
    font-size: 4rem;
    margin-bottom: 20px;
    animation: float 3s ease-in-out infinite;
}

.hero-title {
    font-size: 3rem;
    font-weight: 700;
    color: white;
    margin-bottom: 15px;
    text-shadow: 0 4px 8px rgba(0,0,0,0.3);
}

.hero-subtitle {
    font-size: 1.2rem;
    color: rgba(255,255,255,0.9);
    line-height: 1.6;
}

.achievement-main {
    max-width: 1200px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    gap: 30px;
}

.glass-card {
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    border: 1px solid rgba(255,255,255,0.2);
    padding: 30px;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.card-header {
    text-align: center;
    margin-bottom: 30px;
}

.card-title {
    font-size: 1.8rem;
    font-weight: 600;
    color: white;
    margin-bottom: 10px;
}

.card-subtitle {
    color: rgba(255,255,255,0.8);
    font-size: 1rem;
}

/* Rank Progress Section */
.rank-overview {
    display: flex;
    flex-direction: column;
    gap: 30px;
}

.rank-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
}

.rank-item {
    background: rgba(255,255,255,0.08);
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 15px;
    padding: 25px;
    text-align: center;
    transition: all 0.3s ease;
}

.rank-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.2);
}

.rank-icon {
    font-size: 2.5rem;
    margin-bottom: 15px;
}

.rank-label {
    font-size: 0.9rem;
    color: rgba(255,255,255,0.7);
    margin-bottom: 10px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.rank-name {
    font-size: 1.3rem;
    font-weight: 600;
    color: white;
}

.current-rank {
    background: linear-gradient(135deg, rgba(255, 193, 7, 0.2) 0%, rgba(255, 193, 7, 0.1) 100%);
    border-color: rgba(255, 193, 7, 0.3);
}

.next-rank {
    background: linear-gradient(135deg, rgba(76, 175, 80, 0.2) 0%, rgba(76, 175, 80, 0.1) 100%);
    border-color: rgba(76, 175, 80, 0.3);
}

/* Progress Section */
.progress-section {
    background: rgba(255,255,255,0.05);
    border-radius: 15px;
    padding: 25px;
}

.progress-header {
    display: flex;
    justify-content: space-between;
    margin-bottom: 15px;
}

.progress-label {
    color: rgba(255,255,255,0.8);
    font-size: 0.9rem;
    font-weight: 500;
}

.progress-bar-container {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.progress-bar {
    height: 12px;
    background: rgba(255,255,255,0.1);
    border-radius: 10px;
    overflow: hidden;
    position: relative;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #4caf50, #8bc34a);
    border-radius: 10px;
    transition: width 0.5s ease;
    position: relative;
}

.progress-fill::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
    animation: shimmer 2s infinite;
}

.progress-text {
    text-align: center;
    color: rgba(255,255,255,0.8);
    font-size: 0.9rem;
    font-weight: 500;
}

/* Statistics Section */
.stats-section {
    margin-bottom: 30px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}

.stat-card {
    background: rgba(255,255,255,0.08);
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 15px;
    padding: 25px;
    text-align: center;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.2);
}

.stat-icon {
    font-size: 2.5rem;
    margin-bottom: 15px;
}

.stat-content {
    position: relative;
    z-index: 2;
}

.stat-number {
    font-size: 2rem;
    font-weight: 700;
    color: white;
    margin-bottom: 5px;
}

.stat-label {
    color: rgba(255,255,255,0.8);
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.stat-glow {
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.stat-card:hover .stat-glow {
    opacity: 1;
}

.referrals-card {
    background: linear-gradient(135deg, rgba(78, 205, 196, 0.2) 0%, rgba(78, 205, 196, 0.1) 100%);
    border-color: rgba(78, 205, 196, 0.3);
}

.earnings-card {
    background: linear-gradient(135deg, rgba(76, 175, 80, 0.2) 0%, rgba(76, 175, 80, 0.1) 100%);
    border-color: rgba(76, 175, 80, 0.3);
}

.target-card {
    background: linear-gradient(135deg, rgba(255, 107, 107, 0.2) 0%, rgba(255, 107, 107, 0.1) 100%);
    border-color: rgba(255, 107, 107, 0.3);
}

/* Ranks Table */
.ranks-table-container {
    overflow-x: auto;
}

.ranks-table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
}

.table-header {
    display: grid;
    grid-template-columns: 1.5fr 1fr 1fr 1fr 1fr;
    gap: 15px;
    margin-bottom: 15px;
}

.header-cell {
    background: rgba(255,255,255,0.1);
    color: white;
    font-weight: 600;
    padding: 15px;
    text-align: center;
    border-radius: 10px;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.table-body {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.table-row {
    display: grid;
    grid-template-columns: 1.5fr 1fr 1fr 1fr 1fr;
    gap: 15px;
    background: rgba(255,255,255,0.05);
    border-radius: 10px;
    padding: 15px;
    transition: all 0.3s ease;
}

.table-row:hover {
    background: rgba(255,255,255,0.08);
    transform: translateX(5px);
}

.table-cell {
    color: white;
    font-weight: 500;
    text-align: center;
    display: flex;
    align-items: center;
    justify-content: center;
}

.rank-cell {
    justify-content: flex-start;
}

.rank-badge {
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.rank-badge.leader {
    background: linear-gradient(135deg, #ffc107, #ff9800);
    color: #333;
}

.rank-badge.senior-leader {
    background: linear-gradient(135deg, #2196f3, #1976d2);
    color: white;
}

.rank-badge.sales-manager {
    background: linear-gradient(135deg, #4caf50, #388e3c);
    color: white;
}

.rank-badge.senior-sales {
    background: linear-gradient(135deg, #9c27b0, #7b1fa2);
    color: white;
}

.rank-badge.director {
    background: linear-gradient(135deg, #ff9800, #f57c00);
    color: white;
}

.rank-badge.ambassador {
    background: linear-gradient(135deg, #607d8b, #455a64);
    color: white;
}

/* Referrals Section */
.referrals-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 20px;
}

.referral-item {
    background: rgba(255,255,255,0.08);
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 15px;
    padding: 20px;
    transition: all 0.3s ease;
}

.referral-item:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
}

.referral-header {
    display: flex;
    align-items: center;
    margin-bottom: 20px;
}

.user-avatar {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #4ecdc4, #44a08d);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
}

.avatar-icon {
    font-size: 1.5rem;
}

.user-info {
    flex: 1;
}

.user-name {
    color: white;
    font-weight: 600;
    font-size: 1.1rem;
    margin-bottom: 5px;
}

.user-email {
    color: rgba(255,255,255,0.7);
    font-size: 0.9rem;
}

.referral-stats {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.stat-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255,255,255,0.1);
}

.stat-row:last-child {
    border-bottom: none;
}

.stat-label {
    color: rgba(255,255,255,0.7);
    font-size: 0.9rem;
}

.stat-value {
    color: white;
    font-weight: 600;
    font-size: 0.95rem;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 60px 20px;
}

.empty-icon {
    font-size: 4rem;
    margin-bottom: 20px;
    opacity: 0.7;
}

.empty-title {
    color: white;
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 10px;
}

.empty-desc {
    color: rgba(255,255,255,0.8);
    font-size: 1rem;
    margin-bottom: 30px;
    line-height: 1.6;
}

.empty-action {
    display: flex;
    justify-content: center;
}

.action-btn {
    display: inline-block;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    text-decoration: none;
    padding: 15px 30px;
    border-radius: 15px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
}

.action-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 35px rgba(102, 126, 234, 0.4);
    color: white;
}

/* Animations */
@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-10px); }
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .achievement-container {
        padding: 15px;
    }
    
    .hero-title {
        font-size: 2rem;
    }
    
    .hero-subtitle {
        font-size: 1rem;
    }
    
    .glass-card {
        padding: 20px;
    }
    
    .rank-grid {
        grid-template-columns: 1fr;
        gap: 15px;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
        gap: 15px;
    }
    
    .table-header,
    .table-row {
        grid-template-columns: 1fr;
        gap: 10px;
    }
    
    .header-cell,
    .table-cell {
        padding: 10px;
        font-size: 0.85rem;
    }
    
    .rank-cell {
        justify-content: center;
    }
    
    .referrals-grid {
        grid-template-columns: 1fr;
        gap: 15px;
    }
    
    .referral-header {
        flex-direction: column;
        text-align: center;
        gap: 15px;
    }
    
    .user-avatar {
        margin-right: 0;
    }
}

@media (max-width: 480px) {
    .hero-icon {
        font-size: 3rem;
    }
    
    .hero-title {
        font-size: 1.8rem;
    }
    
    .card-title {
        font-size: 1.5rem;
    }
    
    .rank-icon {
        font-size: 2rem;
    }
    
    .rank-name {
        font-size: 1.1rem;
    }
    
    .stat-icon {
        font-size: 2rem;
    }
    
    .stat-number {
        font-size: 1.5rem;
    }
    
    .empty-icon {
        font-size: 3rem;
    }
    
    .empty-title {
        font-size: 1.3rem;
    }
    
    .action-btn {
        padding: 12px 25px;
        font-size: 0.9rem;
    }
}
</style>

@endsection
