@php
    $landingContent =\App\Models\LandingContent::where('type','counter')->where('locale',app()->getLocale())->get();
@endphp

<!-- Professional Statistics Section -->
<section class="professional-statistics-section">
    <div class="stats-background">
        <div class="stats-gradient-overlay"></div>
        <div class="stats-particles"></div>
    </div>
    
    <div class="container">
        <div class="stats-grid">
            @foreach($landingContent as $index => $content)
            <div class="stat-card" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="{{ $index * 200 }}">
                <div class="card-glow"></div>
                <div class="card-content">
                    <div class="stat-icon">
                        <div class="icon-wrapper">
                            @if(content_exists($content->icon))
                                <img src="{{ asset($content->icon) }}" alt="{{ $content->title }}" class="icon-image">
                            @else
                                <span class="icon-text">{{ $content->icon }}</span>
                            @endif
                        </div>
                        <div class="icon-ring"></div>
                        <div class="icon-shine"></div>
                    </div>
                    
                    <div class="stat-info">
                        <h3 class="stat-number">{{ $content->description }}</h3>
                        <p class="stat-label">{{ $content->title }}</p>
                    </div>
                    
                    <div class="stat-particles">
                        <div class="particle"></div>
                        <div class="particle"></div>
                        <div class="particle"></div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>

<style>
/* Professional Statistics Section Styles */
.professional-statistics-section {
    position: relative;
    padding: 120px 0;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
    overflow: hidden;
}

.stats-background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.stats-gradient-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle at 25% 25%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 75% 75%, rgba(236, 72, 153, 0.1) 0%, transparent 50%);
}

.stats-particles {
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: 
        radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
        radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent);
    background-repeat: repeat;
    background-size: 100px 100px;
    animation: float 30s infinite linear;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 30px;
    position: relative;
    z-index: 2;
}

.stat-card {
    position: relative;
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    padding: 40px 30px;
    transition: all 0.4s ease;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
    text-align: center;
}

.stat-card:hover {
    transform: translateY(-10px);
    border-color: rgba(99, 102, 241, 0.3);
    box-shadow: 0 30px 60px rgba(99, 102, 241, 0.1);
}

.card-glow {
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(99, 102, 241, 0.1) 0%, transparent 70%);
    opacity: 0;
    transition: opacity 0.4s ease;
    pointer-events: none;
}

.stat-card:hover .card-glow {
    opacity: 1;
}

.card-content {
    position: relative;
    z-index: 2;
}

.stat-icon {
    position: relative;
    width: 80px;
    height: 80px;
    margin: 0 auto 30px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.icon-wrapper {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 2px solid rgba(99, 102, 241, 0.3);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    z-index: 2;
    transition: all 0.4s ease;
}

.stat-card:hover .icon-wrapper {
    transform: scale(1.1);
    border-color: rgba(99, 102, 241, 0.5);
}

.icon-image {
    width: 40px;
    height: 40px;
    object-fit: contain;
}

.icon-text {
    font-size: 2rem;
    color: #6366f1;
    font-weight: 700;
}

.icon-ring {
    position: absolute;
    top: -10px;
    left: -10px;
    right: -10px;
    bottom: -10px;
    border: 2px solid rgba(99, 102, 241, 0.2);
    border-radius: 30px;
    animation: rotate 10s infinite linear;
}

.icon-shine {
    position: absolute;
    top: -5px;
    left: -5px;
    right: -5px;
    bottom: -5px;
    background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.1), transparent);
    border-radius: 25px;
    opacity: 0;
    transition: opacity 0.4s ease;
}

.stat-card:hover .icon-shine {
    opacity: 1;
    animation: shine 2s infinite;
}

.stat-info {
    text-align: center;
}

.stat-number {
    font-size: 2.5rem;
    font-weight: 900;
    color: #ffffff;
    margin-bottom: 15px;
    background: linear-gradient(135deg, #6366f1, #ec4899);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    line-height: 1.2;
}

.stat-label {
    font-size: 1.1rem;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.8);
    margin: 0;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.stat-particles {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    overflow: hidden;
}

.particle {
    position: absolute;
    width: 4px;
    height: 4px;
    background: rgba(99, 102, 241, 0.6);
    border-radius: 50%;
    animation: particle-float 6s infinite ease-in-out;
}

.particle:nth-child(1) {
    top: 20%;
    left: 20%;
    animation-delay: 0s;
}

.particle:nth-child(2) {
    top: 60%;
    right: 20%;
    animation-delay: 2s;
}

.particle:nth-child(3) {
    bottom: 20%;
    left: 60%;
    animation-delay: 4s;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

@keyframes rotate {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes shine {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

@keyframes particle-float {
    0%, 100% { transform: translateY(0px) rotate(0deg); opacity: 0.6; }
    50% { transform: translateY(-20px) rotate(180deg); opacity: 1; }
}

/* Responsive Design */
@media (max-width: 768px) {
    .professional-statistics-section {
        padding: 80px 0;
    }
    
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 25px;
    }
    
    .stat-card {
        padding: 30px 20px;
    }
    
    .stat-icon {
        width: 70px;
        height: 70px;
        margin-bottom: 25px;
    }
    
    .icon-wrapper {
        width: 70px;
        height: 70px;
    }
    
    .stat-number {
        font-size: 2rem;
    }
    
    .stat-label {
        font-size: 1rem;
    }
}

@media (max-width: 480px) {
    .stats-grid {
        grid-template-columns: 1fr;
        gap: 20px;
    }
    
    .stat-card {
        padding: 25px 15px;
    }
    
    .stat-icon {
        width: 60px;
        height: 60px;
        margin-bottom: 20px;
    }
    
    .icon-wrapper {
        width: 60px;
        height: 60px;
    }
    
    .icon-text {
        font-size: 1.5rem;
    }
    
    .stat-number {
        font-size: 1.8rem;
    }
    
    .stat-label {
        font-size: 0.9rem;
    }
}
</style>
