<!-- Professional Side Socials -->
<div class="professional-side-socials">
    @foreach($socials as $social)
    <a href="{{ url($social->url) }}" class="social-link {{ Str::lower($social->icon_name) }}" data-aos="fade-left" data-aos-delay="{{ $loop->index * 100 }}">
        <i class="{{ $social->class_name }}"></i>
    </a>
    @endforeach
</div>

<!-- Professional Hero Section -->
<section class="professional-hero-section">
    <div class="hero-background">
        <div class="hero-gradient-overlay"></div>
        <div class="hero-particles"></div>

    </div>
    
    <div class="container">
        <div class="row align-items-center min-vh-100">
            <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-8">
                <div class="hero-content" data-aos="fade-right" data-aos-duration="1000">
                    <div class="hero-badge">
                        <span class="badge-text">🚀 Next-Gen Investment Platform</span>
                    </div>
                    
                    <h1 class="hero-title">
                        <span class="title-line-1">{{ $data['hero_title'] }}</span>
                       
                    </h1>
                    
                    <p class="hero-description">
                        {{ $data['hero_content'] }}
                    </p>
                    
                    <div class="hero-stats">
                        <div class="stat-item">
                            <div class="stat-number">$2.5M+</div>
                            <div class="stat-label">Total Invested</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number">15K+</div>
                            <div class="stat-label">Active Users</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number">99.9%</div>
                            <div class="stat-label">Uptime</div>
                        </div>
                    </div>
                    
                    <div class="hero-buttons">
                        <a href="{{ $data['hero_button1_url'] }}" class="btn-primary">
                            <span class="btn-icon">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                    <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                    <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                </svg>
                            </span>
                            <span class="btn-text">{{ $data['hero_button1_level'] }}</span>
                            <div class="btn-shine"></div>
                        </a>
                        
                        <a href="{{ $data['hero_button2_url'] }}" class="btn-secondary">
                            <span class="btn-icon">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13 2L3 14H12L11 22L21 10H12L13 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                </svg>
                            </span>
                            <span class="btn-text">{{ $data['hero_button2_lavel'] }}</span>
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-4">
                <div class="hero-visual" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="200">
                    <div class="hero-card">
                        <div class="card-header">
                            <div class="card-dots">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                            <div class="card-title">Live Trading Dashboard</div>
                        </div>
                        <div class="card-content">
                            <div class="trading-chart">
                                <div class="chart-line"></div>
                                <div class="chart-points">
                                    <div class="point active"></div>
                                    <div class="point"></div>
                                    <div class="point"></div>
                                    <div class="point"></div>
                                    <div class="point"></div>
                                </div>
                            </div>
                            <div class="trading-stats">
                                <div class="stat">
                                    <span class="label">Portfolio Value</span>
                                    <span class="value positive">+$12,450</span>
                                </div>
                                <div class="stat">
                                    <span class="label">24h Change</span>
                                    <span class="value positive">+8.5%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="floating-elements">
                        <div class="floating-card card-1">
                            <div class="card-icon">💰</div>
                            <div class="card-text">High Returns</div>
                        </div>
                        <div class="floating-card card-2">
                            <div class="card-icon">🔒</div>
                            <div class="card-text">Secure</div>
                        </div>
                        <div class="floating-card card-3">
                            <div class="card-icon">⚡</div>
                            <div class="card-text">Fast</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Professional Hero Section Styles */
.professional-side-socials {
    position: fixed;
    left: 30px;
    top: 50%;
    transform: translateY(-50%);
    z-index: 1000;
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.social-link {
    width: 50px;
    height: 50px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #ffffff;
    font-size: 18px;
    transition: all 0.3s ease;
    text-decoration: none;
}

.social-link:hover {
    background: rgba(99, 102, 241, 0.8);
    border-color: rgba(99, 102, 241, 1);
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(99, 102, 241, 0.3);
}

.professional-hero-section {
    position: relative;
    min-height: 100vh;
    display: flex;
    align-items: center;
    overflow: hidden;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
}

.hero-background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.hero-gradient-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle at 30% 20%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 70% 80%, rgba(236, 72, 153, 0.1) 0%, transparent 50%);
}

.hero-particles {
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: 
        radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
        radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent),
        radial-gradient(1px 1px at 90px 40px, rgba(255,255,255,0.1), transparent);
    background-repeat: repeat;
    background-size: 100px 100px;
    animation: float 20s infinite linear;
}



.hero-content {
    position: relative;
    z-index: 2;
    color: #ffffff;
}

.hero-badge {
    display: inline-block;
    margin-bottom: 20px;
}

.badge-text {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 1px solid rgba(99, 102, 241, 0.3);
    padding: 8px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    color: #ffffff;
    backdrop-filter: blur(10px);
}

.hero-title {
    font-size: 4rem;
    font-weight: 900;
    line-height: 1.1;
    margin-bottom: 25px;
    background: linear-gradient(135deg, #ffffff 0%, #a0a0a0 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.title-line-1 {
    display: block;
}

.title-highlight {
    background: linear-gradient(135deg, #6366f1 0%, #ec4899 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.hero-description {
    font-size: 1.25rem;
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.8);
    margin-bottom: 40px;
    max-width: 600px;
}

.hero-stats {
    display: flex;
    gap: 40px;
    margin-bottom: 40px;
}

.stat-item {
    text-align: center;
}

.stat-number {
    font-size: 2rem;
    font-weight: 900;
    color: #6366f1;
    margin-bottom: 5px;
}

.stat-label {
    font-size: 0.9rem;
    color: rgba(255, 255, 255, 0.7);
    font-weight: 500;
}

.hero-buttons {
    display: flex;
    gap: 20px;
    flex-wrap: wrap;
}

.btn-primary, .btn-secondary {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 16px 32px;
    border-radius: 50px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.btn-primary {
    background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
    color: #ffffff;
    border: none;
    box-shadow: 0 10px 30px rgba(99, 102, 241, 0.3);
}

.btn-primary:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(99, 102, 241, 0.4);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #ffffff;
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-3px);
}

.btn-shine {
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.btn-primary:hover .btn-shine {
    left: 100%;
}

.hero-visual {
    position: relative;
    z-index: 2;
}

.hero-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    padding: 30px;
    box-shadow: 0 25px 50px rgba(0, 0, 0, 0.3);
    position: relative;
    overflow: hidden;
}

.hero-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 1px;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
}

.card-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 25px;
}

.card-dots {
    display: flex;
    gap: 8px;
}

.card-dots span {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
}

.card-dots span:first-child {
    background: #ff5f57;
}

.card-dots span:nth-child(2) {
    background: #ffbd2e;
}

.card-dots span:last-child {
    background: #28ca42;
}

.card-title {
    color: #ffffff;
    font-weight: 600;
    font-size: 1.1rem;
}

.trading-chart {
    height: 120px;
    position: relative;
    margin-bottom: 20px;
}

.chart-line {
    position: absolute;
    top: 50%;
    left: 0;
    right: 0;
    height: 2px;
    background: linear-gradient(90deg, #6366f1, #ec4899);
    border-radius: 1px;
}

.chart-points {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.point {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    transition: all 0.3s ease;
}

.point.active {
    background: #6366f1;
    box-shadow: 0 0 15px rgba(99, 102, 241, 0.5);
    transform: scale(1.5);
}

.trading-stats {
    display: flex;
    justify-content: space-between;
}

.stat {
    text-align: center;
}

.stat .label {
    display: block;
    font-size: 0.8rem;
    color: rgba(255, 255, 255, 0.6);
    margin-bottom: 5px;
}

.stat .value {
    font-size: 1.2rem;
    font-weight: 700;
}

.value.positive {
    color: #10b981;
}

.floating-elements {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    pointer-events: none;
}

.floating-card {
    position: absolute;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 15px;
    padding: 15px 20px;
    display: flex;
    align-items: center;
    gap: 10px;
    animation: float 6s infinite ease-in-out;
}

.card-1 {
    top: 20%;
    right: -20%;
    animation-delay: 0s;
}

.card-2 {
    bottom: 30%;
    left: -25%;
    animation-delay: 2s;
}

.card-3 {
    top: 60%;
    right: -15%;
    animation-delay: 4s;
}

.card-icon {
    font-size: 1.5rem;
}

.card-text {
    color: #ffffff;
    font-weight: 600;
    font-size: 0.9rem;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .professional-side-socials {
        display: none;
    }
    
    .hero-title {
        font-size: 2.5rem;
    }
    
    .hero-stats {
        gap: 20px;
    }
    
    .stat-number {
        font-size: 1.5rem;
    }
    
    .hero-buttons {
        flex-direction: column;
    }
    
    .btn-primary, .btn-secondary {
        width: 100%;
        justify-content: center;
    }
    
    .floating-card {
        display: none;
    }
}

@media (max-width: 480px) {
    .hero-title {
        font-size: 2rem;
    }
    
    .hero-description {
        font-size: 1rem;
    }
    
    .hero-stats {
        flex-direction: column;
        gap: 15px;
    }
    
    .hero-card {
        padding: 20px;
    }
}
</style>
