<!-- Professional Newsletter/CTA Section -->
<section class="professional-newsletter-section">
    <div class="newsletter-background">
        <div class="newsletter-gradient-overlay"></div>
        <div class="newsletter-particles"></div>

    </div>
    
    <div class="container">
        <div class="newsletter-container">
            <div class="newsletter-content" data-aos="fade-up" data-aos-duration="1000">
                <div class="newsletter-header">
                    <div class="newsletter-badge">
                        <span class="badge-text">📧 Stay Connected</span>
                    </div>
                    <h1 class="newsletter-title">
                        <span class="title-line">Join Our Community</span>
                        <span class="title-subtitle">Get Latest Updates & Exclusive Offers</span>
                    </h1>
                    <p class="newsletter-description">
                        Be the first to know about new investment opportunities, platform updates, and exclusive member benefits. Join thousands of investors who trust us with their financial growth.
                    </p>
                </div>
                
                <div class="newsletter-form-container" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                    <form action="{{ route('subscriber') }}" method="POST" class="newsletter-form">
                        @csrf
                        <div class="form-group">
                            <div class="input-container">
                                <div class="input-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M4 4H20C21.1 4 22 4.9 22 6V18C22 19.1 21.1 20 20 20H4C2.9 20 2 19.1 2 18V6C2 4.9 2.9 4 4 4Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <polyline points="22,6 12,13 2,6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <input type="email" name="email" placeholder="Enter your email address" required class="email-input">
                                <div class="input-glow"></div>
                            </div>
                            <button type="submit" class="subscribe-btn">
                                <span class="btn-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M22 2L11 13" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M22 2L15 22L11 13L2 9L22 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </span>
                                <span class="btn-text">{{ __('Subscribe') }}</span>
                                <div class="btn-shine"></div>
                            </button>
                        </div>
                    </form>
                    
                    <div class="newsletter-features">
                        <div class="feature-item" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                            <div class="feature-icon">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 12L11 14L15 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                                </svg>
                            </div>
                            <span>No spam, ever</span>
                        </div>
                        <div class="feature-item" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400">
                            <div class="feature-icon">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 12L11 14L15 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                                </svg>
                            </div>
                            <span>Unsubscribe anytime</span>
                        </div>
                        <div class="feature-item" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500">
                            <div class="feature-icon">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 12L11 14L15 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                                </svg>
                            </div>
                            <span>Exclusive member benefits</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="newsletter-visual" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="400">
                <div class="visual-card">
                    <div class="card-header">
                        <div class="traffic-lights">
                            <div class="light red"></div>
                            <div class="light yellow"></div>
                            <div class="light green"></div>
                        </div>
                        <div class="card-title">Investment Dashboard</div>
                    </div>
                    <div class="card-content">
                        <div class="chart-container">
                            <div class="chart-line">
                                <div class="line-point" style="left: 10%; bottom: 20%;"></div>
                                <div class="line-point" style="left: 30%; bottom: 40%;"></div>
                                <div class="line-point" style="left: 50%; bottom: 30%;"></div>
                                <div class="line-point" style="left: 70%; bottom: 60%;"></div>
                                <div class="line-point" style="left: 90%; bottom: 80%;"></div>
                            </div>
                        </div>
                        <div class="stats-row">
                            <div class="stat">
                                <div class="stat-value">+24.5%</div>
                                <div class="stat-label">This Month</div>
                            </div>
                            <div class="stat">
                                <div class="stat-value">$12,450</div>
                                <div class="stat-label">Total Value</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Professional Newsletter Section Styles */
.professional-newsletter-section {
    position: relative;
    padding: 120px 0;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
    overflow: hidden;
}

.newsletter-background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.newsletter-gradient-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle at 25% 25%, rgba(99, 102, 241, 0.15) 0%, transparent 50%),
                radial-gradient(circle at 75% 75%, rgba(236, 72, 153, 0.15) 0%, transparent 50%);
}

.newsletter-particles {
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: 
        radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
        radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent);
    background-repeat: repeat;
    background-size: 100px 100px;
    animation: float 40s infinite linear;
}



.newsletter-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 80px;
    align-items: center;
    position: relative;
    z-index: 2;
}

.newsletter-content {
    max-width: 600px;
}

.newsletter-header {
    margin-bottom: 50px;
}

.newsletter-badge {
    display: inline-block;
    margin-bottom: 20px;
}

.badge-text {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 1px solid rgba(99, 102, 241, 0.3);
    padding: 8px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    color: #ffffff;
    backdrop-filter: blur(10px);
}

.newsletter-title {
    font-size: 3.5rem;
    font-weight: 900;
    line-height: 1.1;
    margin-bottom: 20px;
    background: linear-gradient(135deg, #ffffff 0%, #a0a0a0 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.title-line {
    display: block;
}

.title-subtitle {
    display: block;
    font-size: 1.5rem;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.8);
    margin-top: 10px;
}

.newsletter-description {
    font-size: 1.2rem;
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
}

.newsletter-form-container {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    padding: 40px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
}

.form-group {
    display: flex;
    gap: 15px;
    margin-bottom: 30px;
}

.input-container {
    position: relative;
    flex: 1;
}

.input-icon {
    position: absolute;
    left: 20px;
    top: 50%;
    transform: translateY(-50%);
    color: rgba(255, 255, 255, 0.6);
    z-index: 2;
}

.email-input {
    width: 100%;
    padding: 18px 20px 18px 55px;
    background: rgba(255, 255, 255, 0.05);
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    color: #ffffff;
    font-size: 1rem;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
}

.email-input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.email-input:focus {
    outline: none;
    border-color: rgba(99, 102, 241, 0.5);
    background: rgba(255, 255, 255, 0.08);
    box-shadow: 0 0 0 4px rgba(99, 102, 241, 0.1);
}

.input-glow {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, transparent, rgba(99, 102, 241, 0.1), transparent);
    border-radius: 15px;
    opacity: 0;
    transition: opacity 0.3s ease;
    pointer-events: none;
}

.email-input:focus + .input-glow {
    opacity: 1;
}

.subscribe-btn {
    position: relative;
    padding: 18px 30px;
    background: linear-gradient(135deg, #6366f1, #ec4899);
    border: none;
    border-radius: 15px;
    color: #ffffff;
    font-size: 1rem;
    font-weight: 700;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
    overflow: hidden;
    white-space: nowrap;
}

.subscribe-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(99, 102, 241, 0.3);
}

.btn-shine {
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s ease;
}

.subscribe-btn:hover .btn-shine {
    left: 100%;
}

.newsletter-features {
    display: flex;
    gap: 30px;
    flex-wrap: wrap;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 8px;
    color: rgba(255, 255, 255, 0.7);
    font-size: 0.9rem;
}

.feature-icon {
    color: #10b981;
    flex-shrink: 0;
}

.newsletter-visual {
    display: flex;
    justify-content: center;
    align-items: center;
}

.visual-card {
    width: 100%;
    max-width: 400px;
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
    animation: float 6s infinite ease-in-out;
}

.card-header {
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    gap: 15px;
}

.traffic-lights {
    display: flex;
    gap: 6px;
}

.light {
    width: 12px;
    height: 12px;
    border-radius: 50%;
}

.light.red { background: #ef4444; }
.light.yellow { background: #f59e0b; }
.light.green { background: #10b981; }

.card-title {
    color: #ffffff;
    font-weight: 600;
    font-size: 0.9rem;
}

.card-content {
    padding: 30px 20px;
}

.chart-container {
    height: 120px;
    position: relative;
    margin-bottom: 20px;
    background: rgba(255, 255, 255, 0.02);
    border-radius: 10px;
    overflow: hidden;
}

.chart-line {
    position: relative;
    width: 100%;
    height: 100%;
}

.line-point {
    position: absolute;
    width: 6px;
    height: 6px;
    background: #6366f1;
    border-radius: 50%;
    animation: pulse 2s infinite;
}

.line-point::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 20px;
    height: 20px;
    background: rgba(99, 102, 241, 0.2);
    border-radius: 50%;
    animation: pulse 2s infinite;
}

.stats-row {
    display: flex;
    gap: 20px;
}

.stat {
    flex: 1;
    text-align: center;
}

.stat-value {
    font-size: 1.2rem;
    font-weight: 800;
    color: #10b981;
    margin-bottom: 5px;
}

.stat-label {
    font-size: 0.8rem;
    color: rgba(255, 255, 255, 0.6);
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

@keyframes pulse {
    0%, 100% { opacity: 1; transform: scale(1); }
    50% { opacity: 0.7; transform: scale(1.1); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .professional-newsletter-section {
        padding: 80px 0;
    }
    
    .newsletter-container {
        grid-template-columns: 1fr;
        gap: 50px;
    }
    
    .newsletter-title {
        font-size: 2.5rem;
    }
    
    .newsletter-form-container {
        padding: 30px 20px;
    }
    
    .form-group {
        flex-direction: column;
        gap: 15px;
    }
    
    .subscribe-btn {
        width: 100%;
        justify-content: center;
    }
    
    .newsletter-features {
        gap: 20px;
        justify-content: center;
    }
    
    .visual-card {
        max-width: 100%;
    }
}

@media (max-width: 480px) {
    .newsletter-title {
        font-size: 2rem;
    }
    
    .newsletter-description {
        font-size: 1rem;
    }
    
    .newsletter-form-container {
        padding: 25px 15px;
    }
    
    .email-input {
        padding: 15px 15px 15px 45px;
        font-size: 0.9rem;
    }
    
    .subscribe-btn {
        padding: 15px 25px;
        font-size: 0.9rem;
    }
    
    .newsletter-features {
        flex-direction: column;
        gap: 15px;
        align-items: center;
    }
    
    .feature-item {
        font-size: 0.85rem;
    }
}
</style>
