@php
$investors = \App\Models\Invest::with('schema')->latest()->take(6)->get();
$withdraws = \App\Models\Transaction::where('type',\App\Enums\TxnType::Withdraw)->take(6)->latest()->get();
@endphp

<!-- Professional Live Activity Section -->
<section class="professional-live-activity-section">
    <div class="activity-background">
        <div class="activity-gradient-overlay"></div>
        <div class="activity-particles"></div>

    </div>
    
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-8 col-xl-8 col-lg-10">
                <div class="section-header" data-aos="fade-up" data-aos-duration="1000">
                    <div class="section-badge">
                        <span class="badge-text">📊 Live Activity</span>
                    </div>
                    <h1 class="section-title">
                        <span class="title-line">{{ $data['title_big'] }}</span>
                        <span class="title-subtitle">{{ $data['title_small'] }}</span>
                    </h1>
                    <p class="section-description">
                        Real-time investment and withdrawal activities from our global community. See the latest transactions happening right now.
                    </p>
                </div>
            </div>
        </div>
        
        <div class="activity-grid">
            <div class="activity-card investors-card" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
                <div class="card-header">
                    <div class="card-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16 21V19C16 17.9391 15.5786 16.9217 14.8284 16.1716C14.0783 15.4214 13.0609 15 12 15H5C3.93913 15 2.92172 15.4214 2.17157 16.1716C1.42143 16.9217 1 17.9391 1 19V21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <circle cx="8.5" cy="7" r="4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M20 8V14M23 11H17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <h3 class="card-title">{{ __('Recent Investors') }}</h3>
                    <div class="live-indicator">
                        <span class="live-dot"></span>
                        <span class="live-text">LIVE</span>
                    </div>
                </div>
                
                <div class="card-body">
                    @foreach($investors as $index => $investor)
                    @php
                    $calculateInterest = ($investor->interest*$investor->invest_amount)/100;
                    $interest = $investor->interest_type != 'percentage' ? $investor->interest : $calculateInterest;
                    @endphp
                    
                    <div class="activity-item" data-aos="fade-up" data-aos-delay="{{ $index * 100 }}">
                        <div class="user-avatar">
                            <div class="avatar-circle">
                                <span class="avatar-text">{{ substr($investor->user->first_name, 0, 1) }}{{ substr($investor->user->last_name, 0, 1) }}</span>
                            </div>
                            <div class="status-indicator {{ $investor->user->status ? 'active' : 'inactive' }}"></div>
                        </div>
                        
                        <div class="activity-details">
                            <div class="user-info">
                                <h4 class="user-name">{{ $investor->user->full_name }}</h4>
                                <p class="activity-time">{{ \Carbon\Carbon::parse($investor->created_at)->format('M d, Y H:i') }}</p>
                            </div>
                            
                            <div class="activity-amount">
                                <div class="amount-main">{{ $investor->invest_amount }} {{ $currency }}</div>
                                <div class="amount-profit">+{{ $investor->already_return_profit*$interest }} {{ $currency }}</div>
                            </div>
                        </div>
                        
                        <div class="activity-status">
                            <span class="status-badge {{ $investor->user->status ? 'success' : 'warning' }}">
                                {{ $investor->user->status ? __('Active') : __('Inactive') }}
                            </span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            
            <div class="activity-card withdraws-card" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="400">
                <div class="card-header">
                    <div class="card-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                            <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                            <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <h3 class="card-title">{{ __('Recent Withdraws') }}</h3>
                    <div class="live-indicator">
                        <span class="live-dot"></span>
                        <span class="live-text">LIVE</span>
                    </div>
                </div>
                
                <div class="card-body">
                    @foreach($withdraws as $index => $withdraw)
                    <div class="activity-item" data-aos="fade-up" data-aos-delay="{{ $index * 100 }}">
                        <div class="user-avatar">
                            <div class="avatar-circle withdraw-avatar">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                    <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                    <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                </svg>
                            </div>
                            <div class="status-indicator {{ $withdraw->status->value === 'success' ? 'success' : ($withdraw->status->value === 'failed' ? 'failed' : 'pending') }}"></div>
                        </div>
                        
                        <div class="activity-details">
                            <div class="user-info">
                                <h4 class="user-name">Bank Transfer - USD</h4>
                                <p class="activity-time">{{ \Carbon\Carbon::parse($withdraw->created_at)->format('M d, Y H:i') }}</p>
                            </div>
                            
                            <div class="activity-amount">
                                <div class="amount-main">{{ $withdraw->final_amount }} {{ $currency }}</div>
                                <div class="amount-profit {{ $withdraw->status->value === 'success' ? 'positive' : 'negative' }}">
                                    @if($withdraw->status->value === 'success')
                                        +{{ $withdraw->final_amount }} {{ $currency }}
                                    @elseif($withdraw->status->value === 'failed')
                                        -{{ $withdraw->final_amount }} {{ $currency }}
                                    @else
                                        Pending
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <div class="activity-status">
                            <span class="status-badge {{ $withdraw->status->value === 'success' ? 'success' : ($withdraw->status->value === 'failed' ? 'failed' : 'pending') }}">
                                {{ ucfirst($withdraw->status->value) }}
                            </span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Professional Live Activity Section Styles */
.professional-live-activity-section {
    position: relative;
    padding: 120px 0;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
    overflow: hidden;
}

.activity-background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.activity-gradient-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle at 25% 25%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 75% 75%, rgba(236, 72, 153, 0.1) 0%, transparent 50%);
}

.activity-particles {
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: 
        radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
        radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent);
    background-repeat: repeat;
    background-size: 100px 100px;
    animation: float 25s infinite linear;
}



.section-header {
    text-align: center;
    margin-bottom: 80px;
    position: relative;
    z-index: 2;
}

.section-badge {
    display: inline-block;
    margin-bottom: 20px;
}

.badge-text {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 1px solid rgba(99, 102, 241, 0.3);
    padding: 8px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    color: #ffffff;
    backdrop-filter: blur(10px);
}

.section-title {
    font-size: 3.5rem;
    font-weight: 900;
    line-height: 1.1;
    margin-bottom: 20px;
    background: linear-gradient(135deg, #ffffff 0%, #a0a0a0 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.title-line {
    display: block;
}

.title-subtitle {
    display: block;
    font-size: 1.5rem;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.8);
    margin-top: 10px;
}

.section-description {
    font-size: 1.2rem;
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.7);
    max-width: 600px;
    margin: 0 auto;
}

.activity-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 40px;
    position: relative;
    z-index: 2;
}

.activity-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    overflow: hidden;
    transition: all 0.4s ease;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
}

.activity-card:hover {
    transform: translateY(-10px);
    border-color: rgba(99, 102, 241, 0.3);
    box-shadow: 0 30px 60px rgba(99, 102, 241, 0.1);
}

.card-header {
    padding: 30px 30px 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    gap: 15px;
}

.card-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 2px solid rgba(99, 102, 241, 0.3);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #6366f1;
}

.card-title {
    font-size: 1.5rem;
    font-weight: 800;
    color: #ffffff;
    margin: 0;
    flex: 1;
}

.live-indicator {
    display: flex;
    align-items: center;
    gap: 8px;
    background: rgba(16, 185, 129, 0.1);
    border: 1px solid rgba(16, 185, 129, 0.3);
    padding: 6px 12px;
    border-radius: 20px;
}

.live-dot {
    width: 8px;
    height: 8px;
    background: #10b981;
    border-radius: 50%;
    animation: pulse 2s infinite;
}

.live-text {
    font-size: 0.8rem;
    font-weight: 700;
    color: #10b981;
}

.card-body {
    padding: 20px 30px 30px;
}

.activity-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 20px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
    transition: all 0.3s ease;
}

.activity-item:last-child {
    border-bottom: none;
}

.activity-item:hover {
    background: rgba(255, 255, 255, 0.02);
    border-radius: 15px;
    padding: 20px 15px;
    margin: 0 -15px;
}

.user-avatar {
    position: relative;
    flex-shrink: 0;
}

.avatar-circle {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 2px solid rgba(99, 102, 241, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #ffffff;
    font-weight: 700;
    font-size: 0.9rem;
}

.withdraw-avatar {
    background: linear-gradient(135deg, rgba(245, 158, 11, 0.2), rgba(239, 68, 68, 0.2));
    border-color: rgba(245, 158, 11, 0.3);
    color: #f59e0b;
}

.status-indicator {
    position: absolute;
    bottom: -2px;
    right: -2px;
    width: 16px;
    height: 16px;
    border-radius: 50%;
    border: 2px solid #0f0f23;
}

.status-indicator.active,
.status-indicator.success {
    background: #10b981;
}

.status-indicator.inactive,
.status-indicator.failed {
    background: #ef4444;
}

.status-indicator.pending {
    background: #f59e0b;
}

.activity-details {
    flex: 1;
    min-width: 0;
}

.user-info {
    margin-bottom: 8px;
}

.user-name {
    font-size: 1rem;
    font-weight: 700;
    color: #ffffff;
    margin: 0 0 4px 0;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.activity-time {
    font-size: 0.8rem;
    color: rgba(255, 255, 255, 0.6);
    margin: 0;
}

.activity-amount {
    text-align: right;
}

.amount-main {
    font-size: 1.1rem;
    font-weight: 800;
    color: #ffffff;
    margin-bottom: 4px;
}

.amount-profit {
    font-size: 0.9rem;
    font-weight: 600;
}

.amount-profit.positive {
    color: #10b981;
}

.amount-profit.negative {
    color: #ef4444;
}

.activity-status {
    flex-shrink: 0;
}

.status-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 15px;
    font-size: 0.8rem;
    font-weight: 700;
    text-transform: uppercase;
}

.status-badge.success {
    background: rgba(16, 185, 129, 0.1);
    border: 1px solid rgba(16, 185, 129, 0.3);
    color: #10b981;
}

.status-badge.warning {
    background: rgba(245, 158, 11, 0.1);
    border: 1px solid rgba(245, 158, 11, 0.3);
    color: #f59e0b;
}

.status-badge.failed {
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.3);
    color: #ef4444;
}

.status-badge.pending {
    background: rgba(99, 102, 241, 0.1);
    border: 1px solid rgba(99, 102, 241, 0.3);
    color: #6366f1;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

@keyframes pulse {
    0%, 100% { opacity: 1; transform: scale(1); }
    50% { opacity: 0.7; transform: scale(1.1); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .professional-live-activity-section {
        padding: 80px 0;
    }
    
    .section-title {
        font-size: 2.5rem;
    }
    
    .activity-grid {
        grid-template-columns: 1fr;
        gap: 30px;
    }
    
    .card-header {
        padding: 25px 20px 15px;
    }
    
    .card-body {
        padding: 15px 20px 25px;
    }
    
    .activity-item {
        padding: 15px 0;
    }
    
    .avatar-circle {
        width: 45px;
        height: 45px;
        font-size: 0.8rem;
    }
    
    .user-name {
        font-size: 0.9rem;
    }
    
    .amount-main {
        font-size: 1rem;
    }
}

@media (max-width: 480px) {
    .section-title {
        font-size: 2rem;
    }
    
    .section-description {
        font-size: 1rem;
    }
    
    .card-header {
        padding: 20px 15px 15px;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    
    .card-body {
        padding: 15px 15px 20px;
    }
    
    .activity-item {
        padding: 12px 0;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    
    .activity-details {
        width: 100%;
    }
    
    .activity-amount {
        text-align: left;
    }
    
    .avatar-circle {
        width: 40px;
        height: 40px;
        font-size: 0.7rem;
    }
}
</style>
