<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="keywords" content="@yield('meta_keywords',setting('site_title','global'))">
    <meta name="description" content="@yield('meta_description',setting('site_title','global'))">
    <link rel="canonical" href="{{ url()->current() }}"/>
    <link rel="shortcut icon" href="{{ asset(setting('site_favicon','global')) }}" type="image/x-icon"/>
    <link rel="icon" href="{{ asset(setting('site_favicon','global')) }}" type="image/x-icon"/>
    <link rel="stylesheet" href="{{ asset('global/css/simple-notify.min.css') }}"/>
    @stack('style')
    @notifyCss
    @yield('style')
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/bootstrap.min.css') }}"/>
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/fontawesome-pro.css') }}"/>
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/nice-select.css') }}"/>
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/datepicker-bs5.min.css') }}"/>
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/spacing.css') }}"/>
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/swiper.min.css') }}"/>
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/odometer-default.min.css') }}"/>
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/styles.css?var=2.1') }}"/>
    <link rel="stylesheet" href="{{ asset('frontend/theme_base/hardrock/css/custom-ui.css?var=3.0') }}"/>

    <style>
        {{ \App\Models\CustomCss::first()->css }}
        
        /* ===== AI-POWERED PROFESSIONAL 3D GLOSSY DASHBOARD ===== */
        
        /* Modern CSS Variables for Professional Theme */
        :root {
            --ai-primary: #6366f1;
            --ai-secondary: #8b5cf6;
            --ai-accent: #06b6d4;
            --ai-success: #10b981;
            --ai-warning: #f59e0b;
            --ai-danger: #ef4444;
            --ai-dark: #0f172a;
            --ai-darker: #020617;
            --ai-light: #f8fafc;
            --ai-glass: rgba(255, 255, 255, 0.1);
            --ai-border: rgba(255, 255, 255, 0.2);
            --ai-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            --ai-glow: 0 0 20px rgba(99, 102, 241, 0.3);
        }
        
        /* ===== PROFESSIONAL BACKGROUND SYSTEM ===== */
        body, html, .rock-page-body-wrapper, .rock-page-body {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 25%, #334155 50%, #1e293b 75%, #0f172a 100%) !important;
            background-attachment: fixed !important;
            color: #f8fafc !important;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif !important;
        }
        
        /* Fix content positioning - bring content up */
        .rock-page-body-wrapper, .rock-page-body {
            margin-top: -450px !important;
            padding-top: 0 !important;
        }
        
        /* Keep sidebar in correct position */
        .rock-sidebar, .rock-sidebar-wrapper, .sidebar, .side-nav {
            position: fixed !important;
            top: 450px !important;
            left: 0 !important;
            margin-top: 0 !important;
            z-index: 1000 !important;
        }
        
        /* Fix main content area positioning */
        .main-content, .content-area, .page-content {
            margin-top: -100px !important;
            padding-top: 0 !important;
        }
        
        /* Push dashboard content up */
        .default-page, .rock-desktop-screen-show {
            margin-top: -100px !important;
            padding-top: 0 !important;
        }
        
        /* Fix dashboard container positioning */
        .default-page, .rock-desktop-screen-show {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }
        
        /* Fix announcement bar positioning */
        .announcement-bar {
            margin-top: 0 !important;
            padding-top: 10px !important;
        }
        
        /* Fix banner padding that's pushing content down */
        .banner-style-four {
            padding-top: 0 !important;
            padding-bottom: 20px !important;
        }
        
        /* Override all banner padding variants */
        @media only screen and (min-width: 1600px) and (max-width: 1800px) {
            .banner-style-four {
                padding-top: 0 !important;
                padding-bottom: 20px !important;
            }
        }
        
        @media only screen and (min-width: 1200px) and (max-width: 1399px) {
            .banner-style-four {
                padding-top: 0 !important;
                padding-bottom: 20px !important;
            }
        }
        
        @media only screen and (min-width: 992px) and (max-width: 1199px) {
            .banner-style-four {
                padding-top: 0 !important;
                padding-bottom: 20px !important;
            }
        }
        
        @media only screen and (min-width: 768px) and (max-width: 991px) {
            .banner-style-four {
                padding-top: 0 !important;
                padding-bottom: 20px !important;
            }
        }
        
        @media only screen and (min-width: 576px) and (max-width: 767px) {
            .banner-style-four {
                padding-top: 0 !important;
                padding-bottom: 20px !important;
            }
        }
        
        @media (max-width: 575px) {
            .banner-style-four {
                padding-top: 0 !important;
                padding-bottom: 20px !important;
            }
        }
        
        @media (max-width: 480px) {
            .banner-style-four {
                padding-top: 0 !important;
                padding-bottom: 20px !important;
            }
        }
        

        
        /* ===== AI-POWERED SIDEBAR ===== */
        .rock-sidebar, .rock-sidebar-wrapper, .sidebar, .side-nav {
            background: linear-gradient(180deg, #6366f1 0%, #8b5cf6 50%, #6366f1 100%) !important;
            backdrop-filter: blur(20px) !important;
            border-right: 1px solid var(--ai-border) !important;
            box-shadow: var(--ai-shadow), var(--ai-glow) !important;
            position: relative !important;
            overflow: hidden !important;
        }
        
        .rock-sidebar::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, transparent 30%, rgba(255, 255, 255, 0.1) 50%, transparent 70%);
            animation: ai-shine 3s ease-in-out infinite;
        }
        
        @keyframes ai-shine {
            0%, 100% { transform: translateX(-100%); }
            50% { transform: translateX(100%); }
        }
        
        /* Sidebar Logo Enhancement */
        .rock-sidebar .logo {
            background: linear-gradient(135deg, #ffffff 0%, #f1f5f9 100%) !important;
            border-radius: 16px !important;
            padding: 20px !important;
            margin: 20px !important;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2) !important;
            border: 1px solid var(--ai-border) !important;
        }
        
        /* Sidebar Navigation Items */
        .rock-sidebar .nav-item, .rock-sidebar .nav-link {
            background: rgba(255, 255, 255, 0.05) !important;
            border-radius: 12px !important;
            margin: 8px 16px !important;
            padding: 12px 20px !important;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
            border: 1px solid transparent !important;
            backdrop-filter: blur(10px) !important;
        }
        
        .rock-sidebar .nav-item:hover, .rock-sidebar .nav-link:hover {
            background: rgba(255, 255, 255, 0.15) !important;
            transform: translateX(8px) !important;
            border-color: var(--ai-accent) !important;
            box-shadow: 0 8px 25px rgba(99, 102, 241, 0.3) !important;
        }
        
        .rock-sidebar .nav-item.active, .rock-sidebar .nav-link.active {
            background: linear-gradient(135deg, var(--ai-accent) 0%, var(--ai-primary) 100%) !important;
            box-shadow: 0 8px 25px rgba(6, 182, 212, 0.4) !important;
            transform: scale(1.05) !important;
        }
        
        /* ===== AI-POWERED DASHBOARD CARDS ===== */
        .dashboard-card, .rock-dashboard-card, .rock-single-card {
            background: rgba(255, 255, 255, 0.05) !important;
            backdrop-filter: blur(20px) !important;
            border: 1px solid var(--ai-border) !important;
            border-radius: 20px !important;
            padding: 24px !important;
            box-shadow: var(--ai-shadow) !important;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
            position: relative !important;
            overflow: hidden !important;
            margin: 0 !important;
            float: none !important;
            display: inline-block !important;
            vertical-align: top !important;
        }
        
        /* Fix card content visibility */
        .rock-single-card .content h3.title {
            color: #ffffff !important;
            font-size: 1.5rem !important;
            font-weight: 700 !important;
            margin-bottom: 8px !important;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3) !important;
        }
        
        .rock-single-card .content p.description {
            color: #e2e8f0 !important;
            font-size: 0.9rem !important;
            font-weight: 500 !important;
            margin: 0 !important;
        }
        
        /* Fix SVG icons visibility */
        .rock-single-card .icon svg path,
        .rock-single-card .icon svg circle {
            fill: #ffffff !important;
        }
        
        .rock-single-card .icon svg path[opacity="0.4"] {
            fill: rgba(255, 255, 255, 0.6) !important;
        }
        
        .rock-single-card .icon span {
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            width: 48px !important;
            height: 48px !important;
            background: linear-gradient(135deg, var(--ai-primary) 0%, var(--ai-secondary) 100%) !important;
            border-radius: 12px !important;
            margin-bottom: 16px !important;
        }
        
        /* Fix card grid layout */
        .rock-dashboard-level-area .row,
        .rock-dashboard-level-area .col,
        .rock-dashboard-level-area .col-12,
        .rock-dashboard-level-area .col-lg-3,
        .rock-dashboard-level-area .col-md-6 {
            margin: 0 !important;
            padding: 8px !important;
            float: none !important;
        }
        

        
        /* Ensure cards are properly aligned */
        .rock-dashboard-level-area {
            display: flex !important;
            flex-direction: column !important;
            align-items: stretch !important;
        }
        
        .rock-dashboard-level-area .row {
            display: flex !important;
            flex-wrap: wrap !important;
            justify-content: space-between !important;
            align-items: stretch !important;
            margin: 0 !important;
        }
        
        .rock-dashboard-level-area .col,
        .rock-dashboard-level-area .col-12,
        .rock-dashboard-level-area .col-lg-3,
        .rock-dashboard-level-area .col-md-6 {
            flex: 1 !important;
            min-width: 200px !important;
            margin: 8px !important;
        }
        
        .dashboard-card::before, .rock-dashboard-card::before, .rock-single-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            transition: left 0.5s ease;
        }
        
        .dashboard-card:hover::before, .rock-dashboard-card:hover::before, .rock-single-card:hover::before {
            left: 100%;
        }
        
        .dashboard-card:hover, .rock-dashboard-card:hover, .rock-single-card:hover {
            transform: translateY(-8px) scale(1.02) !important;
            box-shadow: 0 35px 60px rgba(0, 0, 0, 0.3), 0 0 30px rgba(99, 102, 241, 0.2) !important;
            border-color: var(--ai-accent) !important;
        }
        
        /* Card Content Enhancement */
        .dashboard-card .card-title, .rock-dashboard-card .card-title {
            background: linear-gradient(135deg, var(--ai-primary) 0%, var(--ai-secondary) 100%) !important;
            -webkit-background-clip: text !important;
            -webkit-text-fill-color: transparent !important;
            background-clip: text !important;
            font-weight: 700 !important;
            font-size: 1.25rem !important;
            margin-bottom: 16px !important;
        }
        
        .dashboard-card .card-value, .rock-dashboard-card .card-value {
            font-size: 2.5rem !important;
            font-weight: 800 !important;
            color: #ffffff !important;
            text-shadow: 0 4px 8px rgba(0, 0, 0, 0.3) !important;
        }
        
        /* ===== AI-POWERED STATS CARDS ===== */
        .rock-dashboard-level-area {
            background: rgba(255, 255, 255, 0.03) !important;
            backdrop-filter: blur(20px) !important;
            border: 1px solid var(--ai-border) !important;
            border-radius: 24px !important;
            padding: 32px !important;
            margin: 24px 0 !important;
            box-shadow: var(--ai-shadow) !important;
            position: relative !important;
            top: 0 !important;
            left: 0 !important;
        }
        
        /* Fix the white border box */
        .rock-dashboard-level-contents {
            border: none !important;
            background: transparent !important;
            padding: 0 !important;
            min-width: auto !important;
            border-radius: 0 !important;
        }
        
        /* Make content inside visible */
        .rock-dashboard-level-contents .content {
            color: #ffffff !important;
            visibility: visible !important;
            opacity: 1 !important;
        }
        
        .rock-dashboard-level-contents .content .lavel {
            color: #ffffff !important;
            font-size: 1.2rem !important;
            font-weight: 600 !important;
        }
        
        .rock-dashboard-level-contents .content .lavel-title {
            color: #ffffff !important;
            font-size: 1rem !important;
            font-weight: 500 !important;
        }
        

        
        .rock-dashboard-level-wrapper {
            position: relative !important;
            top: 0 !important;
            left: 0 !important;
            margin: 0 !important;
            padding: 0 !important;
        }
        
        .rock-dashboard-level-contents {
            position: relative !important;
            top: 0 !important;
            left: 0 !important;
            margin: 0 !important;
            padding: 0 !important;
        }
        
        /* ===== PROFESSIONAL ALERTS ===== */
        .alert {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
            border: 1px solid var(--ai-border) !important;
            border-radius: 16px !important;
            backdrop-filter: blur(15px) !important;
            box-shadow: 0 8px 25px rgba(99, 102, 241, 0.15) !important;
        }
        
        /* ===== AI-POWERED BUTTONS ===== */
        .btn {
            background: linear-gradient(135deg, var(--ai-primary) 0%, var(--ai-secondary) 100%) !important;
            border: none !important;
            border-radius: 12px !important;
            padding: 12px 24px !important;
            font-weight: 600 !important;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
            box-shadow: 0 4px 15px rgba(99, 102, 241, 0.3) !important;
            position: relative !important;
            overflow: hidden !important;
        }
        
        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s ease;
        }
        
        .btn:hover::before {
            left: 100%;
        }
        
        .btn:hover {
            transform: translateY(-2px) !important;
            box-shadow: 0 8px 25px rgba(99, 102, 241, 0.4) !important;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--ai-primary) 0%, var(--ai-secondary) 100%) !important;
        }
        
        .btn-success {
            background: linear-gradient(135deg, var(--ai-success) 0%, #059669 100%) !important;
        }
        
        .btn-warning {
            background: linear-gradient(135deg, var(--ai-warning) 0%, #d97706 100%) !important;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, var(--ai-danger) 0%, #dc2626 100%) !important;
        }
        
        /* ===== AI-POWERED TABLES ===== */
        .site-table-head {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
            backdrop-filter: blur(15px) !important;
            border: 1px solid var(--ai-border) !important;
            border-radius: 16px 16px 0 0 !important;
        }
        
        .site-table-list {
            background: rgba(255, 255, 255, 0.02) !important;
            backdrop-filter: blur(10px) !important;
            border: 1px solid var(--ai-border) !important;
            transition: all 0.3s ease !important;
        }
        
        .site-table-list:hover {
            background: rgba(255, 255, 255, 0.05) !important;
            transform: scale(1.01) !important;
        }
        
        /* ===== AI-POWERED FORMS ===== */
        .form-control, .form-select {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 1px solid var(--ai-border) !important;
            border-radius: 12px !important;
            color: #ffffff !important;
            backdrop-filter: blur(10px) !important;
            transition: all 0.3s ease !important;
        }
        
        .form-control:focus, .form-select:focus {
            background: rgba(255, 255, 255, 0.1) !important;
            border-color: var(--ai-accent) !important;
            box-shadow: 0 0 0 3px rgba(6, 182, 212, 0.1) !important;
            transform: scale(1.02) !important;
        }
        
        /* ===== AI-POWERED ANIMATIONS ===== */
        @keyframes ai-float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        
        @keyframes ai-pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        
        @keyframes ai-glow {
            0%, 100% { box-shadow: 0 0 20px rgba(99, 102, 241, 0.3); }
            50% { box-shadow: 0 0 30px rgba(99, 102, 241, 0.6); }
        }
        
        /* Apply animations to key elements */
        .dashboard-card, .rock-dashboard-card {
            animation: ai-float 6s ease-in-out infinite !important;
        }
        
        /* Fix card grid system */
        .rock-dashboard-level-area .row {
            display: grid !important;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)) !important;
            gap: 20px !important;
            align-items: start !important;
            justify-items: center !important;
        }
        
        .rock-dashboard-level-area .col,
        .rock-dashboard-level-area .col-12,
        .rock-dashboard-level-area .col-lg-3,
        .rock-dashboard-level-area .col-md-6 {
            width: 100% !important;
            max-width: 300px !important;
            margin: 0 !important;
            padding: 0 !important;
        }
        
        /* Ensure cards don't float or move unexpectedly */
        .dashboard-card, .rock-dashboard-card, .rock-single-card {
            position: relative !important;
            top: 0 !important;
            left: 0 !important;
            right: auto !important;
            bottom: auto !important;
            transform: none !important;
        }
        

        
        .dashboard-card:hover, .rock-dashboard-card:hover, .rock-single-card:hover {
            transform: translateY(-8px) scale(1.02) !important;
        }
        
        .rock-sidebar .logo {
            animation: ai-pulse 4s ease-in-out infinite !important;
        }
        
        /* ===== RESPONSIVE ENHANCEMENTS ===== */
        @media (max-width: 768px) {
            .dashboard-card, .rock-dashboard-card {
                margin: 16px 0 !important;
                padding: 20px !important;
            }
            
            .rock-sidebar {
                backdrop-filter: blur(15px) !important;
            }
        }
        
        /* ===== PROFESSIONAL TYPOGRAPHY ===== */
        h1, h2, h3, h4, h5, h6 {
            background: linear-gradient(135deg, #ffffff 0%, #e2e8f0 100%) !important;
            -webkit-background-clip: text !important;
            -webkit-text-fill-color: transparent !important;
            background-clip: text !important;
            font-weight: 700 !important;
        }
        
        .welcome-text {
            background: linear-gradient(135deg, var(--ai-accent) 0%, var(--ai-primary) 100%) !important;
            -webkit-background-clip: text !important;
            -webkit-text-fill-color: transparent !important;
            background-clip: text !important;
            font-size: 1.1rem !important;
            font-weight: 500 !important;
        }
        
        /* Fix welcome message text color */
        div[style*="text-align: center"] h3 {
            color: #ffffff !important;
            background: none !important;
            -webkit-background-clip: unset !important;
            -webkit-text-fill-color: unset !important;
            background-clip: unset !important;
        }
        

        
        /* ===== AI-POWERED SCROLLBAR ===== */
        ::-webkit-scrollbar {
            width: 8px !important;
        }
        
        ::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05) !important;
            border-radius: 4px !important;
        }
        
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, var(--ai-primary) 0%, var(--ai-secondary) 100%) !important;
            border-radius: 4px !important;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, var(--ai-secondary) 0%, var(--ai-accent) 100%) !important;
        }
        
        /* ===== PROFESSIONAL PRELOADER ===== */
        .preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 25%, #334155 50%, #1e293b 75%, #0f172a 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.5s ease-out;
        }
        
        .preloader.fade-out {
            opacity: 0;
            pointer-events: none;
        }
        
        .preloader-content {
            text-align: center;
            color: #ffffff;
        }
        
        .preloader-logo {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 20px;
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 50%, #06b6d4 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            animation: logo-glow 2s ease-in-out infinite alternate;
        }
        
        @keyframes logo-glow {
            0% { filter: drop-shadow(0 0 10px rgba(99, 102, 241, 0.5)); }
            100% { filter: drop-shadow(0 0 20px rgba(139, 92, 246, 0.8)); }
        }
        
        .preloader-subtitle {
            font-size: 1rem;
            color: #e2e8f0;
            margin-bottom: 30px;
            font-weight: 500;
        }
        
        .preloader-spinner {
            width: 60px;
            height: 60px;
            border: 3px solid rgba(255, 255, 255, 0.1);
            border-top: 3px solid #6366f1;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .preloader-progress {
            width: 200px;
            height: 4px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 2px;
            margin: 0 auto;
            overflow: hidden;
        }
        
        .preloader-progress-bar {
            height: 100%;
            background: linear-gradient(90deg, #6366f1 0%, #8b5cf6 50%, #06b6d4 100%);
            border-radius: 2px;
            animation: progress 2s ease-in-out infinite;
        }
        
        @keyframes progress {
            0% { width: 0%; }
            50% { width: 70%; }
            100% { width: 100%; }
        }
        
        .preloader-text {
            font-size: 0.9rem;
            color: #94a3b8;
            margin-top: 15px;
            font-weight: 400;
        }
        
        /* Hide preloader after page load */
        .preloader-hidden {
            display: none !important;
            opacity: 0 !important;
            visibility: hidden !important;
            pointer-events: none !important;
        }
        
        /* Preloader HTML and JavaScript */
        .preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 25%, #334155 50%, #1e293b 75%, #0f172a 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.5s ease-out;
        }
        
        .preloader.fade-out {
            opacity: 0;
            pointer-events: none;
        }
        
        .preloader-content {
            text-align: center;
            color: #ffffff;
        }
        
        .preloader-logo {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 20px;
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 50%, #06b6d4 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            animation: logo-glow 2s ease-in-out infinite alternate;
        }
        
        @keyframes logo-glow {
            0% { filter: drop-shadow(0 0 10px rgba(99, 102, 241, 0.5)); }
            100% { filter: drop-shadow(0 0 20px rgba(139, 92, 246, 0.8)); }
        }
        
        .preloader-subtitle {
            font-size: 1rem;
            color: #e2e8f0;
            margin-bottom: 30px;
            font-weight: 500;
        }
        
        .preloader-spinner {
            width: 60px;
            height: 60px;
            border: 3px solid rgba(255, 255, 255, 0.1);
            border-top: 3px solid #6366f1;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .preloader-progress {
            width: 200px;
            height: 4px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 2px;
            margin: 0 auto;
            overflow: hidden;
        }
        
        .preloader-progress-bar {
            height: 100%;
            background: linear-gradient(90deg, #6366f1 0%, #8b5cf6 50%, #06b6d4 100%);
            border-radius: 2px;
            animation: progress 2s ease-in-out infinite;
        }
        
        @keyframes progress {
            0% { width: 0%; }
            50% { width: 70%; }
            100% { width: 100%; }
        }
        
        .preloader-text {
            font-size: 0.9rem;
            color: #94a3b8;
            margin-top: 15px;
            font-weight: 400;
        }
        
        /* ===== MODERN PROFESSIONAL SCHEMA CARDS ===== */
        
        /* Remove stone image and redesign cards */
        .rock-pricing-item {
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%) !important;
            backdrop-filter: blur(20px) !important;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
            border-radius: 20px !important;
            padding: 30px 25px !important;
            position: relative !important;
            overflow: hidden !important;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25) !important;
            margin-bottom: 30px !important;
        }
        
        .rock-pricing-item:hover {
            transform: translateY(-10px) scale(1.02) !important;
            box-shadow: 0 35px 70px -15px rgba(0, 0, 0, 0.35) !important;
            border-color: rgba(99, 102, 241, 0.5) !important;
        }
        
        .rock-pricing-item.is-active {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.2) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
            border-color: rgba(99, 102, 241, 0.6) !important;
            box-shadow: 0 30px 60px -15px rgba(99, 102, 241, 0.3) !important;
        }
        
        /* Card header styling */
        .rock-pricing-item .item-title {
            font-size: 1.5rem !important;
            font-weight: 700 !important;
            color: #ffffff !important;
            text-align: center !important;
            margin-bottom: 20px !important;
            background: linear-gradient(135deg, #ffffff 0%, #e2e8f0 100%) !important;
            -webkit-background-clip: text !important;
            -webkit-text-fill-color: transparent !important;
            background-clip: text !important;
        }
        
        .rock-pricing-item .price-value {
            text-align: center !important;
            margin-bottom: 25px !important;
        }
        
        .rock-pricing-item .price-suggest {
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%) !important;
            color: #ffffff !important;
            padding: 8px 16px !important;
            border-radius: 25px !important;
            font-size: 0.85rem !important;
            font-weight: 600 !important;
            display: inline-block !important;
            box-shadow: 0 4px 15px rgba(99, 102, 241, 0.3) !important;
        }
        
        /* ROI text color fix */
        .rock-pricing-item .price-value h4,
        .rock-pricing-item .price-value .price-suggest,
        .rock-pricing-item .price-value span,
        .rock-pricing-item .price-value p,
        .rock-pricing-item .price-value * {
            color: #ffffff !important;
            -webkit-text-fill-color: #ffffff !important;
            background: none !important;
            -webkit-background-clip: unset !important;
            background-clip: unset !important;
        }
        
        /* Ensure all text in price section is white */
        .rock-pricing-item .price-value {
            color: #ffffff !important;
        }
        
        .rock-pricing-item .price-value * {
            color: #ffffff !important;
        }
        
        /* Features list styling */
        .rock-pricing-item .price-list {
            margin-bottom: 25px !important;
        }
        
        .rock-pricing-item .icon-list {
            list-style: none !important;
            padding: 0 !important;
            margin: 0 !important;
        }
        
        .rock-pricing-item .icon-list li {
            margin-bottom: 15px !important;
            padding: 12px 15px !important;
            background: rgba(255, 255, 255, 0.05) !important;
            border-radius: 12px !important;
            border: 1px solid rgba(255, 255, 255, 0.1) !important;
            transition: all 0.3s ease !important;
        }
        
        .rock-pricing-item .icon-list li:hover {
            background: rgba(255, 255, 255, 0.1) !important;
            border-color: rgba(99, 102, 241, 0.3) !important;
            transform: translateX(5px) !important;
        }
        
        .rock-pricing-item .single-list {
            display: flex !important;
            justify-content: space-between !important;
            align-items: center !important;
        }
        
        .rock-pricing-item .list-content {
            display: flex !important;
            align-items: center !important;
            gap: 12px !important;
        }
        
        .rock-pricing-item .list-item-icon {
            width: 35px !important;
            height: 35px !important;
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.2) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
            border-radius: 10px !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            border: 1px solid rgba(99, 102, 241, 0.3) !important;
        }
        
        .rock-pricing-item .list-item-icon svg {
            width: 18px !important;
            height: 18px !important;
        }
        
        .rock-pricing-item .list-item-text {
            color: #e2e8f0 !important;
            font-size: 0.9rem !important;
            font-weight: 500 !important;
            margin: 0 !important;
        }
        
        .rock-pricing-item .list-valu {
            text-align: right !important;
        }
        
        .rock-pricing-item .list-valu span {
            color: #fbbf24 !important;
            font-weight: 600 !important;
            font-size: 0.9rem !important;
            background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%) !important;
            -webkit-background-clip: text !important;
            -webkit-text-fill-color: transparent !important;
            background-clip: text !important;
        }
        
        /* Button styling */
        .rock-pricing-item .price-btn-wrp {
            text-align: center !important;
        }
        
        .rock-pricing-item .site-btn {
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%) !important;
            border: none !important;
            padding: 15px 30px !important;
            border-radius: 15px !important;
            color: #ffffff !important;
            font-weight: 600 !important;
            font-size: 1rem !important;
            text-decoration: none !important;
            display: inline-flex !important;
            align-items: center !important;
            gap: 10px !important;
            transition: all 0.3s ease !important;
            box-shadow: 0 8px 25px rgba(99, 102, 241, 0.3) !important;
            position: relative !important;
            overflow: hidden !important;
        }
        
        .rock-pricing-item .site-btn:hover {
            transform: translateY(-3px) !important;
            box-shadow: 0 12px 35px rgba(99, 102, 241, 0.4) !important;
            background: linear-gradient(135deg, #8b5cf6 0%, #06b6d4 100%) !important;
        }
        
        .rock-pricing-item .site-btn::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: -100% !important;
            width: 100% !important;
            height: 100% !important;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent) !important;
            transition: left 0.5s ease !important;
        }
        
        .rock-pricing-item .site-btn:hover::before {
            left: 100% !important;
        }
        
        /* Return policy info */
        .rock-pricing-item .return-policy-info {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, rgba(139, 92, 246, 0.05) 100%) !important;
            border: 1px solid rgba(99, 102, 241, 0.2) !important;
            border-radius: 12px !important;
            padding: 15px !important;
            margin-top: 15px !important;
        }
        
        .rock-pricing-item .return-policy-info div:first-child {
            color: #6366f1 !important;
            font-weight: 600 !important;
            margin-bottom: 8px !important;
        }
        
        .rock-pricing-item .return-policy-info div:not(:first-child) {
            color: #cbd5e1 !important;
            line-height: 1.4 !important;
            font-size: 0.85rem !important;
        }
        
        /* Description styling */
        .rock-pricing-item .description {
            color: #94a3b8 !important;
            font-size: 0.8rem !important;
            text-align: center !important;
            margin-top: 15px !important;
            line-height: 1.4 !important;
            font-style: italic !important;
        }
        
        /* Remove stone image */
        .rock-pricing-item .price-shape {
            display: none !important;
        }
        
        /* Card glow effect */
        .rock-pricing-item::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            bottom: 0 !important;
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, transparent 50%, rgba(139, 92, 246, 0.1) 100%) !important;
            border-radius: 20px !important;
            opacity: 0 !important;
            transition: opacity 0.3s ease !important;
            pointer-events: none !important;
        }
        
        .rock-pricing-item:hover::before {
            opacity: 1 !important;
        }
        
        /* Section header styling */
        .rock-dashboard-pricing-section {
            padding: 20px 0 !important;
        }
        
        .rock-dashboard-pricing-section .row {
            margin: 0 -15px !important;
        }
        
        .rock-dashboard-pricing-section .col-xxl-3,
        .rock-dashboard-pricing-section .col-xl-3,
        .rock-dashboard-pricing-section .col-lg-6,
        .rock-dashboard-pricing-section .col-md-6 {
            padding: 0 15px !important;
        }
        
        /* ===== CANCEL INVESTMENT BUTTON ===== */
        
        .cancel-investment-btn {
            margin-top: 10px !important;
        }
        
        .btn-cancel-investment {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%) !important;
            color: #ffffff !important;
            padding: 8px 16px !important;
            border-radius: 8px !important;
            font-size: 0.8rem !important;
            font-weight: 600 !important;
            text-decoration: none !important;
            display: inline-flex !important;
            align-items: center !important;
            gap: 6px !important;
            transition: all 0.3s ease !important;
            border: 1px solid rgba(239, 68, 68, 0.3) !important;
            box-shadow: 0 4px 15px rgba(239, 68, 68, 0.2) !important;
        }
        
        .btn-cancel-investment:hover {
            background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%) !important;
            transform: translateY(-2px) !important;
            box-shadow: 0 6px 20px rgba(239, 68, 68, 0.3) !important;
            color: #ffffff !important;
        }
        
        .btn-cancel-investment svg {
            width: 14px !important;
            height: 14px !important;
        }
        
        /* Timeline grid spacing for cancel button */
        .timeline-grid {
            display: flex !important;
            flex-direction: column !important;
            gap: 8px !important;
        }
        
        /* ===== WORLD-CLASS MOBILE RESPONSIVE DESIGN ===== */
        
        /* Mobile-first approach with stunning 3D effects */
        @media (max-width: 768px) {
            /* Mobile container with glassmorphism */
            .rock-schema-logs-area {
                padding: 10px !important;
                background: linear-gradient(135deg, rgba(15, 23, 42, 0.95) 0%, rgba(30, 41, 59, 0.9) 50%, rgba(15, 23, 42, 0.95) 100%) !important;
                backdrop-filter: blur(20px) !important;
                border-radius: 25px !important;
                margin: 10px !important;
                box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.4) !important;
            }
            
            /* Mobile card with 3D depth */
            .rock-dashboard-card {
                background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%) !important;
                backdrop-filter: blur(25px) !important;
                border: 1px solid rgba(255, 255, 255, 0.2) !important;
                border-radius: 20px !important;
                padding: 20px !important;
                box-shadow: 
                    0 25px 50px -12px rgba(0, 0, 0, 0.25),
                    inset 0 1px 0 rgba(255, 255, 255, 0.1) !important;
                position: relative !important;
                overflow: hidden !important;
            }
            
            /* 3D card hover effect */
            .rock-dashboard-card::before {
                content: '' !important;
                position: absolute !important;
                top: 0 !important;
                left: 0 !important;
                right: 0 !important;
                bottom: 0 !important;
                background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, transparent 50%, rgba(139, 92, 246, 0.1) 100%) !important;
                border-radius: 20px !important;
                opacity: 0 !important;
                transition: opacity 0.3s ease !important;
                pointer-events: none !important;
            }
            
            .rock-dashboard-card:hover::before {
                opacity: 1 !important;
            }
            
            /* Mobile search bar with 3D effect */
            .rock-filter-table-form {
                display: flex !important;
                flex-direction: column !important;
                gap: 15px !important;
                margin-bottom: 20px !important;
            }
            
            .rock-single-input .input-field {
                background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%) !important;
                backdrop-filter: blur(15px) !important;
                border: 1px solid rgba(255, 255, 255, 0.2) !important;
                border-radius: 15px !important;
                padding: 12px 15px !important;
                box-shadow: 
                    0 8px 25px rgba(0, 0, 0, 0.15),
                    inset 0 1px 0 rgba(255, 255, 255, 0.1) !important;
                transition: all 0.3s ease !important;
            }
            
            .rock-single-input .input-field:focus-within {
                border-color: rgba(99, 102, 241, 0.5) !important;
                box-shadow: 
                    0 12px 35px rgba(0, 0, 0, 0.2),
                    0 0 0 3px rgba(99, 102, 241, 0.2),
                    inset 0 1px 0 rgba(255, 255, 255, 0.1) !important;
                transform: translateY(-2px) !important;
            }
            
            .rock-single-input .box-input {
                background: transparent !important;
                border: none !important;
                color: #ffffff !important;
                font-size: 16px !important;
                font-weight: 500 !important;
                width: 100% !important;
            }
            
            .rock-single-input .box-input::placeholder {
                color: rgba(255, 255, 255, 0.6) !important;
            }
            
            /* Mobile filter select with 3D effect */
            .filter-length-select select {
                background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%) !important;
                backdrop-filter: blur(15px) !important;
                border: 1px solid rgba(255, 255, 255, 0.2) !important;
                border-radius: 15px !important;
                color: #ffffff !important;
                padding: 12px 15px !important;
                font-size: 16px !important;
                font-weight: 500 !important;
                box-shadow: 
                    0 8px 25px rgba(0, 0, 0, 0.15),
                    inset 0 1px 0 rgba(255, 255, 255, 0.1) !important;
            }
            
            /* Mobile table with card-based layout */
            .rock-schema-logs-table {
                margin-top: 20px !important;
            }
            
            .rock-custom-table .contents {
                display: flex !important;
                flex-direction: column !important;
                gap: 15px !important;
            }
            
            /* Hide desktop table headers on mobile */
            .site-table-head {
                display: none !important;
            }
            
            /* Mobile investment cards with 3D effect */
            .site-table-list:not(.site-table-head) {
                background: linear-gradient(135deg, rgba(255, 255, 255, 0.08) 0%, rgba(255, 255, 255, 0.03) 100%) !important;
                backdrop-filter: blur(20px) !important;
                border: 1px solid rgba(255, 255, 255, 0.15) !important;
                border-radius: 20px !important;
                padding: 20px !important;
                margin: 0 !important;
                box-shadow: 
                    0 15px 35px rgba(0, 0, 0, 0.2),
                    inset 0 1px 0 rgba(255, 255, 255, 0.1) !important;
                transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
                position: relative !important;
                overflow: hidden !important;
            }
            
            .site-table-list:not(.site-table-head):hover {
                transform: translateY(-5px) scale(1.02) !important;
                box-shadow: 
                    0 25px 50px rgba(0, 0, 0, 0.3),
                    inset 0 1px 0 rgba(255, 255, 255, 0.2) !important;
                border-color: rgba(99, 102, 241, 0.3) !important;
            }
            
            /* Mobile card glow effect */
            .site-table-list:not(.site-table-head)::before {
                content: '' !important;
                position: absolute !important;
                top: 0 !important;
                left: 0 !important;
                right: 0 !important;
                bottom: 0 !important;
                background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, transparent 50%, rgba(139, 92, 246, 0.1) 100%) !important;
                border-radius: 20px !important;
                opacity: 0 !important;
                transition: opacity 0.3s ease !important;
                pointer-events: none !important;
            }
            
            .site-table-list:not(.site-table-head):hover::before {
                opacity: 1 !important;
            }
            
            /* Mobile card content layout */
            .site-table-list:not(.site-table-head) .site-table-col {
                display: block !important;
                width: 100% !important;
                margin-bottom: 15px !important;
                padding: 0 !important;
            }
            
            .site-table-list:not(.site-table-head) .site-table-col:last-child {
                margin-bottom: 0 !important;
            }
            
            /* Mobile investment info with 3D styling */
            .site-table-list .description {
                display: flex !important;
                align-items: center !important;
                gap: 15px !important;
                margin-bottom: 15px !important;
            }
            
            .site-table-list .description .iocn {
                width: 50px !important;
                height: 50px !important;
                background: linear-gradient(135deg, rgba(99, 102, 241, 0.2) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
                border-radius: 15px !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                border: 1px solid rgba(99, 102, 241, 0.3) !important;
                box-shadow: 0 8px 25px rgba(99, 102, 241, 0.2) !important;
            }
            
            .site-table-list .description .content .title {
                font-size: 18px !important;
                font-weight: 700 !important;
                margin-bottom: 5px !important;
                background: linear-gradient(135deg, #ffffff 0%, #e2e8f0 100%) !important;
                -webkit-background-clip: text !important;
                -webkit-text-fill-color: transparent !important;
                background-clip: text !important;
            }
            
            .site-table-list .description .content .description {
                color: rgba(255, 255, 255, 0.7) !important;
                font-size: 14px !important;
                margin: 0 !important;
            }
            
            /* Mobile info labels with 3D effect */
            .site-table-list .site-table-col > span:first-child {
                display: block !important;
                font-size: 12px !important;
                font-weight: 600 !important;
                color: rgba(255, 255, 255, 0.6) !important;
                text-transform: uppercase !important;
                letter-spacing: 0.5px !important;
                margin-bottom: 8px !important;
            }
            
            .site-table-list .site-table-col > span:not(:first-child) {
                display: block !important;
                font-size: 16px !important;
                font-weight: 600 !important;
                color: #ffffff !important;
                background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%) !important;
                padding: 8px 12px !important;
                border-radius: 10px !important;
                border: 1px solid rgba(255, 255, 255, 0.1) !important;
            }
            
            /* Mobile timeline with 3D progress bar */
            .timeline-grid {
                background: linear-gradient(135deg, rgba(255, 255, 255, 0.05) 0%, rgba(255, 255, 255, 0.02) 100%) !important;
                border: 1px solid rgba(255, 255, 255, 0.1) !important;
                border-radius: 15px !important;
                padding: 15px !important;
                margin-top: 10px !important;
            }
            
            .timeline-grid .white-text {
                font-size: 14px !important;
                font-weight: 600 !important;
                color: #ffffff !important;
                margin-bottom: 10px !important;
            }
            
            .single-progress {
                margin: 10px 0 !important;
            }
            
            .single-progress .progress {
                height: 8px !important;
                background: rgba(255, 255, 255, 0.1) !important;
                border-radius: 10px !important;
                overflow: hidden !important;
                box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.2) !important;
            }
            
            .single-progress .progress-bar {
                background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 50%, #06b6d4 100%) !important;
                border-radius: 10px !important;
                box-shadow: 0 2px 8px rgba(99, 102, 241, 0.3) !important;
                transition: width 0.3s ease !important;
            }
            
            /* Mobile cancel button with 3D effect */
            .cancel-investment-btn {
                margin-top: 15px !important;
            }
            
            .btn-cancel-investment {
                width: 100% !important;
                justify-content: center !important;
                padding: 12px 20px !important;
                font-size: 14px !important;
                border-radius: 12px !important;
                box-shadow: 
                    0 8px 25px rgba(239, 68, 68, 0.3),
                    inset 0 1px 0 rgba(255, 255, 255, 0.1) !important;
            }
            
            .btn-cancel-investment:hover {
                transform: translateY(-3px) !important;
                box-shadow: 
                    0 12px 35px rgba(239, 68, 68, 0.4),
                    inset 0 1px 0 rgba(255, 255, 255, 0.2) !important;
            }
            
            /* Mobile badges with 3D effect */
            .rock-badge {
                padding: 8px 16px !important;
                border-radius: 20px !important;
                font-size: 12px !important;
                font-weight: 600 !important;
                text-transform: uppercase !important;
                letter-spacing: 0.5px !important;
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2) !important;
                border: 1px solid rgba(255, 255, 255, 0.1) !important;
            }
            
            .rock-badge.success {
                background: linear-gradient(135deg, #10b981 0%, #059669 100%) !important;
                color: #ffffff !important;
            }
            
            .rock-badge.warning {
                background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%) !important;
                color: #ffffff !important;
            }
            
            /* Mobile pagination with 3D effect */
            .pagination {
                justify-content: center !important;
                margin-top: 30px !important;
            }
            
            .pagination .page-link {
                background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%) !important;
                border: 1px solid rgba(255, 255, 255, 0.2) !important;
                color: #ffffff !important;
                border-radius: 10px !important;
                margin: 0 5px !important;
                padding: 10px 15px !important;
                font-weight: 600 !important;
                transition: all 0.3s ease !important;
            }
            
            .pagination .page-link:hover {
                background: linear-gradient(135deg, rgba(99, 102, 241, 0.2) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
                border-color: rgba(99, 102, 241, 0.5) !important;
                transform: translateY(-2px) !important;
            }
            
            .pagination .page-item.active .page-link {
                background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%) !important;
                border-color: #6366f1 !important;
                box-shadow: 0 8px 25px rgba(99, 102, 241, 0.3) !important;
            }
            
            /* Mobile no data message */
            .alert-table {
                background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%) !important;
                border: 1px solid rgba(255, 255, 255, 0.2) !important;
                border-radius: 15px !important;
                color: #ffffff !important;
                padding: 30px !important;
                text-align: center !important;
                font-size: 16px !important;
                font-weight: 500 !important;
            }
        }
        
        /* Tablet responsive design */
        @media (min-width: 769px) and (max-width: 1024px) {
            .rock-schema-logs-area {
                padding: 20px !important;
            }
            
            .rock-dashboard-card {
                padding: 25px !important;
            }
            
            .site-table-list:not(.site-table-head) {
                padding: 25px !important;
            }
        }
        
        /* ===== NEW PROFESSIONAL NAVIGATION SYSTEM ===== */
        
        /* Professional Navigation Toggle Button */
        .rock-nav-toggle {
            display: none !important;
            position: fixed !important;
            top: 20px !important;
            left: 20px !important;
            z-index: 10000 !important;
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.9) 0%, rgba(139, 92, 246, 0.9) 100%) !important;
            border: none !important;
            border-radius: 15px !important;
            padding: 15px !important;
            cursor: pointer !important;
            box-shadow: 0 10px 30px rgba(99, 102, 241, 0.4) !important;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
            backdrop-filter: blur(10px) !important;
        }
        
        .rock-nav-toggle:hover {
            transform: scale(1.1) !important;
            box-shadow: 0 15px 40px rgba(99, 102, 241, 0.6) !important;
        }
        
        .rock-nav-toggle .nav-line {
            display: block !important;
            width: 25px !important;
            height: 3px !important;
            background: #ffffff !important;
            margin: 4px 0 !important;
            border-radius: 2px !important;
            transition: all 0.3s ease !important;
            transform-origin: center !important;
        }
        
        .rock-nav-toggle.active .nav-line:nth-child(1) {
            transform: rotate(45deg) translate(6px, 6px) !important;
        }
        
        .rock-nav-toggle.active .nav-line:nth-child(2) {
            opacity: 0 !important;
        }
        
        .rock-nav-toggle.active .nav-line:nth-child(3) {
            transform: rotate(-45deg) translate(6px, -6px) !important;
        }
        
        /* Professional Sidebar */
        .rock-professional-sidebar {
            position: fixed !important;
            top: 0 !important;
            left: -350px !important;
            width: 320px !important;
            height: 100vh !important;
            background: linear-gradient(135deg, rgba(15, 23, 42, 0.98) 0%, rgba(30, 41, 59, 0.95) 50%, rgba(15, 23, 42, 0.98) 100%) !important;
            backdrop-filter: blur(25px) !important;
            border-right: 1px solid rgba(255, 255, 255, 0.1) !important;
            z-index: 9999 !important;
            transition: left 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
            overflow-y: auto !important;
            overflow-x: hidden !important;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.3) !important;
            scrollbar-width: thin !important;
            scrollbar-color: rgba(99, 102, 241, 0.5) transparent !important;
        }
        
        /* Custom scrollbar for sidebar */
        .rock-professional-sidebar::-webkit-scrollbar {
            width: 6px !important;
        }
        
        .rock-professional-sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05) !important;
            border-radius: 3px !important;
        }
        
        .rock-professional-sidebar::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.6) 0%, rgba(139, 92, 246, 0.6) 100%) !important;
            border-radius: 3px !important;
            transition: all 0.3s ease !important;
        }
        
        .rock-professional-sidebar::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.8) 0%, rgba(139, 92, 246, 0.8) 100%) !important;
        }
        
        .rock-professional-sidebar.show {
            left: 0 !important;
        }
        
        /* Sidebar Header */
        .sidebar-header {
            padding: 25px 20px !important;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1) !important;
            display: flex !important;
            align-items: center !important;
            justify-content: space-between !important;
        }
        
        .logo-section {
            display: flex !important;
            align-items: center !important;
            gap: 15px !important;
        }
        
        .logo-icon {
            width: 50px !important;
            height: 50px !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            border-radius: 15px !important;
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.2) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
            border: 1px solid rgba(99, 102, 241, 0.3) !important;
        }
        
        .logo-text h3 {
            color: #ffffff !important;
            font-size: 18px !important;
            font-weight: 700 !important;
            margin: 0 !important;
            background: linear-gradient(135deg, #ffffff 0%, #e2e8f0 100%) !important;
            -webkit-background-clip: text !important;
            -webkit-text-fill-color: transparent !important;
            background-clip: text !important;
        }
        
        .logo-text p {
            color: rgba(255, 255, 255, 0.6) !important;
            font-size: 12px !important;
            margin: 0 !important;
            font-weight: 500 !important;
        }
        
        .close-sidebar {
            background: rgba(255, 255, 255, 0.1) !important;
            border: none !important;
            border-radius: 10px !important;
            padding: 8px !important;
            color: rgba(255, 255, 255, 0.7) !important;
            cursor: pointer !important;
            transition: all 0.3s ease !important;
        }
        
        .close-sidebar:hover {
            background: rgba(255, 255, 255, 0.2) !important;
            color: #ffffff !important;
            transform: scale(1.1) !important;
        }
        
        /* Sidebar Content */
        .sidebar-content {
            padding: 20px 0 !important;
        }
        
        .rock-nav-menu {
            padding: 0 !important;
        }
        
        .nav-list {
            list-style: none !important;
            margin: 0 !important;
            padding: 0 !important;
        }
        
        .nav-item {
            margin: 0 !important;
        }
        
        .nav-link {
            display: flex !important;
            align-items: center !important;
            gap: 15px !important;
            padding: 15px 25px !important;
            color: rgba(255, 255, 255, 0.7) !important;
            text-decoration: none !important;
            transition: all 0.3s ease !important;
            position: relative !important;
            border-radius: 0 !important;
        }
        
        .nav-link:hover {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, rgba(139, 92, 246, 0.05) 100%) !important;
            color: #ffffff !important;
            transform: translateX(5px) !important;
        }
        
        .nav-link.active {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.2) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
            color: #ffffff !important;
            border-right: 3px solid #6366f1 !important;
        }
        
        .nav-link.active .nav-indicator {
            opacity: 1 !important;
            transform: scale(1) !important;
        }
        
        .nav-icon {
            width: 20px !important;
            height: 20px !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            flex-shrink: 0 !important;
        }
        
        .nav-text {
            font-size: 15px !important;
            font-weight: 500 !important;
            flex: 1 !important;
        }
        
        .nav-indicator {
            width: 6px !important;
            height: 6px !important;
            background: #6366f1 !important;
            border-radius: 50% !important;
            opacity: 0 !important;
            transform: scale(0) !important;
            transition: all 0.3s ease !important;
        }
        
        /* Sidebar Footer */
        .sidebar-footer {
            padding: 20px !important;
            border-top: 1px solid rgba(255, 255, 255, 0.1) !important;
            margin-top: auto !important;
        }
        
        .user-info {
            display: flex !important;
            align-items: center !important;
            gap: 12px !important;
            margin-bottom: 15px !important;
        }
        
        .user-avatar {
            width: 40px !important;
            height: 40px !important;
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.2) 0%, rgba(139, 92, 246, 0.1) 100%) !important;
            border-radius: 12px !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            border: 1px solid rgba(99, 102, 241, 0.3) !important;
        }
        
        .user-details h4 {
            color: #ffffff !important;
            font-size: 14px !important;
            font-weight: 600 !important;
            margin: 0 !important;
        }
        
        .user-details p {
            color: rgba(255, 255, 255, 0.6) !important;
            font-size: 12px !important;
            margin: 0 !important;
        }
        
        .logout-btn {
            display: flex !important;
            align-items: center !important;
            gap: 10px !important;
            padding: 12px 15px !important;
            background: linear-gradient(135deg, rgba(239, 68, 68, 0.1) 0%, rgba(220, 38, 38, 0.05) 100%) !important;
            border: 1px solid rgba(239, 68, 68, 0.2) !important;
            border-radius: 12px !important;
            color: rgba(239, 68, 68, 0.8) !important;
            text-decoration: none !important;
            font-size: 14px !important;
            font-weight: 500 !important;
            transition: all 0.3s ease !important;
        }
        
        .logout-btn:hover {
            background: linear-gradient(135deg, rgba(239, 68, 68, 0.2) 0%, rgba(220, 38, 38, 0.1) 100%) !important;
            color: #ef4444 !important;
            transform: translateY(-2px) !important;
        }
        
        /* Navigation Overlay */
        .rock-nav-overlay {
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            width: 100% !important;
            height: 100% !important;
            background: rgba(0, 0, 0, 0.6) !important;
            z-index: 9998 !important;
            opacity: 0 !important;
            visibility: hidden !important;
            transition: all 0.3s ease !important;
            backdrop-filter: blur(5px) !important;
        }
        
        .rock-nav-overlay.show {
            opacity: 1 !important;
            visibility: visible !important;
        }
        
        /* Show navigation toggle on mobile */
        @media (max-width: 768px) {
            .rock-nav-toggle {
            display: block !important;
            }
        }
        
        /* Hide on desktop */
        @media (min-width: 769px) {
            .rock-nav-toggle,
            .rock-professional-sidebar,
            .rock-nav-overlay {
                display: none !important;
            }
        }
        
        /* ===== MOBILE LAYOUT FIXES ===== */
        
        /* Fix mobile sidebar and main content layout */
        @media (max-width: 768px) {
            /* Fix page wrapper for mobile */
            .page-wrapper {
                display: flex !important;
                flex-direction: column !important;
                min-height: 100vh !important;
            }
            
            /* Fix sidebar positioning on mobile */
            .rock-sidebar,
            .rock-sidebar-wrapper,
            .sidebar,
            .side-nav {
                position: fixed !important;
                top: 0 !important;
                left: -100% !important;
                width: 280px !important;
                height: 100vh !important;
                z-index: 9999 !important;
                transition: left 0.3s ease !important;
                background: linear-gradient(135deg, rgba(15, 23, 42, 0.95) 0%, rgba(30, 41, 59, 0.9) 100%) !important;
                backdrop-filter: blur(20px) !important;
                border-right: 1px solid rgba(255, 255, 255, 0.1) !important;
            }
            
            /* Show sidebar when mobile menu is open */
            .rock-sidebar.show,
            .rock-sidebar-wrapper.show,
            .sidebar.show,
            .side-nav.show {
                left: 0 !important;
            }
            
            /* Mobile sidebar overlay */
            .sidebar-overlay {
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
                background: rgba(0, 0, 0, 0.5) !important;
                z-index: 9998 !important;
                opacity: 0 !important;
                visibility: hidden !important;
                transition: all 0.3s ease !important;
            }
            
            .sidebar-overlay.show {
                opacity: 1 !important;
            visibility: visible !important;
            }
            
            /* Fix main content area for mobile */
            .rock-page-body-wrapper {
                margin-left: 0 !important;
                width: 100% !important;
                padding: 0 !important;
                margin-top: 0 !important;
            }
            
            .rock-page-body {
                margin-left: 0 !important;
                width: 100% !important;
                padding: 15px !important;
                margin-top: 0 !important;
            }
            
            /* Fix header for mobile */
            .rock-page-header,
            .rock-dashboard-header {
                position: relative !important;
                top: 0 !important;
                left: 0 !important;
                margin-left: 0 !important;
                width: 100% !important;
                padding: 15px !important;
                background: linear-gradient(135deg, rgba(15, 23, 42, 0.95) 0%, rgba(30, 41, 59, 0.9) 100%) !important;
                backdrop-filter: blur(20px) !important;
                border-bottom: 1px solid rgba(255, 255, 255, 0.1) !important;
            }
            
            /* Hide old mobile menu button and hamburger */
            .mobile-menu-btn,
            .hamburger,
            #hamburger {
                display: none !important;
            }
            
            /* Hide desktop menu button */
            .desktop-menu-btn {
                display: none !important;
            }
            
            /* Fix container and content positioning */
            .container-fluid,
            .default-page {
                margin: 0 !important;
                padding: 0 !important;
                width: 100% !important;
            }
            
            /* Fix announcement bar for mobile */
            .announcement-bar {
                margin: 0 !important;
                padding: 10px 15px !important;
                border-radius: 0 !important;
                background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, rgba(139, 92, 246, 0.05) 100%) !important;
                border-bottom: 1px solid rgba(255, 255, 255, 0.1) !important;
            }
            
            /* Fix scrolling text for mobile */
            .scrolling-text {
                font-size: 14px !important;
                animation: scroll-left 15s linear infinite !important;
            }
            
            /* Fix welcome text for mobile */
            div[style*="text-align: center"] h3 {
                font-size: 16px !important;
                padding: 10px 20px !important;
                margin: 15px 0 !important;
            }
            
            /* Fix dashboard cards for mobile */
            .dashboard-card,
            .rock-dashboard-card,
            .rock-single-card {
                margin: 10px 0 !important;
                width: 100% !important;
                max-width: none !important;
            }
            
            /* Fix dashboard level area for mobile */
            .rock-dashboard-level-area {
                padding: 15px !important;
            }
            
            .rock-dashboard-level-area .row {
                margin: 0 !important;
                display: flex !important;
                flex-direction: column !important;
                gap: 15px !important;
            }
            
            .rock-dashboard-level-area .col-xxl-3,
            .rock-dashboard-level-area .col-xl-3,
            .rock-dashboard-level-area .col-lg-6,
            .rock-dashboard-level-area .col-md-6 {
                width: 100% !important;
                padding: 0 !important;
                margin: 0 !important;
            }
            
            /* Fix banner padding for mobile */
            .banner-style-four {
                padding-top: 0 !important;
                padding-bottom: 0 !important;
            }
            
            /* Fix main content positioning */
            .main-content,
            .content-area,
            .page-content {
                margin-top: 0 !important;
                padding-top: 0 !important;
                padding: 15px !important;
            }
            
            /* Fix default page positioning */
            .default-page,
            .rock-desktop-screen-show {
                margin-top: 0 !important;
                padding-top: 0 !important;
                padding: 15px !important;
            }
            
            /* Fix body and html positioning */
            body,
            html {
                margin: 0 !important;
                padding: 0 !important;
                overflow-x: hidden !important;
            }
            
            /* Fix rock page body wrapper positioning */
            .rock-page-body-wrapper,
            .rock-page-body {
                margin-top: 0 !important;
                padding-top: 0 !important;
            }
        }
        
        /* ===== DROPDOWN FIXES ===== */
        
        /* Fix all dropdowns and select elements */
        .site-nice-select,
        .nice-select,
        select,
        .form-select,
        .form-control {
            background: rgba(255, 255, 255, 0.1) !important;
            backdrop-filter: blur(10px) !important;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
            border-radius: 10px !important;
            color: #ffffff !important;
            padding: 12px 15px !important;
            font-size: 0.9rem !important;
            font-weight: 500 !important;
            transition: all 0.3s ease !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
        }
        
        .site-nice-select:hover,
        .nice-select:hover,
        select:hover,
        .form-select:hover,
        .form-control:hover {
            background: rgba(255, 255, 255, 0.15) !important;
            border-color: rgba(99, 102, 241, 0.5) !important;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15) !important;
        }
        
        .site-nice-select:focus,
        .nice-select:focus,
        select:focus,
        .form-select:focus,
        .form-control:focus {
            background: rgba(255, 255, 255, 0.2) !important;
            border-color: #6366f1 !important;
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.2) !important;
            outline: none !important;
        }
        
        /* Dropdown options styling */
        .site-nice-select .list,
        .nice-select .list,
        .dropdown-menu,
        .select2-dropdown {
            background: rgba(15, 23, 42, 0.95) !important;
            backdrop-filter: blur(20px) !important;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
            border-radius: 12px !important;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5) !important;
            padding: 8px 0 !important;
        }
        
        .site-nice-select .list li,
        .nice-select .list li,
        .dropdown-menu li,
        .dropdown-item,
        .select2-results__option {
            color: #e2e8f0 !important;
            padding: 10px 15px !important;
            transition: all 0.3s ease !important;
            border-radius: 8px !important;
            margin: 2px 8px !important;
        }
        
        .site-nice-select .list li:hover,
        .nice-select .list li:hover,
        .dropdown-menu li:hover,
        .dropdown-item:hover,
        .select2-results__option:hover {
            background: rgba(99, 102, 241, 0.2) !important;
            color: #ffffff !important;
        }
        
        .site-nice-select .list li.selected,
        .nice-select .list li.selected,
        .dropdown-menu li.selected,
        .dropdown-item.selected,
        .select2-results__option--selected {
            background: rgba(99, 102, 241, 0.3) !important;
            color: #ffffff !important;
        }
        
        /* Nice select specific fixes */
        .nice-select .current {
            color: #ffffff !important;
        }
        
        .nice-select .list {
            z-index: 9999 !important;
        }
        
        /* Form control specific fixes */
        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.6) !important;
        }
        
        .form-control:focus::placeholder {
            color: rgba(255, 255, 255, 0.8) !important;
        }
        
        /* Input group fixes */
        .input-group .form-control {
            border-right: none !important;
            border-top-right-radius: 0 !important;
            border-bottom-right-radius: 0 !important;
        }
        
        .input-group .input-group-text {
            background: rgba(255, 255, 255, 0.1) !important;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
            border-left: none !important;
            color: #ffffff !important;
            border-top-right-radius: 10px !important;
            border-bottom-right-radius: 10px !important;
        }
        
        /* Ensure dropdowns are visible */
        .nice-select.open .list,
        .site-nice-select.open .list {
            display: block !important;
            opacity: 1 !important;
            visibility: visible !important;
            transform: translateY(0) !important;
        }
        
        /* ===== INVESTIFY SCHEMA PREVIEW DROPDOWN FIXES ===== */
        
        /* Fix Investify schema preview dropdowns */
        .rock-schema-preview-area select,
        .rock-single-input select,
        .input-select select,
        #select-schema,
        #selectWallet {
            background: rgba(255, 255, 255, 0.1) !important;
            backdrop-filter: blur(10px) !important;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
            border-radius: 10px !important;
            color: #ffffff !important;
            padding: 12px 15px !important;
            font-size: 0.9rem !important;
            font-weight: 500 !important;
            transition: all 0.3s ease !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
            width: 100% !important;
            appearance: auto !important;
            -webkit-appearance: auto !important;
            -moz-appearance: auto !important;
        }
        
        .rock-schema-preview-area select:hover,
        .rock-single-input select:hover,
        .input-select select:hover,
        #select-schema:hover,
        #selectWallet:hover {
            background: rgba(255, 255, 255, 0.15) !important;
            border-color: rgba(99, 102, 241, 0.5) !important;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15) !important;
        }
        
        .rock-schema-preview-area select:focus,
        .rock-single-input select:focus,
        .input-select select:focus,
        #select-schema:focus,
        #selectWallet:focus {
            background: rgba(255, 255, 255, 0.2) !important;
            border-color: #6366f1 !important;
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.2) !important;
            outline: none !important;
        }
        
        /* Dropdown options for Investify */
        .rock-schema-preview-area select option,
        .rock-single-input select option,
        .input-select select option,
        #select-schema option,
        #selectWallet option {
            background: rgba(15, 23, 42, 0.95) !important;
            color: #ffffff !important;
            padding: 10px 15px !important;
        }
        
        .rock-schema-preview-area select option:hover,
        .rock-single-input select option:hover,
        .input-select select option:hover,
        #select-schema option:hover,
        #selectWallet option:hover {
            background: rgba(99, 102, 241, 0.3) !important;
        }
        
        /* Force dropdown visibility */
        .rock-schema-preview-area select:focus,
        .rock-single-input select:focus,
        .input-select select:focus,
        #select-schema:focus,
        #selectWallet:focus {
            z-index: 9999 !important;
        }
        
        /* Ensure dropdown container is visible */
        .rock-single-input,
        .input-select {
            position: relative !important;
            z-index: 1000 !important;
        }
        
        /* Override any hidden dropdowns */
        .rock-schema-preview-area select,
        .rock-single-input select,
        .input-select select,
        #select-schema,
        #selectWallet {
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
        }
        
        /* Force native dropdown appearance */
        .rock-schema-preview-area select,
        .rock-single-input select,
        .input-select select,
        #select-schema,
        #selectWallet {
            -webkit-appearance: menulist !important;
            -moz-appearance: menulist !important;
            appearance: menulist !important;
            background-image: none !important;
        }
        
        /* Remove any custom dropdown styling that might interfere */
        .nice-select,
        .site-nice-select {
            display: none !important;
        }
        
        /* Ensure native select is always visible */
        select {
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
            pointer-events: auto !important;
        }
    </style>

    <title>{{ setting('site_title', 'global') }} - @yield('title')</title>
    
    <!-- Professional Preloader HTML -->
    <div class="preloader" id="preloader">
        <div class="preloader-content">
            <div class="preloader-logo">Block Wave Trade</div>
            <div class="preloader-subtitle">Invest Today, Empower Tomorrow</div>
            <div class="preloader-spinner"></div>
            <div class="preloader-progress">
                <div class="preloader-progress-bar"></div>
            </div>
            <div class="preloader-text">Loading...</div>
        </div>
    </div>
    
    <!-- Preloader JavaScript -->
    <script>
    // Hide preloader immediately when DOM is ready
    document.addEventListener('DOMContentLoaded', function() {
        const preloader = document.getElementById('preloader');
        if (preloader) {
            // Hide preloader after 1 second
            setTimeout(function() {
                preloader.classList.add('fade-out');
                setTimeout(function() {
                    preloader.classList.add('preloader-hidden');
                }, 300);
            }, 1000);
        }
    });
    
    // Hide preloader when page is fully loaded
    window.addEventListener('load', function() {
        const preloader = document.getElementById('preloader');
        if (preloader) {
            preloader.classList.add('fade-out');
            setTimeout(function() {
                preloader.classList.add('preloader-hidden');
            }, 300);
        }
    });
    
    // Force hide preloader after 3 seconds maximum
    setTimeout(function() {
        const preloader = document.getElementById('preloader');
        if (preloader) {
            preloader.classList.add('fade-out');
            setTimeout(function() {
                preloader.classList.add('preloader-hidden');
            }, 300);
        }
    }, 3000);
    
    // Fix dropdown functionality
    document.addEventListener('DOMContentLoaded', function() {
        // Remove any nice-select initialization
        if (typeof $.fn.niceSelect !== 'undefined') {
            $('select').niceSelect('destroy');
        }
        
        // Ensure all selects are native
        const selects = document.querySelectorAll('select');
        selects.forEach(function(select) {
            select.style.display = 'block';
            select.style.visibility = 'visible';
            select.style.opacity = '1';
            select.style.pointerEvents = 'auto';
            select.style.webkitAppearance = 'menulist';
            select.style.mozAppearance = 'menulist';
            select.style.appearance = 'menulist';
        });
        
        // Remove any nice-select wrappers
        const niceSelects = document.querySelectorAll('.nice-select, .site-nice-select');
        niceSelects.forEach(function(niceSelect) {
            const originalSelect = niceSelect.querySelector('select');
            if (originalSelect) {
                niceSelect.parentNode.insertBefore(originalSelect, niceSelect);
                niceSelect.remove();
            }
        });
        
        // New Professional Navigation System
        const rockNavToggle = document.getElementById('rockNavToggle');
        const rockNavOverlay = document.getElementById('rockNavOverlay');
        const rockProfessionalSidebar = document.getElementById('rockProfessionalSidebar');
        const closeSidebar = document.getElementById('closeSidebar');
        
        if (rockNavToggle && rockNavOverlay && rockProfessionalSidebar) {
            // Toggle professional navigation
            rockNavToggle.addEventListener('click', function() {
                rockProfessionalSidebar.classList.toggle('show');
                rockNavOverlay.classList.toggle('show');
                rockNavToggle.classList.toggle('active');
            });
            
            // Close sidebar when overlay is clicked
            rockNavOverlay.addEventListener('click', function() {
                rockProfessionalSidebar.classList.remove('show');
                rockNavOverlay.classList.remove('show');
                rockNavToggle.classList.remove('active');
            });
            
            // Close sidebar when close button is clicked
            if (closeSidebar) {
                closeSidebar.addEventListener('click', function() {
                    rockProfessionalSidebar.classList.remove('show');
                    rockNavOverlay.classList.remove('show');
                    rockNavToggle.classList.remove('active');
                });
            }
            
            // Close sidebar when window is resized to desktop
            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    rockProfessionalSidebar.classList.remove('show');
                    rockNavOverlay.classList.remove('show');
                    rockNavToggle.classList.remove('active');
                }
            });
            
            // Close sidebar when clicking on nav links
            const navLinks = document.querySelectorAll('.nav-link');
            navLinks.forEach(function(link) {
                link.addEventListener('click', function() {
                    setTimeout(function() {
                        rockProfessionalSidebar.classList.remove('show');
                        rockNavOverlay.classList.remove('show');
                        rockNavToggle.classList.remove('active');
                    }, 300);
                });
            });
        }
    });
    </script>
</head>
