<!-- InvestFlow Header -->
<header id="main-header" class="main-header">
    <div class="header-content">
        <div class="header-left">
            <button class="menu-btn" onclick="toggleSidebar()">
                <i class="fas fa-bars"></i>
            </button>
            <div class="logo-header">
                <div class="logo-small">
                    <i class="fas fa-chart-line"></i>
                </div>
                <span class="app-name">{{ setting('site_name', 'ShahBlock') }}</span>
            </div>
        </div>
        <div class="header-right">
            <button class="notification-btn" onclick="toggleNotifications()">
                <i class="fas fa-bell"></i>
                <span class="notification-badge" id="notification-count">3</span>
            </button>
            <div class="user-avatar" onclick="toggleUserMenu()">
                <i class="fas fa-user"></i>
            </div>
        </div>
    </div>
</header>

<!-- InvestFlow Sidebar -->
<div id="sidebar" class="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">
            <div class="logo">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="sidebar-brand">
                <h3>{{ setting('site_name', 'ShahBlock') }}</h3>
                <p>Smart Investing</p>
            </div>
        </div>
        <button class="sidebar-close" onclick="toggleSidebar()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="sidebar-content">
        <div class="user-info">
            <div class="user-avatar-large">
                <i class="fas fa-user"></i>
            </div>
            <div class="user-details">
                <h4>{{ Auth::user()->first_name }} {{ Auth::user()->last_name }}</h4>
                <p>Premium Member</p>
            </div>
        </div>
        
        <nav class="sidebar-nav">
            <div class="nav-section">
                <span class="nav-title">Main</span>
                <a href="{{ route('user.dashboard') }}" class="nav-link {{ request()->routeIs('user.dashboard') ? 'active' : '' }}">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
                <a href="{{ route('user.schema') }}" class="nav-link {{ request()->routeIs('user.schema*') ? 'active' : '' }}">
                    <i class="fas fa-wallet"></i>
                    <span>My Wallets</span>
                </a>
                <a href="{{ route('user.transactions') }}" class="nav-link {{ request()->routeIs('user.transactions*') ? 'active' : '' }}">
                    <i class="fas fa-history"></i>
                    <span>Transactions</span>
                </a>
                <a href="{{ route('user.referral') }}" class="nav-link {{ request()->routeIs('user.referral*') ? 'active' : '' }}">
                    <i class="fas fa-users"></i>
                    <span>Referrals</span>
                </a>
            </div>
            
            <div class="nav-section">
                <span class="nav-title">Actions</span>
                <a href="{{ route('user.deposit.amount') }}" class="nav-link {{ request()->routeIs('user.deposit*') ? 'active' : '' }}">
                    <i class="fas fa-plus-circle"></i>
                    <span>Deposit</span>
                </a>
                <a href="{{ route('user.withdraw.simple.index') }}" class="nav-link {{ request()->routeIs('user.withdraw*') ? 'active' : '' }}">
                    <i class="fas fa-minus-circle"></i>
                    <span>Withdraw</span>
                </a>
            </div>
            
            <div class="nav-section">
                <span class="nav-title">Account</span>
                <a href="{{ route('user.profile') }}" class="nav-link {{ request()->routeIs('user.profile*') ? 'active' : '' }}">
                    <i class="fas fa-user-cog"></i>
                    <span>Profile Settings</span>
                </a>
                <a href="{{ route('user.kyc') }}" class="nav-link {{ request()->routeIs('user.kyc*') ? 'active' : '' }}">
                    <i class="fas fa-shield-alt"></i>
                    <span>Security & Verification</span>
                </a>
                <a href="{{ route('user.payment-methods') }}" class="nav-link {{ request()->routeIs('user.payment-methods*') ? 'active' : '' }}">
                    <i class="fas fa-credit-card"></i>
                    <span>Payment Methods</span>
                </a>
            </div>
        </nav>
    </div>
</div>

<!-- Sidebar Overlay -->
<div id="sidebar-overlay" class="sidebar-overlay" onclick="toggleSidebar()"></div>

<!-- Notification Panel -->
<div id="notification-panel" class="notification-panel">
    <div class="notification-header">
        <h3>Notifications</h3>
        <button class="close-btn" onclick="toggleNotifications()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    <div class="notification-list">
        <div class="notification-item">
            <div class="notification-icon">
                <i class="fas fa-info-circle"></i>
            </div>
            <div class="notification-content">
                <h4>Welcome to {{ setting('site_name', 'ShahBlock') }}!</h4>
                <p>Start your investment journey today.</p>
                <span class="notification-time">2 minutes ago</span>
            </div>
        </div>
    </div>
</div>

<!-- User Menu -->
<div id="user-menu" class="user-menu">
    <div class="user-menu-item" onclick="window.location.href='{{ route('user.profile') }}'">
        <i class="fas fa-user"></i>
        <span>Profile</span>
    </div>
    <div class="user-menu-item" onclick="window.location.href='{{ route('user.settings') }}'">
        <i class="fas fa-cog"></i>
        <span>Settings</span>
    </div>
    <div class="user-menu-item" onclick="window.location.href='{{ route('user.logout') }}'">
        <i class="fas fa-sign-out-alt"></i>
        <span>Logout</span>
    </div>
</div>