<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sidebar functionality
    const menuToggle = document.getElementById('menuToggle');
    const professionalSidebar = document.getElementById('professionalSidebar');
    const sidebarOverlay = document.getElementById('sidebarOverlay');
    const closeSidebar = document.getElementById('closeSidebar');
    
    if (menuToggle && professionalSidebar && sidebarOverlay) {
        menuToggle.addEventListener('click', function() {
            professionalSidebar.classList.toggle('show');
            sidebarOverlay.classList.toggle('show');
            menuToggle.classList.toggle('active');
        });
        
        sidebarOverlay.addEventListener('click', function() {
            professionalSidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
            menuToggle.classList.remove('active');
        });
        
        if (closeSidebar) {
            closeSidebar.addEventListener('click', function() {
                professionalSidebar.classList.remove('show');
                sidebarOverlay.classList.remove('show');
                menuToggle.classList.remove('active');
            });
        }
        
        // Close sidebar when window is resized to desktop
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                professionalSidebar.classList.remove('show');
                sidebarOverlay.classList.remove('show');
                menuToggle.classList.remove('active');
            }
        });
        
        // Close sidebar when clicking on nav links
        const navLinks = document.querySelectorAll('.sidebar-navigation .nav-link');
        navLinks.forEach(function(link) {
            link.addEventListener('click', function() {
                setTimeout(function() {
                    professionalSidebar.classList.remove('show');
                    sidebarOverlay.classList.remove('show');
                    menuToggle.classList.remove('active');
                }, 300);
            });
        });
    }
    
    // Back to top functionality
    const backToTop = document.getElementById('backToTop');
    if (backToTop) {
        window.addEventListener('scroll', function() {
            if (window.pageYOffset > 300) {
                backToTop.classList.add('show');
            } else {
                backToTop.classList.remove('show');
            }
        });
        
        backToTop.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    }
    
    // Language dropdown functionality
    const langToggle = document.getElementById('langToggle');
    const langDropdown = document.getElementById('langDropdown');
    
    if (langToggle && langDropdown) {
        langToggle.addEventListener('click', function(e) {
            e.stopPropagation();
            langDropdown.style.display = langDropdown.style.display === 'block' ? 'none' : 'block';
        });
        
        document.addEventListener('click', function() {
            langDropdown.style.display = 'none';
        });
    }
    
    // Add smooth scrolling to all anchor links
    const anchorLinks = document.querySelectorAll('a[href^="#"]');
    anchorLinks.forEach(function(link) {
        link.addEventListener('click', function(e) {
            const href = this.getAttribute('href');
            if (href === '#') return;
            
            e.preventDefault();
            const target = document.querySelector(href);
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
    
    // Add loading states to buttons
    const buttons = document.querySelectorAll('.btn-dashboard, .btn-login, .btn-register');
    buttons.forEach(function(button) {
        button.addEventListener('click', function() {
            const originalText = this.innerHTML;
            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Loading...';
            this.disabled = true;
            
            // Re-enable after 2 seconds (for demo purposes)
            setTimeout(function() {
                button.innerHTML = originalText;
                button.disabled = false;
            }, 2000);
        });
    });
    
    // Add haptic feedback for mobile devices
    function triggerHapticFeedback(type = 'light') {
        if (navigator.vibrate) {
            switch(type) {
                case 'light':
                    navigator.vibrate(10);
                    break;
                case 'medium':
                    navigator.vibrate(20);
                    break;
                case 'heavy':
                    navigator.vibrate([20, 10, 20]);
                    break;
            }
        }
    }
    
    // Add click feedback to interactive elements
    const interactiveElements = document.querySelectorAll('button, .nav-link, .social-link, .btn-dashboard, .btn-login, .btn-register');
    interactiveElements.forEach(function(element) {
        element.addEventListener('click', function() {
            triggerHapticFeedback('light');
            
            // Visual click feedback
            this.style.transform = 'scale(0.95)';
            setTimeout(() => {
                this.style.transform = '';
            }, 100);
        });
    });
    
    // Add keyboard navigation support
    document.addEventListener('keydown', function(e) {
        // Escape key to close sidebar
        if (e.key === 'Escape') {
            if (professionalSidebar && professionalSidebar.classList.contains('show')) {
                professionalSidebar.classList.remove('show');
                sidebarOverlay.classList.remove('show');
                menuToggle.classList.remove('active');
            }
        }
        
        // Ctrl/Cmd + M to toggle sidebar
        if ((e.ctrlKey || e.metaKey) && e.key === 'm') {
            e.preventDefault();
            if (menuToggle) {
                menuToggle.click();
            }
        }
    });
    
    // Add intersection observer for scroll animations
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(function(entry) {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);
    
    // Observe elements that should animate on scroll
    const animateElements = document.querySelectorAll('.nav-link, .btn-dashboard, .btn-login, .btn-register');
    animateElements.forEach(function(el) {
        el.style.opacity = '0';
        el.style.transform = 'translateY(20px)';
        el.style.transition = 'all 0.5s ease';
        observer.observe(el);
    });
    
    // Add performance optimization - debounce scroll events
    let scrollTimeout;
    window.addEventListener('scroll', function() {
        if (scrollTimeout) {
            clearTimeout(scrollTimeout);
        }
        
        scrollTimeout = setTimeout(function() {
            // Scroll-based functionality here
            const scrollY = window.pageYOffset;
            
            // Add header background opacity based on scroll
            const header = document.querySelector('.modern-header');
            if (header) {
                if (scrollY > 100) {
                    header.style.background = 'rgba(15, 15, 35, 0.98)';
                } else {
                    header.style.background = 'rgba(15, 15, 35, 0.95)';
                }
            }
        }, 10);
    });
    
    // Add touch gesture support for mobile
    let touchStartY = 0;
    let touchEndY = 0;
    
    document.addEventListener('touchstart', function(e) {
        touchStartY = e.changedTouches[0].screenY;
    }, { passive: true });
    
    document.addEventListener('touchend', function(e) {
        touchEndY = e.changedTouches[0].screenY;
        handleGesture();
    }, { passive: true });
    
    function handleGesture() {
        const swipeThreshold = 50;
        const diff = touchStartY - touchEndY;
        
        // Pull to refresh gesture (swipe down from top)
        if (diff < -swipeThreshold && window.scrollY === 0) {
            triggerHapticFeedback('medium');
            // Add pull to refresh functionality here if needed
        }
    }
    
    // Initialize tooltips for better UX
    const tooltipElements = document.querySelectorAll('[data-tooltip]');
    tooltipElements.forEach(function(element) {
        element.addEventListener('mouseenter', function() {
            const tooltip = document.createElement('div');
            tooltip.className = 'tooltip';
            tooltip.textContent = this.getAttribute('data-tooltip');
            tooltip.style.cssText = `
                position: absolute;
                background: rgba(0, 0, 0, 0.8);
                color: white;
                padding: 8px 12px;
                border-radius: 6px;
                font-size: 12px;
                z-index: 10000;
                pointer-events: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            `;
            
            document.body.appendChild(tooltip);
            
            const rect = this.getBoundingClientRect();
            tooltip.style.left = rect.left + (rect.width / 2) - (tooltip.offsetWidth / 2) + 'px';
            tooltip.style.top = rect.top - tooltip.offsetHeight - 8 + 'px';
            
            setTimeout(() => {
                tooltip.style.opacity = '1';
            }, 10);
            
            this.addEventListener('mouseleave', function() {
                tooltip.style.opacity = '0';
                setTimeout(() => {
                    if (tooltip.parentNode) {
                        tooltip.parentNode.removeChild(tooltip);
                    }
                }, 300);
            });
        });
    });
    
    console.log('Modern Header initialized successfully!');
});
</script>
