@extends('frontend::pages.index')
@section('title')
    {{ $data['title'] }}
@endsection
@section('meta_keywords')
    {{ $data['meta_keywords'] }}
@endsection
@section('meta_description')
    {{ $data['meta_description'] }}
@endsection
@section('page-content')
    @php
        $rankings = \App\Models\Ranking::where('status',true)->get()
    @endphp

    <!-- Professional Ranking Badges Section -->
    <section class="professional-ranking-section">
        <div class="ranking-background">
            <div class="ranking-gradient-overlay"></div>
            <div class="ranking-particles"></div>
            <div class="ranking-shapes">
                <div class="shape-1"></div>
                <div class="shape-2"></div>
                <div class="shape-3"></div>
            </div>
        </div>
        
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-8 col-xl-8 col-lg-10">
                    <div class="section-header" data-aos="fade-up" data-aos-duration="1000">
                        <div class="section-badge">
                            <span class="badge-text">🏆 Achievement System</span>
                        </div>
                        <h1 class="section-title">
                            <span class="title-line">{{ $data['title_big'] }}</span>
                            <span class="title-subtitle">{{ $data['title_small'] }}</span>
                        </h1>
                        <p class="section-description">
                            Unlock exclusive ranking badges and achievements as you grow your investment portfolio. Each badge represents a milestone in your trading journey.
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="ranking-grid">
                @foreach($rankings as $index => $ranking)
                <div class="ranking-card" data-aos="fade-up" data-aos-delay="{{ $index * 150 }}">
                    <div class="card-glow"></div>
                    <div class="card-content">
                        <div class="badge-container">
                            <div class="badge-icon">
                                <div class="icon-wrapper">
                                    <img src="{{ asset($ranking->icon) }}" alt="{{ $ranking->ranking_name }}" class="badge-image">
                                </div>
                                <div class="badge-ring"></div>
                                <div class="badge-shine"></div>
                            </div>
                        </div>
                        
                        <div class="badge-info">
                            <h3 class="badge-name">{{ $ranking->ranking_name }}</h3>
                            <p class="badge-description">{{ $ranking->description }}</p>
                        </div>
                        
                        <div class="badge-progress">
                            <div class="progress-bar">
                                <div class="progress-fill" style="width: {{ rand(20, 100) }}%"></div>
                            </div>
                            <div class="progress-text">
                                <span class="progress-label">Progress</span>
                                <span class="progress-value">{{ rand(20, 100) }}%</span>
                            </div>
                        </div>
                        
                        <div class="badge-actions">
                            <button class="action-btn primary">
                                <span class="btn-icon">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13 2L3 14H12L11 22L21 10H12L13 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                    </svg>
                                </span>
                                <span class="btn-text">View Details</span>
                            </button>
                        </div>
                    </div>
                    
                    <div class="card-particles">
                        <div class="particle"></div>
                        <div class="particle"></div>
                        <div class="particle"></div>
                    </div>
                </div>
                @endforeach
            </div>
            
            <div class="ranking-stats">
                <div class="stats-grid">
                    <div class="stat-item" data-aos="fade-up" data-aos-delay="200">
                        <div class="stat-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number">{{ $rankings->count() }}</div>
                            <div class="stat-label">Available Badges</div>
                        </div>
                    </div>
                    
                    <div class="stat-item" data-aos="fade-up" data-aos-delay="300">
                        <div class="stat-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12L11 14L15 10M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number">85%</div>
                            <div class="stat-label">Completion Rate</div>
                        </div>
                    </div>
                    
                    <div class="stat-item" data-aos="fade-up" data-aos-delay="400">
                        <div class="stat-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M13 2L3 14H12L11 22L21 10H12L13 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number">2.5K+</div>
                            <div class="stat-label">Active Users</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
    /* Professional Ranking Section Styles */
    .professional-ranking-section {
        position: relative;
        padding: 120px 0;
        background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
        overflow: hidden;
        min-height: 100vh;
    }

    .ranking-background {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1;
    }

    .ranking-gradient-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle at 25% 25%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                    radial-gradient(circle at 75% 75%, rgba(236, 72, 153, 0.1) 0%, transparent 50%);
    }

    .ranking-particles {
        position: absolute;
        width: 100%;
        height: 100%;
        background-image: 
            radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
            radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent);
        background-repeat: repeat;
        background-size: 100px 100px;
        animation: float 30s infinite linear;
    }

    .ranking-shapes {
        position: absolute;
        width: 100%;
        height: 100%;
    }

    .shape-1, .shape-2, .shape-3 {
        position: absolute;
        border-radius: 50%;
        background: linear-gradient(45deg, rgba(99, 102, 241, 0.1), rgba(236, 72, 153, 0.1));
        animation: float 20s infinite ease-in-out;
    }

    .shape-1 {
        width: 200px;
        height: 200px;
        top: 15%;
        right: 10%;
        animation-delay: 0s;
    }

    .shape-2 {
        width: 150px;
        height: 150px;
        bottom: 25%;
        left: 8%;
        animation-delay: 7s;
    }

    .shape-3 {
        width: 100px;
        height: 100px;
        top: 50%;
        right: 25%;
        animation-delay: 14s;
    }

    .section-header {
        text-align: center;
        margin-bottom: 80px;
        position: relative;
        z-index: 2;
    }

    .section-badge {
        display: inline-block;
        margin-bottom: 20px;
    }

    .badge-text {
        background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
        border: 1px solid rgba(99, 102, 241, 0.3);
        padding: 8px 20px;
        border-radius: 50px;
        font-size: 14px;
        font-weight: 600;
        color: #ffffff;
        backdrop-filter: blur(10px);
    }

    .section-title {
        font-size: 3.5rem;
        font-weight: 900;
        line-height: 1.1;
        margin-bottom: 20px;
        background: linear-gradient(135deg, #ffffff 0%, #a0a0a0 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    .title-line {
        display: block;
    }

    .title-subtitle {
        display: block;
        font-size: 1.5rem;
        font-weight: 600;
        color: rgba(255, 255, 255, 0.8);
        margin-top: 10px;
    }

    .section-description {
        font-size: 1.2rem;
        line-height: 1.6;
        color: rgba(255, 255, 255, 0.7);
        max-width: 600px;
        margin: 0 auto;
    }

    .ranking-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        margin-bottom: 80px;
        position: relative;
        z-index: 2;
    }

    .ranking-card {
        background: rgba(255, 255, 255, 0.05);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 25px;
        padding: 40px 30px;
        position: relative;
        overflow: hidden;
        transition: all 0.4s ease;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
    }

    .ranking-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 1px;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
    }

    .ranking-card:hover {
        transform: translateY(-10px);
        border-color: rgba(99, 102, 241, 0.5);
        box-shadow: 0 30px 60px rgba(99, 102, 241, 0.2);
    }

    .card-glow {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 200px;
        height: 200px;
        background: radial-gradient(circle, rgba(99, 102, 241, 0.1) 0%, transparent 70%);
        border-radius: 50%;
        opacity: 0;
        transition: opacity 0.3s ease;
        pointer-events: none;
    }

    .ranking-card:hover .card-glow {
        opacity: 1;
    }

    .card-content {
        position: relative;
        z-index: 2;
        text-align: center;
    }

    .badge-container {
        margin-bottom: 30px;
        position: relative;
    }

    .badge-icon {
        position: relative;
        display: inline-block;
    }

    .icon-wrapper {
        width: 100px;
        height: 100px;
        background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
        border: 3px solid rgba(99, 102, 241, 0.3);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto;
        position: relative;
        overflow: hidden;
    }

    .badge-image {
        width: 60px;
        height: 60px;
        object-fit: contain;
        filter: drop-shadow(0 0 10px rgba(99, 102, 241, 0.3));
    }

    .badge-ring {
        position: absolute;
        top: -5px;
        left: -5px;
        right: -5px;
        bottom: -5px;
        border: 2px solid rgba(99, 102, 241, 0.3);
        border-radius: 50%;
        animation: rotate 10s linear infinite;
    }

    .badge-shine {
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        animation: shine 3s infinite;
    }

    .badge-info {
        margin-bottom: 25px;
    }

    .badge-name {
        font-size: 1.5rem;
        font-weight: 800;
        color: #ffffff;
        margin-bottom: 10px;
    }

    .badge-description {
        color: rgba(255, 255, 255, 0.7);
        line-height: 1.6;
        font-size: 0.95rem;
    }

    .badge-progress {
        margin-bottom: 25px;
    }

    .progress-bar {
        width: 100%;
        height: 8px;
        background: rgba(255, 255, 255, 0.1);
        border-radius: 4px;
        overflow: hidden;
        margin-bottom: 10px;
    }

    .progress-fill {
        height: 100%;
        background: linear-gradient(90deg, #6366f1, #8b5cf6);
        border-radius: 4px;
        transition: width 0.3s ease;
        position: relative;
    }

    .progress-fill::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
        animation: progress-shine 2s infinite;
    }

    .progress-text {
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 0.9rem;
    }

    .progress-label {
        color: rgba(255, 255, 255, 0.6);
    }

    .progress-value {
        color: #6366f1;
        font-weight: 700;
    }

    .badge-actions {
        margin-top: 20px;
    }

    .action-btn {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
        color: #ffffff;
        padding: 12px 24px;
        border-radius: 25px;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        font-size: 0.9rem;
        box-shadow: 0 8px 25px rgba(99, 102, 241, 0.3);
    }

    .action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(99, 102, 241, 0.4);
        color: #ffffff;
    }

    .card-particles {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        pointer-events: none;
        overflow: hidden;
    }

    .particle {
        position: absolute;
        width: 4px;
        height: 4px;
        background: rgba(99, 102, 241, 0.6);
        border-radius: 50%;
        animation: particle-float 6s infinite ease-in-out;
    }

    .particle:nth-child(1) {
        top: 20%;
        left: 20%;
        animation-delay: 0s;
    }

    .particle:nth-child(2) {
        top: 60%;
        right: 20%;
        animation-delay: 2s;
    }

    .particle:nth-child(3) {
        bottom: 30%;
        left: 60%;
        animation-delay: 4s;
    }

    .ranking-stats {
        position: relative;
        z-index: 2;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 30px;
        max-width: 800px;
        margin: 0 auto;
    }

    .stat-item {
        background: rgba(255, 255, 255, 0.05);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 20px;
        padding: 30px 20px;
        text-align: center;
        transition: all 0.3s ease;
    }

    .stat-item:hover {
        transform: translateY(-5px);
        border-color: rgba(99, 102, 241, 0.3);
    }

    .stat-icon {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
        border: 2px solid rgba(99, 102, 241, 0.3);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 20px;
        color: #6366f1;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 900;
        color: #6366f1;
        margin-bottom: 5px;
    }

    .stat-label {
        color: rgba(255, 255, 255, 0.7);
        font-weight: 500;
        font-size: 0.9rem;
    }

    @keyframes float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-20px); }
    }

    @keyframes rotate {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    @keyframes shine {
        0% { left: -100%; }
        100% { left: 100%; }
    }

    @keyframes progress-shine {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(100%); }
    }

    @keyframes particle-float {
        0%, 100% { transform: translateY(0px) scale(1); opacity: 0.6; }
        50% { transform: translateY(-20px) scale(1.2); opacity: 1; }
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .professional-ranking-section {
            padding: 80px 0;
        }
        
        .section-title {
            font-size: 2.5rem;
        }
        
        .ranking-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }
        
        .ranking-card {
            padding: 30px 20px;
        }
        
        .stats-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }
    }

    @media (max-width: 480px) {
        .section-title {
            font-size: 2rem;
        }
        
        .section-description {
            font-size: 1rem;
        }
        
        .ranking-card {
            padding: 25px 15px;
        }
        
        .badge-name {
            font-size: 1.3rem;
        }
        
        .icon-wrapper {
            width: 80px;
            height: 80px;
        }
        
        .badge-image {
            width: 50px;
            height: 50px;
        }
    }
    </style>
@endsection
