@extends('frontend::layouts.user')
@section('title')
{{ __('Dashboard') }}
@endsection
@section('content')

<!-- Dashboard Page -->
<div id="dashboard-page" class="page active">
    <div class="dashboard-container">
        <div class="dashboard-welcome">
            <h3>Welcome back, {{ Auth::user()->first_name }}!</h3>
            <p>Here's what's happening with your investments today.</p>
        </div>

        <!-- Balance Display Card -->
        <div class="balance-card glass-effect">
            <div class="balance-header">
                <span>Total Balance</span>
                <i class="fas fa-eye"></i>
            </div>
            <div class="balance-amount">{{ $currencySymbol }}{{ number_format($user->balance + $user->profit_balance, 2) }}</div>
            <div class="balance-change positive">
                <i class="fas fa-arrow-up"></i>
                +{{ number_format($dataCount['total_profit'], 2) }} this week
    </div>
</div>

        <!-- Carousel Cards -->
        <div class="carousel-section">
            <div class="carousel-container">
                <div class="carousel-card glass-effect active" data-type="balance">
                    <div class="card-icon">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Balance</span>
                        <span class="card-value">{{ $currencySymbol }}{{ number_format($user->balance + $user->profit_balance, 2) }}</span>
                    </div>
                </div>
                <div class="carousel-card glass-effect" data-type="profit">
                    <div class="card-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Your Profit</span>
                        <span class="card-value profit">+{{ $currencySymbol }}{{ number_format($dataCount['total_profit'], 2) }}</span>
                    </div>
                </div>
                <div class="carousel-card glass-effect" data-type="investment">
                    <div class="card-icon">
                        <i class="fas fa-coins"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Investment</span>
                        <span class="card-value">{{ $currencySymbol }}{{ number_format($dataCount['total_investment'], 2) }}</span>
                    </div>
                </div>
            </div>
            <div class="carousel-dots">
                <span class="dot active" data-slide="0"></span>
                <span class="dot" data-slide="1"></span>
                <span class="dot" data-slide="2"></span>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <div class="action-btn glass-effect" onclick="window.location.href='{{ route('user.deposit.amount') }}'">
                <i class="fas fa-plus"></i>
                <span>Deposit</span>
            </div>
            <div class="action-btn glass-effect" onclick="window.location.href='{{ route('user.withdraw.simple.index') }}'">
                <i class="fas fa-minus"></i>
                <span>Withdraw</span>
            </div>
            <div class="action-btn glass-effect" onclick="window.location.href='{{ route('user.schema') }}'">
                <i class="fas fa-chart-pie"></i>
                <span>Invest</span>
            </div>
            <div class="action-btn glass-effect" onclick="window.location.href='{{ route('user.transactions') }}'">
                <i class="fas fa-history"></i>
                <span>History</span>
            </div>
        </div>

        <!-- Recent Transactions -->
        <div class="recent-section">
            <div class="section-header">
                <h3>Recent Transactions</h3>
                <a href="{{ route('user.transactions') }}">View All</a>
            </div>
            <div class="transaction-list">
                @foreach($recentTransactions->take(3) as $transaction)
                <div class="transaction-item glass-effect">
                    <div class="transaction-icon {{ txn_type($transaction->type->value,['deposit','withdraw'],'hardrock') }}">
                        @if(txn_type($transaction->type->value,['+','-'],'hardrock') == '+')
                            <i class="fas fa-arrow-down"></i>
                        @else
                            <i class="fas fa-arrow-up"></i>
                        @endif
                    </div>
                    <div class="transaction-details">
                        <span class="transaction-title">{{ $transaction->description }}</span>
                        <span class="transaction-date">{{ $transaction->created_at->format('M d, Y g:i A') }}</span>
                    </div>
                    <div class="transaction-amount {{ txn_type($transaction->type->value,['positive','negative'],'hardrock') }}">
                        {{ txn_type($transaction->type->value,['+','-'],'hardrock') }}{{ $currencySymbol }}{{ number_format($transaction->amount, 2) }}
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

<!-- InvestFlow Dashboard Styles -->
<style>
/* Dashboard Container */
.dashboard-container {
    padding: 20px;
    max-width: 400px;
    margin: 0 auto;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
}

.dashboard-welcome {
    text-align: center;
    margin-bottom: 30px;
    color: white;
}

.dashboard-welcome h3 {
    font-size: 24px;
    font-weight: 600;
    margin-bottom: 8px;
}

.dashboard-welcome p {
    font-size: 14px;
    opacity: 0.8;
    margin: 0;
}

/* Balance Card */
.balance-card {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 25px;
    margin-bottom: 25px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    text-align: center;
    color: white;
}

.balance-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
    font-size: 14px;
    opacity: 0.8;
}

.balance-amount {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 10px;
}

.balance-change {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 5px;
        font-size: 14px; 
    font-weight: 500;
}

.balance-change.positive {
    color: #4ade80;
}

.balance-change.negative {
    color: #f87171;
}

/* Carousel Section */
.carousel-section {
    margin-bottom: 25px;
}

.carousel-container {
    display: flex;
    gap: 15px;
    overflow-x: auto;
    padding-bottom: 10px;
    scrollbar-width: none;
    -ms-overflow-style: none;
}

.carousel-container::-webkit-scrollbar {
    display: none;
}

.carousel-card {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 20px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    min-width: 140px;
    text-align: center;
    color: white;
    transition: all 0.3s ease;
}

.carousel-card.active {
    background: rgba(255, 255, 255, 0.2);
    transform: scale(1.05);
}

.card-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 15px;
    font-size: 18px;
}

.card-info {
    display: flex;
    flex-direction: column;
    gap: 5px;
}

.card-label {
    font-size: 12px;
    opacity: 0.8;
}

.card-value {
    font-size: 16px;
    font-weight: 600;
}

.card-value.profit {
    color: #4ade80;
}

.card-value.expense {
    color: #f87171;
}

.carousel-dots {
    display: flex;
    justify-content: center;
    gap: 8px;
    margin-top: 15px;
}

.dot {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    cursor: pointer;
    transition: all 0.3s ease;
}

.dot.active {
    background: white;
    transform: scale(1.2);
}

/* Quick Actions */
.quick-actions {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 15px;
    margin-bottom: 25px;
}

.action-btn {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 20px 10px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    text-align: center;
    color: white;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.action-btn:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
    text-decoration: none;
    color: white;
}

.action-btn i {
    font-size: 20px;
    margin-bottom: 8px;
    display: block;
}

.action-btn span {
    font-size: 12px;
    font-weight: 500;
}

/* Recent Section */
.recent-section {
    margin-bottom: 25px;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}

.section-header h3 {
    color: white;
    font-size: 18px;
    font-weight: 600;
    margin: 0;
}

.section-header a {
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
    font-size: 14px;
    transition: color 0.3s ease;
}

.section-header a:hover {
    color: white;
}

.transaction-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.transaction-item {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 15px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    gap: 15px;
    color: white;
}

.transaction-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
}

.transaction-icon.deposit {
    background: rgba(74, 222, 128, 0.2);
    color: #4ade80;
}

.transaction-icon.withdraw {
    background: rgba(248, 113, 113, 0.2);
    color: #f87171;
}

.transaction-details {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.transaction-title {
    font-size: 14px;
    font-weight: 500;
}

.transaction-date {
    font-size: 12px;
    opacity: 0.7;
}

.transaction-amount {
    font-size: 16px;
    font-weight: 600;
}

.transaction-amount.positive {
    color: #4ade80;
}

.transaction-amount.negative {
    color: #f87171;
}

/* Glass Effect */
.glass-effect {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
}

/* Mobile Responsive */
@media (max-width: 480px) {
    .dashboard-container {
        padding: 15px;
    }
    
    .quick-actions {
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
    }
    
    .action-btn {
        padding: 15px 8px;
    }
    
    .carousel-card {
        min-width: 120px;
        padding: 15px;
    }
}
</style>

<!-- InvestFlow Dashboard Scripts -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Carousel functionality
    const carouselCards = document.querySelectorAll('.carousel-card');
    const dots = document.querySelectorAll('.dot');
    let currentSlide = 0;

    function showSlide(index) {
        carouselCards.forEach((card, i) => {
            card.classList.toggle('active', i === index);
        });
        dots.forEach((dot, i) => {
            dot.classList.toggle('active', i === index);
        });
        currentSlide = index;
    }

    // Dot click handlers
    dots.forEach((dot, index) => {
        dot.addEventListener('click', () => showSlide(index));
    });

    // Auto-rotate carousel
    setInterval(() => {
        currentSlide = (currentSlide + 1) % carouselCards.length;
        showSlide(currentSlide);
    }, 3000);

    // Touch/swipe support for carousel
    let startX = 0;
    let endX = 0;
    const carouselContainer = document.querySelector('.carousel-container');

    carouselContainer.addEventListener('touchstart', (e) => {
        startX = e.touches[0].clientX;
    });

    carouselContainer.addEventListener('touchend', (e) => {
        endX = e.changedTouches[0].clientX;
        handleSwipe();
    });

    function handleSwipe() {
        const threshold = 50;
        const diff = startX - endX;

        if (Math.abs(diff) > threshold) {
            if (diff > 0) {
                // Swipe left - next slide
                currentSlide = (currentSlide + 1) % carouselCards.length;
                } else {
                // Swipe right - previous slide
                currentSlide = currentSlide === 0 ? carouselCards.length - 1 : currentSlide - 1;
            }
            showSlide(currentSlide);
        }
    }

    // Add haptic feedback for mobile
    function hapticFeedback() {
        if ('vibrate' in navigator) {
            navigator.vibrate(50);
        }
    }

    // Add haptic feedback to action buttons
    document.querySelectorAll('.action-btn').forEach(btn => {
        btn.addEventListener('click', hapticFeedback);
    });

    // Add haptic feedback to carousel dots
    dots.forEach(dot => {
        dot.addEventListener('click', hapticFeedback);
    });
});
</script>

@endsection