<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>{{ setting('site_name','Block Wave Trade') }} Block Wave Trade</title>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
	<style>
		:root{--bg:#000000;--bg2:#1a1a1a;--card:#1a1a1a;--stroke:#333333;--text:#f8fafc;--muted:#94a3b8;--brand:#fbbf24;--brand2:#f59e0b;--lime:#fbbf24;--neon:#f59e0b}
		html,body{margin:0;padding:0;background:radial-gradient(1200px 700px at 10% -10%,rgba(251,191,36,.08),transparent 50%),radial-gradient(1200px 700px at 110% 10%,rgba(245,158,11,.05),transparent 50%),linear-gradient(180deg,#000000,#1a1a1a);color:var(--text);font-family:Inter,system-ui,Segoe UI,Roboto,Helvetica,Arial,sans-serif}
		.container{max-width:1200px;margin:0 auto;padding:0 16px}
		/* Professional Header */
		header.header-min{position:sticky;top:0;z-index:1000;background:rgba(0,0,0,.95);backdrop-filter:blur(20px);border-bottom:1px solid rgba(251,191,36,.2);box-shadow:0 4px 20px rgba(0,0,0,.3)}
		.header-min .nav{height:90px;display:flex;align-items:center;justify-content:space-between;max-width:1400px;margin:0 auto;padding:0 32px}
		.brand{display:flex;gap:16px;align-items:center;font-weight:800;letter-spacing:.5px}
		.logo{width:50px;height:50px;border-radius:12px;background:linear-gradient(135deg,#fbbf24,#f59e0b);box-shadow:0 8px 25px rgba(251,191,36,.4),inset 0 0 15px rgba(251,191,36,.2);display:flex;align-items:center;justify-content:center;color:#000;font-size:24px}
		.brand span{font-weight:800;font-size:24px;color:white;text-transform:uppercase;letter-spacing:1px}
		.main-nav{display:flex;gap:32px;align-items:center}
		.nav-link{color:rgba(255,255,255,.8);text-decoration:none;font-weight:600;font-size:16px;transition:all .3s ease;position:relative;padding:8px 0}
		.nav-link:hover{color:#fbbf24;transform:translateY(-2px)}
		.nav-link::after{content:'';position:absolute;bottom:0;left:0;width:0;height:2px;background:linear-gradient(90deg,#fbbf24,#f59e0b);transition:width .3s ease}
		.nav-link:hover::after{width:100%}
		.header-actions{display:flex;gap:16px;align-items:center}
		.btn{display:inline-flex;gap:8px;align-items:center;background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#000;border:0;border-radius:8px;padding:12px 24px;font-weight:700;font-size:14px;text-transform:uppercase;letter-spacing:.5px;box-shadow:0 6px 20px rgba(251,191,36,.3);transform:translateZ(0);transition:all .3s ease;text-decoration:none}
		.btn:hover{transform:translateY(-3px);box-shadow:0 10px 30px rgba(251,191,36,.4);color:#000}
		.btn-outline{background:transparent;border:2px solid #fbbf24;color:#fbbf24;box-shadow:none}
		.btn-outline:hover{background:#fbbf24;color:#000;box-shadow:0 6px 20px rgba(251,191,36,.3)}
		.user-menu{position:relative}
		.user-btn{display:flex;gap:8px;align-items:center;background:rgba(255,255,255,.1);border:1px solid rgba(251,191,36,.3);border-radius:8px;padding:8px 16px;color:white;font-weight:600;cursor:pointer;transition:all .3s ease}
		.user-btn:hover{background:rgba(251,191,36,.1);border-color:#fbbf24;transform:translateY(-2px)}
		/* Remove default underline from all anchors */
		a{text-decoration:none}
		a:hover{text-decoration:none}
		/* Background 3D layers */
		.bg-3d{position:absolute;inset:0;overflow:hidden;pointer-events:none}
		.bg-3d .glow{position:absolute;inset:-20%;background:radial-gradient(closest-side,rgba(251,191,36,.05),transparent 70%);filter:blur(40px);animation:float 14s ease-in-out infinite}
		.bg-3d .grid{position:absolute;left:-10%;right:-10%;bottom:-5%;height:60%;background:linear-gradient(transparent,rgba(251,191,36,.03)),repeating-linear-gradient(0deg,rgba(251,191,36,.06) 0 1px,transparent 1px 40px);transform:perspective(800px) rotateX(60deg) translateY(40px);mask-image:linear-gradient(to top,black,transparent)}
		@keyframes float{0%,100%{transform:translateY(0)}50%{transform:translateY(16px)}}
		main{padding-top:0}
		.hero{padding:120px 0;position:relative;overflow:hidden;background:linear-gradient(135deg,#000000,#1a1a1a);min-height:100vh;display:flex;align-items:center}
		.hero::before{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:radial-gradient(ellipse at top,rgba(251,191,36,.05) 0%,transparent 50%),radial-gradient(ellipse at bottom right,rgba(245,158,11,.03) 0%,transparent 50%);pointer-events:none}
		.hero-content{display:grid;grid-template-columns:1fr 1fr;gap:80px;align-items:center;max-width:1400px;margin:0 auto;padding:0 32px;position:relative;z-index:2}
		.hero-text{color:white}
		.hero-title{font-size:56px;line-height:1.1;margin:0 0 24px;font-weight:900;text-transform:uppercase;letter-spacing:2px;background:linear-gradient(135deg,#ffffff,#fbbf24);-webkit-background-clip:text;background-clip:text;color:transparent;text-shadow:0 4px 20px rgba(251,191,36,.3)}
		.hero-subtitle{font-size:36px;line-height:1.2;margin:0 0 32px;font-weight:800;text-transform:uppercase;letter-spacing:1px;color:#fbbf24}
		.hero-description{font-size:20px;line-height:1.7;margin:0 0 40px;color:rgba(255,255,255,.8);max-width:600px;font-weight:400}
		.hero-buttons{display:flex;gap:24px;flex-wrap:wrap;margin-top:48px}
		.btn-primary{background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#000;padding:18px 36px;font-weight:800;text-transform:uppercase;letter-spacing:1px;border-radius:12px;box-shadow:0 12px 35px rgba(251,191,36,.4);font-size:16px;position:relative;overflow:hidden}
		.btn-primary::before{content:'';position:absolute;top:0;left:-100%;width:100%;height:100%;background:linear-gradient(90deg,transparent,rgba(255,255,255,.3),transparent);transition:left .6s ease}
		.btn-primary:hover::before{left:100%}
		.btn-secondary{background:transparent;color:#fbbf24;border:2px solid #fbbf24;padding:16px 34px;font-weight:700;text-transform:uppercase;letter-spacing:1px;border-radius:12px;transition:all 0.4s ease;font-size:16px;position:relative;overflow:hidden}
		.btn-secondary::before{content:'';position:absolute;top:0;left:0;width:0;height:100%;background:#fbbf24;transition:width .4s ease;z-index:-1}
		.btn-secondary:hover::before{width:100%}
		.btn-secondary:hover{color:#000;transform:translateY(-3px);box-shadow:0 12px 35px rgba(251,191,36,.3)}
		.accent{color:#fbbf24;text-shadow:0 0 30px rgba(251,191,36,.6);position:relative}
		
		/* Professional Mobile App Mockup */
		.hero-visual{position:relative;display:flex;justify-content:center;align-items:center;perspective:1000px}
		.phone-mockup{position:relative;width:320px;height:640px;background:linear-gradient(145deg,#1a1a1a,#0a0a0a);border-radius:50px;padding:24px;box-shadow:0 40px 80px rgba(0,0,0,.8),0 0 0 2px rgba(251,191,36,.3),inset 0 0 0 1px rgba(255,255,255,.1);transform:rotateY(-20deg) rotateX(8deg);transition:all 0.6s ease;position:relative}
		.phone-mockup::before{content:'';position:absolute;top:15px;left:50%;transform:translateX(-50%);width:60px;height:6px;background:#333;border-radius:3px}
		.phone-mockup:hover{transform:rotateY(-15deg) rotateX(5deg) scale(1.02);box-shadow:0 50px 100px rgba(0,0,0,.9),0 0 0 3px rgba(251,191,36,.5)}
		.phone-screen{width:100%;height:100%;background:linear-gradient(135deg,#000000,#1a1a1a);border-radius:40px;overflow:hidden;position:relative;box-shadow:inset 0 0 0 1px rgba(251,191,36,.2)}
		.app-header{background:linear-gradient(135deg,#fbbf24,#f59e0b);padding:24px 20px;text-align:center;color:#000;position:relative;overflow:hidden}
		.app-header::before{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:linear-gradient(45deg,transparent 30%,rgba(255,255,255,.1) 50%,transparent 70%);transform:translateX(-100%);animation:shimmer 3s infinite}
		@keyframes shimmer{0%{transform:translateX(-100%)}100%{transform:translateX(100%)}}
		.app-logo{display:flex;align-items:center;justify-content:center;gap:12px;font-weight:900;font-size:18px;text-transform:uppercase;letter-spacing:1px}
		.app-logo i{font-size:24px;text-shadow:0 2px 4px rgba(0,0,0,.3)}
		.app-content{padding:24px;color:white;height:calc(100% - 80px);display:flex;flex-direction:column}
		.balance-section{text-align:center;margin-bottom:32px;padding:20px;background:rgba(251,191,36,.05);border-radius:16px;border:1px solid rgba(251,191,36,.2)}
		.current-balance{color:#fbbf24;font-size:16px;margin-bottom:12px;font-weight:700;text-transform:uppercase;letter-spacing:1px}
		.balance-amount{font-size:36px;font-weight:900;margin-bottom:12px;color:white;text-shadow:0 2px 8px rgba(0,0,0,.5)}
		.total-profit{color:#10b981;font-size:16px;font-weight:700;display:flex;align-items:center;justify-content:center;gap:8px}
		.total-profit::before{content:'↗';font-size:20px}
		.crypto-cards{display:grid;gap:16px;margin-bottom:32px}
		.crypto-card{background:rgba(255,255,255,.03);border:1px solid rgba(251,191,36,.15);border-radius:16px;padding:16px;display:flex;justify-content:space-between;align-items:center;transition:all 0.3s ease;position:relative;overflow:hidden}
		.crypto-card::before{content:'';position:absolute;top:0;left:0;width:100%;height:1px;background:linear-gradient(90deg,transparent,#fbbf24,transparent)}
		.crypto-card:hover{background:rgba(251,191,36,.08);border-color:rgba(251,191,36,.3);transform:translateY(-2px)}
		.crypto-info{display:flex;flex-direction:column;gap:6px}
		.crypto-name{font-size:14px;color:#fbbf24;font-weight:700;text-transform:uppercase;letter-spacing:0.5px}
		.crypto-price{font-size:16px;color:white;font-weight:800}
		.crypto-chart{font-size:20px;filter:drop-shadow(0 2px 4px rgba(0,0,0,.3))}
		.app-buttons{display:grid;grid-template-columns:1fr 1fr;gap:12px;margin-top:auto}
		.app-btn{background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#000;border:none;padding:14px;border-radius:12px;font-weight:700;font-size:13px;cursor:pointer;transition:all 0.3s ease;text-transform:uppercase;letter-spacing:0.5px;position:relative;overflow:hidden}
		.app-btn::before{content:'';position:absolute;top:0;left:-100%;width:100%;height:100%;background:linear-gradient(90deg,transparent,rgba(255,255,255,.3),transparent);transition:left .5s ease}
		.app-btn:hover::before{left:100%}
		.app-btn:hover{transform:translateY(-3px);box-shadow:0 8px 25px rgba(251,191,36,.4)}
		.bitcoin-icon{position:absolute;top:50%;right:-80px;transform:translateY(-50%);font-size:150px;color:#fbbf24;opacity:0.2;z-index:-1;animation:float 8s ease-in-out infinite;filter:blur(1px)}
		
		/* Features Section */
		.features-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(300px,1fr));gap:32px;margin-top:48px}
		.feature-card{background:rgba(0,0,0,.6);border:1px solid rgba(251,191,36,.2);border-radius:20px;padding:32px;text-align:center;transition:all 0.4s ease;position:relative;overflow:hidden}
		.feature-card::before{content:'';position:absolute;top:0;left:0;right:0;height:3px;background:linear-gradient(90deg,transparent,#fbbf24,transparent);transform:translateX(-100%);transition:transform 0.6s ease}
		.feature-card:hover::before{transform:translateX(100%)}
		.feature-card:hover{transform:translateY(-8px);border-color:rgba(251,191,36,.4);box-shadow:0 20px 50px rgba(0,0,0,.4),0 0 0 1px rgba(251,191,36,.2) inset}
		.feature-icon{width:80px;height:80px;background:linear-gradient(135deg,#fbbf24,#f59e0b);border-radius:20px;display:flex;align-items:center;justify-content:center;margin:0 auto 24px;font-size:32px;color:#000;box-shadow:0 8px 25px rgba(251,191,36,.3)}
		.feature-card h3{font-size:24px;font-weight:800;margin:0 0 16px;color:white;text-transform:uppercase;letter-spacing:1px}
		.feature-card p{font-size:16px;line-height:1.6;color:rgba(255,255,255,.8);margin:0}
		
		/* Plans Table */
		.plans-table-container{overflow-x:auto;margin-top:48px;border-radius:20px;background:rgba(0,0,0,.6);border:1px solid rgba(251,191,36,.2);box-shadow:0 20px 50px rgba(0,0,0,.4)}
		.plans-table{width:100%;border-collapse:collapse;color:white}
		.plans-table th{background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#000;padding:20px 16px;font-weight:800;text-transform:uppercase;letter-spacing:1px;font-size:14px;text-align:center}
		.plans-table td{padding:20px 16px;text-align:center;border-bottom:1px solid rgba(251,191,36,.1);font-weight:600}
		.plans-table tr:hover{background:rgba(251,191,36,.05)}
		.rank-badge{padding:8px 16px;border-radius:20px;font-weight:800;text-transform:uppercase;letter-spacing:1px;font-size:12px}
		.rank-badge.basic{background:rgba(255,255,255,.1);color:white;border:1px solid rgba(255,255,255,.2)}
		.rank-badge.bronze{background:linear-gradient(135deg,#cd7f32,#b8860b);color:white}
		.rank-badge.advance{background:linear-gradient(135deg,#c0c0c0,#a8a8a8);color:white}
		.rank-badge.manager{background:linear-gradient(135deg,#ffd700,#ffb347);color:white}
		.rank-badge.team-manager{background:linear-gradient(135deg,#ff6b6b,#ff8e8e);color:white}
		.rank-badge.sr-manager{background:linear-gradient(135deg,#9c27b0,#ba68c8);color:white}
		.btn-sm{padding:8px 16px;font-size:12px;font-weight:700;text-transform:uppercase;letter-spacing:0.5px}
		
		/* Investment Plans Table Styling */
		.plan-name{font-weight:700;color:white;font-size:16px}
		.featured-badge{background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#000;padding:4px 8px;border-radius:12px;font-size:10px;font-weight:700;text-transform:uppercase;letter-spacing:0.5px;margin-left:8px}
		.investment-amount{color:#fbbf24;font-weight:700;font-size:16px}
		.profit-rate{color:#10b981;font-weight:700;font-size:16px}
		.duration{color:rgba(255,255,255,.8);font-weight:600}
		.capital-back{color:rgba(255,255,255,.8);font-weight:600}
		
		/* Ranks & Rewards Section */
		.ranks-rewards-section{margin-top:80px;padding-top:60px;border-top:1px solid rgba(251,191,36,.2)}
		.ranks-rewards-section h3{font-size:36px;font-weight:800;margin:0 0 16px;text-transform:uppercase;letter-spacing:1px;color:white}
		.ranks-rewards-section .muted{font-size:18px;margin-bottom:40px}
		.ranks-table-container{overflow-x:auto;margin-top:40px;border-radius:20px;background:rgba(0,0,0,.6);border:1px solid rgba(251,191,36,.2);box-shadow:0 20px 50px rgba(0,0,0,.4)}
		.ranks-table{width:100%;border-collapse:collapse;color:white;min-width:800px}
		.ranks-table th{background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#000;padding:20px 12px;font-weight:800;text-transform:uppercase;letter-spacing:1px;font-size:12px;text-align:center}
		.ranks-table td{padding:16px 12px;text-align:center;border-bottom:1px solid rgba(251,191,36,.1);font-weight:600;font-size:14px}
		.ranks-table tr:hover{background:rgba(251,191,36,.05)}
		
		/* Rank Badges for Rewards */
		.rank-badge.team-leader{background:linear-gradient(135deg,#6b7280,#9ca3af);color:white}
		.rank-badge.s-team-leader{background:linear-gradient(135deg,#059669,#10b981);color:white}
		.rank-badge.sale-manager{background:linear-gradient(135deg,#dc2626,#ef4444);color:white}
		.rank-badge.s-sale-manager{background:linear-gradient(135deg,#7c3aed,#8b5cf6);color:white}
		.rank-badge.director{background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#000}
		.rank-badge.global-ambassador{background:linear-gradient(135deg,#1e40af,#3b82f6);color:white}
		
		.reward-amount{color:#10b981;font-weight:800;font-size:16px}
		.salary-amount{color:#fbbf24;font-weight:800;font-size:16px}
		
		/* Business Overview */
		.business-description{font-size:18px;line-height:1.7;color:rgba(255,255,255,.8);max-width:800px;margin:0 auto 48px;text-align:center}
		.investment-sectors{display:grid;grid-template-columns:repeat(auto-fit,minmax(280px,1fr));gap:32px;margin-top:48px}
		.sector-card{background:rgba(0,0,0,.6);border:1px solid rgba(251,191,36,.2);border-radius:20px;padding:32px;text-align:center;transition:all 0.4s ease;position:relative;overflow:hidden}
		.sector-card::before{content:'';position:absolute;top:0;left:0;right:0;height:3px;background:linear-gradient(90deg,transparent,#fbbf24,transparent);transform:translateX(-100%);transition:transform 0.6s ease}
		.sector-card:hover::before{transform:translateX(100%)}
		.sector-card:hover{transform:translateY(-8px);border-color:rgba(251,191,36,.4);box-shadow:0 20px 50px rgba(0,0,0,.4),0 0 0 1px rgba(251,191,36,.2) inset}
		.sector-icon{width:80px;height:80px;background:linear-gradient(135deg,#fbbf24,#f59e0b);border-radius:20px;display:flex;align-items:center;justify-content:center;margin:0 auto 24px;font-size:32px;color:#000;box-shadow:0 8px 25px rgba(251,191,36,.3)}
		.sector-card h3{font-size:24px;font-weight:800;margin:0 0 16px;color:white;text-transform:uppercase;letter-spacing:1px}
		.sector-card p{font-size:16px;line-height:1.6;color:rgba(255,255,255,.8);margin:0}
		
		/* Trading Chart Section */
		.trading-chart-section{background:linear-gradient(135deg,#000000,#1a1a1a);padding:100px 0;position:relative;overflow:hidden}
		.trading-chart-section::before{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:radial-gradient(ellipse at center,rgba(251,191,36,.05) 0%,transparent 70%);pointer-events:none}
		.trading-chart-section h2{font-size:48px;font-weight:900;margin:0 0 16px;text-transform:uppercase;letter-spacing:2px;background:linear-gradient(135deg,#ffffff,#fbbf24);-webkit-background-clip:text;background-clip:text;color:transparent;text-align:center}
		.trading-chart-section .muted{font-size:20px;line-height:1.7;color:rgba(255,255,255,.8);margin:0 auto 60px;max-width:600px;text-align:center}
		.chart-container{background:rgba(0,0,0,.8);border:1px solid rgba(251,191,36,.2);border-radius:24px;padding:32px;box-shadow:0 25px 60px rgba(0,0,0,.5),0 0 0 1px rgba(251,191,36,.1) inset;position:relative;overflow:hidden}
		.chart-container::before{content:'';position:absolute;top:0;left:0;right:0;height:3px;background:linear-gradient(90deg,transparent,#fbbf24,transparent)}
		.chart-header{display:flex;justify-content:space-between;align-items:center;margin-bottom:24px;padding-bottom:20px;border-bottom:1px solid rgba(251,191,36,.2)}
		.chart-title{display:flex;align-items:center;gap:12px;color:white}
		.chart-title i{font-size:24px;color:#fbbf24;text-shadow:0 0 10px rgba(251,191,36,.5)}
		.chart-title span{font-size:20px;font-weight:700;text-transform:uppercase;letter-spacing:1px}
		.chart-controls{display:flex;gap:8px}
		.timeframe-btn{background:rgba(251,191,36,.1);border:1px solid rgba(251,191,36,.3);color:rgba(255,255,255,.8);padding:8px 16px;border-radius:8px;font-weight:600;font-size:14px;cursor:pointer;transition:all 0.3s ease;text-transform:uppercase;letter-spacing:0.5px}
		.timeframe-btn:hover{background:rgba(251,191,36,.2);color:white;transform:translateY(-2px)}
		.timeframe-btn.active{background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#000;box-shadow:0 4px 15px rgba(251,191,36,.3)}
		.chart-wrapper{background:rgba(0,0,0,.6);border-radius:16px;padding:20px;margin-bottom:24px;min-height:500px;position:relative;overflow:hidden}
		.trading-chart{width:100%;height:500px;border-radius:12px;overflow:hidden}
		.chart-footer{display:flex;justify-content:space-between;align-items:center;flex-wrap:wrap;gap:20px}
		.price-info{display:flex;gap:32px;align-items:center}
		.current-price,.price-change{display:flex;flex-direction:column;gap:4px}
		.price-label,.change-label{font-size:12px;color:rgba(255,255,255,.6);text-transform:uppercase;letter-spacing:1px;font-weight:600}
		.price-value{font-size:24px;font-weight:800;color:white;text-shadow:0 2px 8px rgba(0,0,0,.5)}
		.change-value{font-size:16px;font-weight:700;color:#10b981;text-shadow:0 2px 8px rgba(16,185,129,.3)}
		.price-change.negative .change-value{color:#ef4444}
		.market-stats{display:flex;gap:24px;align-items:center}
		.market-stats .stat{display:flex;flex-direction:column;gap:4px;text-align:center}
		.market-stats .stat-label{font-size:11px;color:rgba(255,255,255,.6);text-transform:uppercase;letter-spacing:1px;font-weight:600}
		.market-stats .stat-value{font-size:14px;font-weight:700;color:white}
		
		/* CTA Section */
		.cta-section{background:linear-gradient(135deg,#000000,#1a1a1a);padding:100px 0;position:relative;overflow:hidden}
		.cta-section::before{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:radial-gradient(ellipse at center,rgba(251,191,36,.1) 0%,transparent 70%);pointer-events:none}
		.cta-content{text-align:center;max-width:800px;margin:0 auto;position:relative;z-index:2}
		.cta-content h2{font-size:48px;font-weight:900;margin:0 0 24px;text-transform:uppercase;letter-spacing:2px;background:linear-gradient(135deg,#ffffff,#fbbf24);-webkit-background-clip:text;background-clip:text;color:transparent}
		.cta-content p{font-size:20px;line-height:1.7;color:rgba(255,255,255,.8);margin:0 0 40px;max-width:600px;margin-left:auto;margin-right:auto}
		.cta-buttons{display:flex;gap:24px;justify-content:center;flex-wrap:wrap;margin-bottom:60px}
		.cta-stats{display:grid;grid-template-columns:repeat(3,1fr);gap:40px;max-width:600px;margin:0 auto}
		.stat{text-align:center}
		.stat-number{font-size:36px;font-weight:900;color:#fbbf24;margin-bottom:8px;text-shadow:0 2px 8px rgba(251,191,36,.3)}
		.stat-label{font-size:16px;color:rgba(255,255,255,.8);font-weight:600;text-transform:uppercase;letter-spacing:1px}
		/* Binance-style hero card */
		.hero-card{position:relative;min-height:400px;background:linear-gradient(135deg,rgba(30,41,59,.9),rgba(15,23,42,.95));border:1px solid rgba(59,130,246,.3);border-radius:16px;padding:32px;overflow:hidden;box-shadow:0 20px 60px rgba(0,0,0,.4),0 0 0 1px rgba(59,130,246,.1) inset;transform-style:preserve-3d}
		.hero-card .ring{position:absolute;inset:-30%;background:conic-gradient(from 120deg,transparent 20%,rgba(59,130,246,.15) 35%,transparent 50%,rgba(139,92,246,.12) 70%,transparent 80%);filter:blur(30px);animation:spin 10s linear infinite}
		.hero-card .mesh{position:absolute;inset:0;background:radial-gradient(600px 260px at 70% 30%,rgba(59,130,246,.12),transparent 60%),radial-gradient(500px 220px at 20% 80%,rgba(139,92,246,.08),transparent 60%)}
		.hero-card .content{position:relative;z-index:2;display:grid;gap:16px}
		@keyframes spin{to{transform:rotate(360deg)}}
		.kpis{display:grid;grid-template-columns:repeat(2,1fr);gap:16px;margin-top:24px}
		.kpi{background:rgba(30,41,59,.6);border:1px solid rgba(59,130,246,.2);border-radius:12px;padding:16px;text-align:center}
		.kpi strong{display:block;font-size:18px;color:var(--brand);margin-bottom:4px}
		.section{padding:80px 0;max-width:1400px;margin:0 auto;padding-left:24px;padding-right:24px}
		.section h2{text-align:center;margin:0 0 16px;font-size:36px;font-weight:800;letter-spacing:.2px;position:relative;display:inline-block;left:50%;transform:translateX(-50%)}
		.section h2:after{content:"";display:block;height:3px;background:linear-gradient(90deg,transparent,#3b82f6,transparent);margin:12px auto 0;width:120px;opacity:.8}
		.section p.muted{text-align:center;color:var(--muted);max-width:720px;margin:0 auto 32px;line-height:1.7;font-size:18px}
		.cards{display:grid;grid-template-columns:1fr;gap:24px}
		.card{background:rgba(30,41,59,.6);border:1px solid rgba(59,130,246,.2);border-radius:16px;padding:24px;box-shadow:0 8px 32px rgba(0,0,0,.3);transition:all .3s ease;backdrop-filter:blur(10px)}
		.card:hover{transform:translateY(-6px);border-color:rgba(59,130,246,.4);box-shadow:0 20px 50px rgba(0,0,0,.4),0 0 0 1px rgba(59,130,246,.2) inset}
		.card h3{margin:0 0 12px;font-size:20px;font-weight:700}
		.card .icon{width:40px;height:40px;border-radius:12px;display:inline-flex;align-items:center;justify-content:center;background:linear-gradient(135deg,rgba(59,130,246,.15),rgba(139,92,246,.1));border:1px solid rgba(59,130,246,.3);color:#3b82f6;margin-bottom:16px;font-size:18px}
		.plan .price{font-weight:800;font-size:26px}
		.features{display:grid;gap:8px;margin-top:8px}
		/* Plans */
		.cards.plans{align-items:stretch}
		.plan{position:relative}
		.plan .badge{position:absolute;top:14px;right:14px;background:linear-gradient(135deg,#fbbf24,#f59e0b);color:#0f0f0f;font-weight:800;border-radius:999px;padding:6px 10px;font-size:12px;box-shadow:0 10px 20px rgba(245,158,11,.25)}
		.plan.featured{border-color:rgba(56,247,123,.45);box-shadow:0 18px 40px rgba(0,0,0,.55),0 0 0 1px rgba(56,247,123,.12) inset}
		.plan .price{font-weight:800;font-size:26px}
		/* FAQ */
		.faq{display:grid;grid-template-columns:1fr;gap:12px}
		.faq .item{background:#0c1411;border:1px solid var(--stroke);border-radius:12px;padding:16px;transition:border-color .2s ease,transform .2s ease}
		.faq .item:hover{border-color:rgba(56,247,123,.3);transform:translateY(-2px)}
		/* CTA */
		.cta{background:linear-gradient(135deg,#0c1411,#070b09);border:1px solid var(--stroke);border-radius:16px;padding:28px;text-align:center;box-shadow:0 14px 40px rgba(0,0,0,.5)}
		.cta .btn{padding:14px 22px}
		footer{border-top:1px solid var(--stroke);padding:40px 0 24px;color:var(--muted);background:linear-gradient(180deg,rgba(7,11,9,.4),rgba(6,8,7,.6))}
		.footer-top{display:grid;grid-template-columns:1.2fr;gap:24px}
		.footer-brand{display:flex;align-items:center;gap:12px}
		.footer-brand .logo{width:34px;height:34px}
		.footer-desc{max-width:520px;margin-top:8px}
		.footer-columns{display:grid;grid-template-columns:repeat(2,1fr);gap:22px}
		.footer-col h4{margin:0 0 10px;color:#e8f7ef;font-size:14px;letter-spacing:.6px;text-transform:uppercase}
		.footer-col a{display:block;color:var(--muted);padding:6px 0}
		.footer-col a:hover{color:#d6fbe8}
		.footer-bottom{margin-top:20px;display:flex;justify-content:space-between;gap:16px;flex-wrap:wrap;font-size:14px}
		.footer-social{display:flex;gap:12px}
		.footer-social a{color:var(--muted)}
		@media(max-width:768px){
			.header-min .nav{height:70px;padding:0 20px}
			.main-nav{display:none}
			.hero-content{grid-template-columns:1fr;gap:50px;text-align:center;padding:0 20px}
			.hero-title{font-size:36px;letter-spacing:1px}
			.hero-subtitle{font-size:24px;letter-spacing:0.5px}
			.hero-description{font-size:18px;max-width:100%}
			.hero-buttons{justify-content:center;gap:16px}
			.btn-primary,.btn-secondary{padding:14px 28px;font-size:14px}
			.phone-mockup{width:260px;height:520px;transform:rotateY(-10deg) rotateX(3deg)}
			.bitcoin-icon{right:-40px;font-size:100px}
		}
		@media(max-width:480px){
			.hero{padding:80px 0}
			.hero-title{font-size:28px}
			.hero-subtitle{font-size:20px}
			.hero-description{font-size:16px}
			.phone-mockup{width:220px;height:440px}
			.bitcoin-icon{right:-20px;font-size:60px}
			.features-grid{grid-template-columns:1fr;gap:24px}
			.feature-card{padding:24px}
			.plans-table-container{overflow-x:scroll}
			.plans-table{min-width:800px}
			.investment-sectors{grid-template-columns:1fr;gap:24px}
			.sector-card{padding:24px}
			.cta-content h2{font-size:32px}
			.cta-content p{font-size:16px}
			.cta-buttons{flex-direction:column;align-items:center;gap:16px}
			.cta-stats{grid-template-columns:1fr;gap:24px}
			.trading-chart-section{padding:60px 0}
			.trading-chart-section h2{font-size:32px}
			.chart-container{padding:20px}
			.chart-header{flex-direction:column;gap:20px;align-items:flex-start}
			.chart-controls{flex-wrap:wrap;gap:6px}
			.timeframe-btn{padding:6px 12px;font-size:12px}
			.chart-wrapper{min-height:400px;padding:15px}
			.trading-chart{height:400px}
			.chart-footer{flex-direction:column;gap:20px;align-items:flex-start}
			.price-info{flex-direction:column;gap:16px;align-items:flex-start}
			.market-stats{flex-wrap:wrap;gap:16px}
		}
		@media(min-width:768px){
			.hero .grid{grid-template-columns:1.05fr .95fr}
			.h1{font-size:66px}
			.kpis{grid-template-columns:repeat(4,1fr)}
			.cards{grid-template-columns:repeat(3,1fr)}
			.faq{grid-template-columns:1fr 1fr}
			.footer-top{grid-template-columns:1.1fr .9fr}
			.footer-columns{grid-template-columns:repeat(4,1fr)}
		}
	</style>
	<script>
		document.addEventListener('DOMContentLoaded',()=>{
			// Hero tilt interaction
			const card=document.querySelector('.hero-card');
			if(card){
				const damp=18;
				card.addEventListener('mousemove',(e)=>{
					const r=card.getBoundingClientRect();
					const x=(e.clientX - r.left)/r.width*2-1;
					const y=(e.clientY - r.top)/r.height*2-1;
					card.style.transform=`rotateX(${-y*damp}deg) rotateY(${x*damp}deg)`;
				});
				card.addEventListener('mouseleave',()=>{ card.style.transform='rotateX(0deg) rotateY(0deg)'; });
			}
			
			// Smooth scrolling for navigation links
			document.querySelectorAll('a[href^="#"]').forEach(anchor => {
				anchor.addEventListener('click', function (e) {
					e.preventDefault();
					const target = document.querySelector(this.getAttribute('href'));
					if (target) {
						target.scrollIntoView({
							behavior: 'smooth',
							block: 'start'
						});
					}
				});
			});
			
			// Video button functionality
			const videoBtn = document.querySelector('.btn-secondary[href="#"]');
			if (videoBtn) {
				videoBtn.addEventListener('click', function(e) {
					e.preventDefault();
					// You can replace this with actual video modal or redirect
					alert('Video feature coming soon! This will open a promotional video about Block Wave Trade.');
				});
			}
			
			// Animate stats on scroll
			const observerOptions = {
				threshold: 0.5,
				rootMargin: '0px 0px -100px 0px'
			};
			
			const observer = new IntersectionObserver((entries) => {
				entries.forEach(entry => {
					if (entry.isIntersecting) {
						const stats = entry.target.querySelectorAll('.stat-number');
						stats.forEach(stat => {
							const finalValue = stat.textContent;
							const isPercentage = finalValue.includes('%');
							const isDollar = finalValue.includes('$');
							const isPlus = finalValue.includes('+');
							const numericValue = parseInt(finalValue.replace(/[^0-9]/g, ''));
							
							let currentValue = 0;
							const increment = numericValue / 50;
							const timer = setInterval(() => {
								currentValue += increment;
								if (currentValue >= numericValue) {
									stat.textContent = finalValue;
									clearInterval(timer);
								} else {
									let displayValue = Math.floor(currentValue);
									if (isDollar) displayValue = '$' + displayValue;
									if (isPercentage) displayValue = displayValue + '%';
									if (isPlus) displayValue = displayValue + '+';
									stat.textContent = displayValue;
								}
							}, 50);
						});
						observer.unobserve(entry.target);
					}
				});
			}, observerOptions);
			
			const ctaSection = document.querySelector('.cta-section');
			if (ctaSection) {
				observer.observe(ctaSection);
			}
			
			// Trading chart timeframe buttons
			const timeframeBtns = document.querySelectorAll('.timeframe-btn');
			timeframeBtns.forEach(btn => {
				btn.addEventListener('click', function() {
					// Remove active class from all buttons
					timeframeBtns.forEach(b => b.classList.remove('active'));
					// Add active class to clicked button
					this.classList.add('active');
					
					// Update chart timeframe (this would integrate with TradingView widget)
					const timeframe = this.getAttribute('data-timeframe');
					console.log('Switching to timeframe:', timeframe);
					// Here you would update the TradingView widget timeframe
				});
			});
			
			// Fetch real live crypto data
			async function fetchCryptoData() {
				try {
					// Using CoinGecko API for real data
					const response = await fetch('https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd&include_24hr_change=true&include_24hr_vol=true&include_24hr_high=true&include_24hr_low=true');
					const data = await response.json();
					
					if (data.bitcoin) {
						const btc = data.bitcoin;
						const currentPrice = btc.usd;
						const change24h = btc.usd_24h_change;
						const high24h = btc.usd_24h_high;
						const low24h = btc.usd_24h_low;
						const volume24h = btc.usd_24h_vol;
						
						// Update current price
						document.getElementById('current-price').textContent = `$${currentPrice.toLocaleString()}`;
						
						// Update 24h change
						const changeElement = document.getElementById('change-value');
						const changeContainer = document.getElementById('price-change');
						const changeAmount = ((currentPrice * change24h) / 100);
						
						changeElement.textContent = `${change24h >= 0 ? '+' : ''}${change24h.toFixed(2)}% (${change24h >= 0 ? '+' : ''}$${changeAmount.toLocaleString()})`;
						
						// Update color based on change
						if (change24h >= 0) {
							changeContainer.className = 'price-change positive';
						} else {
							changeContainer.className = 'price-change negative';
						}
						
						// Update high price
						document.getElementById('high-price').textContent = `$${high24h.toLocaleString()}`;
						
						// Update low price
						document.getElementById('low-price').textContent = `$${low24h.toLocaleString()}`;
						
						// Update volume
						document.getElementById('volume').textContent = `$${(volume24h / 1000000000).toFixed(2)}B`;
						
						console.log('Live data updated:', btc);
					}
				} catch (error) {
					console.error('Error fetching crypto data:', error);
					// Fallback to static data if API fails
					document.getElementById('current-price').textContent = '$43,250.50';
					document.getElementById('change-value').textContent = '+2.45% (+$1,035.20)';
					document.getElementById('high-price').textContent = '$44,120.00';
					document.getElementById('low-price').textContent = '$42,100.00';
					document.getElementById('volume').textContent = '$2.4B';
				}
			}
			
			// Fetch data on page load
			fetchCryptoData();
			
			// Update data every 30 seconds
			setInterval(fetchCryptoData, 30000);
		});
	</script>
 </head>
 <body>
 	<header class="header-min">
 		<div class="container nav">
			<div class="brand">
				<div class="logo">
					<i class="fas fa-coins"></i>
				</div>
				<span>{{ setting('site_name','Block Wave Trade') }}</span>
			</div>
			<nav class="main-nav">
				<a href="#features" class="nav-link">Features</a>
				<a href="#plans" class="nav-link">Plans</a>
				<a href="#about" class="nav-link">About</a>
				<a href="#contact" class="nav-link">Contact</a>
			</nav>
			<div class="header-actions">
 				@if(auth('web')->check())
					<a class="btn btn-outline" href="{{ route('user.dashboard') }}">Dashboard</a>
					<div class="user-menu">
						<button class="user-btn">
							<i class="fas fa-user"></i>
							<span>{{ Auth::user()->first_name }}</span>
						</button>
					</div>
 				@elseif(function_exists('auth') && auth('admin')->check())
					<a class="btn btn-outline" href="{{ route('admin.dashboard') }}">Admin</a>
 				@else
					<a class="btn btn-outline" href="{{ route('login') }}">Login</a>
					<a class="btn" href="{{ route('welcome') }}">Get Started</a>
 				@endif
 			</div>
 		</div>
 	</header>

	<main>
		<!-- Hero Section with Mobile App Mockup -->
		<section class="hero">
			<div class="container">
				<div class="hero-content">
					<div class="hero-text">
						<h1 class="hero-title">INVEST IN THE FUTURE OF <span class="accent">MINING</span></h1>
						<h2 class="hero-subtitle">THE FUTURE IS HERE: INVEST IN <span class="accent">BLOCK WAVE TRADE</span></h2>
						<p class="hero-description">Unlock the true potential of your investments with Block Wave Trade - the smart way to grow your money.</p>
						<div class="hero-buttons">
							<a class="btn btn-primary" href="{{ route('welcome') }}">Join the Revolution</a>
							<a class="btn btn-secondary" href="#"><i class="fas fa-play"></i> Play Video</a>
						</div>
					</div>
					<div class="hero-visual">
						<div class="phone-mockup">
							<div class="phone-screen">
								<div class="app-header">
									<div class="app-logo">
										<i class="fas fa-coins"></i>
										<span>Block Wave Trade</span>
									</div>
								</div>
								<div class="app-content">
									<div class="balance-section">
										<div class="current-balance">Current Balance</div>
										<div class="balance-amount">1.2102 $</div>
										<div class="total-profit">Total Profit: $2.00</div>
									</div>
									<div class="crypto-cards">
										<div class="crypto-card">
											<div class="crypto-info">
												<span class="crypto-name">BTC-USDT</span>
												<span class="crypto-price">$45,230</span>
											</div>
											<div class="crypto-chart">📈</div>
										</div>
										<div class="crypto-card">
											<div class="crypto-info">
												<span class="crypto-name">ETH-USDC</span>
												<span class="crypto-price">$3,120</span>
											</div>
											<div class="crypto-chart">📈</div>
										</div>
									</div>
									<div class="app-buttons">
										<button class="app-btn">Trading</button>
										<button class="app-btn">Deposit</button>
										<button class="app-btn">Withdraw</button>
										<button class="app-btn">Team</button>
					</div>
					</div>
				</div>
						</div>
						<div class="bitcoin-icon">
							<i class="fab fa-bitcoin"></i>
					</div>
				</div>
			</div>
			</div>
		</section>

		<!-- Why Choose Us Section -->
		<section id="features" class="section">
			<div class="container">
				<h2>Why Investors Choose <span class="accent">Block Wave Trade</span>?</h2>
				<p class="muted">Experience the future of cryptocurrency investment with our cutting-edge platform and proven strategies.</p>
				<div class="features-grid">
					<div class="feature-card">
						<div class="feature-icon">
							<i class="fas fa-chart-line"></i>
						</div>
						<h3>Diversified Income Streams</h3>
						<p>Multiple investment strategies across forex, crypto trading, mining, and real estate for maximum returns.</p>
					</div>
					<div class="feature-card">
						<div class="feature-icon">
							<i class="fas fa-shield-alt"></i>
						</div>
						<h3>Real-time Reporting & Transparency</h3>
						<p>Complete transparency with real-time portfolio tracking and detailed performance analytics.</p>
					</div>
					<div class="feature-card">
						<div class="feature-icon">
							<i class="fas fa-users"></i>
						</div>
						<h3>Expert Team with Proven Track Record</h3>
						<p>Our experienced team of financial experts and crypto specialists manage your investments.</p>
					</div>
					<div class="feature-card">
						<div class="feature-icon">
							<i class="fas fa-cog"></i>
						</div>
						<h3>Simple Investment Plans</h3>
						<p>Tailored investment plans designed to meet your financial goals and risk tolerance.</p>
					</div>
				</div>
			</div>
		</section>

		<!-- Live Trading Chart Section -->
		<section class="trading-chart-section">
			<div class="container">
				<h2>Live <span class="accent">Trading</span> Chart</h2>
				<p class="muted">Track real-time cryptocurrency prices and market movements with our advanced trading interface.</p>
				
				<div class="chart-container">
					<div class="chart-header">
						
						<!-- TradingView Widget -->
	<script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js" async>
	{
		"autosize": true,
		"symbol": "BINANCE:BTCUSDT",
		"interval": "1",
		"timezone": "Etc/UTC",
		"theme": "dark",
		"style": "1",
		"locale": "en",
		"toolbar_bg": "rgba(0,0,0,0.8)",
		"enable_publishing": false,
		"withdateranges": true,
		"range": "1D",
		"hide_side_toolbar": false,
		"allow_symbol_change": true,
		"details": true,
		"hotlist": true,
		"calendar": false,
		"studies": [
			"RSI@tv-basicstudies",
			"MACD@tv-basicstudies"
		],
		"container_id": "tv-portfolio-chart",
		"height": 500,
		"width": "100%",
		"hide_top_toolbar": false,
		"hide_legend": false,
		"save_image": false,
		"studies_overrides": {
			"volume.volume.color.0": "#fbbf24",
			"volume.volume.color.1": "#ef4444"
		}
	}
	</script>
				</div>
			</div>
		</section>

		<!-- Investment Plans Section -->
		<section id="plans" class="section">
			<div class="container">
				<h2>Investment <span class="accent">Plans</span></h2>
				<p class="muted">Choose from our carefully crafted investment plans designed for maximum returns and minimal risk.</p>
				
				@php
					$schemas = \App\Models\Schema::where('status', true)->ordered()->with('schedule')->get();
				@endphp
				
				@if($schemas->count() > 0)
					<!-- Active Investment Plans from Admin Panel -->
					<div class="plans-table-container">
						<table class="plans-table">
							<thead>
								<tr>
									<th>Plan Name</th>
									<th>Investment Range</th>
									<th>Daily Profit</th>
									<th>Duration</th>
									<th>Capital Back</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								@foreach($schemas as $schema)
						@php
							$range = $schema->type === 'range';
							$price = $range ? (setting('currency_symbol', '$') . number_format($schema->min_amount) . ' – ' . setting('currency_symbol', '$') . number_format($schema->max_amount)) : (setting('currency_symbol', '$') . number_format($schema->fixed_amount));
										$profit = $schema->interest_type === 'percentage' ? $schema->return_interest.'%': setting('currency_symbol', '$').$schema->return_interest;
						@endphp
									<tr>
										<td>
											<span class="plan-name">{{ $schema->name }}</span>
							@if($schema->featured && $schema->badge)
												<span class="featured-badge">{{ $schema->badge }}</span>
							@endif
										</td>
										<td><span class="investment-amount">{{ $price }}</span></td>
										<td><span class="profit-rate">{{ $profit }}</span> per {{ optional($schema->schedule)->name ?? 'period' }}</td>
										<td><span class="duration">{{ $schema->schema_duration ?? 'N/A' }}</span></td>
										<td><span class="capital-back">{{ $schema->capital_back ? 'Yes' : 'No' }}</span></td>
										<td><a href="{{ route('user.schema.select', $schema->id) }}" class="btn btn-sm">Select Plan</a></td>
									</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				@else
					<!-- Default Plans if no admin plans available -->
					<div class="plans-table-container">
						<table class="plans-table">
							<thead>
								<tr>
									<th>Plan Name</th>
									<th>Investment Range</th>
									<th>Daily Profit</th>
									<th>Duration</th>
									<th>Capital Back</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td><span class="plan-name">Basic Plan</span></td>
									<td><span class="investment-amount">$25 - $99</span></td>
									<td><span class="profit-rate">1.5% - 3%</span> daily</td>
									<td><span class="duration">30 Days</span></td>
									<td><span class="capital-back">Yes</span></td>
									<td><a href="{{ route('register') }}" class="btn btn-sm">Select Plan</a></td>
								</tr>
								<tr>
									<td><span class="plan-name">Bronze Plan</span></td>
									<td><span class="investment-amount">$100 - $499</span></td>
									<td><span class="profit-rate">2% - 4%</span> daily</td>
									<td><span class="duration">30 Days</span></td>
									<td><span class="capital-back">Yes</span></td>
									<td><a href="{{ route('register') }}" class="btn btn-sm">Select Plan</a></td>
								</tr>
								<tr>
									<td><span class="plan-name">Silver Plan</span></td>
									<td><span class="investment-amount">$500 - $999</span></td>
									<td><span class="profit-rate">2.5% - 5%</span> daily</td>
									<td><span class="duration">30 Days</span></td>
									<td><span class="capital-back">Yes</span></td>
									<td><a href="{{ route('register') }}" class="btn btn-sm">Select Plan</a></td>
								</tr>
								<tr>
									<td><span class="plan-name">Gold Plan</span></td>
									<td><span class="investment-amount">$1,000 - $4,999</span></td>
									<td><span class="profit-rate">3% - 6%</span> daily</td>
									<td><span class="duration">30 Days</span></td>
									<td><span class="capital-back">Yes</span></td>
									<td><a href="{{ route('register') }}" class="btn btn-sm">Select Plan</a></td>
								</tr>
								<tr>
									<td><span class="plan-name">Platinum Plan</span></td>
									<td><span class="investment-amount">$5,000+</span></td>
									<td><span class="profit-rate">3.5% - 7%</span> daily</td>
									<td><span class="duration">30 Days</span></td>
									<td><span class="capital-back">Yes</span></td>
									<td><a href="{{ route('register') }}" class="btn btn-sm">Select Plan</a></td>
								</tr>
							</tbody>
						</table>
					</div>
								@endif
				
				<!-- Ranks & Rewards Section -->
				<div class="ranks-rewards-section">
					<h3>Ranks & <span class="accent">Rewards</span></h3>
					<p class="muted">Earn additional rewards and bonuses based on your team performance and sales targets.</p>
					
					<div class="ranks-table-container">
						<table class="ranks-table">
							<thead>
								<tr>
									<th>Rank</th>
									<th>Sales Target (A)</th>
									<th>Sales Target (B)</th>
									<th>Sales Target (C)</th>
									<th>Sales Target (D)</th>
									<th>Reward</th>
									<th>Monthly Salary</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td><span class="rank-badge team-leader">Team Leader</span></td>
									<td>$750</td>
									<td>$750</td>
									<td>$750</td>
									<td>$750</td>
									<td><span class="reward-amount">$300</span></td>
									<td><span class="salary-amount">$40</span></td>
								</tr>
								<tr>
									<td><span class="rank-badge s-team-leader">S. Team Leader</span></td>
									<td>$3,000</td>
									<td>$3,000</td>
									<td>$3,000</td>
									<td>$3,000</td>
									<td><span class="reward-amount">$600</span></td>
									<td><span class="salary-amount">$80</span></td>
								</tr>
								<tr>
									<td><span class="rank-badge sale-manager">Sale Manager</span></td>
									<td>$12,000</td>
									<td>$12,000</td>
									<td>$12,000</td>
									<td>$12,000</td>
									<td><span class="reward-amount">$2,000</span></td>
									<td><span class="salary-amount">$160</span></td>
								</tr>
								<tr>
									<td><span class="rank-badge s-sale-manager">S. Sale Manager</span></td>
									<td>$40,000</td>
									<td>$40,000</td>
									<td>$40,000</td>
									<td>$40,000</td>
									<td><span class="reward-amount">$7,000</span></td>
									<td><span class="salary-amount">$320</span></td>
								</tr>
								<tr>
									<td><span class="rank-badge director">Director</span></td>
									<td>$100,000</td>
									<td>$100,000</td>
									<td>$100,000</td>
									<td>$100,000</td>
									<td><span class="reward-amount">$30,000</span></td>
									<td><span class="salary-amount">$1,000</span></td>
								</tr>
								<tr>
									<td><span class="rank-badge global-ambassador">Global Ambassador</span></td>
									<td>$500,000</td>
									<td>$500,000</td>
									<td>$500,000</td>
									<td>$500,000</td>
									<td><span class="reward-amount">$105,000</span></td>
									<td><span class="salary-amount">$2,000</span></td>
								</tr>
							</tbody>
						</table>
							</div>
				</div>
			</div>
		</section>

		<!-- Business Overview Section -->
		<section id="about" class="section">
			<div class="container">
				<h2>Business <span class="accent">Overview</span></h2>
				<p class="muted">How Your Money Grows with Block Wave Trade?</p>
				<p class="business-description">At Block Wave Trade, we specialize in smart, diversified investment strategies designed to deliver high, consistent returns to our clients. We invest your capital across four powerful and complementary sectors:</p>
				
				<div class="investment-sectors">
					<div class="sector-card">
						<div class="sector-icon">
							<i class="fas fa-chart-bar"></i>
						</div>
						<h3>Forex Trading</h3>
						<p>Professional forex trading with advanced strategies and risk management across major currency pairs.</p>
					</div>
					<div class="sector-card">
						<div class="sector-icon">
							<i class="fab fa-bitcoin"></i>
						</div>
						<h3>Cryptocurrency Trading</h3>
						<p>AI-powered analysis of digital assets including Bitcoin, Ethereum, and emerging altcoins.</p>
					</div>
					<div class="sector-card">
						<div class="sector-icon">
							<i class="fas fa-hammer"></i>
						</div>
						<h3>Cryptocurrency Mining</h3>
						<p>High-performance mining operations with cost-effective energy sources and advanced hardware.</p>
					</div>
					<div class="sector-card">
						<div class="sector-icon">
							<i class="fas fa-building"></i>
						</div>
						<h3>Real Estate</h3>
						<p>Strategic real estate investments in high-demand rental properties and commercial developments.</p>
					</div>
				</div>
			</div>
		</section>

		<section id="faq" class="section">
			<div class="container">
				<h2>FAQ</h2>
				<div class="faq">
					<div class="item"><strong>Withdraw speed?</strong><p class="lead">Most approved withdrawals finalize within minutes.</p></div>
					<div class="item"><strong>Upgrade plans?</strong><p class="lead">Yes, you can upgrade anytime; ROI adjusts automatically.</p></div>
					<div class="item"><strong>KYC required?</strong><p class="lead">Profile completion and 2FA are required for security.</p></div>
					<div class="item"><strong>Support?</strong><p class="lead">24/7 ticket support inside your dashboard.</p></div>
				</div>
			</div>
		</section>

		<!-- Call to Action Section -->
		<section class="cta-section">
			<div class="container">
				<div class="cta-content">
					<h2>Ready to Start Your <span class="accent">Investment Journey</span>?</h2>
					<p>Join thousands of investors who trust Block Wave Trade for their financial growth. Start with as little as $25 and watch your money grow.</p>
					<div class="cta-buttons">
						<a class="btn btn-primary" href="{{ route('welcome') }}">
							<i class="fas fa-rocket"></i>
							Get Started Now
						</a>
						<a class="btn btn-secondary" href="{{ route('login') }}">
							<i class="fas fa-sign-in-alt"></i>
							Login to Dashboard
						</a>
					</div>
					<div class="cta-stats">
						<div class="stat">
							<div class="stat-number">10,000+</div>
							<div class="stat-label">Active Investors</div>
						</div>
						<div class="stat">
							<div class="stat-number">$50M+</div>
							<div class="stat-label">Assets Under Management</div>
						</div>
						<div class="stat">
							<div class="stat-number">99.9%</div>
							<div class="stat-label">Uptime</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</main>

	<footer>
		<div class="container footer-top">
			<div>
				<div class="footer-brand"><div class="logo"></div><strong>{{ setting('site_name','Block Wave Trade') }}</strong></div>
				<p class="muted footer-desc">Invest smartly with secure infrastructure, transparent fees, and automated returns.</p>
				<div class="footer-social" style="margin-top:12px">
					<a href="#" aria-label="Twitter"><i class="fa-brands fa-x-twitter"></i></a>
					<a href="#" aria-label="Facebook"><i class="fa-brands fa-facebook"></i></a>
					<a href="#" aria-label="Telegram"><i class="fa-brands fa-telegram"></i></a>
				</div>
			</div>
			<div class="footer-columns">
				<div class="footer-col">
					<h4>Product</h4>
					<a href="{{ route('user.schema') }}">Investment Plans</a>
					<a href="{{ route('page','how-it-works') }}">How it works</a>
				</div>
				<div class="footer-col">
					<h4>Company</h4>
					<a href="{{ route('page','about-us') }}">About</a>
					<a href="{{ route('page','contact') }}">Contact</a>
				</div>
				<div class="footer-col">
					<h4>Support</h4>
					<a href="{{ route('login') }}">Login</a>
					<a href="{{ route('register') }}">Create account</a>
					<a href="{{ route('notification-tune') }}">Notification tone</a>
				</div>
				<div class="footer-col">
					<h4>Legal</h4>
					<a href="{{ route('page','privacy-policy') }}">Privacy policy</a>
					<a href="{{ route('page','terms-and-conditions') }}">Terms & conditions</a>
				</div>
			</div>
		</div>
		<div class="container footer-bottom">
			<div>&copy; {{ date('Y') }} {{ setting('site_name','Block Wave Trade') }}. All rights reserved.</div>
			<div>Powered by {{ config('app.name') }}</div>
		</div>
	</footer>

	@include('frontend.shahdeveloper.include.__shahdeveloper_scripts')

	

</body>
</html>