@extends('frontend.shahdeveloper.layouts.user')
@section('title')
{{ __('Achievements') }}
@endsection
@section('subtitle')
Track your progress and unlock rewards
@endsection
@section('content')

<!-- InvestFlow Achievement Page -->
<div class="achievement-page">
    <div class="achievement-container">
        
        <!-- Achievement Welcome -->
        <div class="achievement-welcome">
            <h3>Achievement Center</h3>
            <p>Complete challenges to unlock rewards and advance your rank</p>
        </div>

        <!-- Current Rank Card -->
        <div class="rank-card glass-effect">
            <div class="card-header">
                <div class="rank-info">
                    <div class="rank-icon">
                        <i class="fas fa-trophy"></i>
                    </div>
                    <div class="rank-details">
                        <h4>{{ $currentRankName ?? 'TEAM LEADER' }}</h4>
                        <p>Current Rank</p>
                    </div>
                </div>
                <div class="progress-circle">
                    <div class="progress-percentage">{{ round($progressPercentage ?? 0) }}%</div>
                </div>
            </div>
            
            <div class="rank-stats">
                <div class="stat-row">
                    <span class="stat-label">Referrals:</span>
                    <span class="stat-value">{{ $totalReferrals ?? 0 }}{{ $currentRank && isset($currentRank->minimum_referral) ? '/' . $currentRank->minimum_referral : '' }}</span>
                </div>
                <div class="stat-row">
                    <span class="stat-label">Team Investment:</span>
                    <span class="stat-value">{{ $currency ?? 'USD' }}{{ number_format($teamInvestment ?? 0, 0) }}{{ $currentRank && isset($currentRank->minimum_referral_invest) && $currentRank->minimum_referral_invest > 0 ? '/' . number_format($currentRank->minimum_referral_invest, 0) : '' }}</span>
                </div>
                <div class="stat-row">
                    <span class="stat-label">Next Rank:</span>
                    <span class="stat-value">{{ $nextRankName ?? 'NO RANK' }}</span>
                </div>
            </div>
        </div>

        <!-- Next Rank Requirements Section -->
        @if($nextRank && $nextRank->id != $currentRank->id)
        <div class="next-rank-section glass-effect">
            <div class="section-header">
                <h3><i class="fas fa-arrow-up"></i> Next Rank: {{ $nextRank->ranking_name }}</h3>
                <p>Complete these requirements to achieve the next rank</p>
            </div>
            
            <div class="requirements-grid">
                @if($nextRank->minimum_referral > 0)
                <div class="requirement-card">
                    <div class="requirement-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="requirement-info">
                        <h4>Referrals Required</h4>
                        <div class="progress-info">
                            <span class="current">{{ $totalReferrals ?? 0 }}</span>
                            <span class="separator">/</span>
                            <span class="target">{{ $nextRank->minimum_referral }}</span>
                        </div>
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: {{ min(($totalReferrals / max($nextRank->minimum_referral, 1)) * 100, 100) }}%"></div>
                        </div>
                    </div>
                </div>
                @endif
                
                @if($nextRank->minimum_referral_invest > 0)
                <div class="requirement-card">
                    <div class="requirement-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="requirement-info">
                        <h4>Team Investment Required</h4>
                        <div class="progress-info">
                            <span class="current">{{ $currency }}{{ number_format($teamInvestment ?? 0, 0) }}</span>
                            <span class="separator">/</span>
                            <span class="target">{{ $currency }}{{ number_format($nextRank->minimum_referral_invest, 0) }}</span>
                        </div>
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: {{ min(($teamInvestment / max($nextRank->minimum_referral_invest, 1)) * 100, 100) }}%"></div>
                        </div>
                    </div>
                </div>
                @endif
                
                @if($nextRank->minimum_earnings > 0)
                <div class="requirement-card">
                    <div class="requirement-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="requirement-info">
                        <h4>Earnings Required</h4>
                        <div class="progress-info">
                            <span class="current">{{ $currency }}{{ number_format($totalEarnings ?? 0, 0) }}</span>
                            <span class="separator">/</span>
                            <span class="target">{{ $currency }}{{ number_format($nextRank->minimum_earnings, 0) }}</span>
                        </div>
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: {{ min(($totalEarnings / max($nextRank->minimum_earnings, 1)) * 100, 100) }}%"></div>
                        </div>
                    </div>
                </div>
                @endif
                
                @if($nextRank->minimum_deposit > 0)
                <div class="requirement-card">
                    <div class="requirement-icon">
                        <i class="fas fa-credit-card"></i>
                    </div>
                    <div class="requirement-info">
                        <h4>Deposits Required</h4>
                        <div class="progress-info">
                            <span class="current">{{ $currency }}{{ number_format($totalDeposit ?? 0, 0) }}</span>
                            <span class="separator">/</span>
                            <span class="target">{{ $currency }}{{ number_format($nextRank->minimum_deposit, 0) }}</span>
                        </div>
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: {{ min(($totalDeposit / max($nextRank->minimum_deposit, 1)) * 100, 100) }}%"></div>
                        </div>
                    </div>
                </div>
                @endif
                
                @if($nextRank->minimum_invest > 0)
                <div class="requirement-card">
                    <div class="requirement-icon">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="requirement-info">
                        <h4>Investments Required</h4>
                        <div class="progress-info">
                            <span class="current">{{ $currency }}{{ number_format($totalInvest ?? 0, 0) }}</span>
                            <span class="separator">/</span>
                            <span class="target">{{ $currency }}{{ number_format($nextRank->minimum_invest, 0) }}</span>
                        </div>
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: {{ min(($totalInvest / max($nextRank->minimum_invest, 1)) * 100, 100) }}%"></div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
            
            <!-- Next Rank Rewards Preview -->
            @if($nextRank->salary > 0 || $nextRank->bonus > 0)
            <div class="rewards-preview">
                <h4><i class="fas fa-gift"></i> Rewards You'll Get</h4>
                <div class="rewards-list">
                    @if($nextRank->salary > 0)
                    <div class="reward-item">
                        <i class="fas fa-money-bill-wave"></i>
                        <span>Monthly Salary: {{ $currency }}{{ number_format($nextRank->salary, 0) }}</span>
                    </div>
                    @endif
                    @if($nextRank->bonus > 0)
                    <div class="reward-item">
                        <i class="fas fa-trophy"></i>
                        <span>Achievement Bonus: {{ $currency }}{{ number_format($nextRank->bonus, 0) }}</span>
                    </div>
                    @endif
                </div>
            </div>
            @endif
        </div>
        @endif

        <!-- Detailed Progress Section -->
        <div class="detailed-progress-section glass-effect">
            <div class="section-header">
                <h3><i class="fas fa-users"></i> Team Progress Details</h3>
                <p>Track your direct referrals and their investments</p>
            </div>
            
            <div class="progress-stats">
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-user-plus"></i>
                    </div>
                    <div class="stat-info">
                        <h4>{{ $totalReferrals }}</h4>
                        <p>Total Referrals</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="stat-info">
                        <h4>{{ $currency }}{{ number_format($teamInvestment, 0) }}</h4>
                        <p>Team Investment</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-target"></i>
                    </div>
                    <div class="stat-info">
                        <h4>{{ $currency }}{{ number_format($currentRank ? $currentRank->minimum_referral_invest : 0, 0) }}</h4>
                        <p>Required Amount</p>
                    </div>
                </div>
            </div>

            <!-- Progress Bar -->
            <div class="progress-bar-container">
                <div class="progress-bar-header">
                    <span>Team Investment Progress</span>
                    <span>{{ round(($teamInvestment / max($currentRank ? $currentRank->minimum_referral_invest : 1, 1)) * 100, 1) }}%</span>
                </div>
                <div class="progress-bar">
                    <div class="progress-fill" style="width: {{ min(($teamInvestment / max($currentRank ? $currentRank->minimum_referral_invest : 1, 1)) * 100, 100) }}%"></div>
                </div>
            </div>

            <!-- Direct Referrals List -->
            <div class="referrals-list">
                <h4><i class="fas fa-list"></i> Direct Referrals ({{ $totalReferrals }})</h4>
                @if($totalReferrals > 0)
                    <div class="referrals-grid">
                        @php
                            $directReferrals = \DB::table('users')
                                ->where('ref_id', $user->id)
                                ->select('id', 'username', 'email', 'created_at')
                                ->addSelect([
                                    'total_investment' => DB::raw('(SELECT COALESCE(SUM(invest_amount), 0) FROM invests WHERE user_id = users.id AND status = "ongoing")'),
                                    'total_deposit' => DB::raw('(SELECT COALESCE(SUM(amount), 0) FROM transactions WHERE user_id = users.id AND status = "success" AND type = "deposit")')
                                ])
                                ->get();
                        @endphp
                        
                        @foreach($directReferrals as $referral)
                            <div class="referral-card">
                                <div class="referral-avatar">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div class="referral-info">
                                    <h5>{{ $referral->username ?: 'User ' . $referral->id }}</h5>
                                    <p>{{ $referral->email }}</p>
                                    <small>Joined: {{ \Carbon\Carbon::parse($referral->created_at)->format('M d, Y') }}</small>
                                </div>
                                <div class="referral-stats">
                                    <div class="stat-item">
                                        <span class="label">Investment:</span>
                                        <span class="value">{{ $currency }}{{ number_format($referral->total_investment, 0) }}</span>
                                    </div>
                                    <div class="stat-item">
                                        <span class="label">Deposit:</span>
                                        <span class="value">{{ $currency }}{{ number_format($referral->total_deposit, 0) }}</span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="no-referrals">
                        <i class="fas fa-user-plus"></i>
                        <p>No referrals yet. Start inviting people to build your team!</p>
                    </div>
                @endif
            </div>

            <!-- Rank Achievement Status -->
            <div class="achievement-status">
                @if($currentRank && $currentRank->minimum_referral_invest > 0)
                    @if($teamInvestment >= $currentRank->minimum_referral_invest && $totalReferrals >= $currentRank->minimum_referral)
                        <div class="status-success">
                            <i class="fas fa-check-circle"></i>
                            <div class="status-content">
                                <h4>Requirements Met!</h4>
                                <p>You can now collect your salary and bonus for {{ $currentRank->ranking_name }}</p>
                                <div class="rewards">
                                    @if($currentRank->salary > 0)
                                        <span class="reward-item">Salary: {{ $currency }}{{ number_format($currentRank->salary, 0) }}/month</span>
                                    @endif
                                    @if($currentRank->bonus > 0)
                                        <span class="reward-item">Bonus: {{ $currency }}{{ number_format($currentRank->bonus, 0) }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="status-pending">
                            <i class="fas fa-clock"></i>
                            <div class="status-content">
                                <h4>Requirements Pending</h4>
                                <p>Complete the requirements to unlock salary and bonus</p>
                                <div class="requirements">
                                    @if($totalReferrals < $currentRank->minimum_referral)
                                        <span class="requirement-item incomplete">
                                            <i class="fas fa-times"></i>
                                            Referrals: {{ $totalReferrals }}/{{ $currentRank->minimum_referral }}
                                        </span>
                                    @else
                                        <span class="requirement-item complete">
                                            <i class="fas fa-check"></i>
                                            Referrals: {{ $totalReferrals }}/{{ $currentRank->minimum_referral }}
                                        </span>
                                    @endif
                                    
                                    @if($teamInvestment < $currentRank->minimum_referral_invest)
                                        <span class="requirement-item incomplete">
                                            <i class="fas fa-times"></i>
                                            Team Investment: {{ $currency }}{{ number_format($teamInvestment, 0) }}/{{ number_format($currentRank->minimum_referral_invest, 0) }}
                                        </span>
                                    @else
                                        <span class="requirement-item complete">
                                            <i class="fas fa-check"></i>
                                            Team Investment: {{ $currency }}{{ number_format($teamInvestment, 0) }}/{{ number_format($currentRank->minimum_referral_invest, 0) }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif
                @endif
            </div>
        </div>

        <!-- Progress Section -->
        <div id="tab-progress" class="tab-section" style="display:none;">
        <div class="achievement-table-container glass-effect">
            <div class="table-header">
                <h3>Achievement Progress</h3>
                <div class="table-actions">
                    <button class="btn-refresh" onclick="refreshAchievements()">
                        <i class="fas fa-sync-alt"></i>
                        Refresh
                    </button>
                </div>
            </div>
            
            <div class="table-wrapper">
                <table class="achievement-table">
                    <thead>
                        <tr>
                            <th>Rank</th>
                            <th>Requirements</th>
                            <th>Reward</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($allRankings as $ranking)
                            @php
                                $completedRankings = json_decode($user->rankings, true) ?? [];
                                $isCompleted = in_array($ranking->id, $completedRankings);
                                $isCurrent = $user->ranking_id == $ranking->id;
                                $canCollect = false;
                                
                                // Check if user meets requirements for this rank
                                if (!$isCompleted && !$isCurrent) {
                                    $canCollect = (
                                        ($ranking->minimum_referral == 0 || $totalReferrals >= $ranking->minimum_referral) &&
                                        ($ranking->minimum_earnings == 0 || $totalEarnings >= $ranking->minimum_earnings) &&
                                        ($ranking->minimum_deposit == 0 || $totalDeposit >= $ranking->minimum_deposit) &&
                                        ($ranking->minimum_invest == 0 || $totalInvest >= $ranking->minimum_invest) &&
                                        ($ranking->minimum_referral_deposit == 0 || $totalReferralDeposits >= $ranking->minimum_referral_deposit) &&
                                        ($ranking->minimum_referral_invest == 0 || $totalReferralInvestments >= $ranking->minimum_referral_invest)
                                    );
                                }
                            @endphp
                            <tr class="achievement-row {{ $isCurrent ? 'current' : ($isCompleted ? 'completed' : '') }}">
                                <td class="rank-cell">
                                    <div class="rank-badge {{ strtolower(str_replace(' ', '-', $ranking->ranking_name)) }}">
                                        <i class="{{ $ranking->icon ?? 'fas fa-trophy' }}"></i>
                                        <span>{{ $ranking->ranking_name }}</span>
                                    </div>
                                </td>
                                <td class="requirements-cell">
                                    @if($ranking->minimum_referral > 0)
                                        <div class="requirement-item">
                                            <i class="fas fa-users"></i>
                                            <span>Get {{ $ranking->minimum_referral }} referral{{ $ranking->minimum_referral > 1 ? 's' : '' }}</span>
                                        </div>
                                    @endif
                                    @if($ranking->minimum_earnings > 0)
                                        <div class="requirement-item">
                                            <i class="fas fa-chart-line"></i>
                                            <span>Earn {{ $currency }}{{ number_format($ranking->minimum_earnings) }}</span>
                                        </div>
                                    @endif
                                    @if($ranking->minimum_deposit > 0)
                                        <div class="requirement-item">
                                            <i class="fas fa-plus-circle"></i>
                                            <span>Deposit {{ $currency }}{{ number_format($ranking->minimum_deposit) }}</span>
                                        </div>
                                    @endif
                                    @if($ranking->minimum_invest > 0)
                                        <div class="requirement-item">
                                            <i class="fas fa-wallet"></i>
                                            <span>Invest {{ $currency }}{{ number_format($ranking->minimum_invest) }}</span>
                                        </div>
                                    @endif
                                    @if($ranking->minimum_referral_deposit > 0)
                                        <div class="requirement-item">
                                            <i class="fas fa-users"></i>
                                            <span>Team deposits {{ $currency }}{{ number_format($ranking->minimum_referral_deposit) }}</span>
                                        </div>
                                    @endif
                                    @if($ranking->minimum_referral_invest > 0)
                                        <div class="requirement-item">
                                            <i class="fas fa-users"></i>
                                            <span>Team invests {{ $currency }}{{ number_format($ranking->minimum_referral_invest) }}</span>
                                        </div>
                                    @endif
                                </td>
                                <td class="reward-cell">
                                    @if($ranking->bonus > 0)
                                        <div class="reward-amount">{{ $currency }}{{ number_format($ranking->bonus) }}</div>
                                        <div class="reward-type">Bonus</div>
                                    @endif
                                    @if($ranking->salary > 0)
                                        <div class="reward-amount">{{ $currency }}{{ number_format($ranking->salary) }}</div>
                                        <div class="reward-type">Monthly Salary</div>
                                    @endif
                                </td>
                                <td class="status-cell">
                                    @if($isCompleted)
                                        <span class="status-badge completed">
                                            <i class="fas fa-check"></i>
                                            Completed
                                        </span>
                                    @elseif($isCurrent)
                                        <span class="status-badge current">
                                            <i class="fas fa-clock"></i>
                                            Current
                                        </span>
                                    @else
                                        <span class="status-badge pending">
                                            <i class="fas fa-hourglass-half"></i>
                                            Pending
                                        </span>
                                    @endif
                                </td>
                                <td class="action-cell">
                                    @if($isCompleted)
                                        <button class="btn-collect" disabled>
                                            <i class="fas fa-check"></i>
                                            Collected
                                        </button>
                                    @elseif($canCollect)
                                        <button class="btn-collect" onclick="collectReward({{ $ranking->id }})">
                                            <i class="fas fa-gift"></i>
                                            Collect
                                        </button>
                                    @else
                                        <button class="btn-collect" disabled>
                                            <i class="fas fa-lock"></i>
                                            Locked
                                        </button>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Mobile Card List -->
        <div class="progress-cards">
            @foreach($allRankings as $ranking)
            @php
                $completedRankings = json_decode($user->rankings, true) ?? [];
                $isCompleted = in_array($ranking->id, $completedRankings);
                $isCurrent = $user->ranking_id == $ranking->id;
                $canCollect = false;
                if (!$isCompleted && !$isCurrent) {
                    $canCollect = (
                        ($ranking->minimum_referral == 0 || $totalReferrals >= $ranking->minimum_referral) &&
                        ($ranking->minimum_earnings == 0 || $totalEarnings >= $ranking->minimum_earnings) &&
                        ($ranking->minimum_deposit == 0 || $totalDeposit >= $ranking->minimum_deposit) &&
                        ($ranking->minimum_invest == 0 || $totalInvest >= $ranking->minimum_invest) &&
                        ($ranking->minimum_referral_deposit == 0 || $totalReferralDeposits >= $ranking->minimum_referral_deposit) &&
                        ($ranking->minimum_referral_invest == 0 || $totalReferralInvestments >= $ranking->minimum_referral_invest)
                    );
                }
            @endphp
            <div class="progress-card glass-effect {{ $isCurrent ? 'is-current' : ($isCompleted ? 'is-completed' : '') }}">
                <div class="pc-header">
                    <div class="rank-badge {{ strtolower(str_replace(' ', '-', $ranking->ranking_name)) }}">
                        <i class="{{ $ranking->icon ?? 'fas fa-trophy' }}"></i>
                        <span>{{ $ranking->ranking_name }}</span>
                    </div>
                    <div class="pc-status">
                        @if($isCompleted)
                            <span class="status-badge completed"><i class="fas fa-check"></i> Completed</span>
                        @elseif($isCurrent)
                            <span class="status-badge current"><i class="fas fa-clock"></i> Current</span>
                        @else
                            <span class="status-badge pending"><i class="fas fa-hourglass-half"></i> Pending</span>
                        @endif
                    </div>
                </div>
                <div class="pc-body">
                    <div class="pc-reqs">
                        @if($ranking->minimum_referral > 0)
                        <div class="req"><i class="fas fa-users"></i> Get {{ $ranking->minimum_referral }} referrals</div>
                        @endif
                        @if($ranking->minimum_earnings > 0)
                        <div class="req"><i class="fas fa-chart-line"></i> Earn {{ $currency }}{{ number_format($ranking->minimum_earnings) }}</div>
                        @endif
                        @if($ranking->minimum_deposit > 0)
                        <div class="req"><i class="fas fa-plus-circle"></i> Deposit {{ $currency }}{{ number_format($ranking->minimum_deposit) }}</div>
                        @endif
                        @if($ranking->minimum_invest > 0)
                        <div class="req"><i class="fas fa-wallet"></i> Invest {{ $currency }}{{ number_format($ranking->minimum_invest) }}</div>
                        @endif
                    </div>
                    <div class="pc-reward">
                        @if($ranking->bonus > 0)
                        <div class="amount">{{ $currency }}{{ number_format($ranking->bonus) }}</div>
                        <div class="type">Bonus</div>
                        @endif
                        @if($ranking->salary > 0)
                        <div class="amount">{{ $currency }}{{ number_format($ranking->salary) }}</div>
                        <div class="type">Monthly Salary</div>
                        @endif
                    </div>
                </div>
                <div class="pc-actions">
                    @if($isCompleted)
                        <button class="btn-collect" disabled><i class="fas fa-check"></i> Collected</button>
                    @elseif($canCollect)
                        <button class="btn-collect" onclick="collectReward({{ $ranking->id }})"><i class="fas fa-gift"></i> Collect</button>
                    @else
                        <button class="btn-collect" disabled><i class="fas fa-lock"></i> Locked</button>
                    @endif
                </div>
            </div>
            @endforeach
        </div>
        </div>

        <!-- Rewards Section -->
        <div id="tab-rewards" class="tab-section" style="display:none;">
        @php
            $completedRankings = json_decode($user->rankings, true) ?? [];
            $salaryEligibleRankings = $allRankings->where('salary', '>', 0);
            $hasSalaryEligibility = false;
            $currentSalary = 0;
            
            foreach($salaryEligibleRankings as $ranking) {
                if(in_array($ranking->id, $completedRankings)) {
                    $hasSalaryEligibility = true;
                    $currentSalary = $ranking->salary;
                    break;
                }
            }
        @endphp
        
        @if($hasSalaryEligibility)
        <div class="salary-section glass-effect">
            <div class="salary-header">
                <h3>Monthly Salary</h3>
                <p>As a {{ $currentRankName }}, you earn {{ $currency }}{{ number_format($currentSalary) }} monthly</p>
            </div>
            <div class="salary-info">
                <div class="salary-amount">{{ $currency }}{{ number_format($currentSalary) }}</div>
                <div class="salary-period">Per Month</div>
                <button class="btn-salary" onclick="collectSalary(this)">
                    <i class="fas fa-money-bill-wave"></i>
                    Collect Salary
                </button>
            </div>
        </div>
        @endif
        </div>

    </div>
</div>

<!-- Reward Collection Modal -->
<div id="rewardModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Congratulations!</h3>
            <span class="close" onclick="closeModal()">&times;</span>
        </div>
        <div class="modal-body">
            <div class="reward-animation">
                <i class="fas fa-gift"></i>
            </div>
            <p id="rewardMessage">You have successfully collected your reward!</p>
            <div class="reward-amount" id="rewardAmount">$0</div>
        </div>
        <div class="modal-footer">
            <button class="btn-confirm" onclick="closeModal()">Awesome!</button>
        </div>
    </div>
</div>

<!-- Salary Collection Modal -->
<div id="salaryModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Monthly Salary Collected!</h3>
            <span class="close" onclick="closeModal()">&times;</span>
        </div>
        <div class="modal-body">
            <div class="salary-animation">
                <i class="fas fa-money-bill-wave"></i>
            </div>
            <p>You have successfully collected your monthly salary!</p>
            <div class="salary-amount">$40</div>
        </div>
        <div class="modal-footer">
            <button class="btn-confirm" onclick="closeModal()">Great!</button>
        </div>
    </div>
</div>

@endsection

<style>
/* Achievement Page Styles - Matching Dashboard Theme */
.achievement-page {
    padding: 20px;
}

.achievement-container {
    max-width: 1200px;
    margin: 0 auto;
}

.achievement-welcome {
    text-align: center;
    margin-bottom: 30px;
}

.achievement-welcome h3 {
    color: var(--text-primary);
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 10px;
}

.achievement-welcome p {
    color: var(--text-secondary);
    font-size: 1.1rem;
}

/* Glass Effect Components */
.glass-effect {
    background: var(--glass-bg);
    backdrop-filter: blur(20px);
    border: 1px solid var(--glass-border);
    border-radius: 20px;
    box-shadow: var(--shadow);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.glass-effect:hover {
    transform: translateY(-2px);
    box-shadow: 0 12px 40px rgba(0, 0, 0, 0.4);
}

/* Achievement Header */
.achievement-header {
    text-align: center;
    padding: 16px;
    margin-bottom: 12px;
    background: var(--primary-gradient);
    border-radius: 16px;
    position: relative;
    overflow: hidden;
    width: 100%;
    box-sizing: border-box;
}

.achievement-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, rgba(255,255,255,0.1) 0%, transparent 50%, rgba(255,255,255,0.1) 100%);
    animation: shimmer 3s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

.achievement-header h2 {
    color: var(--text-primary);
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 6px;
    position: relative;
    z-index: 1;
}

.achievement-header p {
    color: var(--text-secondary);
    font-size: 13px;
    position: relative;
    z-index: 1;
    line-height: 1.4;
}

/* Tab Navigation */
.tab-nav {
    display: flex;
    background: var(--glass-bg);
    border-radius: 12px;
    padding: 4px;
    margin-bottom: 16px;
    backdrop-filter: blur(20px);
    width: 100%;
    box-sizing: border-box;
}

.tab-btn {
    flex: 1;
    padding: 8px 12px;
    border: none;
    background: transparent;
    color: var(--text-secondary);
    border-radius: 8px;
    font-size: 12px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    min-height: 40px;
}

.tab-btn.active {
    background: var(--success-gradient);
    color: white;
    box-shadow: 0 4px 15px rgba(79, 172, 254, 0.3);
}

.tab-btn i {
    font-size: 16px;
}

/* Detailed Progress Section */
.detailed-progress-section {
    margin: 20px 0;
    padding: 24px;
    background: var(--glass-bg);
    backdrop-filter: blur(20px);
    border: 1px solid var(--glass-border);
    border-radius: 20px;
    box-shadow: var(--shadow);
}

.section-header {
    text-align: center;
    margin-bottom: 25px;
}

.section-header h3 {
    color: var(--accent-color);
    font-size: 1.5rem;
    margin-bottom: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}

.section-header p {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

.progress-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
    margin-bottom: 25px;
}

/* Rank Card */
.rank-card {
    background: var(--glass-bg);
    backdrop-filter: blur(20px);
    border: 1px solid var(--glass-border);
    border-radius: 20px;
    padding: 25px;
    margin-bottom: 25px;
    box-shadow: var(--shadow);
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.rank-info {
    display: flex;
    align-items: center;
    gap: 15px;
}

.rank-icon {
    width: 60px;
    height: 60px;
    background: var(--primary-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 15px rgba(0, 163, 255, 0.3);
}

.rank-icon i {
    font-size: 24px;
    color: white;
}

.rank-details h4 {
    color: var(--text-primary);
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 5px;
}

.rank-details p {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

.progress-circle {
    width: 80px;
    height: 80px;
    background: var(--primary-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 15px rgba(0, 163, 255, 0.3);
}

.progress-percentage {
    color: white;
    font-size: 1.2rem;
    font-weight: 700;
}

.rank-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
}

.stat-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 16px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 10px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.stat-label {
    color: var(--text-secondary);
    font-size: 0.9rem;
    font-weight: 500;
}

.stat-value {
    color: var(--accent-color);
    font-size: 1rem;
    font-weight: 700;
}

.stat-card {
    background: var(--glass-bg);
    border: 1px solid var(--glass-border);
    border-radius: 15px;
    padding: 20px;
    text-align: center;
    transition: all 0.3s ease;
    backdrop-filter: blur(20px);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    border-color: var(--accent-color);
}

.stat-icon {
    font-size: 2rem;
    color: var(--accent-color);
    margin-bottom: 10px;
}

.stat-info h4 {
    color: var(--text-primary);
    font-size: 1.8rem;
    font-weight: bold;
    margin-bottom: 5px;
}

.stat-info p {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

.progress-bar-container {
    margin-bottom: 25px;
}

.progress-bar-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.progress-bar-header span:first-child {
    color: var(--text-primary);
    font-weight: 500;
}

.progress-bar-header span:last-child {
    color: var(--accent-color);
    font-weight: bold;
}

.progress-bar {
    height: 8px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 4px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, var(--accent-color), #00ff88);
    border-radius: 4px;
    transition: width 0.3s ease;
}

.referrals-list h4 {
    color: var(--text-primary);
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.referrals-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 15px;
}

/* Progress Bar */
.progress-bar-container {
    margin-bottom: 25px;
}

.progress-bar-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 12px;
}

.progress-bar-header span:first-child {
    color: var(--text-primary);
    font-weight: 600;
    font-size: 14px;
}

.progress-bar-header span:last-child {
    color: var(--accent-color);
    font-weight: 700;
    font-size: 16px;
}

.progress-bar {
    height: 12px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    overflow: hidden;
    position: relative;
}

.progress-fill {
    height: 100%;
    background: var(--success-gradient);
    border-radius: 8px;
    transition: width 0.8s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.progress-fill::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(90deg, transparent 0%, rgba(255,255,255,0.3) 50%, transparent 100%);
    animation: progressShine 2s infinite;
}

@keyframes progressShine {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

/* Referral Cards */
.referral-card {
    background: var(--glass-bg);
    border: 1px solid var(--glass-border);
    border-radius: 15px;
    padding: 20px;
    transition: all 0.3s ease;
    backdrop-filter: blur(20px);
    position: relative;
    overflow: hidden;
}

.referral-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: var(--primary-gradient);
    transform: scaleX(0);
    transition: transform 0.3s ease;
}

.referral-card:hover {
    border-color: var(--accent-color);
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
}

.referral-card:hover::before {
    transform: scaleX(1);
}

.referral-avatar {
    width: 40px;
    height: 40px;
    background: var(--accent-color);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 10px;
}

.referral-avatar i {
    color: var(--bg-primary);
    font-size: 1.2rem;
}

.referral-info h5 {
    color: var(--text-primary);
    margin-bottom: 5px;
    font-size: 1rem;
}

.referral-info p {
    color: var(--text-secondary);
    font-size: 0.8rem;
    margin-bottom: 5px;
}

.referral-info small {
    color: var(--text-secondary);
    font-size: 0.7rem;
}

.referral-stats {
    margin-top: 10px;
}

.stat-item {
    display: flex;
    justify-content: space-between;
    margin-bottom: 5px;
}

.stat-item .label {
    color: var(--text-secondary);
    font-size: 0.8rem;
}

.stat-item .value {
    color: var(--accent-color);
    font-weight: bold;
    font-size: 0.8rem;
}

/* Mobile Responsive Design */
@media (max-width: 768px) {
    .achievement-page {
        padding: 15px;
    }
    
    .achievement-welcome h3 {
        font-size: 1.5rem;
    }
    
    .achievement-welcome p {
        font-size: 1rem;
    }
    
    .rank-card {
        padding: 20px;
    }
    
    .card-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .rank-stats {
        grid-template-columns: 1fr;
        gap: 10px;
    }
    
    .progress-stats {
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
    }
    
    .referrals-grid {
        grid-template-columns: 1fr;
        gap: 10px;
    }
    
    .detailed-progress-section {
        padding: 20px;
    }
}

@media (max-width: 480px) {
    .achievement-page {
        padding: 6px;
    }
    
    .achievement-header {
        padding: 12px;
        margin-bottom: 10px;
    }
    
    .achievement-header h2 {
        font-size: 20px;
    }
    
    .achievement-header p {
        font-size: 12px;
    }
    
    .tab-btn {
        padding: 6px 8px;
        font-size: 11px;
    }
    
    .tab-btn i {
        font-size: 12px;
    }
    
    .tab-btn span {
        font-size: 9px;
    }
    
    .status-card {
        padding: 12px;
    }
    
    .rank-icon {
        width: 40px;
        height: 40px;
    }
    
    .rank-icon i {
        font-size: 16px;
    }
    
    .rank-info h3 {
        font-size: 16px;
    }
    
    .rank-info p {
        font-size: 11px;
    }
    
    .progress-ring {
        width: 50px;
        height: 50px;
    }
    
    .progress-text {
        font-size: 11px;
    }
    
    .detailed-progress-section {
        padding: 12px;
    }
    
    .section-header h3 {
        font-size: 16px;
    }
    
    .section-header p {
        font-size: 11px;
    }
    
    .progress-stats {
        grid-template-columns: 1fr;
        gap: 6px;
    }
    
    .stat-card {
        padding: 10px;
    }
    
    .stat-icon {
        font-size: 1.3rem;
    }
    
    .stat-info h4 {
        font-size: 1.2rem;
    }
    
    .stat-info p {
        font-size: 10px;
    }
    
    .referral-card {
        padding: 10px;
    }
    
    .referral-avatar {
        width: 28px;
        height: 28px;
    }
    
    .referral-info h5 {
        font-size: 13px;
    }
    
    .referral-info p {
        font-size: 10px;
    }
    
    .referral-info small {
        font-size: 9px;
    }
}

/* iPhone X/11/12 specific adjustments */
@media (max-width: 414px) and (max-height: 896px) {
    .achievement-page {
        padding: 4px;
        min-height: calc(100vh - 60px);
    }
    
    .achievement-header {
        padding: 10px;
    }
    
    .achievement-header h2 {
        font-size: 18px;
    }
    
    .achievement-header p {
        font-size: 11px;
    }
    
    .tab-nav {
        margin-bottom: 12px;
    }
    
    .status-card {
        padding: 10px;
        margin-bottom: 12px;
    }
    
    .detailed-progress-section {
        padding: 10px;
        margin: 12px 0;
    }
    
    .progress-stats {
        gap: 4px;
        margin-bottom: 12px;
    }
    
    .stat-card {
        padding: 8px;
    }
    
    .referrals-grid {
        gap: 6px;
    }
    
    .referral-card {
        padding: 8px;
    }
}

/* No Referrals State */
.no-referrals {
    text-align: center;
    padding: 60px 20px;
    color: var(--text-secondary);
    background: var(--glass-bg);
    border-radius: 20px;
    backdrop-filter: blur(20px);
    border: 1px solid var(--glass-border);
}

.no-referrals i {
    font-size: 4rem;
    margin-bottom: 20px;
    color: var(--accent-color);
    opacity: 0.5;
    color: var(--accent-color);
}

.achievement-status {
    margin-top: 25px;
}

.status-success, .status-pending {
    padding: 20px;
    border-radius: 10px;
    display: flex;
    align-items: flex-start;
    gap: 15px;
}

.status-success {
    background: rgba(0, 255, 0, 0.1);
    border: 1px solid rgba(0, 255, 0, 0.3);
}

.status-pending {
    background: rgba(255, 193, 7, 0.1);
    border: 1px solid rgba(255, 193, 7, 0.3);
}

.status-success i {
    color: #00ff00;
    font-size: 1.5rem;
    margin-top: 5px;
}

.status-pending i {
    color: #ffc107;
    font-size: 1.5rem;
    margin-top: 5px;
}

.status-content h4 {
    color: var(--text-primary);
    margin-bottom: 8px;
}

.status-content p {
    color: var(--text-secondary);
    margin-bottom: 15px;
}

.rewards {
    display: flex;
    gap: 15px;
    flex-wrap: wrap;
}

.reward-item {
    background: rgba(0, 255, 0, 0.2);
    color: var(--accent-color);
    padding: 5px 10px;
    border-radius: 5px;
    font-size: 0.8rem;
    font-weight: bold;
}

.requirements {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.requirement-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 0.9rem;
}

.requirement-item.complete {
    color: #00ff00;
}

.requirement-item.incomplete {
    color: #ff6b6b;
}

.requirement-item i {
    font-size: 0.8rem;
}

.achievement-container {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

/* Tabs */
.tab-nav {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 8px;
    padding: 8px;
    border-radius: 12px;
    margin-bottom: 16px;
}

.tab-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 10px 12px;
    border-radius: 10px;
    border: 1px solid var(--border);
    background: var(--surface-light);
    color: var(--text-secondary);
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition);
}

.tab-btn i { font-size: 14px; }
.tab-btn span { font-size: 12px; }

.tab-btn.active {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: #001f11;
}

.tab-section { animation: fadeIn 0.25s ease; }

/* Progress Cards (mobile/app style) */
.progress-cards { display: grid; gap: 12px; margin-top: 12px; }

.progress-card { padding: 14px; border-radius: 12px; border: 1px solid var(--border); }

.pc-header { display: flex; align-items: center; justify-content: space-between; margin-bottom: 10px; }

.pc-body { display: flex; align-items: flex-start; justify-content: space-between; gap: 12px; }

.pc-reqs { display: grid; gap: 6px; }
.pc-reqs .req { color: var(--text-secondary); font-size: 0.85rem; display: flex; gap: 8px; align-items: center; }
.pc-reqs .req i { color: var(--primary-color); font-size: 0.85rem; }

.pc-reward { text-align: right; min-width: 120px; }
.pc-reward .amount { color: var(--primary-color); font-weight: 700; }
.pc-reward .type { color: var(--text-muted); font-size: 0.8rem; }

.pc-actions { margin-top: 10px; display: flex; justify-content: flex-end; }

/* Use global glass-effect from theme variables; no override here for consistency */

.achievement-header {
    text-align: center;
    margin-bottom: 20px;
    padding: 20px;
    border-radius: 12px;
}

.achievement-header h2 {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 8px;
}

.achievement-header p {
    font-size: 0.95rem;
    color: var(--text-secondary);
    margin: 0;
}

/* Status Card */
.status-card {
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 20px;
}

.status-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    flex-wrap: wrap;
    gap: 15px;
}

.user-rank {
    display: flex;
    align-items: center;
    gap: 12px;
}

.rank-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: #001f11;
    flex-shrink: 0;
}

.rank-info h3 {
    font-size: 1.2rem;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
}

.rank-info p {
    color: var(--text-secondary);
    margin: 0;
    font-size: 0.9rem;
}

/* Progress Ring */
.progress-ring {
    position: relative;
    width: 60px;
    height: 60px;
    flex-shrink: 0;
}

.progress-ring-svg {
    transform: rotate(-90deg);
    width: 100%;
    height: 100%;
}

.progress-ring-circle-bg {
    fill: none;
    stroke: rgba(255,255,255,0.12);
    stroke-width: 4;
}

.progress-ring-circle {
    fill: none;
    stroke: var(--primary-color);
    stroke-width: 4;
    stroke-linecap: round;
    transition: stroke-dashoffset 0.5s ease;
}

.progress-text {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-weight: 700;
    color: var(--text-primary);
    font-size: 11px;
}

.status-details {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
}

.detail-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 15px;
    background: var(--surface-light);
    border-radius: 10px;
    border: 1px solid var(--border);
}

.detail-item .label {
    color: var(--text-secondary);
    font-weight: 500;
    font-size: 0.9rem;
}

.detail-item .value {
    color: var(--text-primary);
    font-weight: 600;
    font-size: 0.9rem;
}

/* Achievement Table */
.achievement-table-container {
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 20px;
}

.table-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    flex-wrap: wrap;
    gap: 15px;
}

.table-header h3 {
    font-size: 1.2rem;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
}

.btn-refresh {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: #001f11;
    border: none;
    padding: 8px 16px;
    border-radius: 10px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 0.9rem;
}

.btn-refresh:hover {
    filter: brightness(1.05);
}

.table-wrapper {
    overflow-x: auto;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.04);
}

.achievement-table {
    width: 100%;
    border-collapse: collapse;
    margin: 0;
    min-width: 800px;
}

.achievement-table th {
    background: rgba(255, 255, 255, 0.06);
    color: var(--text-primary);
    font-weight: 600;
    padding: 12px 10px;
    text-align: left;
    border-bottom: 1px solid var(--border);
    font-size: 0.9rem;
}

.achievement-table td {
    padding: 15px 10px;
    border-bottom: 1px solid #333;
    vertical-align: middle;
}

.achievement-row.current {
    background: var(--surface-light);
    border-left: 3px solid var(--primary-color);
}

.achievement-row.completed {
    background: rgba(0,255,136,0.10);
    border-left: 3px solid var(--primary-dark);
}

.rank-badge {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 6px 10px;
    border-radius: 15px;
    font-weight: 600;
    width: fit-content;
    font-size: 0.8rem;
}

.rank-badge.struggler {
    background: rgba(255, 107, 107, 0.18);
    color: var(--text-primary);
    border: 1px solid rgba(255, 107, 107, 0.35);
}

.rank-badge.team-leader {
    background: rgba(0,255,136,0.18);
    color: var(--text-primary);
    border: 1px solid var(--border);
}

.requirements-cell {
    display: flex;
    flex-direction: column;
    gap: 4px;
    min-width: 180px;
}

.requirement-item {
    display: flex;
    align-items: center;
    gap: 6px;
    color: var(--text-secondary);
    font-size: 0.8rem;
    line-height: 1.3;
}

.requirement-item i {
    color: var(--primary-color);
    width: 12px;
    flex-shrink: 0;
}

.reward-cell {
    text-align: center;
    min-width: 100px;
}

.reward-amount {
    font-size: 0.9rem;
    font-weight: 700;
    color: var(--primary-color);
    margin-bottom: 2px;
}

.reward-type {
    font-size: 0.7rem;
    color: var(--text-muted);
}

.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 0.7rem;
    font-weight: 600;
    white-space: nowrap;
}

.status-badge.completed {
    background: rgba(0,255,136,0.15);
    color: var(--primary-color);
    border: 1px solid rgba(0,255,136,0.35);
}

.status-badge.current {
    background: rgba(0,255,136,0.12);
    color: var(--primary-color);
    border: 1px solid rgba(0,255,136,0.35);
}

.status-badge.pending {
    background: rgba(255,255,255,0.05);
    color: var(--text-secondary);
    border: 1px solid rgba(255,255,255,0.12);
}

.btn-collect {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: #001f11;
    border: none;
    padding: 6px 12px;
    border-radius: 12px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 0.7rem;
    white-space: nowrap;
}

.btn-collect:hover:not(:disabled) {
    filter: brightness(1.06);
}

.btn-collect:disabled {
    background: rgba(148, 163, 184, 0.18);
    color: var(--text-muted);
    cursor: not-allowed;
}

/* Salary Section */
.salary-section {
    border-radius: 12px;
    padding: 20px;
    text-align: center;
    margin-bottom: 20px;
}

.salary-header h3 {
    font-size: 1.2rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 8px;
}

.salary-header p {
    color: var(--text-secondary);
    margin-bottom: 20px;
    font-size: 0.9rem;
}

.salary-info {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
}

.salary-amount {
    font-size: 1.3rem;
    font-weight: 700;
    color: var(--primary-color);
}

.salary-period {
    color: var(--text-secondary);
    font-size: 0.8rem;
}

.btn-salary {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: #001f11;
    border: none;
    padding: 10px 20px;
    border-radius: 15px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 0.9rem;
}

.btn-salary:hover {
    filter: brightness(1.05);
}

/* Modal Styles */
.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.8);
    backdrop-filter: blur(5px);
}

.modal-content {
    background: linear-gradient(135deg, var(--background-primary), var(--background-secondary));
    margin: 5% auto;
    padding: 0;
    border-radius: 15px;
    width: 95%;
    max-width: 400px;
    border: 1px solid var(--border);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
}

.modal-header {
    padding: 20px 20px 15px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modal-header h3 {
    color: var(--text-primary);
    margin: 0;
    font-size: 1.2rem;
}

.close {
    color: var(--text-secondary);
    font-size: 24px;
    font-weight: bold;
    cursor: pointer;
    transition: color 0.3s ease;
}

.close:hover {
    color: var(--text-primary);
}

.modal-body {
    padding: 20px;
    text-align: center;
}

.reward-animation, .salary-animation {
    font-size: 3rem;
    color: var(--primary-color);
    margin-bottom: 15px;
    animation: bounce 1s infinite;
}

@keyframes bounce {
    0%, 20%, 50%, 80%, 100% {
        transform: translateY(0);
    }
    40% {
        transform: translateY(-10px);
    }
    60% {
        transform: translateY(-5px);
    }
}

.modal-body p {
    color: var(--text-secondary);
    margin-bottom: 15px;
    font-size: 1rem;
}

.modal-body .reward-amount, .modal-body .salary-amount {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--primary-color);
    margin-bottom: 15px;
}

.modal-footer {
    padding: 15px 20px 20px;
    text-align: center;
}

.btn-confirm {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: #001f11;
    border: none;
    padding: 10px 24px;
    border-radius: 20px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 0.9rem;
}

.btn-confirm:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 255, 136, 0.25);
}

/* Responsive Design */
@media (max-width: 768px) {
    .achievement-page {
        padding: 10px;
    }
    
    .achievement-header {
        padding: 15px;
    }
    
    .achievement-header h2 {
        font-size: 1.3rem;
    }
    
    .achievement-header p {
        font-size: 0.8rem;
    }
    
    .status-card {
        padding: 15px;
    }
    
    .status-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .user-rank {
        justify-content: center;
    }
    
    .rank-icon {
        width: 40px;
        height: 40px;
        font-size: 16px;
    }
    
    .rank-info h3 {
        font-size: 1rem;
    }
    
    .progress-ring {
        width: 50px;
        height: 50px;
    }
    
    .progress-text {
        font-size: 10px;
    }
    
    .status-details {
        grid-template-columns: 1fr;
        gap: 10px;
    }
    
    .detail-item {
        padding: 10px 12px;
    }
    
    .detail-item .label,
    .detail-item .value {
        font-size: 0.8rem;
    }
    
    .achievement-table-container {
        padding: 15px;
    }
    
    .table-header {
        flex-direction: column;
        gap: 10px;
        text-align: center;
    }
    
    .table-header h3 {
        font-size: 1rem;
    }
    
    .achievement-table {
        min-width: 600px;
        font-size: 0.75rem;
    }
    
    .achievement-table th,
    .achievement-table td {
        padding: 8px 6px;
    }
    
    .rank-badge {
        padding: 4px 8px;
        font-size: 0.7rem;
    }
    
    .requirements-cell {
        min-width: 120px;
    }
    
    .requirement-item {
        font-size: 0.72rem;
    }
    
    .reward-cell {
        min-width: 80px;
    }
    
    .reward-amount {
        font-size: 0.8rem;
    }
    
    .reward-type {
        font-size: 0.65rem;
    }
    
    .status-badge {
        padding: 3px 6px;
        font-size: 0.65rem;
    }
    
    .btn-collect {
        padding: 6px 10px;
        font-size: 0.7rem;
    }
    
    .salary-section {
        padding: 15px;
    }
    
    .salary-header h3 {
        font-size: 1rem;
    }
    
    .salary-amount {
        font-size: 1.1rem;
    }
    
    .btn-salary {
        padding: 8px 16px;
        font-size: 0.8rem;
    }
    
    .modal-content {
        width: 95%;
        margin: 10% auto;
    }
    
    .modal-header {
        padding: 15px;
    }
    
    .modal-header h3 {
        font-size: 1rem;
    }
    
    .modal-body {
        padding: 15px;
    }
    
    .reward-animation, .salary-animation {
        font-size: 2rem;
    }
    
    .modal-body .reward-amount, .modal-body .salary-amount {
        font-size: 1.1rem;
    }
}

@media (max-width: 480px) {
    .achievement-page {
        padding: 8px;
    }
    
    .achievement-header {
        padding: 12px;
    }
    
    .achievement-header h2 {
        font-size: 1.3rem;
    }
    
    .status-card {
        padding: 12px;
    }
    
    .achievement-table-container {
        padding: 12px;
    }
    
    .achievement-table {
        min-width: 500px;
    }
    
    .achievement-table th,
    .achievement-table td {
        padding: 6px 4px;
    }
    
    .rank-badge {
        padding: 4px 8px;
        font-size: 0.7rem;
    }
    
    .requirements-cell {
        min-width: 120px;
    }
    
    .requirement-item {
        font-size: 0.7rem;
    }
    
    .reward-cell {
        min-width: 80px;
    }
    
    .reward-amount {
        font-size: 0.8rem;
    }
    
    .status-badge {
        padding: 3px 6px;
        font-size: 0.65rem;
    }
    
    .btn-collect {
        padding: 4px 8px;
        font-size: 0.65rem;
    }
    
    .salary-section {
        padding: 12px;
    }
    
    .salary-amount {
        font-size: 1.2rem;
    }
    
    .btn-salary {
        padding: 10px 18px;
        font-size: 0.85rem;
    }
}

</style>
<style>
/* Next Rank section – compact, modern, and responsive */
.next-rank-section {
    padding: 18px 20px;
}
.next-rank-section .section-header {
    text-align: center;
    margin-bottom: 14px;
}
.next-rank-section .section-header h3 {
    margin: 0 0 6px 0;
    font-weight: 800;
    letter-spacing: .2px;
    color: var(--text-primary);
}
.next-rank-section .section-header p {
    margin: 0;
    color: var(--text-secondary);
    font-size: .9rem;
}

.next-rank-section .requirements-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 8px;
}

.next-rank-section .requirement-card {
    display: grid;
    grid-template-columns: 46px 1fr 120px;
    align-items: center;
    gap: 12px;
    background: rgba(255,255,255,0.04);
    border: 1px solid rgba(255,255,255,0.08);
    border-radius: 12px;
    padding: 10px 12px;
}
.next-rank-section .requirement-icon {
    width: 42px;
    height: 42px;
    border-radius: 10px;
    display: grid;
    place-items: center;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: #001f11;
}
.next-rank-section .requirement-info h4 {
    margin: 0 0 6px 0;
    font-size: 0.95rem;
    color: var(--text-primary);
    font-weight: 700;
}
.next-rank-section .progress-info { 
    display: flex; 
    gap: 6px; 
    align-items: baseline; 
    color: var(--text-secondary);
}
.next-rank-section .target { color: var(--text-primary); font-weight: 700; }

.next-rank-section .progress-bar {
    height: 10px;
    background: rgba(255,255,255,0.08);
    border-radius: 8px;
    overflow: hidden;
    margin-top: 6px;
}
.next-rank-section .progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #22c55e, #16a34a);
    box-shadow: 0 0 12px rgba(34,197,94,.25);
}

.next-rank-section .requirement-card > .progress-info { justify-self: end; font-weight: 700; }

/* Rewards band */
.next-rank-section .rewards-preview {
    margin-top: 10px;
    background: linear-gradient(135deg, rgba(16,185,129,.25), rgba(22,163,74,.25));
    border: 1px solid rgba(16,185,129,.45);
    border-radius: 12px;
    padding: 10px 12px;
}
.next-rank-section .rewards-preview h4 {
    margin: 0 0 10px 0; 
    color: var(--text-primary);
}
.next-rank-section .rewards-list {
    display: flex; flex-wrap: wrap; gap: 10px;
}
.next-rank-section .rewards-list .reward-item {
    background: rgba(16,185,129,.2);
    border: 1px solid rgba(16,185,129,.35);
    color: #b7ffe0;
    padding: 6px 10px; border-radius: 10px; font-weight: 700; font-size: .85rem;
}

@media (max-width: 768px) {
    .next-rank-section .requirement-card { grid-template-columns: 36px 1fr; }
    .next-rank-section .requirement-card > .progress-info { grid-column: 1 / -1; justify-self: start; }
}
</style>
<script>
// Progress ring calculation
const progressCircumference = 2 * Math.PI * 35; // radius = 35
const progressOffset = progressCircumference - ({{ $progressPercentage }} / 100) * progressCircumference;

document.addEventListener('DOMContentLoaded', function() {
    const circle = document.querySelector('.progress-ring-circle');
    if (circle) {
        circle.style.strokeDasharray = progressCircumference;
        circle.style.strokeDashoffset = progressOffset;
    }

    // Tabs
    const tabButtons = document.querySelectorAll('.tab-btn');
    const sections = document.querySelectorAll('.tab-section');
    tabButtons.forEach(btn => {
        btn.addEventListener('click', () => {
            tabButtons.forEach(b => b.classList.remove('active'));
            btn.classList.add('active');
            const target = btn.getAttribute('data-target');
            sections.forEach(sec => {
                if ('#' + sec.id === target) {
                    sec.style.display = '';
                    sec.classList.add('active');
                } else {
                    sec.style.display = 'none';
                    sec.classList.remove('active');
                }
            });
            // Scroll to top of content area for app-like feel
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });
    });
});

// Collect reward function
function collectReward(rankId) {
    // Show loading state
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Collecting...';
    button.disabled = true;
    
    // Make AJAX request
    fetch('{{ route("user.achievement.collect") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            rank_id: rankId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Show success modal
            document.getElementById('rewardMessage').textContent = data.message;
            document.getElementById('rewardAmount').textContent = '$' + data.amount;
            document.getElementById('rewardModal').style.display = 'block';
            
            // Update button state
            button.innerHTML = '<i class="fas fa-check"></i> Collected';
            button.disabled = true;
            button.classList.add('collected');
        } else {
            alert(data.message || 'Failed to collect reward');
            button.innerHTML = originalText;
            button.disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while collecting reward');
        button.innerHTML = originalText;
        button.disabled = false;
    });
}

// Collect salary function
function collectSalary(button) {
    const originalText = button.innerHTML;
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Collecting...';
    button.disabled = true;
    
    fetch('{{ route("user.achievement.salary") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('salaryModal').style.display = 'block';
            button.innerHTML = '<i class="fas fa-check"></i> Collected';
            button.disabled = true;
        } else {
            alert(data.message || 'Failed to collect salary');
            button.innerHTML = originalText;
            button.disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while collecting salary');
        button.innerHTML = originalText;
        button.disabled = false;
    });
}

// Close modal function
function closeModal() {
    document.getElementById('rewardModal').style.display = 'none';
    document.getElementById('salaryModal').style.display = 'none';
}

// Refresh achievements
function refreshAchievements() {
    location.reload();
}

// Close modal when clicking outside
window.onclick = function(event) {
    const rewardModal = document.getElementById('rewardModal');
    const salaryModal = document.getElementById('salaryModal');
    
    if (event.target == rewardModal) {
        rewardModal.style.display = 'none';
    }
    if (event.target == salaryModal) {
        salaryModal.style.display = 'none';
    }
}
</script>

