@extends('frontend::layouts.auth')

@section('title')
    {{ __('Login') }}
@endsection

@section('content')
<div class="auth-container">
    <div class="auth-card">
        <div class="auth-header">
            <div class="auth-logo">
                <a href="{{ route('home') }}">
                    <img src="{{ asset(setting('site_logo','global')) }}" alt="logo">
                </a>
            </div>
            <h2 class="auth-title">{{ $data['title'] ?? 'Welcome Back' }}</h2>
            <p class="auth-subtitle">{{ $data['bottom_text'] ?? 'Sign in to your account' }}</p>
        </div>

        <div class="auth-form">
            @if ($errors->any())
                <div class="alert alert-error">
                    @foreach($errors->all() as $error)
                        <span>{{ $error }}</span>
                    @endforeach
                </div>
            @endif

            <form action="{{ route('login') }}" method="POST" id="loginForm">
                @csrf
                
                <div class="form-group">
                    <label for="login" class="form-label">{{ __('Email Or Username') }}<span class="required">*</span></label>
                    <div class="input-wrapper">
                        <input type="text" id="login" name="login" value="{{ old('login') }}" required autofocus class="form-input">
                        <i class="fas fa-user input-icon"></i>
                    </div>
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">{{ __('Password') }}<span class="required">*</span></label>
                    <div class="input-wrapper">
                        <input type="password" id="password" name="password" required class="form-input">
                        <i class="fas fa-lock input-icon"></i>
                    </div>
                </div>

                @if($googleReCaptcha ?? false)
                    <div class="form-group">
                        <div class="g-recaptcha" id="feedback-recaptcha"
                            data-sitekey="{{ json_decode($googleReCaptcha->data,true)['google_recaptcha_key'] }}">
                        </div>
                    </div>
                @endif

                <div class="form-options">
                    <div class="remember-me">
                        <input id="remember" name="remember" type="checkbox" {{ old('remember') ? 'checked' : '' }} class="checkbox">
                        <label for="remember" class="checkbox-label">{{ __('Remember me') }}</label>
                    </div>
                    @if (Route::has('password.request'))
                        <a href="{{ route('password.request') }}" class="forgot-link">{{ __('Forget Password') }}</a>
                    @endif
                </div>

                <button type="submit" form="loginForm" class="auth-btn">
                    <span>{{ __('Account Login') }}</span>
                    <i class="fas fa-arrow-right"></i>
                </button>
            </form>

            <div class="auth-footer">
                <p class="auth-text">
                    {{ __("Don't have an account?") }}
                    <a href="{{ route('register') }}" class="auth-link">{{ __('Signup for free') }}</a>
                </p>
            </div>
        </div>
    </div>

    <div class="auth-background">
        <div class="bg-shape shape-1"></div>
        <div class="bg-shape shape-2"></div>
        <div class="bg-shape shape-3"></div>
    </div>
</div>

<style>
.auth-container {
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    position: relative;
    overflow: hidden;
}

.auth-card {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 40px;
    width: 100%;
    max-width: 450px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    position: relative;
    z-index: 2;
}

.auth-header {
    text-align: center;
    margin-bottom: 30px;
}

.auth-logo img {
    height: 60px;
    margin-bottom: 20px;
}

.auth-title {
    color: white;
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 10px;
}

.auth-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 16px;
    margin-bottom: 0;
}

.form-group {
    margin-bottom: 20px;
}

.form-label {
    display: block;
    color: white;
    font-weight: 500;
    margin-bottom: 8px;
    font-size: 14px;
}

.required {
    color: #ff6b6b;
    margin-left: 4px;
}

.input-wrapper {
    position: relative;
}

.form-input {
    width: 100%;
    padding: 15px 45px 15px 15px;
    border: 2px solid rgba(255, 255, 255, 0.2);
    border-radius: 12px;
    background: rgba(255, 255, 255, 0.1);
    color: white;
    font-size: 16px;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
}

.form-input:focus {
    outline: none;
    border-color: rgba(255, 255, 255, 0.5);
    background: rgba(255, 255, 255, 0.15);
    box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.1);
}

.form-input::placeholder {
    color: rgba(255, 255, 255, 0.6);
}

.input-icon {
    position: absolute;
    right: 15px;
    top: 50%;
    transform: translateY(-50%);
    color: rgba(255, 255, 255, 0.6);
    font-size: 16px;
}

.form-options {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 25px;
}

.remember-me {
    display: flex;
    align-items: center;
}

.checkbox {
    margin-right: 8px;
    accent-color: #667eea;
}

.checkbox-label {
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
    cursor: pointer;
}

.forgot-link {
    color: white;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    transition: color 0.3s ease;
}

.forgot-link:hover {
    color: rgba(255, 255, 255, 0.8);
}

.auth-btn {
    width: 100%;
    padding: 15px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 12px;
    color: white;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    margin-bottom: 25px;
}

.auth-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
}

.auth-footer {
    text-align: center;
}

.auth-text {
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
    margin: 0;
}

.auth-link {
    color: white;
    text-decoration: none;
    font-weight: 600;
    transition: color 0.3s ease;
}

.auth-link:hover {
    color: rgba(255, 255, 255, 0.8);
}

.alert-error {
    background: rgba(255, 107, 107, 0.2);
    border: 1px solid rgba(255, 107, 107, 0.3);
    border-radius: 12px;
    padding: 15px;
    margin-bottom: 20px;
    color: white;
    font-size: 14px;
}

.auth-background {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    z-index: 1;
}

.bg-shape {
    position: absolute;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
    animation: float 6s ease-in-out infinite;
}

.shape-1 {
    width: 200px;
    height: 200px;
    top: 10%;
    left: 10%;
    animation-delay: 0s;
}

.shape-2 {
    width: 150px;
    height: 150px;
    top: 60%;
    right: 10%;
    animation-delay: 2s;
}

.shape-3 {
    width: 100px;
    height: 100px;
    bottom: 20%;
    left: 20%;
    animation-delay: 4s;
}

@keyframes float {
    0%, 100% {
        transform: translateY(0px);
    }
    50% {
        transform: translateY(-20px);
    }
}

@media (max-width: 768px) {
    .auth-card {
        padding: 30px 20px;
        margin: 10px;
    }
    
    .auth-title {
        font-size: 24px;
    }
    
    .form-input {
        padding: 12px 40px 12px 12px;
    }
}
</style>
@endsection

@section('script')
    @if($googleReCaptcha ?? false)
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    @endif
@endsection
