@extends('frontend::layouts.user')

@section('content')
<div class="page-container">
    <div class="page-header">
        <button class="back-btn" onclick="window.history.back()">
            <i class="fas fa-arrow-left"></i>
        </button>
        <h2>Deposit Funds</h2>
    </div>
    <div class="deposit-container">
        <div class="amount-input glass-effect">
            <label>Amount to Deposit</label>
            <div class="input-wrapper">
                <span class="currency">$</span>
                <input type="number" placeholder="0.00" id="deposit-amount" step="0.01" min="1">
            </div>
        </div>
        
        <div class="payment-methods">
            <h3>Select Payment Method</h3>
            <div class="method-list">
                <div class="payment-method glass-effect active" data-method="bank">
                    <i class="fas fa-university"></i>
                    <span>Bank Transfer</span>
                    <i class="fas fa-check"></i>
                </div>
                <div class="payment-method glass-effect" data-method="crypto">
                    <i class="fab fa-bitcoin"></i>
                    <span>Cryptocurrency</span>
                </div>
                <div class="payment-method glass-effect" data-method="card">
                    <i class="fas fa-credit-card"></i>
                    <span>Credit Card</span>
                </div>
            </div>
        </div>
        
        <button class="btn-primary deposit-btn" onclick="proceedToProofSubmission()">Deposit Now</button>
    </div>
</div>

<style>
.page-container {
    padding: 20px;
    max-width: 500px;
    margin: 0 auto;
}

.page-header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
}

.back-btn {
    background: none;
    border: none;
    color: #fff;
    font-size: 18px;
    margin-right: 15px;
    cursor: pointer;
    padding: 8px;
    border-radius: 8px;
    transition: background 0.3s ease;
}

.back-btn:hover {
    background: rgba(255, 255, 255, 0.1);
}

.page-header h2 {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.deposit-container {
    display: flex;
    flex-direction: column;
    gap: 30px;
}

.amount-input {
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.amount-input label {
    display: block;
    margin-bottom: 10px;
    font-weight: 600;
    color: #fff;
}

.input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.currency {
    position: absolute;
    left: 15px;
    font-size: 18px;
    font-weight: 600;
    color: #00d4ff;
    z-index: 2;
}

.input-wrapper input {
    width: 100%;
    padding: 15px 15px 15px 40px;
    border: 2px solid rgba(255, 255, 255, 0.2);
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    outline: none;
    transition: all 0.3s ease;
}

.input-wrapper input:focus {
    border-color: #00d4ff;
    box-shadow: 0 0 20px rgba(0, 212, 255, 0.3);
}

.input-wrapper input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.payment-methods h3 {
    margin-bottom: 15px;
    color: #fff;
    font-weight: 600;
}

.method-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.payment-method {
    display: flex;
    align-items: center;
    padding: 15px 20px;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 2px solid rgba(255, 255, 255, 0.2);
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
}

.payment-method:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateY(-2px);
}

.payment-method.active {
    border-color: #00d4ff;
    background: rgba(0, 212, 255, 0.1);
}

.payment-method i:first-child {
    font-size: 20px;
    margin-right: 15px;
    color: #00d4ff;
}

.payment-method span {
    flex: 1;
    color: #fff;
    font-weight: 500;
}

.payment-method i:last-child {
    color: #00d4ff;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.payment-method.active i:last-child {
    opacity: 1;
}

.deposit-btn {
    width: 100%;
    padding: 15px;
    border: none;
    border-radius: 10px;
    background: linear-gradient(135deg, #00d4ff, #0099cc);
    color: #fff;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.deposit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 212, 255, 0.4);
}

.deposit-btn:active {
    transform: translateY(0);
}

@media (max-width: 768px) {
    .page-container {
        padding: 15px;
    }
    
    .amount-input, .payment-method {
        padding: 15px;
    }
    
    .input-wrapper input {
        font-size: 16px;
        padding: 12px 12px 12px 35px;
    }
    
    .currency {
        left: 12px;
        font-size: 16px;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Payment method selection
    const paymentMethods = document.querySelectorAll('.payment-method');
    paymentMethods.forEach(method => {
        method.addEventListener('click', function() {
            paymentMethods.forEach(m => m.classList.remove('active'));
            this.classList.add('active');
        });
    });
    
    // Amount input formatting
    const amountInput = document.getElementById('deposit-amount');
    amountInput.addEventListener('input', function() {
        let value = this.value;
        if (value < 0) {
            this.value = 0;
        }
    });
});

function proceedToProofSubmission() {
    const amount = document.getElementById('deposit-amount').value;
    const selectedMethod = document.querySelector('.payment-method.active').dataset.method;
    
    if (!amount || amount <= 0) {
        alert('Please enter a valid amount');
        return;
    }
    
    // Store deposit data in sessionStorage
    sessionStorage.setItem('depositAmount', amount);
    sessionStorage.setItem('depositMethod', selectedMethod);
    
    // Redirect to proof submission page
    window.location.href = '{{ route("user.deposit.proof") }}';
}
</script>
@endsection
