@extends('frontend.shahdeveloper.layouts.user')

@section('content')
<div class="success-page-container">
    <div class="success-header">
        <button class="back-btn" onclick="window.location.href='{{ route('user.dashboard') }}'">
            <i class="fas fa-arrow-left"></i>
        </button>
        <h2>Deposit Status</h2>
    </div>

    <div class="success-content">
        <!-- Success Card -->
        <div class="success-card glass-effect">
            <div class="success-icon">
                <i class="fas fa-check"></i>
            </div>
            <div class="success-details">
                <h3>Deposit Submitted For Approval</h3>
                <p class="success-message">
                    @if(session('success'))
                        {{ session('success') }}
                    @else
                        We have received your payment proof. Your request is now pending review by the admin team.
                    @endif
                </p>
                <ul class="success-list">
                    <li>You will be notified once it is approved.</li>
                    <li>You can track the status from Deposit Logs.</li>
                </ul>
                <div class="success-actions">
                    <a href="{{ route('user.dashboard') }}" class="btn-primary">
                        <i class="fas fa-home"></i>
                        <span>Go to Dashboard</span>
                    </a>
                    <a href="{{ route('user.deposit.log') }}" class="btn-secondary">
                        <i class="fas fa-list"></i>
                        <span>View Deposit Logs</span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Info Card -->
        <div class="info-card glass-effect">
            <div class="info-header">
                <i class="fas fa-info-circle"></i>
                <h4>What happens next?</h4>
            </div>
            <p>Our team will verify your proof. Once approved, the amount will reflect in your balance.</p>
        </div>
    </div>
</div>

<style>
/* Success Page Container */
.success-page-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #0a0a0a 0%, #1a1a2e 50%, #16213e 100%);
    padding: 20px;
}

.success-header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
    padding: 20px 0;
}

.back-btn {
    background: rgba(0, 255, 136, 0.1);
    border: 1px solid #00ff88;
    color: #00ff88;
    padding: 12px;
    border-radius: 10px;
    margin-right: 15px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.back-btn:hover {
    background: rgba(0, 255, 136, 0.2);
    transform: translateY(-2px);
}

.success-header h2 {
    color: #fff;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 2px 10px rgba(0, 255, 136, 0.3);
}

.success-content {
    max-width: 800px;
    margin: 0 auto;
    display: grid;
    gap: 25px;
}

/* Success Card */
.success-card {
    padding: 30px;
    border-radius: 20px;
    background: linear-gradient(135deg, rgba(0, 255, 136, 0.1) 0%, rgba(0, 212, 255, 0.1) 100%);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(0, 255, 136, 0.3);
    box-shadow: 0 8px 32px rgba(0, 255, 136, 0.1);
    display: flex;
    gap: 25px;
    align-items: flex-start;
}

.success-icon {
    flex: 0 0 auto;
    width: 70px;
    height: 70px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, rgba(0, 255, 136, 0.2) 0%, rgba(0, 212, 255, 0.2) 100%);
    border: 2px solid #00ff88;
    box-shadow: 0 4px 20px rgba(0, 255, 136, 0.3);
}

.success-icon i {
    color: #00ff88;
    font-size: 32px;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}

.success-details {
    flex: 1 1 auto;
}

.success-details h3 {
    margin: 0 0 15px 0;
    color: #fff;
    font-weight: 700;
    font-size: 24px;
    text-shadow: 0 2px 10px rgba(0, 255, 136, 0.3);
}

.success-message {
    margin: 0 0 20px 0;
    color: rgba(255, 255, 255, 0.9);
    line-height: 1.6;
    font-size: 16px;
}

.success-list {
    margin: 0 0 25px 0;
    padding-left: 20px;
    color: rgba(255, 255, 255, 0.8);
}

.success-list li {
    margin-bottom: 8px;
    line-height: 1.5;
}

.success-actions {
    display: flex;
    gap: 15px;
    flex-wrap: wrap;
}

.btn-primary, .btn-secondary {
    padding: 15px 25px;
    border: none;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 8px;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-primary {
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    color: #000;
    box-shadow: 0 4px 15px rgba(0, 255, 136, 0.3);
}

.btn-primary:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0, 255, 136, 0.4);
    background: linear-gradient(135deg, #00cc6a, #00ff88);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
}

/* Info Card */
.info-card {
    padding: 25px;
    border-radius: 20px;
    background: linear-gradient(135deg, rgba(0, 212, 255, 0.1) 0%, rgba(0, 255, 136, 0.1) 100%);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(0, 212, 255, 0.3);
    box-shadow: 0 8px 32px rgba(0, 212, 255, 0.1);
}

.info-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 15px;
}

.info-header i {
    color: #00d4ff;
    font-size: 20px;
}

.info-header h4 {
    margin: 0;
    color: #fff;
    font-weight: 600;
    font-size: 18px;
}

.info-card p {
    margin: 0;
    color: rgba(255, 255, 255, 0.9);
    line-height: 1.6;
    font-size: 16px;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .success-page-container {
        padding: 15px;
    }
    
    .success-header h2 {
        font-size: 24px;
    }
    
    .success-card {
        flex-direction: column;
        text-align: center;
        padding: 25px;
    }
    
    .success-icon {
        width: 60px;
        height: 60px;
        margin: 0 auto;
    }
    
    .success-actions {
        justify-content: center;
    }
    
    .btn-primary, .btn-secondary {
        flex: 1;
        justify-content: center;
        min-width: 150px;
    }
}
</style>
@endsection
