<div class="col-xl-12 col-md-12">
    <div class="payment-details glass-effect">
        <h4>Payment Details</h4>
        <div class="payment-info">
            @php
                $paymentData = json_decode($paymentDetails, true);
            @endphp
            
            @if($paymentData)
                @if(isset($paymentData['payment_type']))
                    <div class="payment-type-info">
                        <p><strong>Payment Type:</strong> {{ ucfirst(str_replace('_', ' ', $paymentData['payment_type'])) }}</p>
                    </div>
                @endif
                
                @if(isset($paymentData['payment_type']) && $paymentData['payment_type'] === 'easypaisa')
                    <div class="easypaisa-info">
                        <p><strong>EasyPaisa Account:</strong> {{ $paymentData['easypaisa_account'] ?? 'Not provided' }}</p>
                        @if(isset($paymentData['account_holder_name']))
                            <p><strong>Account Holder:</strong> {{ $paymentData['account_holder_name'] }}</p>
                        @endif
                    </div>
                @elseif(isset($paymentData['payment_type']) && $paymentData['payment_type'] === 'jazzcash')
                    <div class="jazzcash-info">
                        <p><strong>JazzCash Account:</strong> {{ $paymentData['jazzcash_account'] ?? 'Not provided' }}</p>
                        @if(isset($paymentData['account_holder_name']))
                            <p><strong>Account Holder:</strong> {{ $paymentData['account_holder_name'] }}</p>
                        @endif
                    </div>
                @elseif(isset($paymentData['payment_type']) && $paymentData['payment_type'] === 'bank_transfer')
                    <div class="bank-info">
                        <p><strong>Account Number:</strong> {{ $paymentData['account_number'] ?? 'Not provided' }}</p>
                        @php
                            $accountHolder = $paymentData['account_holder_name'] ?? $paymentData['account_name'] ?? $paymentData['holder_name'] ?? null;
                        @endphp
                        @if($accountHolder)
                            <p><strong>Account Holder:</strong> {{ $accountHolder }}</p>
                        @endif
                        @if(isset($paymentData['bank_name']))
                            <p><strong>Bank Name:</strong> {{ $paymentData['bank_name'] }}</p>
                        @endif
                        @if(isset($paymentData['branch_code']))
                            <p><strong>Branch Code:</strong> {{ $paymentData['branch_code'] }}</p>
                        @endif
                    </div>
                @elseif(isset($paymentData['payment_type']) && $paymentData['payment_type'] === 'crypto')
                    <div class="crypto-info">
                        @if(isset($paymentData['wallet_address']))
                            <div class="wallet-info">
                                <p><strong>Wallet Address:</strong></p>
                                <div class="wallet-address">
                                    <code>{{ $paymentData['wallet_address'] }}</code>
                                    <button type="button" class="copy-btn" onclick="copyToClipboard('{{ $paymentData['wallet_address'] }}')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        @endif
                        
                        @if(isset($paymentData['crypto_type']))
                            <p><strong>Cryptocurrency:</strong> {{ ucfirst($paymentData['crypto_type']) }}</p>
                        @endif
                        
                        @if(isset($paymentData['network']))
                            <p><strong>Network:</strong> {{ strtoupper($paymentData['network']) }}</p>
                        @endif
                        
                        @if(isset($paymentData['qr_code']))
                            <div class="qr-code-section">
                                <p><strong>QR Code:</strong></p>
                                <div class="qr-code">
                                    <img src="{{ $paymentData['qr_code'] }}" alt="Payment QR Code" style="max-width: 200px; height: auto;">
                                </div>
                            </div>
                        @endif
                    </div>
                @else
                    <!-- Fallback for old format -->
                    @if(isset($paymentData['wallet_address']))
                        <div class="wallet-info">
                            <p><strong>Wallet Address:</strong></p>
                            <div class="wallet-address">
                                <code>{{ $paymentData['wallet_address'] }}</code>
                                <button type="button" class="copy-btn" onclick="copyToClipboard('{{ $paymentData['wallet_address'] }}')">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </div>
                    @endif
                    
                    @if(isset($paymentData['qr_code']))
                        <div class="qr-code-section">
                            <p><strong>QR Code:</strong></p>
                            <div class="qr-code">
                                <img src="{{ $paymentData['qr_code'] }}" alt="Payment QR Code" style="max-width: 200px; height: auto;">
                            </div>
                        </div>
                    @endif
                    
                    @if(isset($paymentData['account_number']))
                        <div class="bank-info">
                            <p><strong>Account Number:</strong> {{ $paymentData['account_number'] }}</p>
                            @php
                                $accountHolder = $paymentData['account_holder_name'] ?? $paymentData['account_name'] ?? $paymentData['holder_name'] ?? null;
                            @endphp
                            @if($accountHolder)
                                <p><strong>Account Holder:</strong> {{ $accountHolder }}</p>
                            @endif
                            @if(isset($paymentData['bank_name']))
                                <p><strong>Bank Name:</strong> {{ $paymentData['bank_name'] }}</p>
                            @endif
                        </div>
                    @endif

                    {{-- Editable raw details fallback for any extra keys provided by admin --}}
                    @php
                        $ignoreKeys = ['qr_code'];
                        $renderedKeys = [
                            'payment_type','easypaisa_account','account_holder_name','account_name','holder_name','jazzcash_account','account_number','bank_name','branch_code','wallet_address','crypto_type','network','payment_instructions'
                        ];
                        $extra = array_diff_key($paymentData, array_flip($renderedKeys));
                    @endphp
                    @if(!empty($extra))
                        <div class="payment-info" style="margin-top: 10px;">
                            <p><strong>Additional Details (editable):</strong></p>
                            @foreach($extra as $k => $v)
                                @if(!in_array($k, $ignoreKeys))
                                <div class="form-group glass-effect">
                                    <label class="form-label">{{ ucwords(str_replace(['_','-'],' ', $k)) }}</label>
                                    <input type="text" class="form-control" value="{{ is_array($v) ? json_encode($v) : $v }}" />
                                </div>
                                @endif
                            @endforeach
                        </div>
                    @endif
                @endif
                
                @if(isset($paymentData['payment_instructions']) && !empty($paymentData['payment_instructions']))
                    <div class="instructions">
                        <p><strong>Instructions:</strong></p>
                        <p>{{ $paymentData['payment_instructions'] }}</p>
                    </div>
                @endif
            @else
                <p>No payment details available.</p>
            @endif
        </div>
    </div>
</div>

@foreach( json_decode($fieldOptions, true) as $key => $field)
    @if($field['type'] == 'textarea')
        <div class="col-xl-12 col-md-12">
            <div class="form-group glass-effect">
                <label class="form-label">{{ $field['name'] }}</label>
                <textarea 
                    class="form-control" 
                    @if($field['validation'] == 'required') required @endif 
                    placeholder="Enter {{ $field['name'] }}..." 
                    name="manual_data[{{$field['name']}}]"
                    rows="4"
                ></textarea>
            </div>
        </div>
    @elseif($field['type'] != 'file')
        <div class="col-xl-12 col-md-12">
            <div class="form-group glass-effect">
                <label class="form-label">{{ $field['name'] }}</label>
                <input 
                    type="text" 
                    name="manual_data[{{$field['name']}}]"
                    @if($field['validation'] == 'required') required @endif 
                    class="form-control"
                    placeholder="Enter {{ $field['name'] }}..."
                />
            </div>
        </div>
    @endif
@endforeach

<style>
.payment-details {
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    margin-bottom: 20px;
}

.payment-details h4 {
    color: #fff;
    margin-bottom: 15px;
    font-weight: 600;
}

.payment-info {
    color: #fff;
    line-height: 1.6;
}

.payment-info p {
    margin-bottom: 10px;
}

.payment-info strong {
    color: #00d4ff;
}

.wallet-info, .qr-code-section, .instructions, .bank-info, .payment-type-info, .easypaisa-info, .jazzcash-info, .crypto-info {
    margin-bottom: 20px;
    padding: 15px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 10px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.payment-type-info {
    background: rgba(0, 212, 255, 0.1);
    border-color: rgba(0, 212, 255, 0.3);
}

.easypaisa-info {
    background: rgba(0, 150, 0, 0.1);
    border-color: rgba(0, 150, 0, 0.3);
}

.jazzcash-info {
    background: rgba(255, 165, 0, 0.1);
    border-color: rgba(255, 165, 0, 0.3);
}

.crypto-info {
    background: rgba(255, 0, 150, 0.1);
    border-color: rgba(255, 0, 150, 0.3);
}

.wallet-address {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-top: 10px;
}

.wallet-address code {
    background: rgba(0, 0, 0, 0.3);
    padding: 10px;
    border-radius: 5px;
    font-family: 'Courier New', monospace;
    font-size: 14px;
    flex: 1;
    word-break: break-all;
}

.copy-btn {
    background: #00d4ff;
    border: none;
    color: white;
    padding: 10px;
    border-radius: 5px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.copy-btn:hover {
    background: #0099cc;
    transform: scale(1.05);
}

.qr-code {
    text-align: center;
    margin-top: 10px;
}

.qr-code img {
    border-radius: 10px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
}


.form-group {
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    margin-bottom: 20px;
}

.form-label {
    display: block;
    color: #fff;
    font-weight: 600;
    margin-bottom: 10px;
}

.form-control {
    width: 100%;
    padding: 15px;
    border: 2px solid rgba(255, 255, 255, 0.2);
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 16px;
    outline: none;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #00d4ff;
    box-shadow: 0 0 20px rgba(0, 212, 255, 0.3);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-control-textarea {
    width: 100%;
    padding: 15px;
    border: 2px solid rgba(255, 255, 255, 0.2);
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 16px;
    outline: none;
    transition: all 0.3s ease;
    resize: vertical;
    min-height: 100px;
}

.form-control-textarea:focus {
    border-color: #00d4ff;
    box-shadow: 0 0 20px rgba(0, 212, 255, 0.3);
}

.form-control-textarea::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

@media (max-width: 768px) {
    .payment-details,
    .form-group {
        padding: 15px;
    }
    
    .wallet-address {
        flex-direction: column;
        align-items: stretch;
    }
    
    .copy-btn {
        margin-top: 10px;
    }
}
</style>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        // Show success message
        const btn = event.target.closest('.copy-btn');
        const originalHTML = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i>';
        btn.style.background = '#28a745';
        
        setTimeout(() => {
            btn.innerHTML = originalHTML;
            btn.style.background = '#00d4ff';
        }, 2000);
    }).catch(function(err) {
        console.error('Could not copy text: ', err);
        alert('Failed to copy to clipboard');
    });
}
</script>

