@extends('frontend::layouts.app')
@section('title')
{{ setting('site_title', 'global') }}
@endsection
@section('content')

<!-- InvestFlow Home Page -->
<div class="home-page">
    <!-- Hero Section -->
    <div class="hero-section">
        <div class="hero-content">
            <div class="hero-text">
                <h1 class="hero-title">
                    Welcome to <span class="gradient-text">{{ setting('site_name', 'ShahBlock') }}</span>
                </h1>
                <p class="hero-subtitle">
                    Your gateway to smart investing and financial growth. Start your investment journey today with our secure and reliable platform.
                </p>
                <div class="hero-buttons">
                    @auth('web')
                        <a href="{{ route('user.dashboard') }}" class="btn-primary">
                            <i class="fas fa-tachometer-alt"></i>
                            <span>Go to Dashboard</span>
                        </a>
                    @else
                        <a href="{{ route('register') }}" class="btn-primary">
                            <i class="fas fa-user-plus"></i>
                            <span>Get Started</span>
                        </a>
                        <a href="{{ route('login') }}" class="btn-secondary">
                            <i class="fas fa-sign-in-alt"></i>
                            <span>Sign In</span>
                        </a>
                    @endauth
                </div>
            </div>
            <div class="hero-image">
                <div class="hero-card glass-effect">
                    <div class="card-header">
                        <div class="card-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div class="card-title">
                            <h3>Investment Portfolio</h3>
                            <p>Real-time Performance</p>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="balance-display">
                            <span class="balance-label">Total Balance</span>
                            <span class="balance-amount">$24,580.50</span>
                        </div>
                        <div class="balance-change positive">
                            <i class="fas fa-arrow-up"></i>
                            <span>+2.5% this week</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Features Section -->
    <div class="features-section">
        <div class="container">
            <div class="section-header">
                <h2>Why Choose {{ setting('site_name', 'ShahBlock') }}?</h2>
                <p>Experience the future of investing with our cutting-edge platform</p>
            </div>
            <div class="features-grid">
                <div class="feature-card glass-effect">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>Secure & Safe</h3>
                    <p>Bank-level security with advanced encryption to protect your investments and personal data.</p>
                </div>
                <div class="feature-card glass-effect">
                    <div class="feature-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>High Returns</h3>
                    <p>Get competitive returns on your investments with our proven investment strategies.</p>
                </div>
                <div class="feature-card glass-effect">
                    <div class="feature-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3>Mobile First</h3>
                    <p>Access your investments anywhere, anytime with our mobile-optimized platform.</p>
                </div>
                <div class="feature-card glass-effect">
                    <div class="feature-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h3>24/7 Support</h3>
                    <p>Round-the-clock customer support to help you with any questions or concerns.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Section -->
    <div class="stats-section">
        <div class="container">
            <div class="stats-grid">
                <div class="stat-item glass-effect">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-content">
                        <h3>10,000+</h3>
                        <p>Active Investors</p>
                    </div>
                </div>
                <div class="stat-item glass-effect">
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="stat-content">
                        <h3>$50M+</h3>
                        <p>Total Investments</p>
                    </div>
                </div>
                <div class="stat-item glass-effect">
                    <div class="stat-icon">
                        <i class="fas fa-percentage"></i>
                    </div>
                    <div class="stat-content">
                        <h3>15%+</h3>
                        <p>Average Returns</p>
                    </div>
                </div>
                <div class="stat-item glass-effect">
                    <div class="stat-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stat-content">
                        <h3>24/7</h3>
                        <p>Platform Uptime</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="cta-section">
        <div class="container">
            <div class="cta-content glass-effect">
                <h2>Ready to Start Investing?</h2>
                <p>Join thousands of investors who trust {{ setting('site_name', 'ShahBlock') }} for their financial growth.</p>
                @auth('web')
                    <a href="{{ route('user.dashboard') }}" class="btn-primary">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>Go to Dashboard</span>
                    </a>
                @else
                    <a href="{{ route('register') }}" class="btn-primary">
                        <i class="fas fa-rocket"></i>
                        <span>Start Investing Now</span>
                    </a>
                @endauth
            </div>
        </div>
    </div>
</div>

<!-- Home Page Styles -->
<style>
.home-page {
    min-height: 100vh;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

/* Hero Section */
.hero-section {
    padding: 4rem 0;
    min-height: 80vh;
    display: flex;
    align-items: center;
}

.hero-content {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 4rem;
    align-items: center;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

.hero-text {
    color: var(--text-primary);
}

.hero-title {
    font-size: 3.5rem;
    font-weight: 800;
    line-height: 1.2;
    margin-bottom: 1.5rem;
}

.gradient-text {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.hero-subtitle {
    font-size: 1.2rem;
    color: var(--text-secondary);
    margin-bottom: 2rem;
    line-height: 1.6;
}

.hero-buttons {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.btn-primary, .btn-secondary {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem 2rem;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: var(--transition);
    border: none;
    cursor: pointer;
}

.btn-primary {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: white;
    text-decoration: none;
}

.btn-secondary {
    background: var(--surface-light);
    color: var(--text-primary);
    border: 1px solid var(--border);
    backdrop-filter: blur(16px);
}

.btn-secondary:hover {
    background: var(--surface-lighter);
    transform: translateY(-2px);
    color: var(--text-primary);
    text-decoration: none;
}

/* Hero Image */
.hero-image {
    display: flex;
    justify-content: center;
    align-items: center;
}

.hero-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 2rem;
    border: 1px solid rgba(255, 255, 255, 0.1);
    max-width: 300px;
    width: 100%;
}

.card-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.card-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
}

.card-title h3 {
    font-size: 1.2rem;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 0.25rem;
}

.card-title p {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin: 0;
}

.balance-display {
    text-align: center;
    margin-bottom: 1rem;
}

.balance-label {
    display: block;
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin-bottom: 0.5rem;
}

.balance-amount {
    font-size: 2rem;
    font-weight: 700;
    color: var(--text-primary);
}

.balance-change {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    font-size: 0.9rem;
    font-weight: 500;
}

.balance-change.positive {
    color: var(--success);
}

/* Features Section */
.features-section {
    padding: 4rem 0;
}

.section-header {
    text-align: center;
    margin-bottom: 3rem;
}

.section-header h2 {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 1rem;
}

.section-header p {
    font-size: 1.1rem;
    color: var(--text-secondary);
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
}

.feature-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 2rem;
    border: 1px solid rgba(255, 255, 255, 0.1);
    text-align: center;
    transition: var(--transition);
}

.feature-card:hover {
    transform: translateY(-5px);
    background: rgba(255, 255, 255, 0.08);
}

.feature-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    color: white;
    font-size: 1.5rem;
}

.feature-card h3 {
    font-size: 1.3rem;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 1rem;
}

.feature-card p {
    color: var(--text-secondary);
    line-height: 1.6;
}

/* Stats Section */
.stats-section {
    padding: 4rem 0;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 2rem;
}

.stat-item {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 2rem;
    border: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    gap: 1.5rem;
    transition: var(--transition);
}

.stat-item:hover {
    transform: translateY(-3px);
    background: rgba(255, 255, 255, 0.08);
}

.stat-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.stat-content h3 {
    font-size: 2rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 0.25rem;
}

.stat-content p {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

/* CTA Section */
.cta-section {
    padding: 4rem 0;
}

.cta-content {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 3rem;
    border: 1px solid rgba(255, 255, 255, 0.1);
    text-align: center;
}

.cta-content h2 {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 1rem;
}

.cta-content p {
    font-size: 1.1rem;
    color: var(--text-secondary);
    margin-bottom: 2rem;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .hero-content {
        grid-template-columns: 1fr;
        gap: 2rem;
        text-align: center;
    }
    
    .hero-title {
        font-size: 2.5rem;
    }
    
    .hero-buttons {
        justify-content: center;
    }
    
    .features-grid {
        grid-template-columns: 1fr;
    }
    
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .stat-item {
        flex-direction: column;
        text-align: center;
    }
}

@media (max-width: 480px) {
    .container {
        padding: 0 1rem;
    }
    
    .hero-title {
        font-size: 2rem;
    }
    
    .hero-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .btn-primary, .btn-secondary {
        width: 100%;
        max-width: 300px;
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
}
</style>

@endsection

