<!-- Shah Developer Theme - InvestFlow Styles -->
<style>
/* InvestFlow CSS Variables */
:root {
    /* Dark Blue/Purple Theme */
    --primary-color: #1e40af;         /* darker blue */
    --primary-dark: #1e3a8a;          /* very dark blue */
    --secondary-color: #6b46c1;       /* darker purple */
    --accent-color: #0891b2;          /* darker cyan */
    --background-primary: #0a0f1a;    /* very dark navy */
    --background-secondary: #111827;  /* dark slate */
    --surface: #1f2937;               /* darker card base */
    --surface-light: rgba(30, 64, 175, 0.05);
    --surface-lighter: rgba(107, 70, 193, 0.08);
    --text-primary: #f9fafb;
    --text-secondary: #d1d5db;
    --text-muted: #9ca3af;
    --success: #059669;               /* darker emerald */
    --error: #dc2626;
    --warning: #d97706;
    --border: rgba(30, 64, 175, 0.15);
    --shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    --shadow-lg: 0 25px 60px rgba(0, 0, 0, 0.4);
    --glow: 0 0 15px rgba(30, 64, 175, 0.2);
    --border-radius: 16px;
    --border-radius-sm: 12px;
    --border-radius-lg: 24px;
    --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    --transition-fast: all 0.15s ease-out;
}

/* Global Styles */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

/* Page transition animations removed - only loading animation needed */

/* Loading Animation Styles */
#page-loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(10, 15, 18, 0.95);
    backdrop-filter: blur(10px);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    opacity: 0;
    transition: opacity 0.3s ease;
}

#page-loading-overlay.loading-show {
    display: flex;
    opacity: 1;
    animation: loadingFadeIn 0.3s ease;
}

#page-loading-overlay.loading-hide {
    opacity: 0;
    animation: loadingFadeOut 0.3s ease;
}

.loading-content {
    text-align: center;
    color: var(--text-primary);
}

.loading-spinner {
    width: 50px;
    height: 50px;
    border: 3px solid rgba(245, 158, 11, 0.35);
    border-top: 3px solid var(--primary-color);
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 20px;
}

.loading-text {
    font-size: 16px;
    font-weight: 500;
    color: var(--text-primary);
    animation: loadingPulse 1.5s ease-in-out infinite;
}

/* Progress Bar Loading */
.loading-progress {
    width: 200px;
    height: 4px;
    background: rgba(245, 158, 11, 0.28);
    border-radius: 2px;
    margin: 20px auto 0;
    overflow: hidden;
}

.loading-progress-bar {
    height: 100%;
    background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
    border-radius: 2px;
    animation: loadingProgress 2s ease-in-out infinite;
}

@keyframes loadingFadeIn {
    0% { opacity: 0; }
    100% { opacity: 1; }
}

@keyframes loadingFadeOut {
    0% { opacity: 1; }
    100% { opacity: 0; }
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes loadingPulse {
    0%, 100% { opacity: 0.6; }
    50% { opacity: 1; }
}

@keyframes loadingProgress {
    0% { width: 0%; }
    50% { width: 70%; }
    100% { width: 100%; }
}

/* Additional Loading Styles */
.loading-dots {
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 20px 0;
}

.loading-dots span {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: var(--primary-color);
    margin: 0 4px;
    animation: loadingDots 1.4s ease-in-out infinite both;
}

.loading-dots span:nth-child(1) { animation-delay: -0.32s; }
.loading-dots span:nth-child(2) { animation-delay: -0.16s; }
.loading-dots span:nth-child(3) { animation-delay: 0s; }

@keyframes loadingDots {
    0%, 80%, 100% {
        transform: scale(0);
        opacity: 0.5;
    }
    40% {
        transform: scale(1);
        opacity: 1;
    }
}

.loading-pulse {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: var(--primary-color);
    margin: 20px auto;
    animation: loadingPulseScale 1.5s ease-in-out infinite;
}

@keyframes loadingPulseScale {
    0% {
        transform: scale(0.8);
        opacity: 0.8;
    }
    50% {
        transform: scale(1.2);
        opacity: 0.4;
    }
    100% {
        transform: scale(0.8);
        opacity: 0.8;
    }
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
    background: radial-gradient(1200px 600px at 80% -10%, rgba(30, 64, 175, 0.08), transparent 60%),
                radial-gradient(900px 500px at -10% 10%, rgba(107, 70, 193, 0.06), transparent 55%),
                linear-gradient(135deg, #0a0f1a 0%, #111827 100%);
    color: var(--text-primary);
    min-height: 100vh;
    overflow-x: hidden;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

/* Content Wrapper */
.content-wrapper {
    min-height: 100vh;
    padding-top: 70px;
    padding-bottom: 80px; /* Space for bottom navigation */
}

/* Bottom Navigation Menu */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background:
        radial-gradient(600px 200px at 80% 0%, rgba(59,130,246,0.15), transparent 60%),
        radial-gradient(500px 200px at 10% 0%, rgba(139,92,246,0.15), transparent 55%),
        linear-gradient(135deg, rgba(15,23,42,0.95) 0%, rgba(30,41,59,0.95) 100%);
    backdrop-filter: blur(20px);
    border-top: 1px solid rgba(59,130,246,0.2);
    display: flex;
    justify-content: space-around;
    align-items: center;
    padding: 10px 0;
    z-index: 1000;
    box-shadow: 0 -10px 30px rgba(59,130,246,0.2);
}

.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 8px 12px;
    text-decoration: none;
    color: rgba(255, 255, 255, 0.6);
    transition: var(--transition);
    border-radius: 12px;
    min-width: 60px;
    position: relative;
}

.nav-item:hover {
    color: white;
    text-decoration: none;
    background: rgba(59, 130, 246, 0.15);
    box-shadow: 0 0 15px rgba(59, 130, 246, 0.2);
}

.nav-item.active {
    color: var(--text-primary);
    background: linear-gradient(135deg, rgba(59,130,246,0.25), rgba(139,92,246,0.25));
    box-shadow: 0 0 20px rgba(59,130,246,0.3);
}

.nav-item.active::before {
    content: '';
    position: absolute;
    top: -2px;
    left: 50%;
    transform: translateX(-50%);
    width: 4px;
    height: 4px;
    background: var(--primary-color);
    border-radius: 50%;
}

.nav-item i {
    font-size: 18px;
    margin-bottom: 4px;
}

.nav-item span {
    font-size: 11px;
    font-weight: 500;
    text-align: center;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .content-wrapper {
        padding-bottom: 80px;
    }
    
    .bottom-nav {
        padding: 8px 0;
    }
    
    .nav-item {
        padding: 6px 8px;
        min-width: 50px;
    }
    
    .nav-item i {
        font-size: 16px;
    }
    
    .nav-item span {
        font-size: 10px;
    }
}

@media (max-width: 480px) {
    .content-wrapper {
        padding-bottom: 75px;
    }
    
    .bottom-nav {
        padding: 6px 0;
    }
    
    .nav-item {
        padding: 5px 6px;
        min-width: 45px;
    }
    
    .nav-item i {
        font-size: 14px;
    }
    
    .nav-item span {
        font-size: 9px;
    }
}

/* User Dashboard Layout */
.user-dashboard {
    display: flex;
    min-height: 100vh;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
}

.main-content {
    flex: 1;
    display: flex;
    flex-direction: column;
    margin-left: 0;
    transition: var(--transition);
}

.main-content.sidebar-open {
    margin-left: 350px;
}

/* User Header */
.user-header {
    background:
        radial-gradient(700px 250px at 90% -40%, rgba(59,130,246,0.15), transparent 60%),
        radial-gradient(700px 250px at -20% -40%, rgba(139,92,246,0.12), transparent 60%),
        linear-gradient(135deg, rgba(15,23,42,0.95) 0%, rgba(30,41,59,0.95) 100%);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-bottom: 1px solid rgba(59,130,246,0.2);
    padding: 1rem 2rem;
    position: sticky;
    top: 0;
    z-index: 100;
}

.user-header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    max-width: 1200px;
    margin: 0 auto;
}

.user-header-left {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.page-title h2 {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 0.25rem;
}

.page-title p {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin: 0;
}

.user-header-right {
    display: flex;
    align-items: center;
    gap: 1rem;
}

/* Page Content */
.page-content {
    flex: 1;
    padding: 2rem;
    max-width: 1200px;
    margin: 0 auto;
    width: 100%;
}

/* Glass Effect */
.glass-effect {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(16px);
    -webkit-backdrop-filter: blur(16px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: var(--border-radius);
    box-shadow: var(--shadow);
    transition: var(--transition);
}

.glass-effect:hover {
    background: rgba(255, 255, 255, 0.08);
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
}

/* Header Styles */
.main-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    height: 70px;
    background:
        radial-gradient(700px 250px at 90% -40%, rgba(59,130,246,0.12), transparent 60%),
        radial-gradient(700px 250px at -20% -40%, rgba(139,92,246,0.10), transparent 60%),
        linear-gradient(135deg, rgba(15,23,42,0.95) 0%, rgba(30,41,59,0.95) 100%);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-bottom: 1px solid rgba(59,130,246,0.2);
    z-index: 1000;
    transition: var(--transition);
}

.header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    height: 100%;
    padding: 0 1.5rem;
    max-width: 1200px;
    margin: 0 auto;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.menu-btn {
    width: 44px;
    height: 44px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 12px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
    backdrop-filter: blur(16px);
}

.menu-btn:hover {
    background: var(--surface-lighter);
    transform: scale(1.05);
}

.logo-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.logo-small {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #1e40af, #8b5cf6);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.app-name {
    font-size: 1.5rem;
    font-weight: 700;
    background: linear-gradient(135deg, #1e40af, #8b5cf6);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 1rem;
}


.notification-btn {
    position: relative;
    width: 44px;
    height: 44px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 12px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
    backdrop-filter: blur(16px);
}

.notification-btn:hover {
    background: var(--surface-lighter);
    transform: scale(1.05);
}

.notification-badge {
    position: absolute;
    top: -5px;
    right: -5px;
    background: var(--error);
    color: white;
    border-radius: 50%;
    width: 20px;
    height: 20px;
    font-size: 0.7rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    animation: pulse 2s infinite;
}

.user-avatar {
    width: 44px;
    height: 44px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    cursor: pointer;
    transition: var(--transition);
}

.user-avatar:hover {
    transform: scale(1.05);
}

/* Sidebar Styles */
.sidebar {
    position: fixed;
    top: 0;
    left: -350px;
    width: 350px;
    height: 100vh;
    background:
        radial-gradient(800px 300px at 110% -30%, rgba(0,255,136,0.10), transparent 60%),
        radial-gradient(700px 300px at -30% -30%, rgba(0,212,170,0.08), transparent 60%),
        linear-gradient(135deg, rgba(10,15,13,0.96) 0%, rgba(14,21,18,0.96) 100%);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-right: 1px solid var(--border);
    z-index: 1100;
    transition: var(--transition);
    overflow-y: auto;
}

.sidebar.active {
    left: 0;
}

.sidebar-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1.5rem;
    border-bottom: 1px solid var(--border);
}

.sidebar-logo {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.sidebar-brand h3 {
    font-size: 1.3rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.sidebar-brand p {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

.sidebar-close {
    width: 36px;
    height: 36px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 8px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
}

.sidebar-close:hover {
    background: var(--surface-lighter);
}

.sidebar-content {
    padding: 1.5rem;
}

.user-info {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: var(--surface-light);
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    backdrop-filter: blur(16px);
}

.user-avatar-large {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.user-details h4 {
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.user-details p {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

/* Navigation Styles */
.sidebar-nav {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.nav-section {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.nav-title {
    font-size: 0.8rem;
    font-weight: 600;
    color: var(--text-muted);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 0.5rem;
}

.nav-link {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.75rem 1rem;
    color: var(--text-secondary);
    text-decoration: none;
    border-radius: var(--border-radius-sm);
    transition: var(--transition);
    position: relative;
}

.nav-link:hover {
    background: var(--surface-light);
    color: var(--text-primary);
    text-decoration: none;
}


.nav-link.active {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
}

.nav-link i {
    width: 20px;
    text-align: center;
    font-size: 1.1rem;
}

/* Sidebar Overlay */
.sidebar-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    backdrop-filter: blur(4px);
    z-index: 1050;
    opacity: 0;
    visibility: hidden;
    transition: var(--transition);
}

.sidebar-overlay.active {
    opacity: 1;
    visibility: visible;
}

/* Notification Panel */
.notification-panel {
    position: fixed;
    top: 70px;
    right: -350px;
    width: 350px;
    height: calc(100vh - 70px);
    background:
        radial-gradient(700px 300px at 120% -40%, rgba(0,255,136,0.10), transparent 60%),
        radial-gradient(700px 300px at -20% -40%, rgba(0,212,170,0.08), transparent 60%),
        linear-gradient(135deg, rgba(10,15,13,0.96) 0%, rgba(14,21,18,0.96) 100%);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-left: 1px solid var(--border);
    z-index: 1100;
    transition: var(--transition);
    overflow-y: auto;
}

.notification-panel.active {
    right: 0;
}

.notification-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1.5rem;
    border-bottom: 1px solid var(--border);
}

.notification-header h3 {
    font-size: 1.2rem;
    font-weight: 600;
    color: var(--text-primary);
}

.close-btn {
    width: 32px;
    height: 32px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 8px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
}

.close-btn:hover {
    background: var(--surface-lighter);
}

.notification-list {
    padding: 1rem;
}

.notification-item {
    display: flex;
    gap: 1rem;
    padding: 1rem;
    background: var(--surface-light);
    border-radius: var(--border-radius);
    margin-bottom: 0.5rem;
    transition: var(--transition);
}

.notification-item:hover {
    background: var(--surface-lighter);
}

.notification-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: linear-gradient(135deg, var(--primary-dark), var(--secondary-color));
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

.notification-content h4 {
    font-size: 0.9rem;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 0.25rem;
}

.notification-content p {
    font-size: 0.8rem;
    color: var(--text-secondary);
    margin-bottom: 0.5rem;
}

.notification-time {
    font-size: 0.7rem;
    color: var(--text-muted);
}

/* User Menu */
.user-menu {
    position: fixed;
    top: 80px;
    right: -200px;
    width: 200px;
    background: rgba(26, 26, 46, 0.95);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border: 1px solid var(--border);
    border-radius: var(--border-radius);
    z-index: 1100;
    transition: var(--transition);
    overflow: hidden;
}

.user-menu.active {
    right: 20px;
}

.user-menu-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    color: var(--text-primary);
    cursor: pointer;
    transition: var(--transition);
    border-bottom: 1px solid var(--border);
}

.user-menu-item:last-child {
    border-bottom: none;
}

.user-menu-item:hover {
    background: var(--surface-light);
}

.user-menu-item i {
    width: 20px;
    text-align: center;
    font-size: 1rem;
}

.user-menu-item span {
    font-size: 0.9rem;
    font-weight: 500;
}

/* Animations */
@keyframes pulse {
    0%, 100% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.1);
    }
}

@keyframes slideInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes slideInLeft {
    from {
        opacity: 0;
        transform: translateX(-30px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .main-content {
        margin-left: 0;
    }
    
    .main-content.sidebar-open {
        margin-left: 0;
    }
    
    .sidebar {
        width: 100%;
        left: -100%;
    }
    
    .page-content {
        padding: 1rem;
    }
    
    .user-header {
        padding: 1rem;
    }
    
    .user-header-content {
        padding: 0;
    }
    
    .notification-panel {
        width: 100%;
        right: -100%;
    }
    
    .user-menu {
        right: -100%;
        width: 100%;
    }
    
    .user-menu.active {
        right: 0;
    }
}

@media (max-width: 480px) {
    .page-content {
        padding: 0.5rem;
    }
    
    .user-header {
        padding: 0.5rem;
    }
    
    .page-title h2 {
        font-size: 1.2rem;
    }
    
    .page-title p {
        font-size: 0.8rem;
    }
}

/* ROI Progress Button Styles */
.roi-progress-btn {
    margin: 12px 0;
}

.btn-roi-progress {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 16px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
    text-decoration: none;
    border-radius: var(--border-radius-sm);
    font-size: 0.9rem;
    font-weight: 500;
    transition: var(--transition);
    box-shadow: 0 4px 12px rgba(30, 64, 175, 0.3);
    border: 1px solid rgba(255, 255, 255, 0.1);
    position: relative;
    overflow: hidden;
}

.btn-roi-progress:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(30, 64, 175, 0.4);
    background: linear-gradient(135deg, var(--primary-dark), var(--primary-color));
    color: white;
    text-decoration: none;
}

.btn-roi-progress:active {
    transform: translateY(0);
}

.btn-roi-progress i {
    font-size: 1rem;
    opacity: 0.9;
}

.btn-roi-progress span {
    font-weight: 600;
    letter-spacing: 0.5px;
}

.btn-roi-progress small {
    display: block;
    font-size: 0.75rem;
    opacity: 0.8;
    margin-top: 2px;
    font-weight: 400;
}

/* Mobile responsive */
@media (max-width: 768px) {
    .btn-roi-progress {
        padding: 8px 12px;
        font-size: 0.85rem;
    }
    
    .btn-roi-progress small {
        font-size: 0.7rem;
    }
}

/* Cancellation Policy Text Styles */
.cancellation-text {
    color: white !important;
    font-size: 0.85rem;
    line-height: 1.4;
    margin: 4px 0;
    display: flex;
    align-items: center;
    gap: 8px;
}

.cancellation-text i {
    color: #60a5fa;
    font-size: 0.9rem;
}

.cancellation-text.success {
    color: #10b981 !important;
}

.cancellation-text.success i {
    color: #10b981;
}

.cancellation-info {
    background: rgba(30, 64, 175, 0.1);
    border: 1px solid rgba(30, 64, 175, 0.2);
    border-radius: 8px;
    padding: 12px;
    margin: 8px 0;
}

.cancellation-info.success {
    background: rgba(16, 185, 129, 0.1);
    border: 1px solid rgba(16, 185, 129, 0.2);
}
</style>
