@extends('frontend.shahdeveloper.layouts.user')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush













@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush













@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush













@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush



@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="transfer-page">
                <!-- Header Section -->
                <div class="transfer-header">
                    <h2 class="transfer-title">
                        <i class="fas fa-exchange-alt"></i>
                        Transfer & Exchange
                    </h2>
                    <p class="transfer-subtitle">Send money to other users or exchange between your wallets</p>
                </div>

                <!-- Wallet Balance Cards -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="wallet-card main-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Main Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="wallet-card profit-wallet">
                            <div class="wallet-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="wallet-info">
                                <h4>Profit Wallet</h4>
                                <p class="wallet-balance">${{ number_format($user->profit_balance, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Tabs -->
                <div class="transfer-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="transfer">
                            <i class="fas fa-paper-plane"></i>
                            Send Money
                        </button>
                        <button class="tab-btn" data-tab="exchange">
                            <i class="fas fa-exchange-alt"></i>
                            Wallet Exchange
                        </button>
                        <button class="tab-btn" data-tab="history">
                            <i class="fas fa-history"></i>
                            History
                        </button>
                    </div>

                    <!-- Transfer Tab -->
                    <div class="tab-content active" id="transfer-tab">
                        <div class="transfer-form-container">
                            <form id="transferForm" class="transfer-form">
                                @csrf
                                <div class="form-group">
                                    <label for="receiver_identifier">
                                        <i class="fas fa-user"></i>
                                        Recipient
                                    </label>
                                    <input type="text" 
                                           id="receiver_identifier" 
                                           name="receiver_identifier" 
                                           class="form-control"
                                           placeholder="Enter username or email"
                                           required>
                                    <div class="form-help">Enter the username or email of the recipient</div>
                                </div>

                                <div class="form-group">
                                    <label for="amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="wallet_type">
                                        <i class="fas fa-wallet"></i>
                                        From Wallet
                                    </label>
                                    <select id="wallet_type" name="wallet_type" class="form-control" required>
                                        <option value="">Select Wallet</option>
                                        <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                        <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-transfer">
                                    <i class="fas fa-paper-plane"></i>
                                    Send Money
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Exchange Tab -->
                    <div class="tab-content" id="exchange-tab">
                        <div class="exchange-form-container">
                            <form id="exchangeForm" class="exchange-form">
                                @csrf
                                <div class="exchange-visual">
                                    <div class="wallet-selector">
                                        <label>From Wallet</label>
                                        <select id="from_wallet" name="from_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>

                                    <div class="exchange-arrow">
                                        <i class="fas fa-exchange-alt"></i>
                                    </div>

                                    <div class="wallet-selector">
                                        <label>To Wallet</label>
                                        <select id="to_wallet" name="to_wallet" class="form-control" required>
                                            <option value="">Select Wallet</option>
                                            <option value="main">Main Wallet (${{ number_format($user->balance, 2) }})</option>
                                            <option value="profit">Profit Wallet (${{ number_format($user->profit_balance, 2) }})</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_amount">
                                        <i class="fas fa-dollar-sign"></i>
                                        Amount
                                    </label>
                                    <input type="number" 
                                           id="exchange_amount" 
                                           name="amount" 
                                           class="form-control"
                                           step="0.01"
                                           min="0.01"
                                           placeholder="0.00"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="exchange_password">
                                        <i class="fas fa-lock"></i>
                                        Password
                                    </label>
                                    <input type="password" 
                                           id="exchange_password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter your password"
                                           required>
                                </div>

                                <button type="submit" class="btn-exchange">
                                    <i class="fas fa-exchange-alt"></i>
                                    Exchange Now
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- History Tab -->
                    <div class="tab-content" id="history-tab">
                        <div class="history-container">
                            <div class="history-header">
                                <h4>Transfer History</h4>
                                <button class="btn-refresh" onclick="loadTransferHistory()">
                                    <i class="fas fa-sync-alt"></i>
                                    Refresh
                                </button>
                            </div>
                            <div id="transferHistory" class="history-list">
                                <div class="loading-spinner">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading history...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalTitle">Result</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="resultModalBody">
                <!-- Content will be inserted here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Transfer Page Styles */
.transfer-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.transfer-header {
    text-align: center;
    margin-bottom: 30px;
}

.transfer-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.transfer-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Wallet Cards */
.wallet-card {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.6), rgba(0, 50, 0, 0.2));
    border-radius: 15px;
    padding: 25px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(0, 255, 0, 0.3);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    margin-bottom: 20px;
}

.wallet-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 255, 0, 0.2);
    border-color: rgba(0, 255, 0, 0.5);
}

.wallet-card.main-wallet {
    border-color: rgba(0, 150, 255, 0.3);
}

.wallet-card.profit-wallet {
    border-color: rgba(255, 150, 0, 0.3);
}

.wallet-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 20px;
    font-size: 24px;
}

.main-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(0, 150, 255, 0.3), rgba(0, 150, 255, 0.1));
    color: #0096ff;
}

.profit-wallet .wallet-icon {
    background: linear-gradient(135deg, rgba(255, 150, 0, 0.3), rgba(255, 150, 0, 0.1));
    color: #ff9600;
}

.wallet-info h4 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.2rem;
    font-weight: 600;
}

.wallet-balance {
    color: #00ff00;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

/* Transfer Tabs */
.transfer-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.transfer-form, .exchange-form {
    max-width: 500px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-help {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
    margin-top: 5px;
}

/* Exchange Visual */
.exchange-visual {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.wallet-selector {
    flex: 1;
    text-align: center;
}

.wallet-selector label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 10px;
}

.exchange-arrow {
    margin: 0 20px;
    font-size: 2rem;
    color: #00ff00;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Buttons */
.btn-transfer, .btn-exchange {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-transfer:hover, .btn-exchange:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-transfer:active, .btn-exchange:active {
    transform: translateY(0);
}

/* History */
.history-container {
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.history-header h4 {
    color: #00ff00;
    margin: 0;
    font-size: 1.5rem;
}

.btn-refresh {
    background: rgba(0, 255, 0, 0.2);
    border: 1px solid rgba(0, 255, 0, 0.3);
    color: #00ff00;
    padding: 8px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-refresh:hover {
    background: rgba(0, 255, 0, 0.3);
}

.history-list {
    max-height: 400px;
    overflow-y: auto;
}

.history-item {
    background: rgba(0, 0, 0, 0.4);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-item.transfer {
    border-color: rgba(0, 150, 255, 0.3);
}

.history-item.exchange {
    border-color: rgba(255, 150, 0, 0.3);
}

.history-info h6 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1rem;
}

.history-info p {
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-size: 0.9rem;
}

.history-amount {
    text-align: right;
}

.history-amount .amount {
    color: #00ff00;
    font-size: 1.2rem;
    font-weight: 700;
    margin: 0;
}

.history-amount .date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.8rem;
    margin: 0;
}

.loading-spinner {
    text-align: center;
    padding: 40px;
    color: rgba(255, 255, 255, 0.7);
}

.loading-spinner i {
    font-size: 2rem;
    color: #00ff00;
}

/* Modal */
.modal-content {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.9), rgba(0, 50, 0, 0.3));
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.modal-title {
    color: #00ff00;
    font-weight: 600;
}

.modal-body {
    color: #fff;
}

.btn-close {
    filter: invert(1);
}

/* Responsive */
@media (max-width: 768px) {
    .transfer-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .transfer-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .exchange-visual {
        flex-direction: column;
        gap: 20px;
    }
    
    .exchange-arrow {
        transform: rotate(90deg);
        margin: 0;
    }
    
    .wallet-card {
        padding: 20px;
    }
    
    .wallet-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
        margin-right: 15px;
    }
    
    .wallet-balance {
        font-size: 1.5rem;
    }
}

@media (max-width: 480px) {
    .transfer-title {
        font-size: 1.8rem;
    }
    
    .wallet-card {
        flex-direction: column;
        text-align: center;
    }
    
    .wallet-icon {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .tab-content {
        padding: 20px;
    }
}
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Transfer form submission
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.transfer.submit") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Exchange form submission
    document.getElementById('exchangeForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Exchanging...';
        submitBtn.disabled = true;
        
        fetch('{{ route("user.shah.wallet.exchange") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            showResult(data.success, data.message);
            if (data.success) {
                this.reset();
                // Update wallet balances if needed
                setTimeout(() => location.reload(), 2000);
            }
        })
        .catch(error => {
            showResult(false, 'An error occurred. Please try again.');
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });

    // Load transfer history on page load
    loadTransferHistory();
});

function showResult(success, message) {
    const modal = new bootstrap.Modal(document.getElementById('resultModal'));
    const title = document.getElementById('resultModalTitle');
    const body = document.getElementById('resultModalBody');
    
    title.textContent = success ? 'Success' : 'Error';
    title.className = 'modal-title ' + (success ? 'text-success' : 'text-danger');
    
    body.innerHTML = `
        <div class="text-center">
            <i class="fas ${success ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger'}" style="font-size: 3rem; margin-bottom: 20px;"></i>
            <p class="mb-0">${message}</p>
        </div>
    `;
    
    modal.show();
}

function loadTransferHistory() {
    const historyContainer = document.getElementById('transferHistory');
    historyContainer.innerHTML = '<div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';
    
    fetch('{{ route("user.shah.transfer.history") }}')
    .then(response => response.json())
    .then(data => {
        if (data.success && data.data.data.length > 0) {
            let historyHTML = '';
            data.data.data.forEach(transaction => {
                const isTransfer = transaction.type === 'transfer';
                const isExchange = transaction.type === 'exchange';
                
                historyHTML += `
                    <div class="history-item ${isTransfer ? 'transfer' : 'exchange'}">
                        <div class="history-info">
                            <h6>${transaction.description}</h6>
                            <p>${new Date(transaction.created_at).toLocaleString()}</p>
                        </div>
                        <div class="history-amount">
                            <p class="amount">$${parseFloat(transaction.amount).toFixed(2)}</p>
                            <p class="date">${transaction.status}</p>
                        </div>
                    </div>
                `;
            });
            historyContainer.innerHTML = historyHTML;
        } else {
            historyContainer.innerHTML = '<div class="text-center text-muted py-4">No transfer history found</div>';
        }
    })
    .catch(error => {
        historyContainer.innerHTML = '<div class="text-center text-danger py-4">Error loading history</div>';
    });
}
</script>
@endpush












