@extends('frontend.shahdeveloper.layouts.user')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="page-container">
    <div class="page-header">
        <button class="back-btn" onclick="window.history.back()">
            <i class="fas fa-arrow-left"></i>
        </button>
        <h2>Submit Payment Proof</h2>
    </div>
    <div class="proof-container">
        <div class="deposit-summary glass-effect">
            <div class="summary-header">
                <h3>Deposit Summary</h3>
            </div>
            <div class="summary-details">
                <div class="summary-row">
                    <span>Amount:</span>
                    <span class="deposit-amount-display">${{ $transaction ? number_format($transaction->amount, 2) : '0.00' }}</span>
                </div>
                <div class="summary-row">
                    <span>Payment Method:</span>
                    <span class="payment-method-display">{{ $transaction ? $transaction->method : 'Select Method' }}</span>
                </div>
                <div class="summary-row">
                    <span>Transaction ID:</span>
                    <span class="txn-id">{{ $transaction ? $transaction->tnx : 'N/A' }}</span>
                </div>
                <div class="summary-row">
                    <span>Status:</span>
                    <span class="status-pending">Awaiting Proof</span>
                </div>
            </div>
        </div>

        <div class="payment-instructions glass-effect">
            <div class="instructions-header">
                <i class="fas fa-info-circle"></i>
                <h3>Payment Instructions</h3>
            </div>
            <div class="instructions-content">
                <p>Please complete your payment using the selected method and provide the proof below:</p>
                <ul>
                    <li>Make the payment for the exact amount shown above</li>
                    <li>Upload a screenshot or photo of your payment confirmation</li>
                    <li>Enter the transaction hash or reference number</li>
                    <li>Your deposit will be processed within Some hours after verification</li>
                </ul>
            </div>
        </div>


        <div class="wallet-details glass-effect" id="wallet-details">
            <div class="wallet-header">
                <i class="fas fa-wallet"></i>
                <h3>Payment Details</h3>
            </div>
            <div class="wallet-content" id="payment-details-content">
                <!-- Payment details will be loaded here dynamically -->
                <div class="loading-payment-details">
                    <i class="fas fa-spinner fa-spin"></i>
                    <span>Loading payment details...</span>
                </div>
            </div>
        </div>

        <form action="{{ route('user.deposit.submit') }}" method="POST" enctype="multipart/form-data" class="proof-submission glass-effect" id="proof-form">
            @csrf
            <input type="hidden" name="amount" id="hidden-amount">
            <input type="hidden" name="txn_id" id="hidden-txn-id" value="{{ $transaction ? $transaction->tnx : '' }}">
            <input type="hidden" name="payment_method" id="hidden-payment-method">
            <input type="hidden" name="gateway_id" id="hidden-gateway-id">
            <h3>Upload Payment Proof</h3>
            
            <div class="upload-section">
                <div class="upload-area" onclick="triggerFileUpload()">
                    <div class="upload-icon">
                        <i class="fas fa-cloud-upload-alt"></i>
                    </div>
                    <div class="upload-text">
                        <h4>Upload Payment Screenshot</h4>
                        <p>Click to browse or drag & drop your payment proof</p>
                        <small>Supports: JPG, PNG, PDF (Max 5MB)</small>
                    </div>
                    <input type="file" id="proof-file" name="proof_file" accept=".jpg,.jpeg,.png,.pdf" style="display: none;" onchange="handleFileUpload(event)">
                </div>
                <div id="uploaded-file" class="uploaded-file" style="display: none;">
                    <div class="file-info">
                        <i class="fas fa-file-image"></i>
                        <span class="file-name"></span>
                        <span class="file-size"></span>
                    </div>
                    <button type="button" class="remove-file-btn" onclick="removeUploadedFile()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="transaction-details">
                <div class="input-group">
                    <label>Transaction Hash / Reference Number *</label>
                    <input type="text" name="transaction_hash" id="transaction-hash" placeholder="Enter transaction hash or reference number" required>
                </div>
                
                <div class="input-group">
                    <label>Additional Notes (Optional)</label>
                    <textarea name="notes" id="deposit-notes" placeholder="Any additional information about your payment..." rows="3"></textarea>
                </div>
            </div>

            <div class="proof-actions">
                <button type="button" class="btn-secondary" onclick="window.history.back()">Back</button>
                <button type="submit" class="btn-primary">Submit for Approval</button>
            </div>
        </form>
    </div>
</div>

<style>
/* Page Container */
.page-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #0a0a0a 0%, #1a1a2e 50%, #16213e 100%);
    padding: 20px;
}

.page-header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
    padding: 20px 0;
}

.back-btn {
    background: rgba(0, 255, 136, 0.1);
    border: 1px solid #00ff88;
    color: #00ff88;
    padding: 12px;
    border-radius: 10px;
    margin-right: 15px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.back-btn:hover {
    background: rgba(0, 255, 136, 0.2);
    transform: translateY(-2px);
}

.page-header h2 {
    color: #fff;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
    text-shadow: 0 2px 10px rgba(0, 255, 136, 0.3);
}

.proof-container {
    max-width: 800px;
    margin: 0 auto;
    display: grid;
    gap: 25px;
}

.deposit-summary {
    padding: 25px;
    border-radius: 20px;
    background: linear-gradient(135deg, rgba(0, 255, 136, 0.1) 0%, rgba(0, 212, 255, 0.1) 100%);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(0, 255, 136, 0.3);
    box-shadow: 0 8px 32px rgba(0, 255, 136, 0.1);
}

.summary-header h3 {
    margin: 0 0 15px 0;
    color: #fff;
    font-weight: 600;
}

.summary-details {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.summary-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.summary-row:last-child {
    border-bottom: none;
}

.summary-row span:first-child {
    color: rgba(255, 255, 255, 0.8);
    font-weight: 500;
}

.deposit-amount-display {
    color: #00d4ff;
    font-weight: 600;
    font-size: 18px;
}

.payment-method-display {
    color: #fff;
    font-weight: 500;
}

.status-pending {
    color: #ffa500;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 12px;
    letter-spacing: 1px;
}

.payment-instructions {
    padding: 25px;
    border-radius: 20px;
    background: linear-gradient(135deg, rgba(0, 212, 255, 0.1) 0%, rgba(0, 255, 136, 0.1) 100%);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(0, 212, 255, 0.3);
    box-shadow: 0 8px 32px rgba(0, 212, 255, 0.1);
}

.instructions-header {
    display: flex;
    align-items: center;
    margin-bottom: 15px;
}

.instructions-header i {
    color: #00d4ff;
    margin-right: 10px;
    font-size: 18px;
}

.instructions-header h3 {
    margin: 0;
    color: #fff;
    font-weight: 600;
}

.instructions-content p {
    color: rgba(255, 255, 255, 0.9);
    margin-bottom: 15px;
    line-height: 1.6;
}

.instructions-content ul {
    color: rgba(255, 255, 255, 0.8);
    padding-left: 20px;
    margin: 0;
}

.instructions-content li {
    margin-bottom: 8px;
    line-height: 1.5;
}


.wallet-details {
    padding: 25px;
    border-radius: 20px;
    background: linear-gradient(135deg, rgba(0, 255, 136, 0.1) 0%, rgba(0, 212, 255, 0.1) 100%);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(0, 255, 136, 0.3);
    box-shadow: 0 8px 32px rgba(0, 255, 136, 0.1);
}

.wallet-header {
    display: flex;
    align-items: center;
    margin-bottom: 20px;
}

.wallet-header i {
    font-size: 20px;
    color: #00d4ff;
    margin-right: 10px;
}

.wallet-header h3 {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.wallet-content {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.wallet-address label,
.qr-code-container label {
    display: block;
    color: #fff;
    font-weight: 600;
    margin-bottom: 8px;
}

.address-container {
    display: flex;
    gap: 10px;
}

.address-container input {
    flex: 1;
    padding: 12px 15px;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    color: #fff;
    font-size: 14px;
    font-family: monospace;
}

.copy-address-btn {
    padding: 12px;
    background: linear-gradient(135deg, #00d4ff, #0099cc);
    border: none;
    border-radius: 8px;
    color: #fff;
    cursor: pointer;
    transition: all 0.3s ease;
}

.copy-address-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 212, 255, 0.4);
}

.qr-code {
    width: 150px;
    height: 150px;
    background: rgba(255, 255, 255, 0.1);
    border: 2px dashed rgba(255, 255, 255, 0.3);
    border-radius: 10px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    color: rgba(255, 255, 255, 0.5);
    text-align: center;
    padding: 20px;
}

.qr-code i {
    font-size: 32px;
    margin-bottom: 10px;
}

.qr-code span {
    font-size: 12px;
    line-height: 1.4;
}

.proof-submission {
    padding: 25px;
    border-radius: 20px;
    background: linear-gradient(135deg, rgba(0, 212, 255, 0.1) 0%, rgba(0, 255, 136, 0.1) 100%);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(0, 212, 255, 0.3);
    box-shadow: 0 8px 32px rgba(0, 212, 255, 0.1);
}

.proof-submission h3 {
    margin: 0 0 20px 0;
    color: #fff;
    font-weight: 600;
}

.upload-section {
    margin-bottom: 20px;
}

.upload-area {
    border: 2px dashed rgba(255, 255, 255, 0.3);
    border-radius: 10px;
    padding: 30px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    background: rgba(255, 255, 255, 0.05);
}

.upload-area:hover {
    border-color: #00d4ff;
    background: rgba(0, 212, 255, 0.1);
}

.upload-icon {
    font-size: 48px;
    color: #00d4ff;
    margin-bottom: 15px;
}

.upload-text h4 {
    margin: 0 0 10px 0;
    color: #fff;
    font-weight: 600;
}

.upload-text p {
    margin: 0 0 10px 0;
    color: rgba(255, 255, 255, 0.8);
}

.upload-text small {
    color: rgba(255, 255, 255, 0.6);
    font-size: 12px;
}

.uploaded-file {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 15px;
    background: rgba(0, 212, 255, 0.1);
    border: 1px solid #00d4ff;
    border-radius: 10px;
    margin-top: 15px;
}

.file-info {
    display: flex;
    align-items: center;
    gap: 10px;
}

.file-info i {
    color: #00d4ff;
    font-size: 20px;
}

.file-name {
    color: #fff;
    font-weight: 500;
}

.file-size {
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
}

.remove-file-btn {
    background: none;
    border: none;
    color: #ff6b6b;
    cursor: pointer;
    padding: 5px;
    border-radius: 5px;
    transition: background 0.3s ease;
}

.remove-file-btn:hover {
    background: rgba(255, 107, 107, 0.2);
}

.transaction-details {
    margin-bottom: 20px;
}

.input-group {
    margin-bottom: 20px;
}

.input-group label {
    display: block;
    margin-bottom: 8px;
    color: #fff;
    font-weight: 500;
}

.input-group input,
.input-group textarea {
    width: 100%;
    padding: 12px 15px;
    border: 2px solid rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 14px;
    outline: none;
    transition: all 0.3s ease;
}

.input-group input:focus,
.input-group textarea:focus {
    border-color: #00d4ff;
    box-shadow: 0 0 15px rgba(0, 212, 255, 0.3);
}

.input-group input::placeholder,
.input-group textarea::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.input-group textarea {
    resize: vertical;
    min-height: 80px;
}

.proof-actions {
    display: flex;
    gap: 15px;
    justify-content: flex-end;
}

.payment-instructions {
    margin-top: 1.5rem;
    padding: 1.5rem;
    border-radius: 12px;
    background: var(--surface);
    border: 1px solid var(--border);
}

.payment-instructions .instructions-header {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 1rem;
}

.payment-instructions .instructions-header i {
    color: var(--primary-color);
    font-size: 1.2rem;
}

.payment-instructions .instructions-header h3 {
    margin: 0;
    color: var(--text-primary);
    font-size: 1.1rem;
}

.payment-instructions .instructions-content p {
    margin: 0;
    color: var(--text-secondary);
    line-height: 1.6;
}

.btn-secondary, .btn-primary {
    padding: 12px 24px;
    border: none;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.2);
    color: #fff;
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.3);
}

.btn-primary {
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    color: #000;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-primary:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0, 255, 136, 0.4);
    background: linear-gradient(135deg, #00cc6a, #00ff88);
}

.loading-payment-details, .no-payment-details, .error-payment-details {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 40px 20px;
    text-align: center;
    color: #fff;
}

.loading-payment-details i {
    font-size: 24px;
    margin-bottom: 10px;
    color: #00d4ff;
}

.no-payment-details i, .error-payment-details i {
    font-size: 24px;
    margin-bottom: 10px;
    color: #ff6b6b;
}

.loading-payment-details span, .no-payment-details span, .error-payment-details span {
    font-size: 14px;
    opacity: 0.8;
}

@media (max-width: 768px) {
    .page-container {
        padding: 15px;
    }
    
    .page-header h2 {
        font-size: 24px;
    }
    
    .proof-container {
        gap: 20px;
    }
    
    .deposit-summary, .payment-instructions, .proof-submission, .wallet-details {
        padding: 20px;
    }
    
    .upload-area {
        padding: 20px;
    }
    
    .upload-icon {
        font-size: 36px;
    }
    
    .proof-actions {
        flex-direction: column;
        gap: 10px;
    }
    
    .btn-secondary, .btn-primary {
        width: 100%;
        padding: 15px;
    }
    
    .gateway-item {
        padding: 12px;
    }
    
    .summary-row {
        flex-direction: column;
        align-items: flex-start;
        gap: 5px;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Load deposit data from sessionStorage
    // Set transaction data from PHP
    @if($transaction)
        const amount = {{ $transaction->amount }};
        const method = '{{ $transaction->method }}';
        const txnId = '{{ $transaction->tnx }}';
        
        document.querySelector('.deposit-amount-display').textContent = '$' + parseFloat(amount).toFixed(2);
        document.getElementById('hidden-amount').value = amount;
        document.querySelector('.payment-method-display').textContent = method.replace('_', ' ').toUpperCase();
        document.getElementById('hidden-payment-method').value = method;
        document.querySelector('.txn-id').textContent = txnId;
        
        console.log('Transaction data set:', { amount, method, txnId });
        
        // Load payment details
        loadPaymentDetails(method);
    @endif
    
    // Load payment details from sessionStorage or fetch from server
    function loadPaymentDetails(method) {
        const paymentDetailsContent = document.getElementById('payment-details-content');
        const walletDetails = document.getElementById('wallet-details');
        
        // Try to get from sessionStorage first
        const storedDetails = sessionStorage.getItem('paymentDetails');
        if (storedDetails) {
            paymentDetailsContent.innerHTML = storedDetails;
            walletDetails.style.display = 'block';
            return;
        }
        
        // If not in sessionStorage, fetch from server
        if (method) {
            fetchPaymentDetailsFromServer(method);
        }
    }
    
    // Fetch payment details from server
    function fetchPaymentDetailsFromServer(method) {
        const paymentDetailsContent = document.getElementById('payment-details-content');
        const walletDetails = document.getElementById('wallet-details');
        
        console.log('Fetching payment details for method:', method);
        
        // Show loading state
        paymentDetailsContent.innerHTML = `
            <div class="loading-payment-details">
                <i class="fas fa-spinner fa-spin"></i>
                <span>Loading payment details...</span>
            </div>
        `;
        walletDetails.style.display = 'block';
        
        // Fetch gateway details
        const url = '{{ route("user.deposit.gateway", ":code") }}'.replace(':code', method);
        console.log('Fetching from URL:', url);
        
        fetch(url)
            .then(response => {
                console.log('Response status:', response.status);
                return response.json();
            })
            .then(data => {
                console.log('Gateway data received:', data);
                if (data.credentials) {
                    paymentDetailsContent.innerHTML = data.credentials;
                    // Store in sessionStorage for future use
                    sessionStorage.setItem('paymentDetails', data.credentials);
                } else {
                    paymentDetailsContent.innerHTML = `
                        <div class="no-payment-details">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span>No payment details available for this method.</span>
                        </div>
                    `;
                }
            })
            .catch(error => {
                console.error('Error fetching payment details:', error);
                paymentDetailsContent.innerHTML = `
                    <div class="error-payment-details">
                        <i class="fas fa-exclamation-triangle"></i>
                        <span>Error loading payment details. Please try again.</span>
                    </div>
                `;
            });
    }
    
    // Form submission handler
    document.getElementById('proof-form').addEventListener('submit', function(e) {
        console.log('Form submit event triggered');
        
        // Check if required fields are filled
        const transactionHash = this.querySelector('input[name="transaction_hash"]').value;
        const proofFile = this.querySelector('input[name="proof_file"]').files[0];
        
        if (!transactionHash) {
            alert('Please enter transaction hash');
            e.preventDefault();
            return;
        }
        
        if (!proofFile) {
            alert('Please upload proof file');
            e.preventDefault();
            return;
        }
        
        // Submit via AJAX to guarantee redirect on success
        e.preventDefault();
        const form = this;
        const url = form.getAttribute('action');
        const formData = new FormData(form);
        fetch(url, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: formData
        }).then(async res => {
            // If server redirected (non-AJAX), follow the redirect
            if (res.redirected) {
                window.location.href = res.url;
                return null;
            }
            const ct = res.headers.get('content-type') || '';
            if (ct.includes('application/json')) {
                return res.json();
            }
            // Fallback: read text and navigate to success page if possible
            const text = await res.text();
            console.log('Non-JSON response:', text.substring(0, 200));
            window.location.href = '{{ route('user.deposit.success') }}';
            return null;
        })
        .then(data => {
            console.log('Submit response:', data);
            if (data && data.success) {
                if (data.redirect_url) {
                    window.location.href = data.redirect_url;
                } else {
                    window.location.reload();
                }
            } else {
                if (data) {
                    alert(data.message ? data.message : 'Submission failed. Please try again.');
                }
            }
        }).catch(err => {
            console.error('Submit error:', err);
            // Fallback to normal submit if AJAX fails
            form.submit();
        });
    });
    
    
    
});

function copyWalletAddress() {
    // Try to find wallet address in the dynamic content
    const walletAddressInput = document.getElementById('wallet-address');
    if (walletAddressInput) {
        walletAddressInput.select();
        document.execCommand('copy');
        showCopySuccess('Wallet address copied!');
        return;
    }
    
    // If no input found, try to find wallet address in the content
    const walletCode = document.querySelector('.wallet-address code');
    if (walletCode) {
        navigator.clipboard.writeText(walletCode.textContent).then(function() {
            showCopySuccess('Wallet address copied!');
        }).catch(function(err) {
            console.error('Could not copy text: ', err);
            alert('Failed to copy wallet address');
        });
        return;
    }
    
    alert('No wallet address found to copy');
}

function triggerFileUpload() {
    document.getElementById('proof-file').click();
}

function handleFileUpload(event) {
    const file = event.target.files[0];
    if (file) {
        const fileSize = (file.size / 1024 / 1024).toFixed(2);
        const fileName = file.name;
        
        document.querySelector('.file-name').textContent = fileName;
        document.querySelector('.file-size').textContent = fileSize + ' MB';
        document.getElementById('uploaded-file').style.display = 'flex';
        document.querySelector('.upload-area').style.display = 'none';
    }
}

function removeUploadedFile() {
    document.getElementById('proof-file').value = '';
    document.getElementById('uploaded-file').style.display = 'none';
    document.querySelector('.upload-area').style.display = 'block';
}

function submitDepositProof() {
    const form = document.querySelector('.proof-submission');
    const formData = new FormData(form);
    
    // Add validation here
    const fileInput = document.getElementById('proof-file');
    const transactionHash = document.getElementById('transaction-hash');
    
    if (!fileInput.files[0]) {
        showError('Please upload a payment proof file');
        return;
    }
    
    if (!transactionHash.value.trim()) {
        showError('Please enter transaction hash or reference number');
        return;
    }
    
    // Show loading state
    const submitBtn = document.querySelector('.btn-primary');
    const originalText = submitBtn.textContent;
    submitBtn.textContent = 'Submitting...';
    submitBtn.disabled = true;
    
    // Submit form via AJAX
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showSuccess('Deposit request submitted successfully!');
            setTimeout(() => {
                window.location.href = '{{ route("user.deposit.log") }}';
            }, 2000);
        } else {
            showError(data.message || 'Something went wrong. Please try again.');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showError('Network error. Please try again.');
    })
    .finally(() => {
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
    });
}

function showSuccess(message) {
    showNotification(message, 'success');
}

function showError(message) {
    showNotification(message, 'error');
}

function showNotification(message, type) {
    const notification = document.createElement('div');
    notification.className = `notification ${type}`;
    notification.textContent = message;
    notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        padding: 15px 20px;
        border-radius: 8px;
        color: white;
        font-weight: 600;
        z-index: 1000;
        backdrop-filter: blur(10px);
        ${type === 'success' ? 'background: rgba(78, 205, 196, 0.9);' : 'background: rgba(255, 107, 107, 0.9);'}
        animation: slideIn 0.3s ease;
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.style.animation = 'slideOut 0.3s ease';
        setTimeout(() => {
            document.body.removeChild(notification);
        }, 300);
    }, 3000);
}
</script>
@endsection
