@extends('frontend.shahdeveloper.layouts.user')

@section('content')
<div class="page-container">
    <div class="page-header">
        <button class="back-btn" onclick="window.history.back()">
            <i class="fas fa-arrow-left"></i>
        </button>
        <h2>Deposit Funds</h2>
    </div>
    <div class="deposit-container">
        <div class="amount-input glass-effect">
            <label>Amount to Deposit</label>
            <div class="input-wrapper">
                <span class="currency">$</span>
                <input type="number" placeholder="0.00" id="deposit-amount" step="0.01" min="1">
            </div>
        </div>
        
        <div class="payment-methods">
            <h3>Select Payment Method</h3>
            <div class="method-list">
                <div class="payment-method glass-effect active" data-method="bank_transfer">
                    <i class="fas fa-university"></i>
                    <span>Bank Transfer</span>
                    <i class="fas fa-check"></i>
                </div>
                <div class="payment-method glass-effect" data-method="crypto">
                    <i class="fab fa-bitcoin"></i>
                    <span>Cryptocurrency</span>
                </div>
                <div class="payment-method glass-effect" data-method="card">
                    <i class="fas fa-credit-card"></i>
                    <span>Credit Card</span>
                </div>
            </div>
        </div>

        <!-- Bank Transfer Fields -->
        <div id="bank_transfer_fields" class="payment-fields" style="display: block;">
            <h4>Bank Transfer Details</h4>
            <div class="field-group">
                <label>Account Number</label>
                <input type="text" id="account_number" placeholder="Enter Account Number">
            </div>
            <div class="field-group">
                <label>Transaction ID</label>
                <input type="text" id="transaction_id" placeholder="Enter Transaction ID">
            </div>
            <div class="field-group">
                <label>Account Name</label>
                <input type="text" id="account_name" placeholder="Enter Account Name">
            </div>
        </div>

        <!-- Crypto Fields -->
        <div id="crypto_fields" class="payment-fields" style="display: none;">
            <h4>Cryptocurrency Details</h4>
            <div class="field-group">
                <label>Wallet Address</label>
                <input type="text" id="wallet_address" placeholder="Enter Wallet Address">
            </div>
            <div class="field-group">
                <label>Transaction Hash</label>
                <input type="text" id="transaction_hash" placeholder="Enter Transaction Hash">
            </div>
            <div class="field-group">
                <label>Cryptocurrency Type</label>
                <select id="crypto_type">
                    <option value="">Select Crypto Type</option>
                    <option value="bitcoin">Bitcoin (BTC)</option>
                    <option value="ethereum">Ethereum (ETH)</option>
                    <option value="usdt">Tether (USDT)</option>
                    <option value="usdc">USD Coin (USDC)</option>
                    <option value="binance">Binance Coin (BNB)</option>
                    <option value="other">Other</option>
                </select>
            </div>
        </div>
        
        <button class="btn-primary deposit-btn" onclick="proceedToProofSubmission()">Deposit Now</button>
    </div>
</div>

<style>
.deposit-container {
    padding: 20px;
    max-width: 500px;
    margin: 0 auto;
}

.amount-input {
    margin-bottom: 30px;
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.amount-input label {
    display: block;
    margin-bottom: 10px;
    font-weight: 600;
    color: #fff;
}

.input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.currency {
    position: absolute;
    left: 15px;
    font-size: 18px;
    font-weight: 600;
    color: #00d4ff;
    z-index: 2;
}

.input-wrapper input {
    width: 100%;
    padding: 15px 15px 15px 40px;
    border: 2px solid rgba(255, 255, 255, 0.2);
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    outline: none;
    transition: all 0.3s ease;
}

.input-wrapper input:focus {
    border-color: #00d4ff;
    box-shadow: 0 0 20px rgba(0, 212, 255, 0.3);
}

.input-wrapper input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.payment-methods {
    margin-bottom: 30px;
}

.payment-methods h3 {
    margin-bottom: 15px;
    color: #fff;
    font-weight: 600;
}

.method-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.payment-method {
    display: flex;
    align-items: center;
    padding: 15px 20px;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 2px solid rgba(255, 255, 255, 0.2);
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
}

.payment-method:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateY(-2px);
}

.payment-method.active {
    border-color: #00d4ff;
    background: rgba(0, 212, 255, 0.1);
}

.payment-method i:first-child {
    font-size: 20px;
    margin-right: 15px;
    color: #00d4ff;
}

.payment-method span {
    flex: 1;
    color: #fff;
    font-weight: 500;
}

.payment-method i:last-child {
    color: #00d4ff;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.payment-method.active i:last-child {
    opacity: 1;
}

.deposit-btn {
    width: 100%;
    padding: 15px;
    border: none;
    border-radius: 10px;
    background: linear-gradient(135deg, #00d4ff, #0099cc);
    color: #fff;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.deposit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 212, 255, 0.4);
}

.deposit-btn:active {
    transform: translateY(0);
}

@media (max-width: 768px) {
    .deposit-container {
        padding: 15px;
    }
    
    .amount-input, .payment-method {
        padding: 15px;
    }
    
    .input-wrapper input {
        font-size: 16px;
        padding: 12px 12px 12px 35px;
    }
    
    .currency {
        left: 12px;
        font-size: 16px;
    }
}

/* Payment Fields Styles */
.payment-fields {
    margin-top: 20px;
    padding: 20px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.payment-fields h4 {
    color: #fff;
    margin-bottom: 15px;
    font-size: 18px;
    font-weight: 600;
}

.field-group {
    margin-bottom: 15px;
}

.field-group label {
    display: block;
    color: #fff;
    margin-bottom: 5px;
    font-weight: 500;
    font-size: 14px;
}

.field-group input,
.field-group select {
    width: 100%;
    padding: 12px 15px;
    border: 1px solid rgba(255, 255, 255, 0.3);
    border-radius: 8px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 14px;
    transition: all 0.3s ease;
}

.field-group input::placeholder {
    color: rgba(255, 255, 255, 0.6);
}

.field-group input:focus,
.field-group select:focus {
    outline: none;
    border-color: #00d4ff;
    background: rgba(255, 255, 255, 0.15);
}

.field-group select option {
    background: #1a1a1a;
    color: #fff;
}
</style>

<script>
// Payment method selection
document.addEventListener('DOMContentLoaded', function() {
    const paymentMethods = document.querySelectorAll('.payment-method');
    const bankFields = document.getElementById('bank_transfer_fields');
    const cryptoFields = document.getElementById('crypto_fields');
    
    paymentMethods.forEach(method => {
        method.addEventListener('click', function() {
            // Remove active class from all methods
            paymentMethods.forEach(m => m.classList.remove('active'));
            
            // Add active class to clicked method
            this.classList.add('active');
            
            // Hide all fields
            bankFields.style.display = 'none';
            cryptoFields.style.display = 'none';
            
            // Show relevant fields based on selection
            const methodType = this.getAttribute('data-method');
            if (methodType === 'bank_transfer') {
                bankFields.style.display = 'block';
            } else if (methodType === 'crypto') {
                cryptoFields.style.display = 'block';
            }
        });
    });
});

function proceedToProofSubmission() {
    const amount = document.getElementById('deposit-amount').value;
    const activeMethod = document.querySelector('.payment-method.active').getAttribute('data-method');
    
    if (!amount || amount <= 0) {
        alert('Please enter a valid amount');
        return;
    }
    
    // Collect payment details based on selected method
    let paymentDetails = {
        method: activeMethod,
        amount: amount
    };
    
    if (activeMethod === 'bank_transfer') {
        paymentDetails.account_number = document.getElementById('account_number').value;
        paymentDetails.transaction_id = document.getElementById('transaction_id').value;
        paymentDetails.account_name = document.getElementById('account_name').value;
        
        if (!paymentDetails.account_number || !paymentDetails.transaction_id || !paymentDetails.account_name) {
            alert('Please fill in all bank transfer details');
            return;
        }
    } else if (activeMethod === 'crypto') {
        paymentDetails.wallet_address = document.getElementById('wallet_address').value;
        paymentDetails.transaction_hash = document.getElementById('transaction_hash').value;
        paymentDetails.crypto_type = document.getElementById('crypto_type').value;
        
        if (!paymentDetails.wallet_address || !paymentDetails.transaction_hash || !paymentDetails.crypto_type) {
            alert('Please fill in all cryptocurrency details');
            return;
        }
    }
    
    // Store payment details in sessionStorage for next step
    sessionStorage.setItem('paymentDetails', JSON.stringify(paymentDetails));
    
    // Redirect to proof submission page
    window.location.href = '{{ route("user.deposit.proof") }}';
}
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Payment method selection
    const paymentMethods = document.querySelectorAll('.payment-method');
    paymentMethods.forEach(method => {
        method.addEventListener('click', function() {
            paymentMethods.forEach(m => m.classList.remove('active'));
            this.classList.add('active');
        });
    });
    
    // Amount input formatting
    const amountInput = document.getElementById('deposit-amount');
    amountInput.addEventListener('input', function() {
        let value = this.value;
        if (value < 0) {
            this.value = 0;
        }
    });
});

function proceedToProofSubmission() {
    const amount = document.getElementById('deposit-amount').value;
    const selectedMethod = document.querySelector('.payment-method.active').dataset.method;
    
    if (!amount || amount <= 0) {
        alert('Please enter a valid amount');
        return;
    }
    
    // Store deposit data in sessionStorage
    sessionStorage.setItem('depositAmount', amount);
    sessionStorage.setItem('depositMethod', selectedMethod);
    
    // Redirect to proof submission page
    window.location.href = '{{ route("user.deposit.proof") }}';
}
</script>
@endsection

