@if($status == 'ongoing')
    <div>
        <strong><span id="days{{ $id }}"></span>D : <span id="hours{{ $id }}"></span>H : <span
                id="minutes{{ $id }}"></span>M : <span id="seconds{{ $id }}"></span>S</strong>
        <span class="site-badge primary-bg ms-3" id="percentage{{ $id }}"></span>
    </div>
    <div class="progress investment-timeline">
        <div class="progress-bar progress-bar-striped progress-bar-animated" id="time-progress{{ $id }}"
             role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
    </div>
    <script>
        (function ($) {
            "use strict";
            
            // Configuration
            const second = 1000,
                minute = second * 60,
                hour = minute * 60,
                day = hour * 24;
            
            // Get timezone from settings
            let timezone = @json(setting('site_timezone','global'));
            console.log('Site Timezone:', timezone);
            
            // Parse target dates
            let countDownDate = new Date('{{$next_profit_time}}');
            let startDate = new Date('{{ $last_profit_time ?? $created_at}}');
            
            console.log('Countdown Date:', countDownDate);
            console.log('Start Date:', startDate);
            
            // Function to get current time in site timezone
            function getCurrentTimeInTimezone() {
                const now = new Date();
                const utcTime = now.getTime() + (now.getTimezoneOffset() * 60000);
                const targetTime = new Date(utcTime + (getTimezoneOffset(timezone) * 60000));
                return targetTime.getTime();
            }
            
            // Function to get timezone offset
            function getTimezoneOffset(timezone) {
                const now = new Date();
                const utc1 = new Date(now.toLocaleString("en-US", {timeZone: "UTC"}));
                const utc2 = new Date(now.toLocaleString("en-US", {timeZone: timezone}));
                return (utc2.getTime() - utc1.getTime()) / (1000 * 60 * 60);
            }
            
            // Convert dates to site timezone
            let countDownUTC = countDownDate.getTime();
            let startUTC = startDate.getTime();
            
            // Calculate total duration
            let totalDuration = countDownUTC - startUTC;
            
            console.log('Total Duration (ms):', totalDuration);
            console.log('Total Duration (hours):', totalDuration / (1000 * 60 * 60));
            
            // Start the timer
            let timerInterval = setInterval(function () {
                let now = getCurrentTimeInTimezone();
                let distance = countDownUTC - now;
                
                // Calculate progress
                let elapsed = now - startUTC;
                let progress = totalDuration > 0 ? Math.min(100, Math.max(0, (elapsed / totalDuration) * 100)) : 0;
                
                // Update progress bar
                $("#time-progress{{ $id }}").css("width", progress.toFixed(2) + '%');
                $("#percentage{{ $id }}").text(progress >= 100 ? '100%' : progress.toFixed(1) + '%');
                
                // Update countdown display
                if (distance <= 0) {
                    // Timer expired
                    document.getElementById('days{{ $id }}').innerText = '0';
                    document.getElementById('hours{{ $id }}').innerText = '0';
                    document.getElementById('minutes{{ $id }}').innerText = '0';
                    document.getElementById('seconds{{ $id }}').innerText = '0';
                    
                    // Clear interval
                    clearInterval(timerInterval);
                    
                    // No auto reload; user will refresh manually if needed
                } else {
                    // Update timer display
                    let days = Math.floor(distance / day);
                    let hours = Math.floor((distance % day) / hour);
                    let minutes = Math.floor((distance % hour) / minute);
                    let seconds = Math.floor((distance % minute) / second);
                    
                    document.getElementById('days{{ $id }}').innerText = days;
                    document.getElementById('hours{{ $id }}').innerText = hours;
                    document.getElementById('minutes{{ $id }}').innerText = minutes;
                    document.getElementById('seconds{{ $id }}').innerText = seconds;
                }
                
                // Debug info (remove in production)
                if (Math.random() < 0.01) { // Log only 1% of the time
                    console.log('Timer {{ $id }} - Distance:', distance, 'Progress:', progress.toFixed(1) + '%');
                }
                
            }, second);
            
        })(jQuery);
    </script>
@elseif($status == 'completed')
    <div class="site-badge success">{{ __('Completed') }}</div>
    <div class="progress investment-timeline">
        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75"
             aria-valuemin="0" aria-valuemax="100" style="width: 100%"></div>
    </div>
@elseif($status == 'pending')
    <div class="site-badge warnning">{{ __('Pending') }}</div>
@elseif($status == 'canceled')
    <div class="site-badge warnning">{{ __('Canceled') }}</div>
@endif
