@extends('frontend.shahdeveloper.layouts.app')

@section('title')
    {{ __('Support Tickets') }}
@endsection

@section('content')
<div class="main-content">
    <div class="page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="title-content">
                        <h2 class="title">{{ __('Support Tickets') }}</h2>
                        <a href="{{ route('user.ticket.new') }}" class="title-btn">
                            <i icon-name="plus-circle"></i>{{ __('New Ticket') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title">{{ __('All Tickets') }}</h3>
                    </div>
                    <div class="site-card-body">
                        @if($tickets->count() > 0)
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th scope="col">{{ __('Ticket ID') }}</th>
                                            <th scope="col">{{ __('Subject') }}</th>
                                            <th scope="col">{{ __('Status') }}</th>
                                            <th scope="col">{{ __('Created') }}</th>
                                            <th scope="col">{{ __('Action') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($tickets as $ticket)
                                            <tr>
                                                <td>
                                                    <div class="table-text">
                                                        <div class="table-text">
                                                            <h6 class="title">{{ $ticket->uuid }}</h6>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="table-text">
                                                        <h6 class="title">{{ $ticket->title }}</h6>
                                                    </div>
                                                </td>
                                                <td>
                                                    @if($ticket->status == 'open')
                                                        <span class="site-badge success">{{ __('Open') }}</span>
                                                    @elseif($ticket->status == 'closed')
                                                        <span class="site-badge warning">{{ __('Closed') }}</span>
                                                    @else
                                                        <span class="site-badge pending">{{ ucfirst($ticket->status) }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="table-text">
                                                        <p class="text">{{ $ticket->created_at }}</p>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="action-btn">
                                                        <a href="{{ route('user.ticket.show', $ticket->uuid) }}" 
                                                           class="site-btn-small primary-btn">
                                                            <i icon-name="eye"></i>{{ __('View') }}
                                                        </a>
                                                        @if($ticket->status == 'open')
                                                            <a href="{{ route('user.ticket.close', $ticket->uuid) }}" 
                                                               class="site-btn-small warning-btn"
                                                               onclick="return confirm('Are you sure you want to close this ticket?')">
                                                                <i icon-name="x-circle"></i>{{ __('Close') }}
                                                            </a>
                                                        @endif
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-5">
                                <div class="empty-state">
                                    <i icon-name="message-circle" class="empty-icon"></i>
                                    <h4>{{ __('No Tickets Found') }}</h4>
                                    <p>{{ __('You haven\'t created any support tickets yet.') }}</p>
                                    <a href="{{ route('user.ticket.new') }}" class="site-btn">
                                        <i icon-name="plus-circle"></i>{{ __('Create New Ticket') }}
                                    </a>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    // Add any JavaScript functionality here if needed
</script>
@endpush
