@extends('frontend.shahdeveloper.layouts.app')

@section('title')
    {{ __('Ticket') }} #{{ $ticket->uuid }}
@endsection

@section('content')
<div class="main-content">
    <div class="page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="title-content">
                        <h2 class="title">{{ __('Ticket') }} #{{ $ticket->uuid }}</h2>
                        <div class="title-actions">
                            <a href="{{ route('user.ticket.index') }}" class="title-btn">
                                <i icon-name="arrow-left"></i>{{ __('Back to Tickets') }}
                            </a>
                            @if($ticket->status == 'open')
                                <a href="{{ route('user.ticket.close', $ticket->uuid) }}" 
                                   class="title-btn warning-btn"
                                   onclick="return confirm('Are you sure you want to close this ticket?')">
                                    <i icon-name="x-circle"></i>{{ __('Close Ticket') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-8">
                <!-- Ticket Details -->
                <div class="site-card">
                    <div class="site-card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h3 class="title">{{ $ticket->title }}</h3>
                            <span class="site-badge {{ $ticket->status == 'open' ? 'success' : 'warning' }}">
                                {{ ucfirst($ticket->status) }}
                            </span>
                        </div>
                    </div>
                    <div class="site-card-body">
                        <div class="ticket-meta">
                            <div class="meta-item">
                                <span class="meta-label">{{ __('Ticket ID') }}:</span>
                                <span class="meta-value">{{ $ticket->uuid }}</span>
                            </div>
                            <div class="meta-item">
                                <span class="meta-label">{{ __('Created') }}:</span>
                                <span class="meta-value">{{ $ticket->created_at }}</span>
                            </div>
                            <div class="meta-item">
                                <span class="meta-label">{{ __('Status') }}:</span>
                                <span class="meta-value">{{ ucfirst($ticket->status) }}</span>
                            </div>
                        </div>
                        
                        <div class="ticket-message">
                            <h6>{{ __('Initial Message') }}:</h6>
                            <div class="message-content">
                                {!! $ticket->message !!}
                            </div>
                            @if($ticket->attach)
                                <div class="attachment">
                                    <i icon-name="paperclip"></i>
                                    <a href="{{ asset('storage/' . $ticket->attach) }}" target="_blank" class="attachment-link">
                                        {{ __('View Attachment') }}
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Messages -->
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title">{{ __('Conversation') }}</h3>
                    </div>
                    <div class="site-card-body">
                        @if($ticket->messages->count() > 0)
                            <div class="conversation">
                                @foreach($ticket->messages as $message)
                                    <div class="message-item {{ $message->user_id == auth()->id() ? 'user-message' : 'admin-message' }}">
                                        <div class="message-header">
                                            <div class="message-sender">
                                                @if($message->user_id == auth()->id())
                                                    <i icon-name="user" class="sender-icon"></i>
                                                    {{ __('You') }}
                                                @else
                                                    <i icon-name="shield" class="sender-icon admin"></i>
                                                    {{ __('Support Team') }}
                                                @endif
                                            </div>
                                            <div class="message-time">
                                                {{ $message->created_at }}
                                            </div>
                                        </div>
                                        <div class="message-body">
                                            {!! $message->message !!}
                                            @if($message->attach)
                                                <div class="attachment">
                                                    <i icon-name="paperclip"></i>
                                                    <a href="{{ asset('storage/' . $message->attach) }}" target="_blank" class="attachment-link">
                                                        {{ __('View Attachment') }}
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-4">
                                <i icon-name="message-circle" class="empty-icon"></i>
                                <p>{{ __('No replies yet. Be the first to respond!') }}</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Reply Form -->
                @if($ticket->status == 'open')
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title">{{ __('Reply to Ticket') }}</h3>
                        </div>
                        <div class="site-card-body">
                            <form action="{{ route('user.ticket.reply') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="uuid" value="{{ $ticket->uuid }}">
                                
                                <div class="site-input-groups">
                                    <label for="message" class="box-input-label">{{ __('Your Message') }} <span class="text-danger">*</span></label>
                                    <div class="box-input">
                                        <textarea class="box-input-field" 
                                                  id="message" 
                                                  name="message" 
                                                  rows="4" 
                                                  placeholder="{{ __('Type your reply here...') }}"
                                                  required>{{ old('message') }}</textarea>
                                    </div>
                                    @error('message')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                
                                <div class="site-input-groups">
                                    <label for="attach" class="box-input-label">{{ __('Attachment') }} ({{ __('Optional') }})</label>
                                    <div class="box-input">
                                        <input type="file" 
                                               class="box-input-field" 
                                               id="attach" 
                                               name="attach" 
                                               accept="image/*,.pdf,.doc,.docx">
                                        <small class="text-muted">{{ __('Supported formats: JPG, PNG, PDF, DOC, DOCX') }}</small>
                                    </div>
                                    @error('attach')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                
                                <div class="site-input-groups">
                                    <button type="submit" class="site-btn">
                                        <i icon-name="send"></i>{{ __('Send Reply') }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                @else
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="alert alert-warning">
                                <i icon-name="info"></i>
                                {{ __('This ticket is closed. You cannot reply to closed tickets.') }}
                            </div>
                        </div>
                    </div>
                @endif
            </div>
            
            <div class="col-xl-4">
                <!-- Ticket Info -->
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title">{{ __('Ticket Information') }}</h3>
                    </div>
                    <div class="site-card-body">
                        <div class="ticket-info">
                            <div class="info-item">
                                <span class="info-label">{{ __('Ticket ID') }}</span>
                                <span class="info-value">{{ $ticket->uuid }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">{{ __('Status') }}</span>
                                <span class="info-value">
                                    <span class="site-badge {{ $ticket->status == 'open' ? 'success' : 'warning' }}">
                                        {{ ucfirst($ticket->status) }}
                                    </span>
                                </span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">{{ __('Created') }}</span>
                                <span class="info-value">{{ $ticket->created_at }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">{{ __('Last Updated') }}</span>
                                <span class="info-value">{{ $ticket->updated_at }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">{{ __('Replies') }}</span>
                                <span class="info-value">{{ $ticket->messages->count() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    // Auto-scroll to bottom of conversation
    document.addEventListener('DOMContentLoaded', function() {
        const conversation = document.querySelector('.conversation');
        if (conversation) {
            conversation.scrollTop = conversation.scrollHeight;
        }
    });
</script>
@endpush

@push('style')
<style>
.title-actions {
    display: flex;
    gap: 10px;
}

.ticket-meta {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
    margin-bottom: 20px;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 8px;
}

.meta-item {
    display: flex;
    flex-direction: column;
}

.meta-label {
    font-weight: 600;
    color: #666;
    font-size: 12px;
    text-transform: uppercase;
    margin-bottom: 5px;
}

.meta-value {
    color: #333;
    font-weight: 500;
}

.ticket-message {
    margin-top: 20px;
}

.message-content {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    margin-top: 10px;
}

.attachment {
    display: flex;
    align-items: center;
    margin-top: 10px;
    padding: 10px;
    background: #e9ecef;
    border-radius: 6px;
}

.attachment i {
    margin-right: 8px;
    color: #00ff88;
}

.attachment-link {
    color: #00ff88;
    text-decoration: none;
    font-weight: 500;
}

.attachment-link:hover {
    text-decoration: underline;
}

.conversation {
    max-height: 400px;
    overflow-y: auto;
    padding-right: 10px;
}

.message-item {
    margin-bottom: 20px;
    padding: 15px;
    border-radius: 8px;
    border: 1px solid #e9ecef;
}

.user-message {
    background: #e3f2fd;
    border-left: 4px solid #2196f3;
}

.admin-message {
    background: #f3e5f5;
    border-left: 4px solid #9c27b0;
}

.message-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.message-sender {
    display: flex;
    align-items: center;
    font-weight: 600;
    color: #333;
}

.sender-icon {
    width: 16px;
    height: 16px;
    margin-right: 8px;
    color: #00ff88;
}

.sender-icon.admin {
    color: #9c27b0;
}

.message-time {
    font-size: 12px;
    color: #666;
}

.message-body {
    color: #555;
    line-height: 1.6;
}

.ticket-info {
    padding: 0;
}

.info-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 0;
    border-bottom: 1px solid #f0f0f0;
}

.info-item:last-child {
    border-bottom: none;
}

.info-label {
    font-weight: 600;
    color: #666;
}

.info-value {
    color: #333;
    font-weight: 500;
}

.empty-icon {
    width: 48px;
    height: 48px;
    color: #ccc;
    margin-bottom: 15px;
}

.alert {
    padding: 15px;
    border-radius: 8px;
    display: flex;
    align-items: center;
}

.alert-warning {
    background: #fff3cd;
    border: 1px solid #ffeaa7;
    color: #856404;
}

.alert i {
    margin-right: 10px;
    color: #f39c12;
}
</style>
@endpush
