@extends('frontend.shahdeveloper.layouts.user')

@section('title', 'Withdrawal Success')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-xl-8 col-lg-10">
            <div class="success-card">
                <div class="success-content">
                    <!-- Success Icon -->
                    <div class="success-icon">
                        <div class="icon-wrapper">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                    
                    <!-- Success Title -->
                    <h2 class="success-title">Withdrawal Request Submitted!</h2>
                    
                    <!-- Success Message -->
                    <div class="success-message">
                        <p>🎉 Your withdrawal request has been submitted successfully and is now under review.</p>
                    </div>
                    
                    <!-- Info Cards -->
                    <div class="info-cards">
                        <div class="info-card processing">
                            <div class="info-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="info-content">
                                <h6>⏰ Processing Time</h6>
                                <p>Your withdrawal will be processed within 24 hours during business days.</p>
                            </div>
                        </div>
                        
                        <div class="info-card notification">
                            <div class="info-icon">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="info-content">
                                <h6>📧 Email Notification</h6>
                                <p>You will receive an email notification once your withdrawal is processed.</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="action-buttons">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <a href="{{ route('user.withdraw.simple.index') }}" class="btn btn-primary w-100">
                                    <i class="fas fa-plus"></i>
                                    Make Another Withdrawal
                                </a>
                            </div>
                            <div class="col-md-6 mb-3">
                                <a href="{{ route('user.withdraw.log') }}" class="btn btn-secondary w-100">
                                    <i class="fas fa-history"></i>
                                    View Withdrawal History
                                </a>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('user.dashboard') }}" class="btn btn-outline-primary w-100">
                                    <i class="fas fa-home"></i>
                                    Back to Dashboard
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.success-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    border: 1px solid rgba(0, 255, 136, 0.2);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    margin: 2rem 0;
}

.success-content {
    padding: 3rem 2rem;
    text-align: center;
}

.success-icon {
    margin-bottom: 2rem;
}

.icon-wrapper {
    width: 100px;
    height: 100px;
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    animation: pulse 2s infinite;
}

.icon-wrapper i {
    font-size: 3rem;
    color: #001f11;
}

@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.05); }
    100% { transform: scale(1); }
}

.success-title {
    color: var(--text-primary);
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.success-message {
    margin-bottom: 2rem;
}

.success-message p {
    color: var(--text-secondary);
    font-size: 1.2rem;
    margin: 0;
}

.info-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2.5rem;
}

.info-card {
    background: rgba(255, 255, 255, 0.03);
    border-radius: 15px;
    padding: 1.5rem;
    border: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    transition: all 0.3s ease;
}

.info-card:hover {
    transform: translateY(-5px);
    border-color: rgba(0, 255, 136, 0.3);
}

.info-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.info-icon i {
    font-size: 1.5rem;
    color: #001f11;
}

.info-content h6 {
    color: var(--text-primary);
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.1rem;
}

.info-content p {
    color: var(--text-secondary);
    margin: 0;
    font-size: 0.95rem;
    line-height: 1.5;
}

.action-buttons {
    margin-top: 2rem;
}

.btn {
    padding: 12px 24px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    transition: all 0.3s ease;
    border: none;
    font-size: 1rem;
}

.btn-primary {
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    color: #001f11;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 20px rgba(0, 255, 136, 0.3);
    color: #001f11;
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: var(--text-primary);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.15);
    color: var(--text-primary);
    transform: translateY(-2px);
}

.btn-outline-primary {
    background: transparent;
    color: var(--primary-color);
    border: 2px solid var(--primary-color);
}

.btn-outline-primary:hover {
    background: var(--primary-color);
    color: #001f11;
    transform: translateY(-2px);
}

/* Responsive */
@media (max-width: 768px) {
    .success-content {
        padding: 2rem 1rem;
    }
    
    .success-title {
        font-size: 2rem;
    }
    
    .info-cards {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .info-card {
        padding: 1rem;
    }
    
    .icon-wrapper {
        width: 80px;
        height: 80px;
    }
    
    .icon-wrapper i {
        font-size: 2.5rem;
    }
}
</style>
@endsection
