<?php
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AppController;
use App\Http\Controllers\CronJobController;
use App\Http\Controllers\Frontend\IpnController;
use App\Http\Controllers\Frontend\KycController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\PageController;
use App\Http\Controllers\Frontend\UserController;
use App\Http\Controllers\Frontend\InvestController;
use App\Http\Controllers\Frontend\SchemaController;
use App\Http\Controllers\Frontend\StatusController;
use App\Http\Controllers\Frontend\TicketController;
use App\Http\Controllers\Frontend\DepositController;
use App\Http\Controllers\Frontend\GatewayController;
use App\Http\Controllers\Frontend\SettingController;
use App\Http\Controllers\Frontend\ReferralController;
use App\Http\Controllers\Frontend\WithdrawController;
use App\Http\Controllers\Frontend\DashboardController;
use App\Http\Controllers\Frontend\ShahTransferController;
use App\Http\Controllers\Frontend\SendMoneyController;
use App\Http\Controllers\Frontend\TransactionController;
use App\Http\Controllers\Frontend\AchievementController;
use App\Http\Controllers\Frontend\RoiCollectionController;
use App\Http\Controllers\User\ProfileController;
use App\Http\Controllers\User\UserTransferController;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Auth\GoogleController;
Route::get('/refresh-config', function () {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('config:cache');
    return '✅ Laravel config refreshed!';
});
Route::get('/test-mail-config', function () {
    dd(config('mail.mailer'), config('mail.host'), config('mail.port'));
});


Route::get('/mail-debug', function () {
    return [
        'MAIL_MAILER' => config('mail.default'),
        'MAIL_HOST' => config('mail.mailers.smtp.host'),
        'MAIL_PORT' => config('mail.mailers.smtp.port'),
        'MAIL_ENCRYPTION' => config('mail.mailers.smtp.encryption'),
        'MAIL_USERNAME' => config('mail.mailers.smtp.username'),
        'MAIL_PASSWORD' => config('mail.mailers.smtp.password'),
        'MAIL_FROM' => config('mail.from'),
    ];
});

Route::get('/send-test-mail', function () {
    try {
        Mail::raw('Test mail from FutureGlobalWealth SMTP.', function ($message) {
            $message->to('asadhafiz485@gmail.com')
                    ->subject('SMTP Test');
        });

        return '✅ Mail sent!';
    } catch (\Exception $e) {
        return '❌ Mail failed: ' . $e->getMessage();
    }
});
Route::get('/', function () {
    return view('frontend.landing_pro');
})->name('home');

Route::get('/welcome', function () {
    return view('frontend.welcome');
})->name('welcome');

Route::get('/old-home', [HomeController::class, 'home'])->name('old-home');

// ✅ ADD REFERRAL REGISTRATION ROUTE
Route::get('register/{referralCode}', function($referralCode) {
    // Set invite cookie and redirect to registration
    return redirect()->route('register')->withCookie('invite', $referralCode, 60 * 24 * 7); // 7 days
})->name('register.referral');

Route::post('subscriber', [HomeController::class, 'subscribeNow'])->name('subscriber');
// Add this route with your other withdraw routes
Route::get('/withdraw/resend-otp', [WithdrawController::class, 'resendOtp'])->name('user.withdraw.resend.otp');
Route::get('/withdraw/verify-otp', [WithdrawController::class, 'showVerifyOtpForm'])
    ->name('user.withdraw.verify.otp');
Route::post('/withdraw/verify-otp', [WithdrawController::class, 'verifyOtp']);
// Route::middleware(['auth'])->prefix('user')->name('user.')->group(function () {
//     // OTP verification routes
//     Route::get('withdraw/verify-otp', [WithdrawController::class, 'showOtpForm'])->name('withdraw.verify-otp');
//     Route::post('withdraw/verify-otp', [WithdrawController::class, 'verifyOtp'])->name('withdraw.verify-otp');
//     Route::get('withdraw/resend-otp', [WithdrawController::class, 'resendOtp'])->name('withdraw.resend-otp');
// });

// Static Page Routes
Route::get('/{page}', PageController::class)->name('page')->where('page', 'schema|how-it-works|about-us|faq|rankings|blog|contact|privacy-policy|terms-and-conditions');
Route::get('page/{section}', [PageController::class, 'getPage'])->name('dynamic.page');
Route::get('blog/{id}', [PageController::class, 'blogDetails'])->name('blog-details');
Route::post('mail-send', [PageController::class, 'mailSend'])->name('mail-send');

// Admin Routes
Route::prefix('admin')->middleware(['auth:admin'])->group(function () {
    Route::get('/', 'Admin\DashboardController@index')->name('admin.dashboard');
    
    // Withdraw Methods Management
    Route::get('withdraw-methods', 'App\Http\Controllers\Admin\WithdrawMethodController@index')->name('admin.withdraw.methods.index');
    Route::get('withdraw-methods/create', 'App\Http\Controllers\Admin\WithdrawMethodController@create')->name('admin.withdraw.methods.create');
    Route::post('withdraw-methods', 'App\Http\Controllers\Admin\WithdrawMethodController@store')->name('admin.withdraw.methods.store');
    Route::get('withdraw-methods/{method}', 'App\Http\Controllers\Admin\WithdrawMethodController@show')->name('admin.withdraw.methods.show');
    Route::get('withdraw-methods/{method}/edit', 'App\Http\Controllers\Admin\WithdrawMethodController@edit')->name('admin.withdraw.methods.edit');
    Route::put('withdraw-methods/{method}', 'App\Http\Controllers\Admin\WithdrawMethodController@update')->name('admin.withdraw.methods.update');
    Route::delete('withdraw-methods/{method}', 'App\Http\Controllers\Admin\WithdrawMethodController@destroy')->name('admin.withdraw.methods.destroy');
    Route::post('withdraw-methods/{method}/toggle', 'App\Http\Controllers\Admin\WithdrawMethodController@toggleStatus')->name('admin.withdraw.methods.toggle');
    
    // Withdraw Requests Management
    Route::get('withdraw-requests', 'App\Http\Controllers\Admin\WithdrawRequestController@index')->name('admin.withdraw.requests.index');
    Route::get('withdraw-requests/{withdrawRequest}', 'App\Http\Controllers\Admin\WithdrawRequestController@show')->name('admin.withdraw.requests.show');
    Route::post('withdraw-requests/{withdrawRequest}/approve', 'App\Http\Controllers\Admin\WithdrawRequestController@approve')->name('admin.withdraw.requests.approve');
    Route::post('withdraw-requests/{withdrawRequest}/reject', 'App\Http\Controllers\Admin\WithdrawRequestController@reject')->name('admin.withdraw.requests.reject');
    Route::post('withdraw-requests/{withdrawRequest}/complete', 'App\Http\Controllers\Admin\WithdrawRequestController@complete')->name('admin.withdraw.requests.complete');
    Route::get('withdraw-statistics', 'App\Http\Controllers\Admin\WithdrawRequestController@statistics')->name('admin.withdraw.statistics');
    
    // Manual Payment Gateways
    // Route::resource('manual-payment-gateways', 'Admin\ManualPaymentGatewayController');
    
    // Wallet Management System
    Route::prefix('wallet')->name('admin.wallet.')->controller('App\Http\Controllers\Backend\WalletController')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('{id}', 'show')->name('show');
        Route::post('update-balance', 'updateBalance')->name('update-balance');
        Route::post('add-transaction', 'addTransaction')->name('add-transaction');
        Route::get('statistics', 'statistics')->name('statistics');
    });
});

// Authenticated User Routes
Route::group(['middleware' => ['auth', '2fa', 'isActive'], 'prefix' => 'user', 'as' => 'user.'], function () {

    Route::get('dashboard', [DashboardController::class, 'dashboard'])->name('dashboard');

    // Ranks & Rewards
    Route::get('ranking', [\App\Http\Controllers\Frontend\RankingController::class, 'index'])->name('ranking');

    // Notifications
    Route::get('notify', [UserController::class, 'notifyUser'])->name('notify');
    Route::get('notification/all', [UserController::class, 'allNotification'])->name('notification.all');
    Route::get('latest-notification', [UserController::class, 'latestNotification'])->name('latest-notification');
    Route::get('notification-read/{id}', [UserController::class, 'readNotification'])->name('read-notification');

    // Change Password
    Route::get('/change-password', [UserController::class, 'changePassword'])->name('change.password');
    Route::post('/password-store', [UserController::class, 'newPassword'])->name('new.password');

    // KYC (Disabled - Replaced with Profile Completion)
    // Route::get('kyc', [KycController::class, 'kyc'])->name('kyc');
    // Route::get('kyc/{id}', [KycController::class, 'kycData'])->name('kyc.data');
    // Route::post('kyc-submit', [KycController::class, 'submit'])->name('kyc.submit');

    // Schema
    Route::get('schemas', [SchemaController::class, 'index'])->name('schema');
    Route::get('schema-preview/{id}', [SchemaController::class, 'schemaPreview'])->name('schema.preview');

    // Investment
    Route::post('invest-now', [InvestController::class, 'investNow'])->name('invest-now');
    Route::get('invest-logs', [InvestController::class, 'investLogs'])->name('invest-logs');
    // ROI collection removed - ROI will be sent by admin automatically

// ROI Status Check API
Route::get('/check-roi-status/{investmentId}', function($investmentId) {
    $investment = \App\Models\Invest::with(['activeRoiSchedule', 'readyRoiSchedule'])->find($investmentId);
    
    if (!$investment) {
        return response()->json(['status' => 'not_found']);
    }
    
    if ($investment->readyRoiSchedule) {
        return response()->json(['status' => 'ready']);
    } elseif ($investment->activeRoiSchedule) {
        return response()->json(['status' => 'pending']);
    }
    
    return response()->json(['status' => 'none']);
})->middleware('auth');
    Route::get('invest-cancel/{id}', [InvestController::class, 'investCancel'])->name('invest-cancel');

    // Transactions
    Route::get('transactions', [TransactionController::class, 'transactions'])->name('transactions');
    Route::get('api/transactions/latest', [TransactionController::class, 'latest'])->name('transactions.latest');

    // Investment Cancellation
    Route::post('investment/cancel', [\App\Http\Controllers\Frontend\InvestmentCancelController::class, 'cancelInvestment'])->name('investment.cancel');
    Route::get('investment/cancel/debug', [\App\Http\Controllers\Frontend\InvestmentCancelController::class, 'debugCancel'])->name('investment.cancel.debug');
    Route::post('investment/debug', [\App\Http\Controllers\Frontend\InvestmentCancelController::class, 'debugCancel'])->name('investment.debug');

    // Deposit
    Route::prefix('deposit')->name('deposit.')->group(function () {
        Route::get('', [DepositController::class, 'deposit'])->name('amount');
        Route::get('gateway/{code}', [GatewayController::class, 'gateway'])->name('gateway');
        Route::get('gateway-details/{id}', [GatewayController::class, 'gatewayDetails'])->name('gateway.details');
        Route::post('now', [DepositController::class, 'depositNow'])->name('now');
        Route::get('log', [DepositController::class, 'depositLog'])->name('log');
        Route::get('proof', [DepositController::class, 'depositProof'])->name('proof');
        Route::post('submit', [DepositController::class, 'depositSubmit'])->name('submit');
        Route::get('success', function(){
            return view('frontend.shahdeveloper.deposit.success');
        })->name('success');
        Route::post('gateway-details', [DepositController::class, 'getGatewayDetails'])->name('gateway-details');
    });

    // User Deposit Route (for user.deposit)
    Route::get('deposit', [DepositController::class, 'deposit'])->name('deposit');

    // Send Money (Profile Completion required)
    Route::middleware('ProfileCompletion')->prefix('send-money')->name('send-money.')->controller(SendMoneyController::class)->group(function () {
        Route::get('/', 'sendMoney')->name('view');
        Route::post('now', 'sendMoneyNow')->name('now');
        Route::get('log', 'sendMoneyLog')->name('log');
    });

    // Wallet Exchange
    Route::get('wallet-exchange', [UserController::class, 'walletExchange'])->name('wallet-exchange');
    Route::post('wallet-exchange-now', [UserController::class, 'walletExchangeNow'])->name('wallet-exchange-now');
    
    // Simple Withdraw System (Easy Method) - Profile Completion Required for Simple Withdraw
    Route::middleware('ProfileCompletionWithdraw')->prefix('withdraw/simple')->name('withdraw.simple.')->controller(\App\Http\Controllers\Frontend\SimpleWithdrawController::class)->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('store', 'store')->name('store');
        Route::get('success', 'success')->name('success');
        Route::get('history', 'history')->name('history');
    });
    
    
    // Withdraw (Profile Completion required)
    Route::middleware(['auth'])->prefix('withdraw')->name('withdraw.')->group(function () {
        Route::resource('account', WithdrawController::class)->except('show');
        Route::get('/', [WithdrawController::class, 'withdraw'])->name('view');
        Route::get('details/{accountId}/{amount?}', [WithdrawController::class, 'details'])->name('details');
        Route::get('method/{id}', [WithdrawController::class, 'withdrawMethod'])->name('method');
        Route::post('now', [WithdrawController::class, 'withdrawNow'])->name('now');
        Route::get('log', [WithdrawController::class, 'withdrawLog'])->name('log');
        Route::get('history', [WithdrawController::class, 'history'])->name('history');
        
        // OTP verification routes
        Route::get('verify-otp', [WithdrawController::class, 'showVerifyOtpForm'])->name('verify.otp');
        Route::post('verify-otp', [WithdrawController::class, 'verifyOtp'])->name('verify.otp');
        Route::post('resend-otp', [WithdrawController::class, 'resendOtp'])->name('resend-otp');
        
        // New Withdraw System
        Route::prefix('new')->name('new.')->controller(\App\Http\Controllers\Frontend\NewWithdrawController::class)->group(function () {
            Route::get('/', 'index')->name('index');
            Route::post('/', 'store')->name('store');
            Route::get('history', 'history')->name('history');
        });
        
        // Test route for withdrawal
        Route::get('test-withdraw', function() {
            $user = \App\Models\User::where('username', 'shahdeveloper77')->first();
            if (!$user) {
                return 'User not found';
            }
            
            // Add balance columns if they don't exist
            if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'balance')) {
                \Illuminate\Support\Facades\DB::statement('ALTER TABLE users ADD COLUMN balance DECIMAL(20,2) DEFAULT 0');
            }
            if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'profit_balance')) {
                \Illuminate\Support\Facades\DB::statement('ALTER TABLE users ADD COLUMN profit_balance DECIMAL(20,2) DEFAULT 0');
            }
            
            // Set balance to 100
            \Illuminate\Support\Facades\DB::table('users')->where('id', $user->id)->update(['balance' => 100]);
            $user->refresh();
            
            return "Balance set to: {$user->balance} for user: {$user->username}";
        })->name('test.withdraw');
    });


    // Email Check
    Route::get('exist/{email}', [UserController::class, 'userExist'])->name('exist');

    // Support Ticket
Route::prefix('support-ticket')->name('ticket.')->controller(TicketController::class)->group(function () {
    Route::get('index', 'index')->name('index');
    Route::get('logs', 'logs')->name('logs');
    Route::get('new', 'new')->name('new');
    Route::post('store', 'store')->name('store');
    Route::post('reply', 'reply')->name('reply');
    Route::get('show/{uuid}', 'show')->name('show');
    Route::get('close/{uuid}', 'closeNow')->name('close');
});

    // Referral
    Route::get('referral', [ReferralController::class, 'referral'])->name('referral');
    Route::get('referral-users', [ReferralController::class, 'referralUsers'])->name('referral.users');

    // Ranking Badge
    Route::get('ranking-badge', [UserController::class, 'rankingBadge'])->name('ranking-badge');

    // Achievement
    Route::get('achievement', [AchievementController::class, 'index'])->name('achievement');
    Route::post('achievement/check-rank', [AchievementController::class, 'checkAndUpdateRank'])->name('achievement.check-rank');
    Route::post('achievement/process-rank-up', [AchievementController::class, 'processRankUp'])->name('achievement.process-rank-up');
    Route::post('achievement/collect', [AchievementController::class, 'collectReward'])->name('achievement.collect');
    Route::post('achievement/salary', [AchievementController::class, 'collectSalary'])->name('achievement.salary');

    // ROI Collection
    Route::get('collect-roi', [RoiCollectionController::class, 'index'])->name('collect-roi');
    Route::post('roi/collect', [RoiCollectionController::class, 'collectRoi'])->name('roi.collect');
    Route::post('roi/collect-all', [RoiCollectionController::class, 'collectAllRoi'])->name('roi.collect-all');
    Route::get('roi/stats', [RoiCollectionController::class, 'getRoiStats'])->name('roi.stats');
    Route::get('roi/get-schedule/{investmentId}', [RoiCollectionController::class, 'getReadySchedule'])->name('roi.get-schedule');

    // Referral Tree
    Route::get('referral-tree', [App\Http\Controllers\Frontend\ReferralTreeController::class, 'index'])->name('referral-tree');
    Route::get('referral-tree/details', [App\Http\Controllers\Frontend\ReferralTreeController::class, 'getReferralDetails'])->name('referral-tree.details');

    // Settings
    Route::prefix('settings')->name('setting.')->controller(SettingController::class)->group(function () {
        Route::get('/', 'settings')->name('show')->withoutMiddleware('2fa');
        Route::get('2fa', 'twoFa')->name('2fa')->withoutMiddleware('2fa');
        Route::post('action-2fa', 'actionTwoFa')->name('action-2fa')->withoutMiddleware('2fa');
        Route::post('profile-update', 'profileUpdate')->name('profile-update');
        Route::post('/2fa/verify', fn() => redirect(route('user.dashboard')))->name('2fa.verify');
    });

    // User Transfer
    Route::get('transfer', [UserTransferController::class, 'showTransferForm'])->name('transfer');
    Route::post('transfer', [UserTransferController::class, 'transfer'])->name('transfer.submit');
    
    // Shah Developer Transfer System
    Route::prefix('shah')->name('shah.')->controller(ShahTransferController::class)->group(function () {
        Route::get('transfer', 'index')->name('transfer');
        Route::post('transfer', 'transfer')->name('transfer.submit');
        Route::get('transfer/history', 'history')->name('transfer.history');
        Route::post('wallet-exchange', 'walletExchange')->name('wallet.exchange');
    });
});

// Language & Theme
Route::get('language-update', [HomeController::class, 'languageUpdate'])->name('language-update');
Route::get('theme-mode', [HomeController::class, 'themeMode'])->name('mode-theme');

// Gateway
Route::get('gateway-list', [GatewayController::class, 'gatewayList'])->name('gateway.list')->middleware('XSS', 'translate', 'auth');

// Status Routes
Route::prefix('status')->name('status.')->controller(StatusController::class)->group(function () {
    Route::match(['get', 'post'], '/success', 'success')->name('success');
    Route::match(['get', 'post'], '/cancel', 'cancel')->name('cancel');
    Route::match(['get', 'post'], '/pending', 'pending')->name('pending');
});

// IPN Routes
Route::prefix('ipn')->name('ipn.')->controller(IpnController::class)->group(function () {
    Route::post('coinpayments', 'coinpaymentsIpn')->name('coinpayments');
    Route::post('nowpayments', 'nowpaymentsIpn')->name('nowpayments');
    Route::post('cryptomus', 'cryptomusIpn')->name('cryptomus');
    Route::get('paypal', 'paypalIpn')->name('paypal');
    Route::post('mollie', 'mollieIpn')->name('mollie');
    Route::any('perfectmoney', 'perfectMoneyIpn')->name('perfectMoney');
    Route::get('paystack', 'paystackIpn')->name('paystack');
    Route::get('flutterwave', 'flutterwaveIpn')->name('flutterwave');
    Route::post('coingate', 'coingateIpn')->name('coingate');
    Route::get('monnify', 'monnifyIpn')->name('monnify');
    Route::get('non-hosted-securionpay', 'nonHostedSecurionpayIpn')->name('non-hosted.securionpay')->middleware(['auth', 'XSS']);
    Route::post('coinremitter', 'coinremitterIpn')->name('coinremitter');
    Route::post('btcpay', 'btcpayIpn')->name('btcpay');
    Route::post('binance', 'binanceIpn')->name('binance');
    Route::get('blockchain', 'blockchainIpn')->name('blockchain');
    Route::get('instamojo', 'instamojoIpn')->name('instamojo');
    Route::post('paytm', 'paytmIpn')->name('paytm');
    Route::post('razorpay', 'razorpayIpn')->name('razorpay');
    Route::post('twocheckout', 'twocheckoutIpn')->name('twocheckout');
});

// Public schema select and notification tune
Route::get('schema-select/{id}', [SchemaController::class, 'schemaSelect'])->name('user.schema.select');
Route::get('notification-tune', [AppController::class, 'notificationTune'])->name('notification-tune');

// Cron Jobs
Route::get('cron-job/investment', [CronJobController::class, 'investmentCronJob'])->name('cron-job.investment');
Route::get('cron-job/referral', [CronJobController::class, 'referralCronJob'])->name('cron-job.referral');
Route::get('cron-job/user-ranking', [CronJobController::class, 'userRanking'])->name('cron-job.user-ranking');
Route::get('cron-job/queue', [CronJobController::class, 'queueWork']);

// Announcement API Routes
Route::prefix('api/announcements')->name('announcement.')->controller(\App\Http\Controllers\Frontend\AnnouncementController::class)->group(function () {
    Route::get('popup', 'getPopupAnnouncements')->name('popup');
    Route::get('active', 'getActiveAnnouncements')->name('active');
    Route::get('type/{type}', 'getAnnouncementsByType')->name('by-type');
});


// Announcement API Routes
Route::prefix('api/announcements')->name('announcement.')->controller(\App\Http\Controllers\Frontend\AnnouncementController::class)->group(function () {
    Route::get('popup', 'getPopupAnnouncements')->name('popup');
    Route::get('active', 'getActiveAnnouncements')->name('active');
    Route::get('type/{type}', 'getAnnouncementsByType')->name('by-type');
});



// Announcement API Routes
Route::prefix('api/announcements')->name('announcement.')->controller(\App\Http\Controllers\Frontend\AnnouncementController::class)->group(function () {
    Route::get('popup', 'getPopupAnnouncements')->name('popup');
    Route::get('active', 'getActiveAnnouncements')->name('active');
    Route::get('type/{type}', 'getAnnouncementsByType')->name('by-type');
});



// Announcement API Routes
Route::prefix('api/announcements')->name('announcement.')->controller(\App\Http\Controllers\Frontend\AnnouncementController::class)->group(function () {
    Route::get('popup', 'getPopupAnnouncements')->name('popup');
    Route::get('active', 'getActiveAnnouncements')->name('active');
    Route::get('type/{type}', 'getAnnouncementsByType')->name('by-type');
});



