<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

// Total users per rank
$rows = DB::table('users')
    ->leftJoin('rankings', 'rankings.id', '=', 'users.ranking_id')
    ->select(DB::raw('COALESCE(rankings.ranking_name, "NO RANK") as rank_name'), DB::raw('COUNT(users.id) as total'))
    ->groupBy('rank_name')
    ->orderBy('total', 'desc')
    ->get();

echo "Users per rank:\n";
foreach ($rows as $row) {
    echo str_pad($row->rank_name, 25) . ": " . $row->total . "\n";
}

// Optional: top 10 users with their rank names
$top = DB::table('users')
    ->leftJoin('rankings', 'rankings.id', '=', 'users.ranking_id')
    ->select('users.id','users.username','rankings.ranking_name')
    ->orderBy('users.id','asc')
    ->limit(10)
    ->get();

echo "\nSample users:\n";
foreach ($top as $u) {
    echo "#{$u->id} {$u->username} - " . ($u->ranking_name ?? 'NO RANK') . "\n";
}


