<?php

use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "Starting next_profit_time realignment...\n";

$updated = 0;
$skipped = 0;
$errors = 0;

/** @var \Illuminate\Database\Eloquent\Collection $investments */
$investments = \App\Models\Invest::with(['schema'])
    ->where('status', 'ongoing')
    ->get();

foreach ($investments as $investment) {
    try {
        $scheduleMinutes = optional(optional($investment->schema)->schedule)->time
            ?? ($investment->period_hours ? $investment->period_hours * 60 : 1440);

        if ($scheduleMinutes <= 0) {
            $scheduleMinutes = 1440; // fallback safety
        }

        $anchorStart = Carbon::parse($investment->created_at);
        $now = Carbon::now();
        $elapsedMinutes = max(0, $anchorStart->diffInMinutes($now));
        $cyclesElapsed = intdiv($elapsedMinutes, $scheduleMinutes);
        $nextWindowStart = $anchorStart->copy()->addMinutes(($cyclesElapsed + 1) * $scheduleMinutes);

        // Only update if different or null (handle string datetime)
        $currentNext = $investment->next_profit_time ? Carbon::parse($investment->next_profit_time) : null;
        if (!$currentNext || $currentNext->ne($nextWindowStart)) {
            $investment->update([
                'next_profit_time' => $nextWindowStart,
            ]);
            $updated++;
        } else {
            $skipped++;
        }
    } catch (\Throwable $e) {
        $errors++;
        echo "Error on investment ID {$investment->id}: {$e->getMessage()}\n";
    }
}

echo "Realignment complete. Updated: {$updated}, Skipped: {$skipped}, Errors: {$errors}\n";


