<?php

use Carbon\Carbon;

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "Starting ROI schedules realignment...\n";

$updated = 0;
$skipped = 0;
$errors = 0;

$investments = \App\Models\Invest::with(['schema'])
    ->where('status', 'ongoing')
    ->get();

foreach ($investments as $investment) {
    try {
        $rawTime = optional($investment->schema->schedule)->time ?? ($investment->period_hours ?: 24);
        $minutes = $rawTime > 48 ? $rawTime : ($rawTime * 60); // normalize (<=48 treated as hours)
        if ($minutes <= 0) { $minutes = 1440; }

        $anchor = Carbon::parse($investment->created_at);

        $schedules = \App\Models\RoiSchedule::where('invest_id', $investment->id)
            ->where('status', 'pending')
            ->orderBy('roi_cycle')
            ->get();

        if ($schedules->isEmpty()) { $skipped++; continue; }

        foreach ($schedules as $s) {
            $idx = max(0, ($s->roi_cycle - 1));
            $start = $anchor->copy()->addMinutes($idx * $minutes);
            $end = $anchor->copy()->addMinutes(($idx + 1) * $minutes);
            $s->update([
                'roi_start_time' => $start,
                'roi_end_time' => $end,
            ]);
            $updated++;
        }
    } catch (\Throwable $e) {
        $errors++;
        echo "Error on investment ID {$investment->id}: {$e->getMessage()}\n";
    }
}

echo "Schedules realignment complete. Updated rows: {$updated}, Skipped investments: {$skipped}, Errors: {$errors}\n";


