<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

// Goal: Ensure all ROI schedules are 24h cycles.
// Rules:
// - For any schedule with status 'pending': set roi_end_time = roi_start_time + 1440 minutes.
// - For any schedule with status 'ready' or 'sent': leave as-is.
// - For any schedule with invalid short duration (< 60 mins) or non-24h: normalize to 1440.

$fixed = 0;
$checked = 0;

$schedules = DB::table('roi_schedules')->select('id','roi_start_time','roi_end_time','status')->orderBy('id')->chunk(1000, function($chunk) use (&$fixed, &$checked) {
    foreach ($chunk as $row) {
        $checked++;
        if ($row->status === 'pending') {
            $start = \Carbon\Carbon::parse($row->roi_start_time);
            $end = \Carbon\Carbon::parse($row->roi_end_time);
            $diff = $start->diffInMinutes($end, false);
            if ($diff !== 1440) {
                $newEnd = $start->copy()->addMinutes(1440);
                DB::table('roi_schedules')->where('id', $row->id)->update([
                    'roi_end_time' => $newEnd,
                ]);
                $fixed++;
            }
        }
    }
});

echo "Checked: {$checked}\n";
echo "Fixed (normalized to 24h): {$fixed}\n";


