<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

// Find IDs for TEAM LEADER and SALE MANAGER ranks
$rankIds = DB::table('rankings')
    ->whereIn('ranking_name', ['TEAM LEADER','SALE MANAGER'])
    ->pluck('id')
    ->all();

$affected = 0;
if (!empty($rankIds)) {
    $affected = DB::table('users')
        ->whereIn('ranking_id', $rankIds)
        ->update(['ranking_id' => 0]); // 0 corresponds to NO RANK
}

echo "Users demoted to NO RANK: {$affected}\n";


