<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

// Set all schemas to 24 hours period
$updatedSchemas = DB::table('schemas')->update([
    'roi_period' => 24,
]);

// If legacy column exists, try to update it too
try {
    DB::statement("UPDATE schemas SET period_hours = 24");
    $legacyUpdated = true;
} catch (\Throwable $e) {
    $legacyUpdated = false;
}

// Normalize all pending ROI schedules to 24h
$updatedSchedules = DB::table('roi_schedules')
    ->where('status', 'pending')
    ->update([
        'roi_end_time' => DB::raw("DATE_ADD(roi_start_time, INTERVAL 1440 MINUTE)")
    ]);

echo "Schemas set to 24h: {$updatedSchemas}\n";
echo "Legacy period_hours updated: " . ($legacyUpdated ? 'yes' : 'no') . "\n";
echo "Pending schedules normalized to 24h: {$updatedSchedules}\n";


