<?php $__env->startSection('content'); ?>
<div class="page-container">
    <div class="page-header">
        <button class="back-btn" onclick="window.history.back()">
            <i class="fas fa-arrow-left"></i>
        </button>
        <h2>Deposit Funds</h2>
    </div>
    <div class="deposit-container">
        <form action="<?php echo e(route('user.deposit.now')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="gateway_code" id="gateway_code_input" value="">
        <div class="amount-input glass-effect">
            <label>Amount to Deposit</label>
            <div class="input-wrapper">
                <span class="currency">$</span>
                    <input type="number" name="amount" placeholder="0.00" id="deposit-amount" step="0.01" min="1" oninput="this.value = validateDouble(this.value)">
            </div>
                <div class="input-info-text min-max"></div>
        </div>
        
        <div class="payment-methods">
            <h3>Select Payment Method</h3>
            <div class="method-list">
                <?php $__empty_1 = true; $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="payment-method glass-effect <?php echo e($loop->first ? 'active' : ''); ?>" data-method="<?php echo e($gateway->gateway_code); ?>" data-gateway-id="<?php echo e($gateway->id); ?>">
                    <div class="gateway-icon">
                        <?php if($gateway->logo): ?>
                            <img src="<?php echo e(asset($gateway->logo)); ?>" alt="<?php echo e($gateway->name); ?>" style="width: 24px; height: 24px; border-radius: 4px;">
                        <?php else: ?>
                            <i class="fas fa-credit-card"></i>
                        <?php endif; ?>
                    </div>
                    <span><?php echo e($gateway->name); ?></span>
                    <i class="fas fa-check"></i>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="no-gateways glass-effect">
                    <div class="no-gateways-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <h4>No Payment Methods Available</h4>
                    <p>Please contact administrator to add payment methods.</p>
                </div>
                <?php endif; ?>
            </div>
                <div class="input-info-text charge"></div>
            </div>
            
            
            <div class="deposit-summary glass-effect" id="deposit-summary" style="display: none;">
                <h3>Deposit Summary</h3>
                <div class="summary-details">
                    <div class="summary-row">
                        <span>Amount:</span>
                        <span class="amount-display">$0.00</span>
                    </div>
                    <div class="summary-row">
                        <span>Charge:</span>
                        <span class="charge-display">$0.00</span>
                    </div>
                    <div class="summary-row">
                        <span>Total:</span>
                        <span class="total-display">$0.00</span>
                    </div>
                    <div class="summary-row conversion-rate-row" id="conversion-rate-row" style="display: none;">
                        <span>Conversion Rate:</span>
                        <span class="conversion-rate-display">1 USD = 1 USD</span>
                    </div>
                    <div class="summary-row">
                        <span>Pay Amount:</span>
                        <span class="pay-amount-display">$0.00</span>
                    </div>
                </div>
        </div>
        
            <button type="submit" class="btn-primary deposit-btn" onclick="validateForm(event)">Deposit Now</button>
        </form>
    </div>
</div>

<style>
.page-container {
    padding: 20px;
    max-width: 500px;
    margin: 0 auto;
}

.page-header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
}

.back-btn {
    background: none;
    border: none;
    color: #fff;
    font-size: 18px;
    margin-right: 15px;
    cursor: pointer;
    padding: 8px;
    border-radius: 8px;
    transition: background 0.3s ease;
}

.back-btn:hover {
    background: rgba(255, 255, 255, 0.1);
}

.page-header h2 {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.deposit-container {
    display: flex;
    flex-direction: column;
    gap: 30px;
}

.amount-input {
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.amount-input label {
    display: block;
    margin-bottom: 10px;
    font-weight: 600;
    color: #fff;
}

.input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.currency {
    position: absolute;
    left: 15px;
    font-size: 18px;
    font-weight: 600;
    color: #00d4ff;
    z-index: 2;
}

.input-wrapper input {
    width: 100%;
    padding: 15px 15px 15px 40px;
    border: 2px solid rgba(255, 255, 255, 0.2);
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    outline: none;
    transition: all 0.3s ease;
}

.input-wrapper input:focus {
    border-color: #00d4ff;
    box-shadow: 0 0 20px rgba(0, 212, 255, 0.3);
}

.input-wrapper input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.payment-methods h3 {
    margin-bottom: 15px;
    color: #fff;
    font-weight: 600;
}

.method-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.payment-method {
    display: flex;
    align-items: center;
    padding: 15px 20px;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 2px solid rgba(255, 255, 255, 0.2);
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
}

.payment-method:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateY(-2px);
}

.payment-method.active {
    border-color: #00d4ff;
    background: rgba(0, 212, 255, 0.1);
}

.payment-method i:first-child,
.gateway-icon {
    font-size: 20px;
    margin-right: 15px;
    color: #00d4ff;
    display: flex;
    align-items: center;
    justify-content: center;
}

.no-gateways {
    text-align: center;
    padding: 40px 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.no-gateways-icon {
    font-size: 32px;
    color: rgba(255, 193, 7, 0.8);
    margin-bottom: 15px;
}

.no-gateways h4 {
    color: #fff;
    margin-bottom: 8px;
    font-weight: 600;
}

.no-gateways p {
    color: rgba(255, 255, 255, 0.7);
    font-size: 14px;
}

.deposit-summary {
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    margin-bottom: 20px;
}

.deposit-summary h3 {
    color: #fff;
    margin-bottom: 15px;
    font-weight: 600;
}

.summary-details {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.summary-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.summary-row:last-child {
    border-bottom: none;
    font-weight: 600;
    font-size: 1.1rem;
}

.conversion-rate-row {
    background: rgba(0, 212, 255, 0.1);
    border-radius: 8px;
    padding: 8px 12px;
    margin: 5px 0;
    border: 1px solid rgba(0, 212, 255, 0.3);
}

.conversion-rate-row span:first-child {
    color: #00d4ff !important;
    font-weight: 600;
}

.conversion-rate-row span:last-child {
    color: #00ff88 !important;
    font-weight: 600;
}

.summary-row span:first-child {
    color: rgba(255, 255, 255, 0.8);
}

.summary-row span:last-child {
    color: #00ff88;
    font-weight: 500;
}
}

.payment-method span {
    flex: 1;
    color: #fff;
    font-weight: 500;
}

.payment-method i:last-child {
    color: #00d4ff;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.payment-method.active i:last-child {
    opacity: 1;
}

.deposit-btn {
    width: 100%;
    padding: 15px;
    border: none;
    border-radius: 10px;
    background: linear-gradient(135deg, #00d4ff, #0099cc);
    color: #fff;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.deposit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 212, 255, 0.4);
}

.deposit-btn:active {
    transform: translateY(0);
}

@media (max-width: 768px) {
    .page-container {
        padding: 15px;
    }
    
    .amount-input, .payment-method {
        padding: 15px;
    }
    
    .input-wrapper input {
        font-size: 16px;
        padding: 12px 12px 12px 35px;
    }
    
    .currency {
        left: 12px;
        font-size: 16px;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Payment method selection
    const paymentMethods = document.querySelectorAll('.payment-method');
    paymentMethods.forEach(method => {
        method.addEventListener('click', function() {
            paymentMethods.forEach(m => m.classList.remove('active'));
            this.classList.add('active');
        });
    });
    
    // Amount input formatting
    const amountInput = document.getElementById('deposit-amount');
    amountInput.addEventListener('input', function() {
        let value = this.value;
        if (value < 0) {
            this.value = 0;
        }
    });
});

var globalData;
var currency = '<?php echo e(setting("currency_symbol", "global")); ?>';

// Payment method selection
document.querySelectorAll('.payment-method').forEach(method => {
    method.addEventListener('click', function() {
        // Remove active class from all methods
        document.querySelectorAll('.payment-method').forEach(m => m.classList.remove('active'));
        // Add active class to clicked method
        this.classList.add('active');
        
        // Get gateway code
        const gatewayCode = this.dataset.method;
        const gatewayId = this.dataset.gatewayId;
        
        // Set hidden input for gateway_code
        document.getElementById('gateway_code_input').value = gatewayCode;
        
        // Fetch gateway details
        fetchGatewayDetails(gatewayCode);
    });
});

// Auto-select first payment method on page load
document.addEventListener('DOMContentLoaded', function() {
    const firstMethod = document.querySelector('.payment-method');
    if (firstMethod) {
        firstMethod.click();
    }
});

function fetchGatewayDetails(gatewayCode) {
    console.log('Fetching gateway details for:', gatewayCode);
    const url = '<?php echo e(route("user.deposit.gateway", ":code")); ?>'.replace(':code', gatewayCode);
    console.log('URL:', url);
    
    fetch(url)
        .then(response => {
            console.log('Response status:', response.status);
            return response.json();
        })
        .then(data => {
            console.log('Gateway data received:', data);
            globalData = data;
            
            // Update charge info
            const chargeText = 'Charge ' + data.charge + ' ' + (data.charge_type === 'percentage' ? ' % ' : currency);
            document.querySelector('.charge').textContent = chargeText;
            
            // Update min-max info
            const minMaxText = 'Minimum ' + data.minimum_deposit + ' ' + currency + ' and Maximum ' + data.maximum_deposit + ' ' + currency;
            document.querySelector('.min-max').textContent = minMaxText;
            
            // Update conversion rate display
            const conversionRateRow = document.getElementById('conversion-rate-row');
            const conversionRateDisplay = document.querySelector('.conversion-rate-display');
            
            if (data.rate && data.rate != 1) {
                // Show conversion rate if it's different from 1
                conversionRateDisplay.textContent = `1 ${currency} = ${data.rate} ${data.currency}`;
                conversionRateRow.style.display = 'flex';
            } else {
                // Hide conversion rate if it's 1 (same currency)
                conversionRateRow.style.display = 'none';
            }
            
            // Show deposit summary
            document.getElementById('deposit-summary').style.display = 'block';
            
            // Store payment details for proof page
            if (data.credentials !== undefined) {
                sessionStorage.setItem('paymentDetails', data.credentials);
            }
            
            // Calculate if amount is already entered
            const amount = document.getElementById('deposit-amount').value;
            if (amount && amount > 0) {
                calculateDeposit(amount);
            }
        })
        .catch(error => {
            console.error('Error fetching gateway details:', error);
            alert('Error loading gateway details. Please try again.');
        });
}

// Amount input handler
document.getElementById('deposit-amount').addEventListener('keyup', function() {
    const amount = this.value;
    if (globalData && amount > 0) {
        calculateDeposit(amount);
    }
});

function calculateDeposit(amount) {
    if (!globalData) return;
    
    // Calculate charge
    const charge = globalData.charge_type === 'percentage' ? 
        (amount * globalData.charge / 100) : 
        globalData.charge;
    
    // Calculate total
    const total = parseFloat(amount) + parseFloat(charge);
    
    // Calculate pay amount
    const payAmount = total * globalData.rate;
    
    // Update display
    document.querySelector('.amount-display').textContent = '$' + parseFloat(amount).toFixed(2);
    document.querySelector('.charge-display').textContent = '$' + parseFloat(charge).toFixed(2);
    document.querySelector('.total-display').textContent = '$' + total.toFixed(2);
    document.querySelector('.pay-amount-display').textContent = payAmount.toFixed(2) + ' ' + globalData.currency;
}

function validateDouble(value) {
    return value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');
}

function validateForm(event) {
    const amount = document.getElementById('deposit-amount').value;
    const gatewayCode = document.getElementById('gateway_code_input').value;
    
    console.log('Validating form - Amount:', amount, 'Gateway:', gatewayCode);
    console.log('Amount type:', typeof amount, 'Amount value:', amount);
    
    if (!amount || amount <= 0) {
        event.preventDefault();
        alert('Please enter a valid amount');
        return false;
    }
    
    if (!gatewayCode) {
        event.preventDefault();
        alert('Please select a payment method');
        return false;
    }
    
    if (!globalData) {
        event.preventDefault();
        alert('Please select a payment method first');
        return false;
    }
    
    // Check amount limits
    if (parseFloat(amount) < globalData.minimum_deposit) {
        event.preventDefault();
        alert('Amount must be at least ' + globalData.minimum_deposit);
        return false;
    }
    
    if (parseFloat(amount) > globalData.maximum_deposit) {
        event.preventDefault();
        alert('Amount must not exceed ' + globalData.maximum_deposit);
        return false;
    }
    
    console.log('Form validation passed, submitting...');
    return true;
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/deposit/index.blade.php ENDPATH**/ ?>