

<?php $__env->startSection('title', 'Ranks & Rewards'); ?>

<?php $__env->startSection('content'); ?>
<div class="ranks-rewards-container">
    <!-- Page Header -->
    <div class="page-header">
        <div class="header-content">
            <h1 class="page-title">
                <i class="fas fa-trophy"></i>
                Ranks & Rewards
            </h1>
            <p class="page-subtitle">Unlock exclusive rewards and benefits by achieving higher ranks</p>
        </div>
    </div>


    <!-- Ranks Grid -->
    <div class="ranks-section">
        <div class="section-header">
            <h2>Available Ranks</h2>
            <p>Choose your path to success and unlock amazing rewards</p>
        </div>
        
        <div class="ranks-grid">
            <?php if($rankings->count() > 0): ?>
                <?php $__currentLoopData = $rankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $ranking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="rank-card <?php echo e($userRanking && $userRanking->id == $ranking->id ? 'current-rank' : ''); ?>">
                <div class="rank-header">
                    <div class="rank-icon-container">
                        <img src="<?php echo e(asset($ranking->icon)); ?>" alt="<?php echo e($ranking->ranking_name); ?>" class="rank-icon">
                        <div class="rank-level">Level <?php echo e($ranking->ranking); ?></div>
                    </div>
                    <div class="rank-badge <?php echo e($userRanking && $userRanking->id == $ranking->id ? 'achieved' : 'locked'); ?>">
                        <?php if($userRanking && $userRanking->id == $ranking->id): ?>
                            <i class="fas fa-check-circle"></i>
                            <span>Achieved</span>
                        <?php else: ?>
                            <i class="fas fa-lock"></i>
                            <span>Locked</span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="rank-content">
                    <h3 class="rank-name"><?php echo e($ranking->ranking_name); ?></h3>
                    
                    <?php if($ranking->description): ?>
                    <p class="rank-description"><?php echo e($ranking->description); ?></p>
                    <?php endif; ?>
                    
                    <!-- Requirements -->
                    <div class="requirements-section">
                        <h4>Requirements</h4>
                        <div class="requirements-list">
                            <?php if($ranking->minimum_earnings > 0): ?>
                            <div class="requirement">
                                <i class="fas fa-dollar-sign"></i>
                                <span>Minimum Earnings: <?php echo e($currencySymbol); ?><?php echo e(number_format($ranking->minimum_earnings)); ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if($ranking->minimum_deposit > 0): ?>
                            <div class="requirement">
                                <i class="fas fa-credit-card"></i>
                                <span>Minimum Deposits: <?php echo e($currencySymbol); ?><?php echo e(number_format($ranking->minimum_deposit)); ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if($ranking->minimum_invest > 0): ?>
                            <div class="requirement">
                                <i class="fas fa-chart-line"></i>
                                <span>Minimum Investments: <?php echo e($currencySymbol); ?><?php echo e(number_format($ranking->minimum_invest)); ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if($ranking->minimum_referral > 0): ?>
                            <div class="requirement">
                                <i class="fas fa-users"></i>
                                <span>Minimum Referrals: <?php echo e($ranking->minimum_referral); ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if($ranking->minimum_referral_deposit > 0): ?>
                            <div class="requirement">
                                <i class="fas fa-user-plus"></i>
                                <span>Referral Deposits: <?php echo e($currencySymbol); ?><?php echo e(number_format($ranking->minimum_referral_deposit)); ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if($ranking->minimum_referral_invest > 0): ?>
                            <div class="requirement">
                                <i class="fas fa-handshake"></i>
                                <span>Referral Investments: <?php echo e($currencySymbol); ?><?php echo e(number_format($ranking->minimum_referral_invest)); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Rewards -->
                    <div class="rewards-section">
                        <h4>Rewards</h4>
                        <div class="rewards-grid">
                            <?php if($ranking->bonus > 0): ?>
                            <div class="reward-item">
                                <i class="fas fa-gift"></i>
                                <div class="reward-info">
                                    <span class="reward-label">Bonus</span>
                                    <span class="reward-value"><?php echo e($currencySymbol); ?><?php echo e(number_format($ranking->bonus)); ?></span>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if($ranking->salary > 0): ?>
                            <div class="reward-item">
                                <i class="fas fa-coins"></i>
                                <div class="reward-info">
                                    <span class="reward-label">Salary</span>
                                    <span class="reward-value"><?php echo e($currencySymbol); ?><?php echo e(number_format($ranking->salary)); ?></span>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <div style="text-align: center; padding: 3rem; color: var(--text-secondary);">
                <i class="fas fa-exclamation-triangle" style="font-size: 3rem; color: #ffc107; margin-bottom: 1rem;"></i>
                <h3>No Active Rankings Found</h3>
                <p>Please contact administrator to set up rankings.</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.ranks-rewards-container {
    padding: 0 20px;
    max-width: 1400px;
    margin: 0 auto;
}

.page-header {
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.1), rgba(107, 70, 193, 0.1));
    backdrop-filter: blur(20px);
    border-radius: 25px;
    border: 2px solid rgba(30, 64, 175, 0.3);
    padding: 3rem 2rem;
    margin-bottom: 3rem;
    text-align: center;
    position: relative;
    overflow: hidden;
    box-shadow: 
        0 20px 40px rgba(30, 64, 175, 0.1),
        inset 0 1px 0 rgba(255, 255, 255, 0.1);
}

.page-header::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(30, 64, 175, 0.05) 0%, transparent 70%);
    animation: float 6s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translateY(0px) rotate(0deg); }
    50% { transform: translateY(-20px) rotate(180deg); }
}

.page-title {
    color: var(--text-primary);
    font-size: 3rem;
    font-weight: 800;
    margin: 0 0 1rem 0;
    background: linear-gradient(135deg,rgb(255, 255, 255),rgb(162, 0, 255),rgb(0, 204, 255));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 1rem;
    text-shadow: 0 0 30px rgba(30, 64, 175, 0.3);
    position: relative;
    z-index: 2;
}

.page-subtitle {
    color: var(--text-secondary);
    font-size: 1.2rem;
    margin: 0;
    position: relative;
    z-index: 2;
}

.ranks-section {
    background: linear-gradient(135deg, rgba(255, 255, 255, 0.05), rgba(255, 255, 255, 0.02));
    backdrop-filter: blur(20px);
    border-radius: 25px;
    border: 2px solid rgba(30, 64, 175, 0.2);
    padding: 3rem 2rem;
    box-shadow: 
        0 20px 40px rgba(0, 0, 0, 0.1),
        inset 0 1px 0 rgba(255, 255, 255, 0.1);
}

.section-header {
    text-align: center;
    margin-bottom: 4rem;
}

.section-header h2 {
    color: var(--text-primary);
    font-size: 2.5rem;
    font-weight: 800;
    margin: 0 0 1rem 0;
    background: linear-gradient(135deg,rgb(255, 255, 255),rgb(255, 255, 255));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.section-header p {
    color: var(--text-secondary);
    font-size: 1.2rem;
    margin: 0;
}

.ranks-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(450px, 1fr));
    gap: 2.5rem;
}

.rank-card {
    background: linear-gradient(135deg, rgba(255, 255, 255, 0.08), rgba(255, 255, 255, 0.03));
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    padding: 2.5rem;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    box-shadow: 
        0 15px 35px rgba(0, 0, 0, 0.1),
        inset 0 1px 0 rgba(255, 255, 255, 0.1);
}

.rank-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.05), rgba(107, 70, 193, 0.05));
    opacity: 0;
    transition: opacity 0.3s ease;
    border-radius: 25px;
}

.rank-card:hover::before {
    opacity: 1;
}

.rank-card:hover {
    border-color: rgba(30, 64, 175, 0.4);
    transform: translateY(-5px);
    box-shadow: 
        0 15px 30px rgba(30, 64, 175, 0.2),
        0 0 0 1px rgba(30, 64, 175, 0.1);
}

.rank-card.current-rank {
    border-color: rgba(30, 64, 175, 0.6);
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.1), rgba(107, 70, 193, 0.05));
    box-shadow: 
        0 20px 40px rgba(30, 64, 175, 0.2),
        inset 0 1px 0 rgba(255, 255, 255, 0.2);
}

.rank-card.current-rank::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(135deg, #1e40af, #6b46c1);
    border-radius: 25px 25px 0 0;
}

.rank-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 2rem;
    position: relative;
    z-index: 2;
}

.rank-icon-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 1rem;
}

.rank-icon {
    width: 100px;
    height: 100px;
    object-fit: contain;
    filter: drop-shadow(0 8px 16px rgba(0, 0, 0, 0.3));
    transition: transform 0.3s ease;
}

.rank-card:hover .rank-icon {
    transform: rotate(5deg);
}

.rank-level {
    color: var(--text-secondary);
    font-size: 1rem;
    font-weight: 700;
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.2), rgba(107, 70, 193, 0.2));
    padding: 0.5rem 1rem;
    border-radius: 20px;
    border: 1px solid rgba(30, 64, 175, 0.3);
    box-shadow: 0 4px 8px rgba(30, 64, 175, 0.1);
}

.rank-badge {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem 1.5rem;
    border-radius: 25px;
    font-size: 0.9rem;
    font-weight: 700;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.rank-badge.achieved {
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.2), rgba(107, 70, 193, 0.2));
    color: #1e40af;
    border: 2px solid rgba(30, 64, 175, 0.4);
    box-shadow: 0 4px 8px rgba(30, 64, 175, 0.2);
}

.rank-badge.locked {
    background: linear-gradient(135deg, rgba(255, 193, 7, 0.2), rgba(255, 152, 0, 0.2));
    color: #ffc107;
    border: 2px solid rgba(255, 193, 7, 0.4);
    box-shadow: 0 4px 8px rgba(255, 193, 7, 0.2);
}

.rank-content {
    display: flex;
    flex-direction: column;
    gap: 2rem;
    position: relative;
    z-index: 2;
}

.rank-name {
    color: var(--text-primary);
    font-size: 1.8rem;
    font-weight: 800;
    margin: 0;
    text-align: center;
    background: linear-gradient(135deg,rgb(255, 255, 255),rgb(255, 255, 255));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.rank-description {
    color: var(--text-secondary);
    font-size: 1.1rem;
    margin: 0;
    text-align: center;
    line-height: 1.6;
}

.requirements-section,
.rewards-section {
    background: linear-gradient(135deg, rgba(255, 255, 255, 0.08), rgba(255, 255, 255, 0.03));
    border-radius: 20px;
    padding: 2rem;
    border: 1px solid rgba(255, 255, 255, 0.1);
    box-shadow: 
        0 8px 16px rgba(0, 0, 0, 0.1),
        inset 0 1px 0 rgba(255, 255, 255, 0.1);
}

.requirements-section h4,
.rewards-section h4 {
    color: var(--text-primary);
    font-size: 1.4rem;
    font-weight: 700;
    margin: 0 0 1.5rem 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.requirements-section h4::before {
    content: '📋';
    font-size: 1.3rem;
}

.rewards-section h4::before {
    content: '🎁';
    font-size: 1.3rem;
}

.requirements-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.requirement {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.1), rgba(107, 70, 193, 0.05));
    border-radius: 15px;
    border: 1px solid rgba(30, 64, 175, 0.2);
    transition: all 0.3s ease;
}

.requirement:hover {
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.15), rgba(107, 70, 193, 0.1));
    transform: translateX(3px);
}

.requirement i {
    color:rgb(0, 217, 255);
    font-size: 1.2rem;
    width: 24px;
    text-align: center;
}

.requirement span {
    color: var(--text-primary);
    font-size: 1rem;
    font-weight: 600;
}

.rewards-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 1.5rem;
}

.reward-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.5rem;
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.15), rgba(107, 70, 193, 0.1));
    border-radius: 15px;
    border: 2px solid rgba(30, 64, 175, 0.3);
    transition: all 0.3s ease;
    box-shadow: 0 8px 16px rgba(30, 64, 175, 0.1);
}

.reward-item:hover {
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.2), rgba(107, 70, 193, 0.15));
    transform: translateY(-2px);
    box-shadow: 0 10px 20px rgba(30, 64, 175, 0.2);
}

.reward-item i {
    color:rgb(0, 238, 255);
    font-size: 1.5rem;
}

.reward-info {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.reward-label {
    color: var(--text-secondary);
    font-size: 0.9rem;
    font-weight: 600;
}

.reward-value {
    color: var(--text-primary);
    font-size: 1.3rem;
    font-weight: 800;
    background: linear-gradient(135deg,rgb(255, 255, 255),rgb(255, 255, 255));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .ranks-rewards-container {
        padding: 0 10px;
    }
    
    .page-header {
        padding: 2rem 1rem;
        margin-bottom: 2rem;
    }
    
    .page-title {
        font-size: 2.2rem;
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .ranks-section {
        padding: 2rem 1rem;
    }
    
    .ranks-grid {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .rank-card {
        padding: 1.5rem;
        margin-bottom: 1rem;
    }
    
    .rank-header {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .rank-icon {
        width: 80px;
        height: 80px;
    }
    
    .rewards-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .requirements-section,
    .rewards-section {
        padding: 1.5rem;
    }
}

@media (max-width: 480px) {
    .ranks-rewards-container {
        padding: 0 5px;
    }
    
    .page-header {
        padding: 1.5rem 0.5rem;
    }
    
    .page-title {
        font-size: 1.8rem;
    }
    
    .ranks-section {
        padding: 1.5rem 0.5rem;
    }
    
    .rank-card {
        padding: 1rem;
    }
    
    .rank-icon {
        width: 70px;
        height: 70px;
    }
    
    .rank-name {
        font-size: 1.4rem;
    }
    
    .requirements-section,
    .rewards-section {
        padding: 1rem;
    }
    
    .requirement {
        padding: 0.75rem 1rem;
    }
    
    .reward-item {
        padding: 1rem;
    }
}

/* Extra small devices */
@media (max-width: 360px) {
    .page-title {
        font-size: 1.5rem;
    }
    
    .rank-icon {
        width: 60px;
        height: 60px;
    }
    
    .rank-name {
        font-size: 1.2rem;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.shahdeveloper.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/user/ranking/index.blade.php ENDPATH**/ ?>