<!-- InvestFlow Sidebar -->
<div id="sidebar" class="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">
            <div class="logo">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="sidebar-brand">
                <h3><?php echo e(setting('site_name', 'ShahBlock')); ?></h3>
                <p>Block Wave Trade</p>
            </div>
        </div>
        <button class="sidebar-close" onclick="toggleSidebar()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="sidebar-content">
        <?php if(auth()->guard('web')->check()): ?>
        <div class="user-info">
            <div class="user-avatar-large">
                <i class="fas fa-user"></i>
            </div>
            <div class="user-details">
                <h4><?php echo e(Auth::user()->first_name); ?> <?php echo e(Auth::user()->last_name); ?></h4>
                <p>Premium Member</p>
            </div>
        </div>
        <?php endif; ?>
        
        <nav class="sidebar-nav">
            <div class="nav-section">
                <span class="nav-title">Main</span>
                <a href="<?php echo e(route('home')); ?>" class="nav-link <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>">
                    <i class="fas fa-home"></i>
                    <span>Home</span>
                </a>
                <?php if(auth()->guard('web')->check()): ?>
                <a href="<?php echo e(route('user.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('user.dashboard') ? 'active' : ''); ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
                <a href="<?php echo e(route('user.schema')); ?>" class="nav-link <?php echo e(request()->routeIs('user.schema*') ? 'active' : ''); ?>">
                    <i class="fas fa-wallet"></i>
                    <span>Investment Plans</span>
                </a>
                <a href="<?php echo e(route('user.invest-logs')); ?>" class="nav-link <?php echo e(request()->routeIs('user.invest-logs*') ? 'active' : ''); ?>">
                    <i class="fas fa-chart-line"></i>
                    <span>My Investments</span>
                </a>
                <a href="<?php echo e(route('user.transactions')); ?>" class="nav-link <?php echo e(request()->routeIs('user.transactions*') ? 'active' : ''); ?>">
                    <i class="fas fa-history"></i>
                    <span>Transactions</span>
                </a>
                <a href="<?php echo e(route('user.referral')); ?>" class="nav-link <?php echo e(request()->routeIs('user.referral*') ? 'active' : ''); ?>">
                    <i class="fas fa-users"></i>
                    <span>Referrals</span>
                </a>
                <a href="<?php echo e(route('user.achievement')); ?>" class="nav-link <?php echo e(request()->routeIs('user.achievement*') ? 'active' : ''); ?>">
                    <i class="fas fa-trophy"></i>
                    <span>Achievements</span>
                </a>
                <a href="<?php echo e(route('user.ranking')); ?>" class="nav-link <?php echo e(request()->routeIs('user.ranking*') ? 'active' : ''); ?>">
                    <i class="fas fa-medal"></i>
                    <span>Ranks & Rewards</span>
                </a>
                <a href="<?php echo e(route('user.collect-roi')); ?>" class="nav-link <?php echo e(request()->routeIs('user.collect-roi*') ? 'active' : ''); ?>">
                    <i class="fas fa-coins"></i>
                    <span>Collect ROI</span>
                </a>
                <?php endif; ?>
            </div>
            
            <?php if(auth()->guard('web')->check()): ?>
            <div class="nav-section">
                <span class="nav-title">Actions</span>
                <a href="<?php echo e(route('user.deposit')); ?>" class="nav-link <?php echo e(request()->routeIs('user.deposit*') ? 'active' : ''); ?>">
                    <i class="fas fa-plus-circle"></i>
                    <span>Deposit</span>
                </a>
                <a href="<?php echo e(route('user.deposit.log')); ?>" class="nav-link <?php echo e(request()->routeIs('user.deposit.log*') ? 'active' : ''); ?>">
                    <i class="fas fa-list-alt"></i>
                    <span>Deposit Logs</span>
                </a>
                <a href="<?php echo e(route('user.withdraw.new.index')); ?>" class="nav-link <?php echo e(request()->routeIs('user.withdraw.new*') ? 'active' : ''); ?>">
                    <i class="fas fa-minus-circle"></i>
                    <span>Withdraw</span>
                </a>
                <a href="<?php echo e(route('user.withdraw.new.history')); ?>" class="nav-link <?php echo e(request()->routeIs('user.withdraw.new.history') ? 'active' : ''); ?>">
                    <i class="fas fa-history"></i>
                    <span>Withdraw History</span>
                </a>
            </div>
            
            <div class="nav-section">
                <span class="nav-title">Account</span>
                <a href="<?php echo e(route('user.setting.show')); ?>" class="nav-link <?php echo e(request()->routeIs('user.setting*') ? 'active' : ''); ?>">
                    <i class="fas fa-user-cog"></i>
                    <span>Profile Settings</span>
                </a>
                
                <a href="<?php echo e(route('user.setting.show')); ?>" class="nav-link <?php echo e(request()->routeIs('user.setting*') ? 'active' : ''); ?>">
                    <i class="fas fa-credit-card"></i>
                    <span>Payment Methods</span>
                </a>
            </div>
            <?php endif; ?>
        </nav>
    </div>
</div>

<!-- Sidebar Overlay -->
<div id="sidebar-overlay" class="sidebar-overlay" onclick="toggleSidebar()"></div><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/include/__shahdeveloper_sidebar.blade.php ENDPATH**/ ?>