
<?php $__env->startSection('title'); ?>
<?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle'); ?>
Here's what's happening with your investments today
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php
    $currencySymbol = setting('currency_symbol', 'global', '$');
?>

<!-- InvestFlow Dashboard Page -->
<div class="dashboard-page">
    <div class="dashboard-container">
        

        <div class="dashboard-welcome" style="padding: 20px 15px 0px 15px; margin-bottom: 15px;">
            <h3>Welcome back, <?php echo e(Auth::user()->first_name); ?>!</h3>
            <p>Here's what's happening with your investments today.</p>
        </div>

        
        <style>
            /* Dashboard slider styles - Full screen fit like Profit Miner */
            .slider-wrap{margin:0;width:100%;padding:0}
            .slider-wrap .slide{position:relative;border-radius:0;overflow:hidden;border:none;background:#0a0f0e;box-shadow:none;aspect-ratio:4/1;height:120px;min-height:120px;width:100%;margin:0}
            .slider-wrap .slide img{width:100%;height:100%;object-fit:cover;display:block}
            .slider-wrap .slide .overlay{position:absolute;inset:0;background:linear-gradient(0deg,rgba(0,0,0,.1),transparent 70%)}
            .slider-wrap .slide .caption{position:absolute;left:20px;bottom:25px;font-weight:800;color:white;font-size:22px;text-shadow:0 2px 6px rgba(0,0,0,.8);line-height:1.1;max-width:calc(100% - 40px);letter-spacing:0.5px}
            .slider-wrap .swiper-pagination{position:absolute;bottom:10px;left:50%;transform:translateX(-50%);z-index:10}
            .slider-wrap .swiper-pagination-bullet{background:rgba(255,255,255,0.6);opacity:.8;width:10px;height:10px;margin:0 5px;border-radius:50%}
            .slider-wrap .swiper-pagination-bullet-active{background:white;opacity:1;box-shadow:0 0 0 2px rgba(255,255,255,.3)}
            
            /* Mobile specific styles - Full fit */
            @media (max-width: 768px) {
                .slider-wrap{margin:0;padding:0;width:100%}
                .slider-wrap .slide{height:110px;min-height:110px;aspect-ratio:3.5/1;border-radius:0;margin:0}
                .slider-wrap .slide .caption{left:15px;bottom:20px;font-size:20px;max-width:calc(100% - 30px)}
                .slider-wrap .swiper-pagination{bottom:8px}
                .slider-wrap .swiper-pagination-bullet{width:8px;height:8px;margin:0 4px}
            }
            
            @media (max-width: 480px) {
                .slider-wrap{margin:0;padding:0;width:100%}
                .slider-wrap .slide{height:100px;min-height:100px;aspect-ratio:3/1;border-radius:0;margin:0}
                .slider-wrap .slide .caption{left:12px;bottom:18px;font-size:18px;max-width:calc(100% - 24px)}
                .slider-wrap .swiper-pagination{bottom:6px}
                .slider-wrap .swiper-pagination-bullet{width:7px;height:7px;margin:0 3px}
            }
        </style>
	<?php
		$slides = collect();
		try{
			if(\Illuminate\Support\Facades\Schema::hasTable('sliders')){
				$slides = \App\Models\Slider::where('status',true)->orderBy('position')->get(['title','image','desktop_image','mobile_image','link']);
			}
		}catch(\Throwable $e){
			$slides = collect();
		}
	?>
	<?php if($slides->count()): ?>
		<div class="slider-wrap">
			<div class="container" style="padding:0">
				<div class="slider swiper" id="landing-slider">
					<div class="swiper-wrapper">
						<?php $__currentLoopData = $slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<div class="swiper-slide">
								<div class="slide">
									<?php if(!empty($s->link)): ?>
										<a href="<?php echo e($s->link); ?>" target="_blank" style="display:block;height:100%">
											<picture>
												<?php if(isset($s->mobile_image)): ?>
													<source media="(max-width: 767px)" srcset="<?php echo e(asset($s->mobile_image)); ?>">
												<?php endif; ?>
												<?php if(isset($s->desktop_image)): ?>
													<source media="(min-width: 768px)" srcset="<?php echo e(asset($s->desktop_image)); ?>">
												<?php endif; ?>
												<img src="<?php echo e(asset($s->image)); ?>" alt="<?php echo e($s->title); ?>">
											</picture>
											<div class="overlay"></div>
											<div class="caption"><?php echo e($s->title); ?></div>
										</a>
									<?php else: ?>
										<picture>
											<?php if(isset($s->mobile_image)): ?>
												<source media="(max-width: 767px)" srcset="<?php echo e(asset($s->mobile_image)); ?>">
											<?php endif; ?>
											<?php if(isset($s->desktop_image)): ?>
												<source media="(min-width: 768px)" srcset="<?php echo e(asset($s->desktop_image)); ?>">
											<?php endif; ?>
											<img src="<?php echo e(asset($s->image)); ?>" alt="<?php echo e($s->title); ?>">
										</picture>
										<div class="overlay"></div>
										<div class="caption"><?php echo e($s->title); ?></div>
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</div>
					<div class="swiper-pagination"></div>
				</div>
			</div>
		</div>
	<?php endif; ?>

        <!-- Balance Display Card -->
        <div class="balance-card glass-effect" style="margin: 20px 5px 35px 5px;">
            <div class="card-logo">
                <span class="logo-text">BLOCKWAVE</span>
            </div>
            <div class="balance-header">
                <span>Wallets</span>
                <i class="fas fa-eye"></i>
            </div>
            <div class="balance-breakdown">
                <div class="breakdown-row">
                    <span>Main Wallet</span>
                    <span><?php echo e($currencySymbol); ?><?php echo e(number_format($user->balance, 2)); ?></span>
                </div>
                <div class="breakdown-row">
                    <span>Profit Wallet</span>
                    <span><?php echo e($currencySymbol); ?><?php echo e(number_format($user->profit_balance, 2)); ?></span>
                </div>
            </div>
            <div class="balance-change positive" style="background: rgba(245,158,11,0.12); border-color: rgba(245,158,11,0.28); color:#f59e0b;">
                <i class="fas fa-arrow-up"></i>
                +<?php echo e(number_format($dataCount['total_profit'], 2)); ?> this week
            </div>
        </div>

        <!-- Trading News Ticker -->
        <div class="trading-ticker-section" style="margin: 0 15px 25px 15px;">
            <div class="ticker-container">
                <div class="ticker-content" id="tickerContent">
                    <div class="ticker-item">
                        <div class="coin-symbol">BTC</div>
                        <div class="coin-price">$43,250.50</div>
                        <div class="coin-change positive">+2.45%</div>
                        <div class="coin-chart">
                            <canvas id="btc-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">ETH</div>
                        <div class="coin-price">$2,650.30</div>
                        <div class="coin-change positive">+1.85%</div>
                        <div class="coin-chart">
                            <canvas id="eth-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">BNB</div>
                        <div class="coin-price">$315.75</div>
                        <div class="coin-change negative">-0.65%</div>
                        <div class="coin-chart">
                            <canvas id="bnb-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">ADA</div>
                        <div class="coin-price">$0.485</div>
                        <div class="coin-change positive">+3.25%</div>
                        <div class="coin-chart">
                            <canvas id="ada-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">SOL</div>
                        <div class="coin-price">$98.45</div>
                        <div class="coin-change positive">+5.12%</div>
                        <div class="coin-chart">
                            <canvas id="sol-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">DOGE</div>
                        <div class="coin-price">$0.082</div>
                        <div class="coin-change negative">-1.25%</div>
                        <div class="coin-chart">
                            <canvas id="doge-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">XRP</div>
                        <div class="coin-price">$0.625</div>
                        <div class="coin-change positive">+1.85%</div>
                        <div class="coin-chart">
                            <canvas id="xrp-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">DOT</div>
                        <div class="coin-price">$7.25</div>
                        <div class="coin-change negative">-0.45%</div>
                        <div class="coin-chart">
                            <canvas id="dot-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">MATIC</div>
                        <div class="coin-price">$0.85</div>
                        <div class="coin-change positive">+2.15%</div>
                        <div class="coin-chart">
                            <canvas id="matic-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">AVAX</div>
                        <div class="coin-price">$25.30</div>
                        <div class="coin-change positive">+1.75%</div>
                        <div class="coin-chart">
                            <canvas id="avax-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">LINK</div>
                        <div class="coin-price">$14.85</div>
                        <div class="coin-change positive">+2.30%</div>
                        <div class="coin-chart">
                            <canvas id="link-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">UNI</div>
                        <div class="coin-price">$6.45</div>
                        <div class="coin-change negative">-0.85%</div>
                        <div class="coin-chart">
                            <canvas id="uni-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">ATOM</div>
                        <div class="coin-price">$8.75</div>
                        <div class="coin-change positive">+3.15%</div>
                        <div class="coin-chart">
                            <canvas id="atom-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">NEAR</div>
                        <div class="coin-price">$3.25</div>
                        <div class="coin-change positive">+4.20%</div>
                        <div class="coin-chart">
                            <canvas id="near-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">FTM</div>
                        <div class="coin-price">$0.35</div>
                        <div class="coin-change negative">-1.50%</div>
                        <div class="coin-chart">
                            <canvas id="ftm-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">ALGO</div>
                        <div class="coin-price">$0.18</div>
                        <div class="coin-change positive">+1.25%</div>
                        <div class="coin-chart">
                            <canvas id="algo-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">VET</div>
                        <div class="coin-price">$0.025</div>
                        <div class="coin-change positive">+2.80%</div>
                        <div class="coin-chart">
                            <canvas id="vet-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">ICP</div>
                        <div class="coin-price">$4.85</div>
                        <div class="coin-change negative">-0.95%</div>
                        <div class="coin-chart">
                            <canvas id="icp-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">FIL</div>
                        <div class="coin-price">$5.20</div>
                        <div class="coin-change positive">+1.65%</div>
                        <div class="coin-chart">
                            <canvas id="fil-chart" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <!-- Duplicate content for seamless loop -->
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">BTC</div>
                        <div class="coin-price">$43,250.50</div>
                        <div class="coin-change positive">+2.45%</div>
                        <div class="coin-chart">
                            <canvas id="btc-chart-2" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">ETH</div>
                        <div class="coin-price">$2,650.75</div>
                        <div class="coin-change negative">-1.25%</div>
                        <div class="coin-chart">
                            <canvas id="eth-chart-2" width="60" height="20"></canvas>
                        </div>
                    </div>
                    
                    <div class="ticker-separator"></div>
                    
                    <div class="ticker-item">
                        <div class="coin-symbol">BNB</div>
                        <div class="coin-price">$315.80</div>
                        <div class="coin-change positive">+3.15%</div>
                        <div class="coin-chart">
                            <canvas id="bnb-chart-2" width="60" height="20"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css"/>
	<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
	<script>
		(function initDashboardSwiper(){
			var el = document.getElementById('landing-slider');
			if(!el){return;}
			if(typeof Swiper === 'undefined'){return setTimeout(initDashboardSwiper,200);} // wait until script loads
			new Swiper('#landing-slider',{
				loop:true,
				speed:600,
				autoplay:{delay:3200,disableOnInteraction:false},
				pagination:{el:'#landing-slider .swiper-pagination',clickable:true},
				spaceBetween:12,
				slidesPerView:1,
				centeredSlides:false,
				autoHeight:true,
				breakpoints:{768:{slidesPerView:1},1024:{slidesPerView:1}}
			});
		})();
	</script>

        <!-- Carousel Cards -->
        <div class="carousel-section">
            <div class="carousel-container">
                <!-- All Transactions -->
                <div class="carousel-card glass-effect active" data-type="transactions">
                    <div class="card-icon">
                        <i class="fas fa-list-alt"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">All Transactions</span>
                        <span class="card-value"><?php echo e(number_format($dataCount['total_transaction'])); ?></span>
                    </div>
                </div>

                <!-- Total Deposit -->
                <div class="carousel-card glass-effect" data-type="deposit">
                    <div class="card-icon">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Deposit</span>
                        <span class="card-value"><?php echo e($currencySymbol); ?><?php echo e(number_format($dataCount['total_deposit'], 2)); ?></span>
                    </div>
                </div>

                <!-- Total Investment -->
                <div class="carousel-card glass-effect" data-type="investment">
                    <div class="card-icon">
                        <i class="fas fa-chart-pie"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Investment</span>
                        <span class="card-value"><?php echo e($currencySymbol); ?><?php echo e(number_format($dataCount['total_investment'], 2)); ?></span>
                    </div>
                </div>

                <!-- Total Profit -->
                <div class="carousel-card glass-effect" data-type="profit">
                    <div class="card-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Profit</span>
                        <span class="card-value profit">+<?php echo e($currencySymbol); ?><?php echo e(number_format($dataCount['total_profit'], 2)); ?></span>
                    </div>
                </div>

                <!-- Total Transfer -->
                <div class="carousel-card glass-effect" data-type="transfer">
                    <div class="card-icon">
                        <i class="fas fa-exchange-alt"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Transfer</span>
                        <span class="card-value"><?php echo e($currencySymbol); ?><?php echo e(number_format($dataCount['total_transfer'], 2)); ?></span>
                    </div>
                </div>

                <!-- Total Withdraw -->
                <div class="carousel-card glass-effect" data-type="withdraw">
                    <div class="card-icon">
                        <i class="fas fa-arrow-up"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Withdraw</span>
                        <span class="card-value"><?php echo e($currencySymbol); ?><?php echo e(number_format($dataCount['total_withdraw'], 2)); ?></span>
                    </div>
                </div>

                <!-- Salary -->
                <div class="carousel-card glass-effect" data-type="salary">
                    <div class="card-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Salary</span>
                        <span class="card-value"><?php echo e($currencySymbol); ?><?php echo e(number_format($dataCount['salary'], 2)); ?></span>
                    </div>
                </div>

                <!-- Network Bonus -->
                <div class="carousel-card glass-effect" data-type="network-bonus">
                    <div class="card-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Network Bonus</span>
                        <span class="card-value"><?php echo e($currencySymbol); ?><?php echo e(number_format($dataCount['network_bonus'], 2)); ?></span>
                    </div>
                </div>

                <!-- Total Referral -->
                <div class="carousel-card glass-effect" data-type="referral">
                    <div class="card-icon">
                        <i class="fas fa-user-plus"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Referral</span>
                        <span class="card-value"><?php echo e(number_format($dataCount['total_referral'])); ?></span>
                    </div>
                </div>

                <!-- Rank Achieved -->
                <div class="carousel-card glass-effect" data-type="rank">
                    <div class="card-icon">
                        <i class="fas fa-trophy"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Rank Achieved</span>
                        <span class="card-value"><?php echo e($user->rank->ranking_name ?? 'Bronze'); ?></span>
                    </div>
                </div>

                <!-- Total Ticket -->
                <div class="carousel-card glass-effect" data-type="ticket">
                    <div class="card-icon">
                        <i class="fas fa-ticket-alt"></i>
                    </div>
                    <div class="card-info">
                        <span class="card-label">Total Ticket</span>
                        <span class="card-value"><?php echo e($dataCount['total_ticket'] ?? 0); ?></span>
                    </div>
                </div>
            </div>
            <div class="carousel-dots">
                <span class="dot active" data-slide="0"></span>
                <span class="dot" data-slide="1"></span>
                <span class="dot" data-slide="2"></span>
                <span class="dot" data-slide="3"></span>
                <span class="dot" data-slide="4"></span>
                <span class="dot" data-slide="5"></span>
                <span class="dot" data-slide="6"></span>
                <span class="dot" data-slide="7"></span>
                <span class="dot" data-slide="8"></span>
                <span class="dot" data-slide="9"></span>
                <span class="dot" data-slide="10"></span>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions" style="margin: 0 15px 25px 15px;">
            <div class="action-btn glass-effect" onclick="window.location.href='<?php echo e(route('user.deposit')); ?>'">
                <i class="fas fa-plus"></i>
                <span>Deposit</span>
            </div>
            <div class="action-btn glass-effect" onclick="window.location.href='<?php echo e(route('user.withdraw.simple.index')); ?>'">
                <i class="fas fa-minus"></i>
                <span>Withdraw</span>
            </div>
            <div class="action-btn glass-effect" onclick="window.location.href='<?php echo e(route('user.schema')); ?>'">
                <i class="fas fa-chart-pie"></i>
                <span>Plans</span>
            </div>
            <div class="action-btn glass-effect" onclick="window.location.href='<?php echo e(route('user.transactions')); ?>'">
                <i class="fas fa-history"></i>
                <span>History</span>
            </div>
        <div class="action-btn glass-effect" onclick="window.location.href='<?php echo e(route('user.ticket.index')); ?>'">
            <i class="fas fa-headset"></i>
            <span>Support</span>
        </div>
        <div class="action-btn glass-effect" onclick="window.location.href='<?php echo e(route('user.ticket.logs')); ?>'">
            <i class="fas fa-file-alt"></i>
            <span>Ticket Logs</span>
        </div>
        </div>

        <!-- Your Purchased Plans -->
        <div class="purchased-plans-section" style="margin: 20px 15px;">
            <div class="section-header">
                <h3>Your Purchased Plans</h3>
                <a href="<?php echo e(route('user.invest-logs')); ?>">View All</a>
            </div>
            
            <?php if($investments->count() > 0): ?>
                <div class="plans-grid">
                    <?php $__currentLoopData = $investments->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="plan-card glass-effect">
                        <div class="plan-header">
                            <div class="plan-info">
                                <h4><?php echo e($investment->schema->name); ?></h4>
                                <span class="plan-type"><?php echo e($investment->schema->type); ?></span>
                            </div>
                            <div class="status-badge status-<?php echo e($investment->status->value); ?>">
                                <?php echo e(ucfirst($investment->status->value)); ?>

                            </div>
                        </div>
                        
                        <div class="plan-details">
                            <div class="detail-row">
                                <span class="label">Amount:</span>
                                <span class="value"><?php echo e($currencySymbol); ?><?php echo e(number_format($investment->invest_amount, 2)); ?></span>
                            </div>
                            <div class="detail-row">
                                <span class="label">Return:</span>
                                <span class="value"><?php echo e($investment->schema->return_interest); ?>%</span>
                            </div>
                            <div class="detail-row">
                                <span class="label">Period:</span>
                                <span class="value"><?php echo e($investment->schema->return_period); ?> <?php echo e($investment->schema->return_period_type); ?></span>
                            </div>
                            <?php
                                // Derive cycles using schedules first (more accurate), fallback to legacy columns
                                $schedules = $investment->relationLoaded('roiSchedules') ? $investment->roiSchedules : collect();
                                $completedCycles = $schedules->whereIn('status', ['sent','completed'])->count();
                                if ($completedCycles === 0) {
                                    $completedCycles = (int)($investment->already_return_profit ?? 0);
                                }
                                $totalCycles = 0;
                                if ($schedules->count() > 0) {
                                    $totalCycles = (int)($schedules->max('total_cycles') ?? 0);
                                    if ($totalCycles === 0) {
                                        $totalCycles = (int)($investment->number_of_period ?? 0);
                                    }
                                } else {
                                    $totalCycles = (int)($investment->number_of_period ?? 0);
                                }
                                $pendingCycles = max(0, $totalCycles - $completedCycles);
                            ?>
                            <div class="detail-row">
                                <span class="label">Number of Periods:</span>
                                <span class="value">
                                    <?php echo e($completedCycles); ?> / <?php echo e($totalCycles); ?>

                                    <?php if($totalCycles > 0): ?>
                                        <span class="badge" style="background:linear-gradient(135deg,#f59e0b,#d97706);color:#0b1020;margin-left:6px;border:1px solid rgba(0,0,0,0.25);box-shadow:0 2px 8px rgba(245,158,11,.25);"><?php echo e($pendingCycles); ?> pending</span>
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                        
                        <?php if($investment->status->value === 'ongoing'): ?>
                        <div class="plan-actions">
                            <?php
                                $now = \Carbon\Carbon::now();
                                $nextProfitTime = \Carbon\Carbon::parse($investment->next_profit_time);
                                $canCollect = $now->gte($nextProfitTime);
                                $timeRemaining = $now->lt($nextProfitTime) ? $nextProfitTime->diffForHumans($now, true) : null;
                            ?>
                            
                            <?php
                                $activeSchedule = $investment->activeRoiSchedule;
                                $readySchedule = $investment->readyRoiSchedule;
                            ?>
                            
                            <?php if($readySchedule): ?>
                                <div class="roi-progress-btn">
                                    <a href="<?php echo e(route('user.collect-roi')); ?>" class="btn-roi-progress">
                                        <i class="fas fa-chart-line"></i>
                                        <span>ROI Progress</span>
                                        <small>Cycle <?php echo e($readySchedule->roi_cycle); ?>/<?php echo e($readySchedule->total_cycles); ?></small>
                                    </a>
                                </div>
                            <?php elseif($activeSchedule): ?>
                                <div class="roi-progress-btn">
                                    <a href="<?php echo e(route('user.collect-roi')); ?>" class="btn-roi-progress">
                                        <i class="fas fa-chart-line"></i>
                                        <span>ROI Progress</span>
                                        <small>Cycle <?php echo e($activeSchedule->roi_cycle); ?>/<?php echo e($activeSchedule->total_cycles); ?></small>
                                    </a>
                                </div>
                            <?php else: ?>
                                    <div class="roi-progress-btn">
                                        <a href="<?php echo e(route('user.collect-roi')); ?>" class="btn-roi-progress">
                                            <i class="fas fa-chart-line"></i>
                                            <span>ROI Progress</span>
                                    </a>
                                </div>
                            <?php endif; ?>
                            
                            
                            <?php if($investment->schema->schema_cancel == 1): ?>
                                <?php
                                    $investmentDate = \Carbon\Carbon::parse($investment->created_at);
                                    $currentDate = \Carbon\Carbon::now();
                                    $daysDifference = $investmentDate->diffInDays($currentDate);
                                    $moneyBackPeriod = $investment->schema->money_back_period ?? 15;
                                    $remainingDays = $moneyBackPeriod - $daysDifference;
                                ?>
                                
                                <div class="cancel-investment-section">
                                    <?php if($remainingDays > 0): ?>
                                        <div class="cancellation-info">
                                            <p class="cancellation-text">
                                                <i class="fas fa-info-circle"></i>
                                                Cancel within <?php echo e($remainingDays); ?> days to get 80% refund (20% fees)
                                            </p>
                                            <p class="cancellation-text">
                                                <i class="fas fa-check-circle"></i>
                                                Cancel after <?php echo e($moneyBackPeriod); ?> days to get 100% refund (0% fees)
                                            </p>
                                        </div>
                                    <?php else: ?>
                                        <div class="cancellation-info success">
                                            <p class="cancellation-text success">
                                                <i class="fas fa-check-circle"></i>
                                                You can now cancel for 100% refund (0% fees)
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <button type="button" class="btn-cancel-invest" onclick="showCancelModal(<?php echo e($investment->id); ?>)">
                                        <i class="fas fa-times-circle"></i>
                                        Cancel Investment
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php elseif($investment->status->value === 'canceled' || $investment->status->value === 'cancelled'): ?>
                        <div class="plan-actions">
                            <div class="cancelled-chip">
                                <i class="fas fa-ban"></i>
                                <div class="text">
                                    <span class="title">Canceled</span>
                                    <small>Plan is no longer active</small>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-investments">
                    <div class="no-investments-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h4>No Investments Yet</h4>
                    <p>You haven't purchased any Investment plans yet. Go to plans and purchase a plan to start Investing.</p>
                    <a href="<?php echo e(route('user.schema')); ?>" class="go-to-plans-btn">
                        <i class="fas fa-plus"></i>
                        Go to Plans
                    </a>
                </div>
            <?php endif; ?>
        </div>

        <!-- Recent Transactions -->
        <div class="recent-section" style="margin: 20px 15px;">
            <div class="section-header">
                <h3>Recent Transactions</h3>
                <a href="<?php echo e(route('user.transactions')); ?>">View All</a>
            </div>
            <div class="transaction-list">
                <?php $__currentLoopData = $recentTransactions->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="transaction-item glass-effect">
                    <div class="transaction-icon <?php echo e(txn_type($transaction->type->value,['deposit','withdraw'],'hardrock')); ?>">
                        <?php if(txn_type($transaction->type->value,['+','-'],'hardrock') == '+'): ?>
                            <i class="fas fa-arrow-down"></i>
                        <?php else: ?>
                            <i class="fas fa-arrow-up"></i>
                        <?php endif; ?>
                    </div>
                    <div class="transaction-details">
                        <span class="transaction-title"><?php echo e($transaction->description); ?></span>
                        <span class="transaction-date"><?php echo e(\Carbon\Carbon::parse($transaction->created_at)->format('M d, Y g:i A')); ?></span>
                    </div>
                    <div class="transaction-amount <?php echo e(txn_type($transaction->type->value,['positive','negative'],'hardrock')); ?>">
                        <?php echo e(txn_type($transaction->type->value,['+','-'],'hardrock')); ?><?php echo e($currencySymbol); ?><?php echo e(number_format($transaction->amount, 2)); ?>

                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<!-- Dashboard Specific Styles -->
<style>
.dashboard-page {
    min-height: 100vh;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
}

/* System Notice Banner removed */

.dashboard-container {
    padding: 0;
    max-width: 100%;
    margin: 0;
    width: 100%;
}

/* Purchased Plans Section */
.purchased-plans-section {
    margin: 20px 0;
}

.plans-grid {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.plan-card {
    background: rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    padding: 20px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
}

.plan-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 15px;
}

.plan-info h4 {
    color: var(--text-primary);
    font-size: 16px;
    font-weight: 600;
    margin: 0 0 5px 0;
}

.plan-type {
    color: var(--text-secondary);
    font-size: 12px;
    background: rgba(0, 255, 0, 0.1);
    padding: 2px 8px;
    border-radius: 10px;
}

.status-badge {
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-ongoing {
    background: rgba(0, 255, 0, 0.2);
    color: #00ff00;
}

.status-completed {
    background: rgba(0, 150, 255, 0.2);
    color: #0096ff;
}

.status-pending {
    background: rgba(255, 165, 0, 0.2);
    color: #ffa500;
}

.plan-details {
    margin-bottom: 15px;
}

.detail-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.detail-row .label {
    color: var(--text-secondary);
    font-size: 14px;
}

.detail-row .value {
    color: var(--text-primary);
    font-size: 14px;
    font-weight: 600;
}

.plan-actions {
    text-align: center;
}

/* ROI chip styles (shared theme) */
.roi-chip {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 10px 14px;
    border-radius: 14px;
    color: var(--text-primary);
    justify-content: center;
    font-weight: 600;
    background: linear-gradient(135deg, rgba(17,24,39,0.65) 0%, rgba(2,6,23,0.45) 100%);
    border: 1px solid rgba(255,255,255,0.08);
    box-shadow: 0 10px 26px rgba(0,0,0,0.35);
    backdrop-filter: blur(14px);
}
.roi-chip i { font-size: 16px; opacity: .95; }
.roi-chip .roi-chip-text { display: flex; flex-direction: column; line-height: 1.15; color: #e5f7ee; }
.roi-chip .roi-chip-text small { opacity: .85; font-weight: 500; }
.cancelled-chip { display:flex; align-items:center; gap:10px; padding:12px 14px; border-radius:12px; background:linear-gradient(135deg,#0b1020,#0f172a); border:1px solid rgba(239,68,68,.38); box-shadow:0 8px 24px rgba(239,68,68,.18), inset 0 0 0 1px rgba(255,255,255,.04); color:#fecaca; }
.cancelled-chip i { color:#ef4444; }
.cancelled-chip .text .title { display:block; font-weight:700; color:#fca5a5; }
.cancelled-chip .text small { color:#f87171; }
.roi-ready {
    border-color: rgba(0,255,136,0.28);
    box-shadow: 0 8px 24px rgba(0,255,136,0.18);
}
.roi-ready i { color: #00ff88; text-shadow: 0 0 10px rgba(0,255,136,.35); }
.roi-pending {
    border-color: rgba(245,158,11,0.28);
    box-shadow: 0 8px 24px rgba(245,158,11,0.18);
}
.roi-pending i { color: #f59e0b; text-shadow: 0 0 8px rgba(245,158,11,.25); }
.roi-info {
    border-color: rgba(148,163,184,0.28);
    box-shadow: 0 8px 24px rgba(148,163,184,0.14);
}
.roi-info i { color: #93c5fd; opacity: .95; }

/* Cancel button theme */
.cancel-investment-section { margin-top: 12px; }

/* Cancellation Info Styles */
.cancellation-info {
    background: rgba(33, 150, 243, 0.1);
    border: 1px solid rgba(33, 150, 243, 0.3);
    border-radius: 8px;
    padding: 12px;
    margin-bottom: 12px;
}

.cancellation-info.success {
    background: rgba(76, 175, 80, 0.1);
    border: 1px solid rgba(76, 175, 80, 0.3);
}

.cancellation-text {
    font-size: 12px;
    color: #1976D2;
    margin: 4px 0;
    display: flex;
    align-items: center;
    gap: 8px;
}

.cancellation-text.success {
    color: #4CAF50;
}

.cancellation-text i {
    font-size: 14px;
}
.btn-cancel-invest {
    background: linear-gradient(135deg, rgba(239,68,68,0.95), rgba(220,38,38,0.95));
    color: #fff;
    border: 1px solid rgba(239,68,68,0.35);
    padding: 10px 18px;
    border-radius: 12px;
    font-weight: 700;
    letter-spacing: .2px;
    cursor: pointer;
    box-shadow: 0 12px 28px rgba(239, 68, 68, 0.25);
    transition: transform .18s ease, box-shadow .18s ease, filter .18s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}
.btn-cancel-invest:hover { transform: translateY(-2px); box-shadow: 0 16px 34px rgba(239, 68, 68, 0.35); filter: brightness(1.05); }

/* Modal Neo Glass Theme */
.modal-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.55);
    display: grid;
    place-items: center;
    z-index: 1000;
    padding: 20px;
}
.modal-card {
    width: 100%;
    max-width: 520px;
    background: linear-gradient(145deg, rgba(10,15,13,0.92), rgba(14,21,18,0.88));
    border: 1px solid rgba(0,255,136,0.14);
    border-radius: 16px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.45);
    overflow: hidden;
    color: var(--text-primary);
}
.modal-header-neo {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px 18px;
    border-bottom: 1px solid rgba(255,255,255,0.06);
}
.modal-title { display: flex; align-items: center; gap: 10px; }
.modal-title i { color: #ef4444; }
.modal-title h3 { margin: 0; font-weight: 800; }
.modal-close {
    background: transparent; color: #94a3b8; border: none; font-size: 26px; cursor: pointer;
}
.modal-close:hover { color: #e2e8f0; }
.modal-body-neo { padding: 18px; }
.alert-warning-neo {
    display: flex; gap: 10px; align-items: flex-start; padding: 12px 14px; border-radius: 12px;
    background: rgba(245,158,11,0.12); color: #fbbf24; border: 1px solid rgba(245,158,11,0.28); margin-bottom: 14px;
}
.cancel-details { margin-bottom: 12px; }
.cancel-details-card { background: rgba(255,255,255,0.02); border: 1px solid rgba(148,163,184,0.18); padding: 14px; border-radius: 12px; }
.cancel-details-card h5 { margin: 0 0 8px 0; color: #e2e8f0; }
.cancel-details-card p { margin: 4px 0; color: #cbd5e1; }
.cancel-details-card p.muted { color: #94a3b8; }
.form-field { display: flex; flex-direction: column; gap: 8px; }
.form-field label { font-weight: 700; color: #e2e8f0; }
.form-field textarea {
    width: 100%; padding: 12px 14px; border-radius: 12px; border: 1px solid rgba(148,163,184,0.28);
    background: rgba(2,6,23,0.55); color: #e5e7eb; resize: vertical; min-height: 96px;
}
.form-field textarea::placeholder { color: #94a3b8; }
.field-hint { font-size: 12px; color: #94a3b8; display: flex; align-items: center; gap: 6px; }
.modal-actions { display: flex; justify-content: flex-end; gap: 10px; padding: 14px 18px; border-top: 1px solid rgba(255,255,255,0.06); }
.btn-ghost { background: transparent; border: 1px solid rgba(148,163,184,0.3); color: #cbd5e1; padding: 10px 14px; border-radius: 10px; font-weight: 700; }
.btn-ghost:hover { border-color: rgba(148,163,184,0.6); }
.btn-danger-neo { background: linear-gradient(135deg, #ef4444, #dc2626); color: #fff; border: 1px solid rgba(239,68,68,0.35); padding: 10px 16px; border-radius: 10px; font-weight: 800; }

.collect-btn {
    background: linear-gradient(135deg, #1e40af, #1e3a8a);
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 25px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
}

.collect-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.4);
}

.time-remaining {
    background: rgba(30, 64, 175, 0.08);
    color: #1e40af;
    padding: 10px 20px;
    border-radius: 25px;
    font-size: 14px;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    border: 1px solid rgba(30, 64, 175, 0.2);
}

.no-investments {
    text-align: center;
    padding: 40px 20px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.no-investments-icon {
    font-size: 48px;
    color: var(--text-secondary);
    margin-bottom: 20px;
}

.no-investments h4 {
    color: var(--text-primary);
    font-size: 20px;
    margin-bottom: 10px;
}

.no-investments p {
    color: var(--text-secondary);
    font-size: 14px;
    margin-bottom: 20px;
    line-height: 1.5;
}

.go-to-plans-btn {
    background: linear-gradient(135deg, #0096ff, #0066cc);
    color: white;
    text-decoration: none;
    padding: 12px 24px;
    border-radius: 25px;
    font-size: 14px;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.go-to-plans-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 150, 255, 0.3);
    color: white;
    text-decoration: none;
}

.dashboard-welcome {
    text-align: center;
    margin-bottom: 0px;
    color: var(--text-primary);
}

.dashboard-welcome h3 {
    font-size: 24px;
    font-weight: 600;
    margin-bottom: 8px;
}

.dashboard-welcome p {
    font-size: 14px;
    color: var(--text-secondary);
    margin: 0;
}

/* Balance Card - Dark Black & Purple Gradient with Blue Glow */
.balance-card {
    background: linear-gradient(135deg, #000000 0%, #1a0b2e 50%, #000000 100%);
    border-radius: 16px;
    padding: 24px;
    margin-bottom: 25px;
    border: 1px solid rgba(59, 130, 246, 0.3);
    text-align: left;
    color: white;
    position: relative;
    overflow: hidden;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4), 0 0 20px rgba(59, 130, 246, 0.15);
    min-height: 200px;
    transition: all 0.3s ease;
}

.balance-card:hover {
    background: linear-gradient(135deg, #1a0b2e 0%, #2d1b69 50%, #1a0b2e 100%);
    box-shadow: 0 12px 35px rgba(0, 0, 0, 0.5), 0 0 30px rgba(59, 130, 246, 0.4), 0 0 50px rgba(59, 130, 246, 0.2);
    transform: translateY(-3px);
    border-color: rgba(59, 130, 246, 0.6);
}

.balance-card.active {
    background: linear-gradient(135deg, #1a0b2e 0%, #2d1b69 50%, #1a0b2e 100%);
    box-shadow: 0 12px 35px rgba(0, 0, 0, 0.5), 0 0 30px rgba(59, 130, 246, 0.4), 0 0 50px rgba(59, 130, 246, 0.2);
    border-color: rgba(59, 130, 246, 0.6);
}

.balance-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 200px;
    height: 200px;
    background: radial-gradient(circle, rgba(107, 70, 193, 0.15) 0%, transparent 70%);
    border-radius: 50%;
    z-index: 1;
}

.balance-card::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: -10%;
    width: 150px;
    height: 150px;
    background: radial-gradient(circle, rgba(45, 27, 105, 0.12) 0%, transparent 70%);
    border-radius: 50%;
    z-index: 1;
}

/* card-chip removed */

.card-logo {
    position: absolute;
    bottom: 20px;
    right: 24px;
    z-index: 3;
}

.logo-text {
    font-size: 16px;
    font-weight: 700;
    color: rgba(255, 255, 255, 0.8);
    text-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
    letter-spacing: 1.5px;
    background: linear-gradient(45deg, #ffffff, #e2e8f0);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.balance-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    font-size: 14px;
    color: #ffffff;
    font-weight: 600;
    position: relative;
    z-index: 2;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.balance-header i {
    font-size: 16px;
    opacity: 0.8;
    color: #3b82f6;
    text-shadow: 0 0 10px rgba(59, 130, 246, 0.5);
}

.balance-amount {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 10px;
}

.balance-breakdown {
    display: flex;
    flex-direction: column;
    gap: 12px;
    margin-bottom: 20px;
    position: relative;
    z-index: 2;
}

.breakdown-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    font-size: 14px;
    color: #ffffff;
    padding: 12px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.15);
    position: relative;
    z-index: 2;
}

.breakdown-row:last-child {
    border-bottom: none;
    padding-bottom: 0;
}

.breakdown-row span:first-child {
    font-weight: 500;
    color: #ffffff;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.breakdown-row span:last-child {
    color: #ffffff;
    font-weight: 700;
    font-size: 15px;
    text-shadow: 0 1px 3px rgba(0, 0, 0, 0.3);
}

.balance-change {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    font-size: 12px;
    font-weight: 600;
    padding: 8px 12px;
    background: rgba(59, 130, 246, 0.1);
    border-radius: 12px;
    border: 1px solid rgba(59, 130, 246, 0.3);
    position: relative;
    z-index: 2;
    backdrop-filter: blur(10px);
    margin-top: 16px;
    box-shadow: 0 0 15px rgba(59, 130, 246, 0.2);
    color: #ffffff;
}

.balance-change.positive {
    color: #10b981;
    background: rgba(16, 185, 129, 0.1);
    border-color: rgba(16, 185, 129, 0.2);
}

.balance-change.negative {
    color: #ef4444;
    background: rgba(239, 68, 68, 0.1);
    border-color: rgba(239, 68, 68, 0.2);
}

.balance-change i {
    font-size: 12px;
}

/* Carousel Section */
.carousel-section {
    margin-bottom: 25px;
}

.carousel-container {
    display: flex;
    gap: 15px;
    overflow-x: auto;
    padding-bottom: 10px;
    scrollbar-width: none;
    -ms-overflow-style: none;
}

.carousel-container::-webkit-scrollbar {
    display: none;
}

.carousel-card {
    background: linear-gradient(135deg, rgba(31, 41, 55, 0.95) 0%, rgba(55, 65, 81, 0.95) 60%);
    backdrop-filter: blur(25px);
    border-radius: 20px;
    padding: 25px 20px;
    border: 1px solid rgba(30, 64, 175, 0.15);
    min-width: 240px;
    text-align: center;
    color: white;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
    box-shadow: 0 8px 26px rgba(0, 0, 0, 0.3);
}

.carousel-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 1px;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
}

.carousel-card::after {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.carousel-card:hover::after {
    opacity: 1;
}

.carousel-card.active {
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.9) 0%, rgba(30, 58, 138, 0.85) 60%, rgba(107, 70, 193, 0.1) 100%);
    transform: scale(1.03) translateY(-4px);
    box-shadow: 0 12px 36px rgba(0, 0, 0, 0.4);
    border-color: rgba(30, 64, 175, 0.3);
}

.carousel-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 45px rgba(0, 0, 0, 0.4);
    border-color: rgba(30, 64, 175, 0.25);
}

.card-icon {
    width: 50px;
    height: 50px;
    border-radius: 15px;
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.15) 0%, rgba(107, 70, 193, 0.08) 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 18px;
    font-size: 20px;
    color: #1e40af;
    position: relative;
    overflow: hidden;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(30, 64, 175, 0.2);
}

.card-icon::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, transparent 30%, rgba(255, 255, 255, 0.1) 50%, transparent 70%);
    transform: translateX(-100%);
    transition: transform 0.6s ease;
}

.carousel-card:hover .card-icon::before {
    transform: translateX(100%);
}

.card-info {
    display: flex;
    flex-direction: column;
    gap: 8px;
    position: relative;
    z-index: 2;
}

.card-label {
    font-size: 11px;
    color: rgba(255, 255, 255, 0.8);
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 2px;
}

.card-value {
    font-size: 18px;
    font-weight: 800;
    color: white;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    line-height: 1.2;
}

.card-value.profit {
    color: #10b981;
    text-shadow: 0 0 10px rgba(16, 185, 129, 0.3);
}

.card-value.expense {
    color: #ef4444;
    text-shadow: 0 0 10px rgba(239, 68, 68, 0.3);
}

.carousel-dots {
    display: flex;
    justify-content: center;
    gap: 10px;
    margin-top: 20px;
    padding: 10px 0;
}

.dot {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    cursor: pointer;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.dot::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    background: rgba(255, 255, 255, 0.3);
    border-radius: 50%;
    transform: translate(-50%, -50%);
    transition: all 0.3s ease;
}

.dot:hover {
    background: rgba(255, 255, 255, 0.4);
    transform: scale(1.2);
}

.dot:hover::before {
    width: 100%;
    height: 100%;
}

.dot.active {
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    box-shadow: 0 0 15px rgba(0, 255, 136, 0.5);
    transform: scale(1.3);
}

.dot.active::before {
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.2);
}

/* Trading News Ticker Section */
.trading-ticker-section {
    margin-bottom: 30px;
}



.ticker-container {
    background: rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 10px;
    overflow: hidden;
    position: relative;
    width: 100%;
    height: 60px;
}

.ticker-content {
    display: flex;
    align-items: center;
    animation: ticker-scroll 30s linear infinite;
    white-space: nowrap;
    padding: 12px 0;
    width: max-content;
    min-width: 200%;
    animation-delay: 0s;
    animation-fill-mode: both;
}

.ticker-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 0 20px;
    flex-shrink: 0;
    transition: all 0.3s ease;
}

.ticker-item:hover {
    background: rgba(255, 255, 255, 0.05);
}

.coin-symbol {
    color: #00ff88;
    font-weight: 700;
    font-size: 14px;
    min-width: 40px;
    text-align: center;
}

.coin-price {
    color: #fff;
    font-weight: 600;
    font-size: 14px;
    min-width: 80px;
    text-align: right;
}

.coin-change {
    font-size: 12px;
    font-weight: 600;
    padding: 2px 6px;
    border-radius: 4px;
    min-width: 50px;
    text-align: center;
}

.coin-change.positive {
    background: rgba(0, 255, 136, 0.2);
    color: #00ff88;
}

.coin-change.negative {
    background: rgba(255, 71, 87, 0.2);
    color: #ff4757;
}

.coin-chart {
    width: 60px;
    height: 20px;
    flex-shrink: 0;
}

.coin-chart canvas {
    width: 100% !important;
    height: 100% !important;
}

.ticker-separator {
    width: 1px;
    height: 30px;
    background: rgba(255, 255, 255, 0.1);
    margin: 0 10px;
}

/* Ticker Animation */
@keyframes ticker-scroll {
    0% {
        transform: translateX(0%);
    }
    100% {
        transform: translateX(-100%);
    }
}

/* Pause animation on hover */
.ticker-container:hover .ticker-content {
    animation-play-state: paused;
}

/* Responsive */
@media (max-width: 768px) {
    .ticker-item {
        gap: 8px;
        padding: 0 15px;
    }
    
    .coin-symbol {
        font-size: 12px;
        min-width: 35px;
    }
    
    .coin-price {
        font-size: 12px;
        min-width: 70px;
    }
    
    .coin-change {
        font-size: 10px;
        min-width: 45px;
    }
    
    .coin-chart {
        width: 50px;
        height: 18px;
    }
}

/* Quick Actions */
        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(110px, 1fr));
            gap: 15px;
            margin-bottom: 25px;
        }

.action-btn {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 20px 10px;
    border: 1px solid rgba(245, 158, 11, 0.25);
    text-align: center;
    color: var(--text-primary);
    cursor: pointer;
    transition: var(--transition);
    text-decoration: none;
}

.action-btn:hover {
    background: rgba(251, 191, 36, 0.12);
    transform: translateY(-2px);
    text-decoration: none;
    color: var(--text-primary);
}

.action-btn i {
    font-size: 20px;
    margin-bottom: 8px;
    display: block;
}

.action-btn span {
    font-size: 12px;
    font-weight: 500;
}

/* Recent Section */
.recent-section {
    margin-bottom: 25px;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}

.section-header h3 {
    color: var(--text-primary);
    font-size: 18px;
    font-weight: 600;
    margin: 0;
}

.section-header a {
    color: var(--text-secondary);
    text-decoration: none;
    font-size: 14px;
    transition: var(--transition);
    padding: 8px 12px;
    border-radius: 8px;
    background: rgba(59, 130, 246, 0.1);
    border: 1px solid rgba(59, 130, 246, 0.2);
    font-weight: 500;
}

.section-header a:hover {
    color: var(--text-primary);
    background: rgba(59, 130, 246, 0.2);
    border-color: rgba(59, 130, 246, 0.3);
}

.transaction-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.transaction-item {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    gap: 15px;
    color: var(--text-primary);
}

.transaction-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
}

.transaction-icon.deposit {
    background: rgba(16, 185, 129, 0.2);
    color: var(--success);
}

.transaction-icon.withdraw {
    background: rgba(239, 68, 68, 0.2);
    color: var(--error);
}

.transaction-details {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.transaction-title {
    font-size: 14px;
    font-weight: 500;
}

.transaction-date {
    font-size: 12px;
    color: var(--text-secondary);
}

.transaction-amount {
    font-size: 16px;
    font-weight: 600;
}

.transaction-amount.positive {
    color: var(--success);
}

.transaction-amount.negative {
    color: var(--error);
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .dashboard-container {
        padding: 0;
    }
    
    .balance-card {
        padding: 30px 25px;
        min-height: 260px;
    }
    
    .card-logo {
        bottom: 12px;
        right: 20px;
    }
    
    .logo-text {
        font-size: 16px;
        letter-spacing: 1.5px;
    }
    
    .balance-header {
        font-size: 15px;
        margin-bottom: 18px;
    }
    
    .breakdown-row {
        font-size: 14px;
        padding: 6px 0;
    }
    
    .breakdown-row span:last-child {
        font-size: 15px;
    }
    
    .balance-change {
        font-size: 13px;
        padding: 8px 12px;
    }
    
    .quick-actions {
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
    }
    
    .action-btn {
        padding: 15px 8px;
    }
    
    .carousel-card {
        min-width: 210px;
        padding: 20px 15px;
    }
    
    .card-icon {
        width: 45px;
        height: 45px;
        font-size: 18px;
    }
    
    .card-value {
        font-size: 16px;
    }
}

@media (max-width: 480px) {
    .balance-card {
        padding: 25px 20px;
        min-height: 240px;
    }
    
    .card-logo {
        bottom: 10px;
        right: 18px;
    }
    
    .logo-text {
        font-size: 14px;
        letter-spacing: 1px;
    }
    
    .balance-header {
        font-size: 14px;
        margin-bottom: 15px;
    }
    
    .breakdown-row {
        font-size: 13px;
        padding: 5px 0;
    }
    
    .breakdown-row span:last-child {
        font-size: 14px;
    }
    
    .balance-change {
        font-size: 12px;
        padding: 6px 10px;
    }
    
    .quick-actions {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .carousel-container {
        gap: 10px;
    }
    
    .carousel-card {
        min-width: 190px;
        padding: 18px 12px;
    }
    
    .card-icon {
        width: 40px;
        height: 40px;
        font-size: 16px;
    }
    
    .card-value {
        font-size: 15px;
    }
    
    .card-label {
        font-size: 10px;
    }
    
    .system-notice-banner {
        padding: 0.8rem 1rem;
        margin-bottom: 1.5rem;
    }
    
    .notice-content {
        font-size: 0.9rem;
        gap: 0.8rem;
    }
    
    .notice-content i {
        font-size: 1.1rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Carousel functionality
    const carouselContainer = document.querySelector('.carousel-container');
    const carouselCards = document.querySelectorAll('.carousel-card');
    const dots = document.querySelectorAll('.carousel-dots .dot');
    
    let currentSlide = 0;
    const totalSlides = carouselCards.length;
    
    // Auto-rotate carousel
    function autoRotate() {
        currentSlide = (currentSlide + 1) % totalSlides;
        updateCarousel();
    }
    
    // Update carousel display
    function updateCarousel() {
        // Remove active class from all cards
        carouselCards.forEach(card => card.classList.remove('active'));
        dots.forEach(dot => dot.classList.remove('active'));
        
        // Add active class to current card
        if (carouselCards[currentSlide]) {
            carouselCards[currentSlide].classList.add('active');
        }
        if (dots[currentSlide]) {
            dots[currentSlide].classList.add('active');
        }
        
        // Scroll to current card
        // Disabled to prevent pagination/dot auto scroll
        // if (carouselContainer && carouselCards[currentSlide]) {
        //     carouselCards[currentSlide].scrollIntoView({
        //         behavior: 'smooth',
        //         block: 'nearest',
        //         inline: 'center'
        //     });
        // }
    }
    
    // Dot click handlers
    dots.forEach((dot, index) => {
        dot.addEventListener('click', () => {
            currentSlide = index;
            updateCarousel();
        });
    });
    
    // Card click handlers
    carouselCards.forEach((card, index) => {
        card.addEventListener('click', () => {
            currentSlide = index;
            updateCarousel();
        });
    });
    
    // Auto-rotation disabled - manual navigation only
    // setInterval(autoRotate, 3000); // Change slide every 3 seconds
    
    // Initialize carousel
    updateCarousel();
});

// Timer functionality removed - ROI will be processed automatically

// ROI collection removed - ROI will be sent by admin automatically

// Trading Chart JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Chart data for different coins
    const chartData = {
        btc: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [42000, 42500, 43000, 43250, 42800, 43500, 43250]
        },
        eth: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [2600, 2620, 2640, 2650, 2630, 2660, 2650]
        },
        bnb: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [320, 318, 315, 315, 312, 310, 315]
        },
        ada: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [0.47, 0.48, 0.485, 0.485, 0.49, 0.50, 0.485]
        },
        sol: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [95, 97, 98, 98, 99, 100, 98]
        },
        doge: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [0.083, 0.082, 0.082, 0.082, 0.081, 0.080, 0.082]
        },
        xrp: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [0.62, 0.625, 0.63, 0.625, 0.62, 0.63, 0.625]
        },
        dot: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [7.2, 7.25, 7.3, 7.25, 7.2, 7.3, 7.25]
        },
        matic: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [0.84, 0.85, 0.86, 0.85, 0.84, 0.87, 0.85]
        },
        avax: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [24.5, 25.0, 25.3, 25.3, 25.1, 25.5, 25.3]
        },
        link: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [14.2, 14.5, 14.8, 14.85, 14.7, 15.0, 14.85]
        },
        uni: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [6.2, 6.3, 6.45, 6.45, 6.4, 6.5, 6.45]
        },
        atom: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [8.2, 8.5, 8.75, 8.75, 8.6, 8.9, 8.75]
        },
        near: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [3.0, 3.1, 3.25, 3.25, 3.2, 3.3, 3.25]
        },
        ftm: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [0.33, 0.34, 0.35, 0.35, 0.34, 0.36, 0.35]
        },
        algo: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [0.17, 0.18, 0.18, 0.18, 0.17, 0.19, 0.18]
        },
        vet: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [0.023, 0.024, 0.025, 0.025, 0.024, 0.026, 0.025]
        },
        icp: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [4.6, 4.7, 4.85, 4.85, 4.8, 4.9, 4.85]
        },
        fil: {
            labels: ['00:00', '04:00', '08:00', '12:00', '16:00', '20:00', '24:00'],
            data: [5.0, 5.1, 5.2, 5.2, 5.15, 5.25, 5.2]
        }
    };

    // Create charts for each coin
    const coins = ['btc', 'eth', 'bnb', 'ada', 'sol', 'doge', 'xrp', 'dot', 'matic', 'avax', 'link', 'uni', 'atom', 'near', 'ftm', 'algo', 'vet', 'icp', 'fil'];
    const duplicateCoins = ['btc-chart-2', 'eth-chart-2', 'bnb-chart-2'];
    const charts = {};

    // Ticker functionality
    const tickerContent = document.getElementById('tickerContent');
    
    // Force start animation immediately
    if (tickerContent) {
        tickerContent.style.animation = 'none';
        tickerContent.offsetHeight; // Trigger reflow
        tickerContent.style.animation = 'ticker-scroll 30s linear infinite';
    }

    // Create duplicate charts
    duplicateCoins.forEach(coinId => {
        const ctx = document.getElementById(coinId);
        if (ctx) {
            const coinName = coinId.replace('-chart-2', '');
            charts[coinId] = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: chartData[coinName].labels,
                    datasets: [{
                        data: chartData[coinName].data,
                        borderColor: '#00ff88',
                        backgroundColor: 'rgba(0, 255, 136, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.4,
                        pointRadius: 0,
                        pointHoverRadius: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        x: {
                            display: false
                        },
                        y: {
                            display: false
                        }
                    },
                    elements: {
                        point: {
                            radius: 0
                        }
                    }
                }
            });
        }
    });

    // Live data update function
    function updateLiveData() {
        const tickerItems = document.querySelectorAll('.ticker-item');
        
        tickerItems.forEach(item => {
            const symbol = item.querySelector('.coin-symbol').textContent;
            const priceElement = item.querySelector('.coin-price');
            const changeElement = item.querySelector('.coin-change');
            
            if (priceElement && changeElement) {
                // Get current price
                const currentPrice = parseFloat(priceElement.textContent.replace('$', '').replace(',', ''));
                
                // Generate random change (-2% to +3%)
                const changePercent = (Math.random() - 0.4) * 5; // -2% to +3%
                const newPrice = currentPrice * (1 + changePercent / 100);
                
                // Update price
                priceElement.textContent = '$' + newPrice.toFixed(2);
                
                // Update change
                const changeText = (changePercent >= 0 ? '+' : '') + changePercent.toFixed(2) + '%';
                changeElement.textContent = changeText;
                changeElement.className = 'coin-change ' + (changePercent >= 0 ? 'positive' : 'negative');
            }
        });
    }

    // Update live data every 10 seconds
    setInterval(updateLiveData, 10000);

    coins.forEach(coin => {
        const ctx = document.getElementById(coin + '-chart');
        if (ctx) {
            charts[coin] = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: chartData[coin].labels,
                    datasets: [{
                        data: chartData[coin].data,
                        borderColor: '#00ff88',
                        backgroundColor: 'rgba(0, 255, 136, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.4,
                        pointRadius: 0,
                        pointHoverRadius: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        x: {
                            display: false
                        },
                        y: {
                            display: false
                        }
                    },
                    interaction: {
                        intersect: false
                    }
                }
            });
        }
    });

    // Chart timeframe controls
    const chartBtns = document.querySelectorAll('.chart-btn');
    chartBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            chartBtns.forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            // Update charts based on timeframe
            const timeframe = this.dataset.timeframe;
            updateCharts(timeframe);
        });
    });

    function updateCharts(timeframe) {
        // Simulate different data for different timeframes
        const newData = {
            '1h': {
                btc: [43000, 43100, 43200, 43250, 43200, 43300, 43250],
                eth: [2640, 2645, 2650, 2650, 2648, 2652, 2650],
                bnb: [314, 315, 315, 315, 314, 316, 315],
                ada: [0.483, 0.484, 0.485, 0.485, 0.486, 0.487, 0.485],
                sol: [97, 98, 98, 98, 99, 100, 98],
                doge: [0.081, 0.082, 0.082, 0.082, 0.081, 0.080, 0.082]
            },
            '24h': {
                btc: [42000, 42500, 43000, 43250, 42800, 43500, 43250],
                eth: [2600, 2620, 2640, 2650, 2630, 2660, 2650],
                bnb: [320, 318, 315, 315, 312, 310, 315],
                ada: [0.47, 0.48, 0.485, 0.485, 0.49, 0.50, 0.485],
                sol: [95, 97, 98, 98, 99, 100, 98],
                doge: [0.083, 0.082, 0.082, 0.082, 0.081, 0.080, 0.082]
            },
            '7d': {
                btc: [40000, 41000, 42000, 43000, 42500, 43500, 43250],
                eth: [2500, 2550, 2600, 2650, 2620, 2680, 2650],
                bnb: [300, 310, 315, 315, 320, 325, 315],
                ada: [0.45, 0.47, 0.48, 0.485, 0.49, 0.50, 0.485],
                sol: [90, 95, 98, 98, 100, 105, 98],
                doge: [0.08, 0.081, 0.082, 0.082, 0.083, 0.084, 0.082]
            }
        };

        coins.forEach(coin => {
            if (charts[coin] && newData[timeframe][coin]) {
                charts[coin].data.datasets[0].data = newData[timeframe][coin];
                charts[coin].update('active');
            }
        });
    }
});

// ROI Timer functionality removed - ROI will be processed automatically

// Cancel Investment Functions
var currentInvestmentId = null;

function showCancelModal(investmentId) {
    currentInvestmentId = investmentId;
    document.getElementById('cancelInvestmentModal').style.display = 'block';
    
    // Load investment details
    loadInvestmentDetails(investmentId);
}

function closeCancelModal() {
    document.getElementById('cancelInvestmentModal').style.display = 'none';
    currentInvestmentId = null;
}

function loadInvestmentDetails(investmentId) {
    // This would typically fetch from server, for now showing static info
    document.getElementById('cancelDetails').innerHTML = `
        <div class="cancel-details-card">
            <h5>Investment Details</h5>
            <p><strong>Investment ID:</strong> ${investmentId}</p>
            <p><strong>Status:</strong> Ongoing</p>
            <p class="muted"><strong>Note:</strong> Cancellation will incur a deduction as per plan policy.</p>
        </div>
    `;
}

function confirmCancelInvestment() {
    if (!currentInvestmentId) return;
    
    const reason = document.getElementById('cancelReason').value;
    
    // Show loading state
    const confirmBtn = document.querySelector('.btn-danger-neo');
    const originalText = confirmBtn.innerHTML;
    confirmBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
    confirmBtn.disabled = true;
    
    // Send cancellation request
    fetch('/user/investment/cancel', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            investment_id: currentInvestmentId,
            reason: reason
        })
    })
    .then(response => {
        console.log('Response status:', response.status);
        console.log('Response headers:', response.headers);
        // Always read body; surface server-side error details
        return response.text().then(text => {
            console.log('Raw response:', text);
            let payload = null;
            try { payload = text ? JSON.parse(text) : null; } catch (e) { payload = null; }
            if (!response.ok) {
                const serverMsg = (payload && (payload.message || payload.error)) ? (payload.message || payload.error) : text;
                throw new Error(`HTTP ${response.status}: ${serverMsg}`);
            }
            return payload || { success: true };
        });
    })
    .then(data => {
        console.log('Parsed data:', data);
        if (data && data.success) {
            alert('Investment cancelled successfully!');
            location.reload();
        } else {
            const errDetails = data && data.errors ? Object.values(data.errors).flat().join('\n') : '';
            const msg = (data && data.message) ? data.message : 'Failed to cancel investment';
            showCancelError(msg + (errDetails ? ('\n' + errDetails) : ''));
        }
    })
    .catch(error => {
        console.error('Error details:', error);
        console.error('Error stack:', error.stack);
        showCancelError('Error cancelling investment: ' + error.message);
    })
    .finally(() => {
        confirmBtn.innerHTML = originalText;
        confirmBtn.disabled = false;
        closeCancelModal();
    });
}

function showCancelError(message) {
    try {
        const box = document.getElementById('cancelErrorBox');
        if (box) {
            box.style.display = 'block';
            box.innerText = message;
        } else {
            alert(message);
        }
    } catch (e) {
        alert(message);
    }
}

// Close modal when clicking outside
window.onclick = function(event) {
    const modal = document.getElementById('cancelInvestmentModal');
    if (event.target == modal) {
        closeCancelModal();
    }
}
</script>

<!-- Cancel Investment Modal - Neo Glass UI -->
<div id="cancelInvestmentModal" class="modal-overlay" style="display: none;">
    <div class="modal-card">
        <div class="modal-header-neo">
            <div class="modal-title">
                <i class="fas fa-times-circle"></i>
                <h3>Cancel Investment</h3>
            </div>
            <button type="button" class="modal-close" aria-label="Close" onclick="closeCancelModal()">&times;</button>
        </div>
        <div class="modal-body-neo">
            <div class="alert-warning-neo">
                <i class="fas fa-exclamation-triangle"></i>
                <div>
                    <strong>Heads up!</strong> Canceling will apply a deduction according to plan policy. Refund will be credited to your main wallet.
                </div>
            </div>
            <div id="cancelErrorBox" class="alert-danger-neo" style="display:none;margin-bottom:12px;">
                <!-- Dynamic error text will appear here -->
            </div>
            <div id="cancelDetails" class="cancel-details"></div>
            <div class="form-field">
                <label for="cancelReason">Reason (optional)</label>
                <textarea id="cancelReason" rows="4" placeholder="Tell us briefly why you want to cancel..."></textarea>
                <div class="field-hint"><i class="fas fa-shield-alt"></i> Your feedback helps us improve plans.</div>
            </div>
        </div>
        <div class="modal-actions">
            <button type="button" class="btn-ghost" onclick="closeCancelModal()"><i class="fas fa-arrow-left"></i> Keep Plan</button>
            <button type="button" class="btn-danger-neo" onclick="confirmCancelInvestment()"><i class="fas fa-check"></i> Confirm Cancellation</button>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.shahdeveloper.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/user/dashboard.blade.php ENDPATH**/ ?>