<?php $__env->startSection('title'); ?>
<?php echo e(__('Investment')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- Investment Page -->
<div class="investment-page">
    <div class="investment-container">
        <div class="page-header">
            <h2>Investment Plan</h2>
            <p>Choose your investment amount and wallet</p>
        </div>

        <div class="investment-form-container">
            <!-- Plan Details -->
            <div class="plan-details glass-effect">
                <div class="plan-header">
                    <div class="plan-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="plan-info">
                        <h3><?php echo e($schema->name); ?></h3>
                        <p><?php echo e($schema->description); ?></p>
                    </div>
                </div>

                <div class="plan-specs">
                    <?php if($schema->type == 'range'): ?>
                    <div class="spec-item">
                        <span class="label">Amount Range:</span>
                        <span class="value"><?php echo e($currencySymbol); ?><?php echo e(number_format($schema->min_amount, 2)); ?> - <?php echo e($currencySymbol); ?><?php echo e(number_format($schema->max_amount, 2)); ?></span>
                    </div>
                    <?php else: ?>
                    <div class="spec-item">
                        <span class="label">Fixed Amount:</span>
                        <span class="value"><?php echo e($currencySymbol); ?><?php echo e(number_format($schema->fixed_amount, 2)); ?></span>
                    </div>
                    <?php endif; ?>
                    <div class="spec-item">
                        <span class="label">Return Interest:</span>
                        <span class="value"><?php echo e($schema->return_interest); ?><?php echo e($schema->interest_type == 'percentage' ? '%' : ' ' . $currency); ?></span>
                    </div>
                    <div class="spec-item">
                        <span class="label">Return Period:</span>
                        <span class="value"><?php echo e($schema->schedule->name ?? 'Daily'); ?></span>
                    </div>
                </div>
            </div>

            <!-- Investment Form -->
            <div class="investment-form glass-effect">
                <form action="<?php echo e(route('user.invest-now')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="schema_id" value="<?php echo e($schema->id); ?>">
                    
                    <div class="form-group">
                        <label for="invest_amount">Investment Amount</label>
                        <?php if($schema->type == 'fixed'): ?>
                        <input type="number" id="invest_amount" name="invest_amount" value="<?php echo e($schema->fixed_amount); ?>" readonly class="form-control">
                        <?php else: ?>
                        <input type="number" id="invest_amount" name="invest_amount" min="<?php echo e($schema->min_amount); ?>" max="<?php echo e($schema->max_amount); ?>" step="0.01" class="form-control" placeholder="Enter amount" required>
                        <small class="help-text">Min: <?php echo e($currencySymbol); ?><?php echo e(number_format($schema->min_amount, 2)); ?> - Max: <?php echo e($currencySymbol); ?><?php echo e(number_format($schema->max_amount, 2)); ?></small>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="wallet">Select Wallet</label>
                        <select id="wallet" name="wallet" class="form-control" required>
                            <option value="main">Main Wallet (<?php echo e($currencySymbol); ?><?php echo e(number_format(auth()->user()->balance, 2)); ?>)</option>
                            <option value="profit">Profit Wallet (<?php echo e($currencySymbol); ?><?php echo e(number_format(auth()->user()->profit_balance, 2)); ?>)</option>
                        </select>
                    </div>

                    <div class="form-actions">
                        <a href="<?php echo e(route('user.schema')); ?>" class="btn-cancel">
                            <i class="fas fa-arrow-left"></i>
                            <span>Back to Plans</span>
                        </a>
                        <button type="submit" class="btn-invest">
                            <i class="fas fa-check"></i>
                            <span>Confirm Investment</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.investment-page {
    min-height: 100vh;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
    padding: 20px 0;
}

.investment-container {
    max-width: 800px;
    margin: 0 auto;
    padding: 0 20px;
}

.page-header {
    text-align: center;
    margin-bottom: 30px;
}

.page-header h2 {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.page-header p {
    color: var(--text-secondary);
    font-size: 16px;
}

.investment-form-container {
    display: grid;
    gap: 30px;
}

.plan-details, .investment-form {
    background: linear-gradient(135deg, rgba(15, 23, 42, 0.8) 0%, rgba(30, 41, 59, 0.6) 100%);
    backdrop-filter: blur(25px);
    border-radius: 20px;
    padding: 30px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    color: white;
}

.plan-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 25px;
}

.plan-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #667eea, #764ba2);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
}

.plan-info h3 {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 5px;
}

.plan-info p {
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
}

.plan-specs {
    display: grid;
    gap: 15px;
}

.spec-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.spec-item:last-child {
    border-bottom: none;
}

.spec-item .label {
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
}

.spec-item .value {
    font-weight: 600;
    font-size: 16px;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.9);
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    border-radius: 12px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    background: rgba(255, 255, 255, 0.1);
    color: white;
    font-size: 16px;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: rgba(255, 255, 255, 0.4);
    background: rgba(255, 255, 255, 0.15);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.6);
}

.help-text {
    display: block;
    margin-top: 5px;
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
}

.form-actions {
    display: flex;
    gap: 15px;
    margin-top: 30px;
}

.btn-cancel, .btn-invest {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 20px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
    font-size: 16px;
}

.btn-cancel {
    background: rgba(255, 255, 255, 0.1);
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.btn-cancel:hover {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    text-decoration: none;
}

.btn-invest {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
}

.btn-invest:hover {
    background: linear-gradient(135deg, #5a67d8, #6b46c1);
    transform: translateY(-2px);
}

@media (max-width: 768px) {
    .investment-container {
        padding: 0 15px;
    }
    
    .plan-header {
        flex-direction: column;
        text-align: center;
        gap: 10px;
    }
    
    .plan-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
    }
    
    .form-actions {
        flex-direction: column;
    }
}
</style>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend.shahdeveloper.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/app/Providers/../../resources/views/frontend/shahdeveloper/user/invest.blade.php ENDPATH**/ ?>