<?php $__env->startSection('title'); ?>
Collect Your ROI
<?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle'); ?>
Collect your investment returns and track your progress
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="collect-roi-page">
    <div class="roi-container">
        
        <!-- Page Header -->
        <div class="page-header">
            <h2><i class="fas fa-coins"></i> Collect Your ROI</h2>
            <p>Track and collect your investment returns</p>
        </div>

        <?php if($userInvestments->count() > 0): ?>
            <!-- ROI Plans Grid -->
            <div class="roi-plans-grid">
                <?php $__currentLoopData = $userInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $activeSchedule = $investment->roiSchedules->where('status', 'pending')->first();
                        $readySchedule = $investment->roiSchedules->where('status', 'ready')->first();
                        $completedSchedules = $investment->roiSchedules->where('status', 'sent')->count();
                        $totalCycles = $investment->schema->number_of_period ?? 30;
                        $progressPercentage = $readySchedule ? 100 : ($activeSchedule ? $activeSchedule->getProgressPercentage() : 0);
                        $timeRemaining = $activeSchedule ? $activeSchedule->getTimeRemaining() : 0;
                        $roiAmount = $investment->schema ? ($investment->invest_amount * $investment->schema->return_interest) / 100 : 0;
                    ?>
                    
                    <div class="roi-plan-card" data-investment-id="<?php echo e($investment->id); ?>" data-schedule-id="<?php echo e($readySchedule ? $readySchedule->id : ($activeSchedule ? $activeSchedule->id : '')); ?>">
                        <!-- Plan Header -->
                        <div class="plan-header">
                            <h3><?php echo e($investment->schema->name); ?></h3>
                            <div class="plan-badge">
                                <span class="badge badge-<?php echo e($readySchedule ? 'success' : ($activeSchedule ? 'warning' : 'secondary')); ?>">
                                    <?php echo e($readySchedule ? 'Ready' : ($activeSchedule ? 'Pending' : 'Completed')); ?>

                                </span>
                            </div>
                        </div>

                        <!-- Investment Details -->
                        <div class="investment-details">
                            <div class="detail-item">
                                <span class="label">Investment:</span>
                                <span class="value">$<?php echo e(number_format($investment->invest_amount, 2)); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">ROI Rate:</span>
                                <span class="value"><?php echo e($investment->schema->return_interest); ?>%</span>
                            </div>
                            <div class="detail-item">
                                <span class="label">ROI Amount:</span>
                                <span class="value">$<?php echo e(number_format($roiAmount, 2)); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">Cycle:</span>
                                <span class="value"><?php echo e($completedSchedules + 1); ?>/<?php echo e($totalCycles); ?></span>
                            </div>
                        </div>

                        <!-- Progress Circle -->
                        <div class="progress-circle-container">
                            <div class="progress-circle" data-percentage="<?php echo e($progressPercentage); ?>">
                                <div class="circle-inner">
                                    <?php if($readySchedule): ?>
                                        <div class="ready-content">
                                            <i class="fas fa-check-circle"></i>
                                            <span class="ready-text">Ready!</span>
                                        </div>
                                    <?php elseif($activeSchedule): ?>
                                        <div class="pending-content">
                                            <div class="timer" data-end-time="<?php echo e($activeSchedule->roi_end_time->timestamp); ?>">
                                                <span class="timer-text">Loading...</span>
                                            </div>
                                            <div class="progress-text"><?php echo e($progressPercentage); ?>%</div>
                                        </div>
                                    <?php else: ?>
                                        <div class="completed-content">
                                            <i class="fas fa-trophy"></i>
                                            <span class="completed-text">Completed</span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Action Button -->
                        <div class="action-section">
                            <?php if($readySchedule): ?>
                                <button class="btn btn-collect" onclick="collectRoi(<?php echo e($readySchedule->id); ?>, <?php echo e($investment->id); ?>)">
                                    <i class="fas fa-download"></i>
                                    Collect ROI ($<?php echo e(number_format($roiAmount, 2)); ?>)
                                </button>
                            <?php elseif($activeSchedule): ?>
                                <div class="waiting-info">
                                    <i class="fas fa-clock"></i>
                                    <span>Waiting for timer to complete...</span>
                                </div>
                            <?php else: ?>
                                <div class="completed-info">
                                    <i class="fas fa-check-circle"></i>
                                    <span>All cycles completed!</span>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Progress Bar -->
                        <?php if($activeSchedule): ?>
                        <div class="progress-bar-container">
                            <div class="progress-bar">
                                <div class="progress-fill" style="width: <?php echo e($progressPercentage); ?>%"></div>
                            </div>
                            <div class="progress-labels">
                                <span>Started</span>
                                <span><?php echo e($progressPercentage); ?>%</span>
                                <span>Ready</span>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            

        <?php else: ?>
            <!-- No Investments State -->
            <div class="no-investments">
                <div class="no-investments-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <h3>No Active Investments</h3>
                <p>You don't have any active investments yet. Start investing to see your ROI here!</p>
                <a href="<?php echo e(route('user.schema')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i>
                    Start Investing
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
/* Collect ROI Page Styles */
.collect-roi-page {
    padding: 20px;
    max-width: 1200px;
    margin: 0 auto;
}

.page-header {
    text-align: center;
    margin-bottom: 30px;
    padding: 20px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: var(--border-radius);
    color: white;
}

.page-header h2 {
    margin: 0 0 10px 0;
    font-size: 28px;
    font-weight: 700;
}

.page-header p {
    margin: 0;
    opacity: 0.9;
    font-size: 16px;
}

.roi-plans-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 25px;
    margin-bottom: 30px;
}

.roi-plan-card {
    background: var(--surface);
    border: 1px solid var(--border);
    border-radius: var(--border-radius);
    padding: 25px;
    transition: var(--transition);
    position: relative;
    overflow: hidden;
}

.roi-plan-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
}

.roi-plan-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
}

.plan-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.plan-header h3 {
    margin: 0;
    color: var(--text-primary);
    font-size: 20px;
    font-weight: 600;
}

.plan-badge .badge {
    font-size: 12px;
    padding: 6px 12px;
    border-radius: 20px;
}

.investment-details {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
    margin-bottom: 25px;
}

.detail-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid var(--border-light);
}

.detail-item:last-child {
    border-bottom: none;
}

.detail-item .label {
    color: var(--text-secondary);
    font-size: 14px;
    font-weight: 500;
}

.detail-item .value {
    color: var(--text-primary);
    font-weight: 600;
    font-size: 14px;
}

.progress-circle-container {
    display: flex;
    justify-content: center;
    margin: 25px 0;
}

.progress-circle {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    background: conic-gradient(var(--primary-color) 0deg, var(--primary-color) 0deg, var(--border) 0deg);
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    transition: all 0.3s ease;
}

.progress-circle::before {
    content: '';
    position: absolute;
    width: 100px;
    height: 100px;
    background: var(--surface);
    border-radius: 50%;
    z-index: 1;
}

.circle-inner {
    position: relative;
    z-index: 2;
    text-align: center;
    color: var(--text-primary);
}

.ready-content {
    color: var(--success);
}

.ready-content i {
    font-size: 24px;
    margin-bottom: 5px;
    display: block;
}

.ready-text {
    font-size: 12px;
    font-weight: 600;
}

.pending-content .timer {
    font-family: 'Courier New', monospace;
    font-size: 14px;
    font-weight: 600;
    color: var(--warning);
    margin-bottom: 5px;
}

.progress-text {
    font-size: 12px;
    color: var(--text-secondary);
}

.completed-content {
    color: var(--success);
}

.completed-content i {
    font-size: 24px;
    margin-bottom: 5px;
    display: block;
}

.completed-text {
    font-size: 12px;
    font-weight: 600;
}

.action-section {
    text-align: center;
    margin: 20px 0;
}

.btn-collect {
    background: linear-gradient(135deg, var(--success), #10b981);
    color: white;
    border: none;
    padding: 12px 24px;
    border-radius: var(--border-radius);
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: var(--transition);
    box-shadow: 0 4px 15px rgba(5, 150, 105, 0.3);
}

.btn-collect:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(5, 150, 105, 0.4);
}

.btn-collect-all {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
    border: none;
    padding: 15px 30px;
    border-radius: var(--border-radius);
    font-weight: 600;
    font-size: 16px;
    cursor: pointer;
    transition: var(--transition);
    box-shadow: 0 4px 15px rgba(30, 64, 175, 0.3);
    width: 100%;
    max-width: 400px;
    margin: 0 auto;
    display: block;
}

.btn-collect-all:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(30, 64, 175, 0.4);
}

.waiting-info, .completed-info {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    color: var(--text-secondary);
    font-size: 14px;
    padding: 12px;
    background: var(--surface-light);
    border-radius: var(--border-radius);
}

.completed-info {
    color: var(--success);
}

.progress-bar-container {
    margin-top: 20px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: var(--border);
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 8px;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
    border-radius: 4px;
    transition: width 0.3s ease;
}

.progress-labels {
    display: flex;
    justify-content: space-between;
    font-size: 12px;
    color: var(--text-muted);
}

.quick-actions {
    text-align: center;
    margin: 30px 0;
    padding: 20px;
    background: var(--surface);
    border: 1px solid var(--border);
    border-radius: var(--border-radius);
}

.no-investments {
    text-align: center;
    padding: 60px 20px;
    background: var(--surface);
    border: 1px solid var(--border);
    border-radius: var(--border-radius);
}

.no-investments-icon {
    font-size: 64px;
    color: var(--text-muted);
    margin-bottom: 20px;
}

.no-investments h3 {
    color: var(--text-primary);
    margin-bottom: 15px;
}

.no-investments p {
    color: var(--text-secondary);
    margin-bottom: 25px;
    font-size: 16px;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .collect-roi-page {
        padding: 15px;
    }
    
    .roi-plans-grid {
        grid-template-columns: 1fr;
        gap: 20px;
    }
    
    .investment-details {
        grid-template-columns: 1fr;
        gap: 10px;
    }
    
    .progress-circle {
        width: 100px;
        height: 100px;
    }
    
    .progress-circle::before {
        width: 80px;
        height: 80px;
    }
}
</style>

<script>
// Update progress circles based on percentage
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.progress-circle').forEach(circle => {
        const percentage = circle.dataset.percentage;
        const degrees = (percentage / 100) * 360;
        circle.style.background = `conic-gradient(var(--primary-color) 0deg, var(--primary-color) ${degrees}deg, var(--border) ${degrees}deg)`;
    });
});

// Timer functionality
function updateTimers() {
    document.querySelectorAll('.timer').forEach(timer => {
        const endTime = parseInt(timer.dataset.endTime);
        const now = Math.floor(Date.now() / 1000);
        const remaining = endTime - now;
        
        if (remaining > 0) {
            const hours = Math.floor(remaining / 3600);
            const minutes = Math.floor((remaining % 3600) / 60);
            const seconds = remaining % 60;
            
            timer.querySelector('.timer-text').textContent = 
                `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
        } else {
            timer.querySelector('.timer-text').textContent = 'Ready!';
            // Check if ROI is ready and update UI
            checkRoiStatus(timer);
        }
    });
}

// Check ROI status and update UI
function checkRoiStatus(timer) {
    const card = timer.closest('.roi-plan-card');
    const investmentId = card.dataset.investmentId;
    
    // For now, just show the collect button when timer completes
    // The collectRoiFromTimer function will handle the actual collection
    const actionSection = card.querySelector('.action-section');
    const progressCircle = card.querySelector('.progress-circle');
    
    // Update action section to show collect button
    actionSection.innerHTML = `
        <button class="btn btn-collect" onclick="collectRoiFromTimer(${investmentId})">
            <i class="fas fa-download"></i>
            Collect ROI
        </button>
    `;
    
    // Update progress circle to show ready state
    progressCircle.style.background = 'conic-gradient(var(--success) 0deg, var(--success) 360deg)';
    progressCircle.querySelector('.circle-inner').innerHTML = `
        <div class="ready-content">
            <i class="fas fa-check-circle"></i>
            <span class="ready-text">Ready!</span>
        </div>
    `;
}

// Update timers every second
setInterval(updateTimers, 1000);
updateTimers();

// Collect ROI from timer (when timer completes)
function collectRoiFromTimer(investmentId) {
    // Find the ready schedule for this specific investment
    // We'll use a direct approach by finding the schedule ID from the page data
    const card = document.querySelector(`[data-investment-id="${investmentId}"]`);
    const scheduleId = card.dataset.scheduleId;
    
    if (!scheduleId) {
        showNotification('error', 'No ready ROI found for this investment');
        return;
    }
    
    if (confirm('Are you sure you want to collect this ROI?')) {
        fetch(`<?php echo e(route('user.roi.collect')); ?>`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                schedule_id: scheduleId
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showNotification('success', `ROI collected successfully! Amount: $${data.amount}`);
                setTimeout(() => location.reload(), 2000);
            } else {
                showNotification('error', 'Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('error', 'An error occurred while collecting ROI');
        });
    }
}

// Collect single ROI
function collectRoi(scheduleId, investmentId) {
    if (confirm('Are you sure you want to collect this ROI?')) {
        fetch(`<?php echo e(route('user.roi.collect')); ?>`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ schedule_id: scheduleId })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show success message
                showNotification('success', `ROI collected successfully! Amount: $${data.amount}`);
                
                // Update UI
                const card = document.querySelector(`[data-investment-id="${investmentId}"]`);
                if (card) {
                    // Update button to show next cycle
                    const actionSection = card.querySelector('.action-section');
                    actionSection.innerHTML = `
                        <div class="waiting-info">
                            <i class="fas fa-clock"></i>
                            <span>Next cycle starting...</span>
                        </div>
                    `;
                    
                    // Update progress circle
                    const progressCircle = card.querySelector('.progress-circle');
                    progressCircle.style.background = 'conic-gradient(var(--border) 0deg, var(--border) 360deg)';
                    progressCircle.querySelector('.circle-inner').innerHTML = `
                        <div class="pending-content">
                            <div class="timer" data-end-time="${Math.floor(Date.now() / 1000) + 86400}">
                                <span class="timer-text">24:00:00</span>
                            </div>
                            <div class="progress-text">0%</div>
                        </div>
                    `;
                }
                
                // Refresh page after 2 seconds
                setTimeout(() => location.reload(), 2000);
            } else {
                showNotification('error', 'Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('error', 'An error occurred while collecting ROI');
        });
    }
}

// Collect all ROI
function collectAllRoi() {
    if (confirm('Are you sure you want to collect all ready ROI?')) {
        fetch(`<?php echo e(route('user.roi.collect-all')); ?>`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showNotification('success', `Successfully collected ${data.processed_count} ROI schedules! Total amount: $${data.total_amount}`);
                setTimeout(() => location.reload(), 2000);
            } else {
                showNotification('error', 'Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('error', 'An error occurred while collecting ROI');
        });
    }
}

// Notification function
function showNotification(type, message) {
    const notification = document.createElement('div');
    notification.className = `notification notification-${type}`;
    notification.innerHTML = `
        <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'}"></i>
        <span>${message}</span>
    `;
    
    // Add styles
    notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: ${type === 'success' ? 'var(--success)' : 'var(--danger)'};
        color: white;
        padding: 15px 20px;
        border-radius: var(--border-radius);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        z-index: 9999;
        display: flex;
        align-items: center;
        gap: 10px;
        font-weight: 500;
        animation: slideIn 0.3s ease;
    `;
    
    document.body.appendChild(notification);
    
    // Remove after 5 seconds
    setTimeout(() => {
        notification.style.animation = 'slideOut 0.3s ease';
        setTimeout(() => notification.remove(), 300);
    }, 5000);
}

// Add CSS for animations
const style = document.createElement('style');
style.textContent = `
    @keyframes slideIn {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes slideOut {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(100%); opacity: 0; }
    }
`;
document.head.appendChild(style);
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.shahdeveloper.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/user/collect-roi.blade.php ENDPATH**/ ?>