<?php $__env->startSection('title'); ?>
    <?php echo e(__('Ticket Logs')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="desktop-screen-show">
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Ticket Logs')); ?></h3>
                    <div class="ticket-actions">
                        <a href="<?php echo e(route('user.ticket.index')); ?>" class="site-btn">
                            <i icon-name="list"></i><?php echo e(__('All Tickets')); ?>

                        </a>
                        <a href="<?php echo e(route('user.ticket.new')); ?>" class="site-btn primary-btn">
                            <i icon-name="plus-circle"></i><?php echo e(__('New Ticket')); ?>

                        </a>
                    </div>
                </div>
                <div class="site-card-body">
                    <?php if($tickets && $tickets->count() > 0): ?>
                        <div class="ticket-logs-container">
                            <div class="debug-info" style="background: #00ff00; color: #000; padding: 10px; margin: 10px 0;">
                                Debug: Found <?php echo e($tickets->count()); ?> tickets
                            </div>
                            <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="ticket-log-item">
                                    <div class="ticket-log-header">
                                        <div class="ticket-info">
                                            <h4 class="ticket-title"><?php echo e($ticket->title); ?></h4>
                                            <div class="ticket-meta">
                                                <span class="ticket-id">#<?php echo e($ticket->uuid); ?></span>
                                                <span class="ticket-date"><?php echo e($ticket->created_at); ?></span>
                                                <?php if($ticket->status == 'open'): ?>
                                                    <span class="site-badge success"><?php echo e(__('Open')); ?></span>
                                                <?php elseif($ticket->status == 'closed'): ?>
                                                    <span class="site-badge warning"><?php echo e(__('Closed')); ?></span>
                                                <?php else: ?>
                                                    <span class="site-badge pending"><?php echo e(ucfirst($ticket->status)); ?></span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="ticket-actions">
                                            <a href="<?php echo e(route('user.ticket.show', $ticket->uuid)); ?>" 
                                               class="site-btn-small primary-btn">
                                                <i icon-name="eye"></i><?php echo e(__('View')); ?>

                                            </a>
                                        </div>
                                    </div>
                                    
                                    <!-- Original Message -->
                                    <div class="ticket-message user-message">
                                        <div class="message-header">
                                            <div class="message-author">
                                                <i icon-name="user" class="author-icon"></i>
                                                <span class="author-name"><?php echo e(__('You')); ?></span>
                                            </div>
                                            <div class="message-time"><?php echo e($ticket->created_at); ?></div>
                                        </div>
                                        <div class="message-content">
                                            <p><?php echo e(strip_tags($ticket->message)); ?></p>
                                            <?php if($ticket->attach): ?>
                                                <div class="message-attachment">
                                                    <i icon-name="paperclip"></i>
                                                    <a href="<?php echo e(asset('storage/tickets/' . $ticket->attach)); ?>" target="_blank">
                                                        <?php echo e($ticket->attach); ?>

                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <!-- Admin Replies -->
                                    <?php if($ticket->messages && $ticket->messages->count() > 0): ?>
                                        <?php $__currentLoopData = $ticket->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="ticket-message admin-message">
                                                <div class="message-header">
                                                    <div class="message-author">
                                                        <i icon-name="shield-check" class="author-icon admin-icon"></i>
                                                        <span class="author-name"><?php echo e(__('Admin')); ?></span>
                                                    </div>
                                                    <div class="message-time"><?php echo e($reply->created_at); ?></div>
                                                </div>
                                                <div class="message-content">
                                                    <p><?php echo e(strip_tags($reply->message)); ?></p>
                                                    <?php if($reply->attach): ?>
                                                        <div class="message-attachment">
                                                            <i icon-name="paperclip"></i>
                                                            <a href="<?php echo e(asset('storage/tickets/' . $reply->attach)); ?>" target="_blank">
                                                                <?php echo e($reply->attach); ?>

                                                            </a>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="no-replies">
                                            <i icon-name="message-circle" class="no-replies-icon"></i>
                                            <span><?php echo e(__('No admin replies yet')); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <div class="empty-state">
                                <i icon-name="message-circle" class="empty-icon"></i>
                                <h4><?php echo e(__('No Tickets Found')); ?></h4>
                                <p><?php echo e(__('You haven\'t created any support tickets yet.')); ?></p>
                                <a href="<?php echo e(route('user.ticket.new')); ?>" class="site-btn">
                                    <i icon-name="plus-circle"></i><?php echo e(__('Create New Ticket')); ?>

                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<!-- Mobile View - Direct HTML -->
<div class="mobile-screen-show" style="display: none;">
    <div style="padding: 15px;">
        <!-- Mobile Debug -->
        <div style="background: #ff0000; color: #fff; padding: 10px; margin: 10px 0; border-radius: 5px;">
            Mobile Debug: Found <?php echo e($tickets ? $tickets->count() : 0); ?> tickets
        </div>
        
        <h3 style="color: #fff; margin-bottom: 20px;"><?php echo e(__('Ticket Logs')); ?></h3>
        
        <?php if($tickets && $tickets->count() > 0): ?>
            <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div style="background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 10px; padding: 15px; margin-bottom: 15px;">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                        <h4 style="color: #fff; margin: 0;"><?php echo e($ticket->title); ?></h4>
                        <?php if($ticket->status == 'open'): ?>
                            <span style="background: #00ff88; color: #000; padding: 4px 8px; border-radius: 12px; font-size: 12px;"><?php echo e(__('Open')); ?></span>
                        <?php elseif($ticket->status == 'closed'): ?>
                            <span style="background: #ffc107; color: #000; padding: 4px 8px; border-radius: 12px; font-size: 12px;"><?php echo e(__('Closed')); ?></span>
                        <?php else: ?>
                            <span style="background: #6c757d; color: #fff; padding: 4px 8px; border-radius: 12px; font-size: 12px;"><?php echo e(ucfirst($ticket->status)); ?></span>
                        <?php endif; ?>
                    </div>
                    
                    <div style="color: #00ff88; font-size: 12px; margin-bottom: 10px;">#<?php echo e($ticket->uuid); ?></div>
                    
                    <!-- Original Message -->
                    <div style="background: rgba(0, 255, 136, 0.1); border-left: 3px solid #00ff88; padding: 10px; margin-bottom: 10px; border-radius: 5px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span style="color: #fff; font-weight: 600; font-size: 12px;"><?php echo e(__('You')); ?></span>
                            <span style="color: #ccc; font-size: 10px;"><?php echo e($ticket->created_at); ?></span>
                        </div>
                        <p style="color: #fff; margin: 0; font-size: 14px;"><?php echo e(strip_tags($ticket->message)); ?></p>
                    </div>

                    <!-- Admin Replies -->
                    <?php if($ticket->messages && $ticket->messages->count() > 0): ?>
                        <?php $__currentLoopData = $ticket->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div style="background: rgba(255, 255, 255, 0.05); border-left: 3px solid #ffc107; padding: 10px; margin-bottom: 10px; border-radius: 5px;">
                                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                    <span style="color: #fff; font-weight: 600; font-size: 12px;"><?php echo e(__('Admin')); ?></span>
                                    <span style="color: #ccc; font-size: 10px;"><?php echo e($reply->created_at); ?></span>
                                </div>
                                <p style="color: #fff; margin: 0; font-size: 14px;"><?php echo e(strip_tags($reply->message)); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div style="text-align: center; padding: 10px; color: #ccc; background: rgba(255, 255, 255, 0.03); border-radius: 5px; margin-bottom: 10px;">
                            <span style="font-size: 12px;"><?php echo e(__('No admin replies')); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <div style="text-align: center; margin-top: 15px;">
                        <a href="<?php echo e(route('user.ticket.show', $ticket->uuid)); ?>" 
                           style="background: #007bff; color: #fff; padding: 8px 16px; border-radius: 5px; text-decoration: none; font-size: 12px;">
                            <?php echo e(__('View Details')); ?>

                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div style="text-align: center; padding: 40px 20px;">
                <h4 style="color: #fff; margin-bottom: 10px;"><?php echo e(__('No Tickets Found')); ?></h4>
                <p style="color: #ccc; margin-bottom: 20px;"><?php echo e(__('You haven\'t created any support tickets yet.')); ?></p>
                <a href="<?php echo e(route('user.ticket.new')); ?>" 
                   style="background: #00ff88; color: #000; padding: 12px 24px; border-radius: 8px; text-decoration: none; font-weight: 600;">
                    <?php echo e(__('Create New Ticket')); ?>

                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('style'); ?>
<style>
/* Desktop Styles */
.site-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    margin-bottom: 20px;
}

.site-card-header {
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.site-card-header .title {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.ticket-actions {
    display: flex;
    gap: 10px;
}

.site-btn {
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    border: none;
    padding: 12px 24px;
    border-radius: 8px;
    color: #000;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.site-btn:hover {
    background: linear-gradient(135deg, #00cc6a, #00ff88);
    color: #000;
    text-decoration: none;
    transform: translateY(-2px);
}

.site-btn.primary-btn {
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: #fff;
}

.site-btn.primary-btn:hover {
    background: linear-gradient(135deg, #0056b3, #007bff);
    color: #fff;
}

.site-card-body {
    padding: 20px;
}

.ticket-logs-container {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.ticket-log-item {
    background: rgba(255, 255, 255, 0.03);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 20px;
    transition: all 0.3s ease;
}

.ticket-log-item:hover {
    background: rgba(255, 255, 255, 0.05);
    border-color: rgba(0, 255, 136, 0.3);
}

.ticket-log-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.ticket-info {
    flex: 1;
}

.ticket-title {
    color: #fff;
    margin: 0 0 10px 0;
    font-weight: 600;
    font-size: 18px;
}

.ticket-meta {
    display: flex;
    align-items: center;
    gap: 15px;
    flex-wrap: wrap;
}

.ticket-id {
    color: #00ff88;
    font-weight: 600;
    font-size: 14px;
}

.ticket-date {
    color: #ccc;
    font-size: 14px;
}

.site-badge {
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.site-badge.success {
    background: rgba(0, 255, 136, 0.2);
    color: #00ff88;
    border: 1px solid #00ff88;
}

.site-badge.warning {
    background: rgba(255, 193, 7, 0.2);
    color: #ffc107;
    border: 1px solid #ffc107;
}

.site-badge.pending {
    background: rgba(108, 117, 125, 0.2);
    color: #6c757d;
    border: 1px solid #6c757d;
}

.ticket-message {
    margin-bottom: 15px;
    padding: 15px;
    border-radius: 8px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.user-message {
    background: rgba(0, 255, 136, 0.1);
    border-left: 4px solid #00ff88;
}

.admin-message {
    background: rgba(255, 255, 255, 0.05);
    border-left: 4px solid #ffc107;
}

.message-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.message-author {
    display: flex;
    align-items: center;
    gap: 8px;
}

.author-icon {
    width: 18px;
    height: 18px;
    color: #00ff88;
}

.admin-icon {
    color: #ffc107;
}

.author-name {
    color: #fff;
    font-weight: 600;
    font-size: 14px;
}

.message-time {
    color: #ccc;
    font-size: 12px;
}

.message-content p {
    color: #fff;
    margin: 0;
    line-height: 1.6;
    font-size: 14px;
}

.message-attachment {
    margin-top: 10px;
    padding: 8px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 6px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.message-attachment i {
    color: #00ff88;
    width: 14px;
    height: 14px;
}

.message-attachment a {
    color: #00ff88;
    text-decoration: none;
    font-size: 12px;
}

.message-attachment a:hover {
    text-decoration: underline;
}

.no-replies {
    text-align: center;
    padding: 20px;
    color: #ccc;
    background: rgba(255, 255, 255, 0.03);
    border-radius: 8px;
    border: 1px dashed rgba(255, 255, 255, 0.1);
}

.no-replies-icon {
    width: 24px;
    height: 24px;
    color: #00ff88;
    margin-bottom: 8px;
}

.site-btn-small {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 500;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 4px;
    transition: all 0.3s ease;
}

.site-btn-small.primary-btn {
    background: rgba(0, 123, 255, 0.2);
    color: #007bff;
    border: 1px solid #007bff;
}

.site-btn-small.primary-btn:hover {
    background: #007bff;
    color: #fff;
    text-decoration: none;
}

.empty-state {
    text-align: center;
    padding: 40px 20px;
}

.empty-icon {
    width: 64px;
    height: 64px;
    color: #00ff88;
    margin-bottom: 20px;
}

.empty-state h4 {
    color: #fff;
    margin-bottom: 10px;
    font-weight: 600;
}

.empty-state p {
    color: #ccc;
    margin-bottom: 20px;
}

/* Mobile Styles */
@media (max-width: 768px) {
    /* Hide desktop view */
    .desktop-screen-show {
        display: none !important;
    }
    
    /* Show mobile view */
    .mobile-screen-show {
        display: block !important;
    }
    
    .site-card-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .ticket-actions {
        width: 100%;
        justify-content: center;
    }
    
    .site-btn {
        flex: 1;
        justify-content: center;
        padding: 10px 16px;
        font-size: 14px;
    }
    
    .ticket-log-header {
        flex-direction: column;
        gap: 15px;
    }
    
    .ticket-meta {
        justify-content: center;
    }
    
    .ticket-message {
        padding: 12px;
    }
    
    .message-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 5px;
    }
}

/* Mobile Ticket Logs */
.mobile-ticket-logs {
    display: none;
}

@media (max-width: 768px) {
    .ticket-logs-container {
        display: none !important;
    }
    
    .mobile-ticket-logs {
        display: block !important;
    }
    
    .mobile-screen-show {
        display: block !important;
    }
    
    .desktop-screen-show {
        display: none !important;
    }
    
    /* Debug mobile view */
    .debug-info {
        display: block !important;
        background: #ff0000 !important;
        color: #fff !important;
        padding: 10px !important;
        margin: 10px 0 !important;
        border-radius: 5px !important;
    }
}
    
    .mobile-ticket-log {
        background: rgba(255, 255, 255, 0.03);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
    }
    
    .mobile-ticket-log .ticket-header {
        margin-bottom: 15px;
        padding-bottom: 10px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .mobile-ticket-log .ticket-title {
        color: #fff;
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 8px;
    }
    
    .mobile-ticket-log .ticket-meta {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 8px;
    }
    
    .mobile-ticket-log .ticket-id {
        color: #00ff88;
        font-size: 12px;
        font-weight: 600;
    }
    
    .mobile-message {
        margin-bottom: 10px;
        padding: 10px;
        border-radius: 6px;
        border: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .mobile-message.user-message {
        background: rgba(0, 255, 136, 0.1);
        border-left: 3px solid #00ff88;
    }
    
    .mobile-message.admin-message {
        background: rgba(255, 255, 255, 0.05);
        border-left: 3px solid #ffc107;
    }
    
    .mobile-message .message-header {
        display: flex;
        justify-content: space-between;
        margin-bottom: 8px;
    }
    
    .mobile-message .author-name {
        font-weight: 600;
        font-size: 12px;
        color: #fff;
    }
    
    .mobile-message .message-time {
        font-size: 10px;
        color: #ccc;
    }
    
    .mobile-message .message-content p {
        color: #fff;
        margin: 0;
        line-height: 1.4;
        font-size: 13px;
    }
    
    .mobile-ticket-log .ticket-actions {
        margin-top: 15px;
        text-align: center;
    }
    
    .mobile-ticket-log .site-btn-small {
        padding: 8px 16px;
        font-size: 12px;
    }
    
    .mobile-actions {
        display: flex;
        gap: 10px;
        width: 100%;
        justify-content: center;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/ticket/logs.blade.php ENDPATH**/ ?>