<?php $__env->startSection('title'); ?>
    <?php echo e(__('All KYC')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('All KYC')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="row">
                    <div class="col-xl-12 col-md-12">
                        <div class="site-card">
                            <div class="site-card-body table-responsive">
                                <div class="site-datatable">
                                    <table id="dataTable" class="display data-table">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(__('Date')); ?></th>
                                            <th><?php echo e(__('User')); ?></th>
                                            <th><?php echo e(__('Type')); ?></th>
                                            <th><?php echo e(__('Status')); ?></th>
                                            <th><?php echo e(__('Action')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <!-- Modal for Pending KYC Details -->
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('kyc-action')): ?>
                            <div
                                class="modal fade"
                                id="kyc-action-modal"
                                tabindex="-1"
                                aria-labelledby="editPendingDepositModalLabel"
                                aria-hidden="true"
                            >
                                <div class="modal-dialog modal-md modal-dialog-centered">
                                    <div class="modal-content site-table-modal">
                                        <div class="modal-body popup-body">
                                            <button
                                                type="button"
                                                class="btn-close"
                                                data-bs-dismiss="modal"
                                                aria-label="Close"
                                            ></button>
                                            <div class="popup-body-text" id="kyc-action-data">

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <!-- Modal for Pending KYC Details -->
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function ($) {
            "use strict";

            var table = $('#dataTable').DataTable({
                processing: true,
                serverSide: true,
                autoWidth: false,
                ajax: "<?php echo e(route('admin.kyc.all')); ?>",
                columns: [
                    {data: 'time', name: 'time'},
                    {data: 'user', name: 'user'},
                    {data: 'type', name: 'type'},
                    {data: 'status', name: 'status'},
                    {data: 'action', name: 'action'},
                ]
            });
        })(jQuery);

        $('body').on('click', '#action-kyc', function (e) {
            "use strict";
            e.preventDefault()
            $('#kyc-action-data').empty();

            var id = $(this).data('id');

            console.log(id);

            var url = '<?php echo e(route("admin.kyc.action",":id")); ?>';
            url = url.replace(':id', id);
            $.get(url, function (data) {
                $('#kyc-action-data').append(data)
                imagePreview()
            })


            $('#kyc-action-modal').modal('toggle')
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/backend/kyc/all.blade.php ENDPATH**/ ?>