<?php $__env->startSection('title'); ?>
<?php echo e(__('My Investments')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- Invest Logs Page -->
<div class="invest-logs-page">
    <div class="invest-logs-container">
        <div class="page-header">
            <h2>My Investments</h2>
            <p>Track your purchased plans and collect returns</p>
        </div>

        <!-- Stats Cards -->
        <div class="stats-cards">
            <div class="stat-card glass-effect">
                <div class="stat-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="stat-content">
                    <h3><?php echo e($totalInvested); ?></h3>
                    <p>Total Invested</p>
                </div>
            </div>
            
            <div class="stat-card glass-effect">
                <div class="stat-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="stat-content">
                    <h3><?php echo e($totalProfit); ?></h3>
                    <p>Total Profit</p>
                </div>
            </div>
            
            <div class="stat-card glass-effect">
                <div class="stat-icon">
                    <i class="fas fa-play-circle"></i>
                </div>
                <div class="stat-content">
                    <h3><?php echo e($activeInvestments); ?></h3>
                    <p>Active Plans</p>
                </div>
            </div>
            
            <div class="stat-card glass-effect">
                <div class="stat-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-content">
                    <h3><?php echo e($completedInvestments); ?></h3>
                    <p>Completed</p>
                </div>
            </div>
        </div>

        <!-- Investment List -->
        <div class="investment-list">
            <div class="list-header">
                <h3>Your Purchased Plans</h3>
                <div class="filter-tabs">
                    <button class="filter-tab active" data-filter="all">All</button>
                    <button class="filter-tab" data-filter="active">Active</button>
                    <button class="filter-tab" data-filter="completed">Completed</button>
                </div>
            </div>

            <div class="investments-grid">
                <?php $__empty_1 = true; $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="investment-card glass-effect" data-status="<?php echo e($investment->status->value); ?>">
                    <div class="card-header">
                        <div class="plan-info">
                            <h4><?php echo e($investment->schema->name); ?></h4>
                            <span class="plan-type"><?php echo e($investment->schema->type); ?></span>
                        </div>
                        <div class="status-badge status-<?php echo e($investment->status->value); ?>">
                            <?php echo e(ucfirst($investment->status->value)); ?>

                        </div>
                    </div>

                    <div class="card-body">
                        <div class="investment-details">
                            <div class="detail-row">
                                <span class="label">Investment Amount:</span>
                                <span class="value">$<?php echo e(number_format($investment->invest_amount ?? $investment->amount ?? 0, 2)); ?></span>
                            </div>
                            
                            <div class="detail-row">
                                <span class="label">Return Interest:</span>
                                <span class="value"><?php echo e($investment->schema->return_interest); ?>%</span>
                            </div>
                            
                            <div class="detail-row">
                                <span class="label">Number of Periods:</span>
                                <span class="value">
                                    <?php if($investment->schema->return_type == 'period'): ?>
                                        <?php
                                            $activeSchedule = $investment->activeRoiSchedule;
                                            $readySchedule = $investment->readyRoiSchedule;
                                            $completedPeriods = 0;
                                            $totalPeriods = $investment->schema->number_of_period ?? 0;
                                            
                                            if ($activeSchedule) {
                                                $completedPeriods = $activeSchedule->roi_cycle - 1;
                                            } elseif ($readySchedule) {
                                                $completedPeriods = $readySchedule->roi_cycle - 1;
                                            }
                                            
                                            $pendingPeriods = $totalPeriods - $completedPeriods;
                                        ?>
                                        <span class="period-info">
                                            <span class="completed"><?php echo e($completedPeriods); ?></span>/<span class="total"><?php echo e($totalPeriods); ?></span>
                                            <span class="period-label"><?php echo e($totalPeriods == 1 ? 'Time' : 'Times'); ?></span>
                                            <?php if($pendingPeriods > 0): ?>
                                                <span class="pending">(<?php echo e($pendingPeriods); ?> pending)</span>
                                            <?php endif; ?>
                                        </span>
                                    <?php else: ?>
                                        Unlimited
                                    <?php endif; ?>
                                </span>
                            </div>
                            
                            <div class="detail-row">
                                <span class="label">Total Profit:</span>
                                <span class="value profit">$<?php echo e(number_format($investment->total_profit_amount ?? 0, 2)); ?></span>
                            </div>
                            
                            <div class="detail-row">
                                <span class="label">Start Date:</span>
                                <span class="value"><?php echo e(\Carbon\Carbon::parse($investment->created_at)->format('M d, Y')); ?></span>
                            </div>
                            
                            <div class="detail-row">
                                <span class="label">End Date:</span>
                                <span class="value">
                                    <?php if($investment->calculated_end_date): ?>
                                        <?php echo e($investment->calculated_end_date->format('M d, Y')); ?>

                                    <?php elseif($investment->return_type === 'lifetime'): ?>
                                        <span class="lifetime-badge">Lifetime</span>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>

                        <!-- Progress Bar -->
                        <div class="progress-section">
                            <div class="progress-info">
                                <span>Progress</span>
                                <span><?php echo e($investment->progress_percentage); ?>%</span>
                            </div>
                            <div class="progress-bar">
                                <div class="progress-fill" style="width: <?php echo e($investment->progress_percentage); ?>%"></div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="card-actions">
                            <?php if($investment->status->value === 'ongoing'): ?>
                                <?php
                                    $now = \Carbon\Carbon::now();
                                    $nextProfitTime = \Carbon\Carbon::parse($investment->next_profit_time);
                                    $canCollect = $now->gte($nextProfitTime);
                                    $timeRemaining = $now->lt($nextProfitTime) ? $nextProfitTime->diffForHumans($now, true) : 'Available';
                                    $isCompleted = $investment->return_type === 'period' && $investment->already_return_profit >= $investment->number_of_period;
                                ?>
                                
                                <?php if($isCompleted): ?>
                                    <button class="btn-completed" disabled>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Investment Completed</span>
                                    </button>
                                <?php else: ?>
                                    <?php
                                        $activeSchedule = $investment->activeRoiSchedule;
                                        $readySchedule = $investment->readyRoiSchedule;
                                    ?>
                                    
                                    <?php if($readySchedule): ?>
                                        <div class="roi-progress-btn">
                                            <a href="<?php echo e(route('user.collect-roi')); ?>" class="btn-roi-progress">
                                                <i class="fas fa-chart-line"></i>
                                                <span>ROI Progress</span>
                                                <small>Cycle <?php echo e($readySchedule->roi_cycle); ?>/<?php echo e($readySchedule->total_cycles); ?></small>
                                            </a>
                                        </div>
                                    <?php elseif($activeSchedule): ?>
                                        <div class="roi-progress-btn">
                                            <a href="<?php echo e(route('user.collect-roi')); ?>" class="btn-roi-progress">
                                                <i class="fas fa-chart-line"></i>
                                                <span>ROI Progress</span>
                                                <small>Cycle <?php echo e($activeSchedule->roi_cycle); ?>/<?php echo e($activeSchedule->total_cycles); ?></small>
                                            </a>
                                        </div>
                                <?php else: ?>
                                        <div class="roi-chip roi-info">
                                            <i class="fas fa-info-circle"></i>
                                            <div class="roi-chip-text">
                                                <span>ROI DAILY ADMIN KEE TARAF SY SEND HOJAYEGA</span>
                                        </div>
                                        </div>
                                    <?php endif; ?>
                                    
                                    
                                    <?php if($investment->schema->schema_cancel == 1): ?>
                                        <div class="cancel-investment-section">
                                            <button type="button" class="btn-cancel-invest" onclick="showCancelModal(<?php echo e($investment->id); ?>)">
                                                <i class="fas fa-times-circle"></i>
                                                Cancel Investment
                                            </button>
                                    </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php elseif($investment->status->value === 'completed'): ?>
                                <button class="btn-collected" disabled>
                                    <i class="fas fa-check"></i>
                                    <span>Completed</span>
                                </button>
                            <?php else: ?>
                                <button class="btn-active" disabled>
                                    <i class="fas fa-clock"></i>
                                    <span>In Progress</span>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="empty-state">
                    <div class="empty-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>No Investments Yet</h3>
                    <p>You haven't purchased any investment plans yet. Go to plans and purchase a plan to start investing.</p>
                    <a href="<?php echo e(route('user.schema')); ?>" class="btn-invest-now">
                        <i class="fas fa-plus"></i>
                        <span>Go to Plans</span>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
.glass-effect {
    background: linear-gradient(135deg, rgba(17, 24, 39, 0.72) 0%, rgba(2, 6, 23, 0.52) 100%) !important;
    backdrop-filter: blur(18px);
    -webkit-backdrop-filter: blur(18px);
    border: 1px solid rgba(255, 255, 255, 0.07) !important;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.25);
}
.invest-logs-page {
    min-height: 100vh;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
    padding: 20px 0;
}

.invest-logs-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
}

.page-header {
    text-align: center;
    margin-bottom: 30px;
}

.page-header h2 {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.page-header p {
    color: var(--text-secondary);
    font-size: 16px;
}

.stats-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: linear-gradient(135deg, rgba(15, 23, 42, 0.8) 0%, rgba(30, 41, 59, 0.6) 100%);
    backdrop-filter: blur(25px);
    border-radius: 20px;
    padding: 25px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    color: white;
    display: flex;
    align-items: center;
    gap: 15px;
}

.stat-icon {
    font-size: 32px;
    color: #16a34a; /* green */
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(22, 163, 74, 0.18);
    border-radius: 12px;
}

.stat-content h3 {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 5px;
}

.stat-content p {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.7);
}

.investment-list {
    background: linear-gradient(135deg, rgba(15, 23, 42, 0.8) 0%, rgba(30, 41, 59, 0.6) 100%);
    backdrop-filter: blur(25px);
    border-radius: 20px;
    padding: 30px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    color: white;
}

.list-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 25px;
    flex-wrap: wrap;
    gap: 15px;
}

.list-header h3 {
    font-size: 24px;
    font-weight: 700;
}

.filter-tabs {
    display: flex;
    gap: 10px;
}

.filter-tab {
    padding: 8px 16px;
    border-radius: 20px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    background: rgba(255, 255, 255, 0.05);
    color: rgba(255, 255, 255, 0.7);
    cursor: pointer;
    transition: all 0.3s ease;
}

.filter-tab.active,
.filter-tab:hover {
    background: linear-gradient(135deg, #22c55e, #16a34a);
    color: white;
    border-color: rgba(34,197,94,0.6);
}

.investments-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 20px;
}

.investment-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    padding: 25px;
    transition: all 0.3s ease;
}

.investment-card:hover {
    background: rgba(255, 255, 255, 0.08);
    border-color: rgba(34, 197, 94, 0.25);
    transform: translateY(-2px);
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
}

.plan-info h4 {
    font-size: 18px;
    font-weight: 700;
    margin-bottom: 5px;
}

.plan-type {
    font-size: 12px;
    color: rgba(255, 255, 255, 0.7);
    background: rgba(255, 255, 255, 0.1);
    padding: 4px 8px;
    border-radius: 8px;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-active {
    background: rgba(34, 197, 94, 0.2);
    color: #22c55e;
    border: 1px solid rgba(34, 197, 94, 0.3);
}

.status-completed {
    background: rgba(22, 163, 74, 0.18);
    color: #16a34a;
    border: 1px solid rgba(22, 163, 74, 0.28);
}

.investment-details {
    margin-bottom: 20px;
}

.detail-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
}

.detail-row:last-child {
    border-bottom: none;
    margin-bottom: 0;
}

.label {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.7);
}

.value {
    font-size: 14px;
    font-weight: 600;
    color: white;
}

.value.profit {
    color: #22c55e;
}

.progress-section {
    margin-bottom: 20px;
}

.progress-info {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
    font-size: 14px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 4px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #22c55e, #16a34a);
    border-radius: 4px;
    transition: width 0.3s ease;
}

.card-actions {
    display: flex;
    gap: 10px;
}

.btn-collected,
.btn-active {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 20px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
    font-size: 14px;
}

.btn-collected {
    background: rgba(34, 197, 94, 0.2);
    color: #22c55e;
    border: 1px solid rgba(34, 197, 94, 0.3);
    cursor: not-allowed;
}

.btn-active {
    background: rgba(148, 163, 184, 0.18);
    color: #cbd5e1;
    border: 1px solid rgba(148, 163, 184, 0.28);
    cursor: not-allowed;
}

.empty-state {
    text-align: center;
    padding: 60px 20px;
    grid-column: 1 / -1;
}

.empty-icon {
    font-size: 64px;
    color: rgba(255, 255, 255, 0.3);
    margin-bottom: 20px;
}

.empty-state h3 {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 10px;
    color: white;
}

.empty-state p {
    color: rgba(255, 255, 255, 0.7);
    margin-bottom: 30px;
}

.btn-invest-now {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    background: linear-gradient(135deg, #22c55e, #16a34a);
    color: white;
    text-decoration: none;
    border-radius: 12px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-invest-now:hover {
    background: linear-gradient(135deg, #16a34a, #15803d);
    transform: translateY(-2px);
    color: white;
    text-decoration: none;
}

.btn-waiting {
    background: rgba(255, 165, 0, 0.1);
    color: #ffa500;
    border: 1px solid rgba(255, 165, 0, 0.3);
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 600;
    cursor: not-allowed;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

/* ROI chip shared theme */
.roi-chip {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 10px 14px;
    border-radius: 14px;
    color: var(--text-primary);
    justify-content: center;
    font-weight: 600;
    background: linear-gradient(135deg, rgba(17,24,39,0.65) 0%, rgba(2,6,23,0.45) 100%);
    border: 1px solid rgba(255,255,255,0.08);
    box-shadow: 0 10px 26px rgba(0,0,0,0.35);
    backdrop-filter: blur(14px);
    margin-top: 6px;
}
.roi-chip i { font-size: 16px; opacity: .95; }
.roi-chip .roi-chip-text { display: flex; flex-direction: column; line-height: 1.15; color: #e5f7ee; }
.roi-chip .roi-chip-text small { opacity: .85; font-weight: 500; }
.roi-ready { border-color: rgba(0,255,136,0.28); box-shadow: 0 8px 24px rgba(0,255,136,0.18); }
.roi-ready i { color: #00ff88; text-shadow: 0 0 10px rgba(0,255,136,.35); }
.roi-pending { border-color: rgba(245,158,11,0.28); box-shadow: 0 8px 24px rgba(245,158,11,0.18); }
.roi-pending i { color: #f59e0b; text-shadow: 0 0 8px rgba(245,158,11,.25); }
.roi-info { border-color: rgba(148,163,184,0.28); box-shadow: 0 8px 24px rgba(148,163,184,0.14); }
.roi-info i { color: #93c5fd; opacity: .95; }

/* Cancel button theme */
.cancel-investment-section { margin-top: 12px; }
.btn-cancel-invest {
    background: linear-gradient(135deg, rgba(239,68,68,0.95), rgba(220,38,38,0.95));
    color: #fff;
    border: 1px solid rgba(239,68,68,0.35);
    padding: 10px 18px;
    border-radius: 12px;
    font-weight: 700;
    letter-spacing: .2px;
    cursor: pointer;
    box-shadow: 0 12px 28px rgba(239, 68, 68, 0.25);
    transition: transform .18s ease, box-shadow .18s ease, filter .18s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}
.btn-cancel-invest:hover { transform: translateY(-2px); box-shadow: 0 16px 34px rgba(239, 68, 68, 0.35); filter: brightness(1.05); }

/* Modal Neo Glass Theme */
.modal-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.55);
    display: grid;
    place-items: center;
    z-index: 1000;
    padding: 20px;
}
.modal-card {
    width: 100%;
    max-width: 520px;
    background: linear-gradient(145deg, rgba(10,15,13,0.92), rgba(14,21,18,0.88));
    border: 1px solid rgba(0,255,136,0.14);
    border-radius: 16px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.45);
    overflow: hidden;
    color: var(--text-primary);
}
.modal-header-neo { display: flex; align-items: center; justify-content: space-between; padding: 16px 18px; border-bottom: 1px solid rgba(255,255,255,0.06); }
.modal-title { display: flex; align-items: center; gap: 10px; }
.modal-title i { color: #ef4444; }
.modal-title h3 { margin: 0; font-weight: 800; }
.modal-close { background: transparent; color: #94a3b8; border: none; font-size: 26px; cursor: pointer; }
.modal-close:hover { color: #e2e8f0; }
.modal-body-neo { padding: 18px; }
.alert-warning-neo { display: flex; gap: 10px; align-items: flex-start; padding: 12px 14px; border-radius: 12px; background: rgba(245,158,11,0.12); color: #fbbf24; border: 1px solid rgba(245,158,11,0.28); margin-bottom: 14px; }
.cancel-details { margin-bottom: 12px; }
.cancel-details-card { background: rgba(255,255,255,0.02); border: 1px solid rgba(148,163,184,0.18); padding: 14px; border-radius: 12px; }
.cancel-details-card h5 { margin: 0 0 8px 0; color: #e2e8f0; }
.cancel-details-card p { margin: 4px 0; color: #cbd5e1; }
.cancel-details-card p.muted { color: #94a3b8; }
.form-field { display: flex; flex-direction: column; gap: 8px; }
.form-field label { font-weight: 700; color: #e2e8f0; }
.form-field textarea { width: 100%; padding: 12px 14px; border-radius: 12px; border: 1px solid rgba(148,163,184,0.28); background: rgba(2,6,23,0.55); color: #e5e7eb; resize: vertical; min-height: 96px; }
.form-field textarea::placeholder { color: #94a3b8; }
.field-hint { font-size: 12px; color: #94a3b8; display: flex; align-items: center; gap: 6px; }
.modal-actions { display: flex; justify-content: flex-end; gap: 10px; padding: 14px 18px; border-top: 1px solid rgba(255,255,255,0.06); }
.btn-ghost { background: transparent; border: 1px solid rgba(148,163,184,0.3); color: #cbd5e1; padding: 10px 14px; border-radius: 10px; font-weight: 700; }
.btn-ghost:hover { border-color: rgba(148,163,184,0.6); }
.btn-danger-neo { background: linear-gradient(135deg, #ef4444, #dc2626); color: #fff; border: 1px solid rgba(239,68,68,0.35); padding: 10px 16px; border-radius: 10px; font-weight: 800; }

@media (max-width: 768px) {
    .invest-logs-container {
        padding: 0 15px;
    }
    
    .stats-cards {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 15px;
    }
    
    .stat-card {
        padding: 20px;
        flex-direction: column;
        text-align: center;
    }
    
    .list-header {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .investments-grid {
        grid-template-columns: 1fr;
    }
    
    .investment-card {
        padding: 20px;
    }
    
    .card-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    
    .detail-row {
        flex-direction: column;
        align-items: flex-start;
        gap: 5px;
    }
}
</style>

<script>
// Filter functionality
document.addEventListener('DOMContentLoaded', function() {
    const filterTabs = document.querySelectorAll('.filter-tab');
    const investmentCards = document.querySelectorAll('.investment-card');
    
    filterTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            // Remove active class from all tabs
            filterTabs.forEach(t => t.classList.remove('active'));
            // Add active class to clicked tab
            this.classList.add('active');
            
            const filter = this.getAttribute('data-filter');
            
            investmentCards.forEach(card => {
                if (filter === 'all' || card.getAttribute('data-status') === filter) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
        });
    });
});


// ROI countdown removed - ROI is now admin-controlled


</script>

<style>

/* ROI Progress Bar Styles */
.roi-progress-container {
    width: 100%;
    margin: 8px 0;
}

.roi-progress-bar {
    width: 100%;
    height: 8px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 8px;
}

.roi-progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #22c55e, #16a34a);
    border-radius: 4px;
    transition: width 0.3s ease;
    position: relative;
}

.roi-progress-fill::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

/* Lifetime Badge Styles */
.lifetime-badge {
    background: linear-gradient(135deg, #8b5cf6, #a855f7);
    color: white;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    box-shadow: 0 2px 4px rgba(139, 92, 246, 0.3);
}

.roi-progress-text {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    font-size: 12px;
    font-weight: 600;
    color: #22c55e;
}

.roi-progress-text i {
    font-size: 14px;
}

/* Period Info Styles */
.period-info {
    display: flex;
    align-items: center;
    gap: 4px;
    flex-wrap: wrap;
}

.period-info .completed {
    color: #22c55e;
    font-weight: 600;
}

.period-info .total {
    color: #6b7280;
    font-weight: 500;
}

.period-info .period-label {
    color: #9ca3af;
    font-size: 12px;
    margin-left: 2px;
}

.period-info .pending {
    color: #f59e0b;
    font-size: 11px;
    font-weight: 500;
    background: rgba(245, 158, 11, 0.1);
    padding: 2px 6px;
    border-radius: 4px;
    margin-left: 4px;
}

.btn-completed {
    background: rgba(34, 197, 94, 0.1);
    color: #22c55e;
    border: 1px solid rgba(34, 197, 94, 0.3);
    border-radius: 12px;
    padding: 12px 20px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

    color: #22c55e;
    font-weight: 600;
}

.period-info .total {
    color: #6b7280;
    font-weight: 500;
}

.period-info .period-label {
    color: #9ca3af;
    font-size: 12px;
    margin-left: 2px;
}

.period-info .pending {
    color: #f59e0b;
    font-size: 11px;
    font-weight: 500;
    background: rgba(245, 158, 11, 0.1);
    padding: 2px 6px;
    border-radius: 4px;
    margin-left: 4px;
}

.btn-completed {
    background: rgba(34, 197, 94, 0.1);
    color: #22c55e;
    border: 1px solid rgba(34, 197, 94, 0.3);
    border-radius: 12px;
    padding: 12px 20px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}
</style>

<script>
// ROI Timer Updates
function startROITimers() {
    <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($investment->activeRoiSchedule): ?>
            var timeRemaining<?php echo e($investment->id); ?> = <?php echo e($investment->activeRoiSchedule->getTimeRemaining()); ?>;
            updateROITimer(<?php echo e($investment->id); ?>, timeRemaining<?php echo e($investment->id); ?>);
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
}

function updateROITimer(investmentId, timeRemaining) {
    var timerElement = document.getElementById('timer-' + investmentId);
    if (!timerElement) return;
    
    var interval = setInterval(function() {
        if (timeRemaining <= 0) {
            clearInterval(interval);
            timerElement.innerHTML = 'Ready!';
            // Update status without page reload
            updateROIStatus(investmentId);
        return;
    }
    
        var hours = Math.floor(timeRemaining / 3600);
        var minutes = Math.floor((timeRemaining % 3600) / 60);
        var seconds = timeRemaining % 60;
        
        timerElement.innerHTML = 
            (hours < 10 ? '0' : '') + hours + ':' +
            (minutes < 10 ? '0' : '') + minutes + ':' +
            (seconds < 10 ? '0' : '') + seconds;
        
        timeRemaining--;
    }, 1000);
}

function updateROIStatus(investmentId) {
    // Check if ROI is ready via AJAX
    fetch('/check-roi-status/' + investmentId)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'ready') {
                // Update UI to show ready status
                var timerElement = document.getElementById('timer-' + investmentId);
                if (timerElement) {
                    timerElement.parentElement.innerHTML = 
                        '<i class="fas fa-check-circle" style="margin-right: 8px;"></i>' +
                        '<span>Your ROI is ready! ROI is added soon</span>';
                }
            }
        })
        .catch(error => {
            console.log('ROI status check failed:', error);
        });
}

// Start timers when page loads
document.addEventListener('DOMContentLoaded', function() {
    startROITimers();
});

// Cancel Investment Functions
var currentInvestmentId = null;

function showCancelModal(investmentId) {
    currentInvestmentId = investmentId;
    document.getElementById('cancelInvestmentModal').style.display = 'block';
    
    // Load investment details
    loadInvestmentDetails(investmentId);
}

function closeCancelModal() {
    document.getElementById('cancelInvestmentModal').style.display = 'none';
    currentInvestmentId = null;
}

function loadInvestmentDetails(investmentId) {
    // This would typically fetch from server, for now showing static info
    document.getElementById('cancelDetails').innerHTML = `
        <div class="cancel-details-card">
            <h5>Investment Details</h5>
            <p><strong>Investment ID:</strong> ${investmentId}</p>
            <p><strong>Status:</strong> Ongoing</p>
            <p class="muted"><strong>Note:</strong> Cancellation will incur a deduction as per plan policy.</p>
        </div>
    `;
}

function confirmCancelInvestment() {
    if (!currentInvestmentId) return;
    
    const reason = document.getElementById('cancelReason').value;
    
    // Show loading state
    const confirmBtn = document.querySelector('.btn-danger-neo');
    const originalText = confirmBtn.innerHTML;
    confirmBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
    confirmBtn.disabled = true;
    
    // Send cancellation request
    fetch('/user/investment/cancel', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            investment_id: currentInvestmentId,
            reason: reason
        })
    })
    .then(response => {
        console.log('Response status:', response.status);
        console.log('Response headers:', response.headers);
        
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        
        return response.text().then(text => {
            console.log('Raw response:', text);
            try {
                return JSON.parse(text);
            } catch (e) {
                console.error('JSON parse error:', e);
                throw new Error('Invalid JSON response');
            }
        });
    })
    .then(data => {
        console.log('Parsed data:', data);
        if (data.success) {
            alert('Investment cancelled successfully!');
                location.reload();
        } else {
            alert('Error: ' + (data.message || 'Failed to cancel investment'));
        }
    })
    .catch(error => {
        console.error('Error details:', error);
        console.error('Error stack:', error.stack);
        alert('Error cancelling investment: ' + error.message);
    })
    .finally(() => {
        confirmBtn.innerHTML = originalText;
        confirmBtn.disabled = false;
        closeCancelModal();
    });
}

// Close modal when clicking outside
window.onclick = function(event) {
    const modal = document.getElementById('cancelInvestmentModal');
    if (event.target == modal) {
        closeCancelModal();
    }
}
</script>

<!-- Cancel Investment Modal - Neo Glass UI -->
<div id="cancelInvestmentModal" class="modal-overlay" style="display: none;">
    <div class="modal-card">
        <div class="modal-header-neo">
            <div class="modal-title">
                <i class="fas fa-times-circle"></i>
                <h3>Cancel Investment</h3>
            </div>
            <button type="button" class="modal-close" aria-label="Close" onclick="closeCancelModal()">&times;</button>
        </div>
        <div class="modal-body-neo">
            <div class="alert-warning-neo">
                <i class="fas fa-exclamation-triangle"></i>
                <div>
                    <strong>Heads up!</strong> Canceling will apply a deduction according to plan policy. Refund will be credited to your main wallet.
                </div>
            </div>
            <div id="cancelDetails" class="cancel-details"></div>
            <div class="form-field">
                <label for="cancelReason">Reason (optional)</label>
                <textarea id="cancelReason" rows="4" placeholder="Tell us briefly why you want to cancel..."></textarea>
                <div class="field-hint"><i class="fas fa-shield-alt"></i> Your feedback helps us improve plans.</div>
            </div>
        </div>
        <div class="modal-actions">
            <button type="button" class="btn-ghost" onclick="closeCancelModal()"><i class="fas fa-arrow-left"></i> Keep Plan</button>
            <button type="button" class="btn-danger-neo" onclick="confirmCancelInvestment()"><i class="fas fa-check"></i> Confirm Cancellation</button>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.shahdeveloper.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/user/invest-logs.blade.php ENDPATH**/ ?>