

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Referral Management')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Referral Management System')); ?></h3>
                    <div class="card-header-links">
                        <a href="#" class="card-header-link" onclick="showAssignReferrerModal()">
                            <i icon-name="plus"></i> <?php echo e(__('Assign Referrer')); ?>

                        </a>
                        <a href="#" class="card-header-link" onclick="generateAvatarsForAllUsers()">
                            <i icon-name="image"></i> <?php echo e(__('Generate All Avatars')); ?>

                        </a>
                    </div>
                </div>
                <div class="site-card-body">
                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="stat-card bg-primary text-white p-3 rounded">
                                <h4><?php echo e($totalUsers); ?></h4>
                                <p class="mb-0"><?php echo e(__('Total Users')); ?></p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="stat-card bg-success text-white p-3 rounded">
                                <h4><?php echo e($usersWithReferrers); ?></h4>
                                <p class="mb-0"><?php echo e(__('Users with Referrers')); ?></p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="stat-card bg-warning text-white p-3 rounded">
                                <h4><?php echo e($usersWithoutReferrers); ?></h4>
                                <p class="mb-0"><?php echo e(__('Users without Referrers')); ?></p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="stat-card bg-info text-white p-3 rounded">
                                <h4><?php echo e(number_format(($usersWithReferrers / max($totalUsers, 1)) * 100, 1)); ?>%</h4>
                                <p class="mb-0"><?php echo e(__('Referral Coverage')); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Users Table -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('User')); ?></th>
                                    <th><?php echo e(__('Email')); ?></th>
                                    <th><?php echo e(__('Join Date')); ?></th>
                                    <th><?php echo e(__('Current Referrer')); ?></th>
                                    <th><?php echo e(__('Referral Count')); ?></th>
                                    <th><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="user-avatar me-2">
                                                <img src="<?php echo e($user->avatar); ?>" alt="<?php echo e($user->username); ?>" class="rounded-circle" width="40">
                                            </div>
                                            <div>
                                                <strong><?php echo e($user->username); ?></strong>
                                                <br>
                                                <small class="text-muted">ID: <?php echo e($user->id); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
                                    <td>
                                        <?php if($user->referrer): ?>
                                            <span class="badge bg-success"><?php echo e($user->referrer->username); ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary"><?php echo e(__('No Referrer')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e($user->referrals()->count()); ?></span>
                                    </td>
                                    <td>
                                        <?php if($user->referrer): ?>
                                            <button class="btn btn-sm btn-warning" onclick="removeReferrer(<?php echo e($user->id); ?>, '<?php echo e($user->username); ?>')">
                                                <i icon-name="user-minus"></i> <?php echo e(__('Remove')); ?>

                                            </button>
                                        <?php else: ?>
                                            <button class="btn btn-sm btn-primary" onclick="assignReferrer(<?php echo e($user->id); ?>, '<?php echo e($user->username); ?>')">
                                                <i icon-name="user-plus"></i> <?php echo e(__('Assign')); ?>

                                            </button>
                                        <?php endif; ?>
                                        <button class="btn btn-sm btn-info" onclick="viewReferralTree(<?php echo e($user->id); ?>)">
                                            <i icon-name="tree"></i> <?php echo e(__('Tree')); ?>

                                        </button>
                                        <button class="btn btn-sm btn-success" onclick="generateAvatar(<?php echo e($user->id); ?>, '<?php echo e($user->username); ?>')">
                                            <i icon-name="image"></i> <?php echo e(__('Avatar')); ?>

                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($users->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Assign Referrer Modal -->
<div class="modal fade" id="assignReferrerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Assign Referrer')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="assignReferrerForm">
                    <input type="hidden" id="assignUserId" name="user_id">
                    
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('User')); ?></label>
                        <input type="text" id="assignUsername" class="form-control" readonly>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Select Referrer')); ?></label>
                        <select id="referrerSelect" name="referrer_id" class="form-control" required style="max-height: 200px; overflow-y: auto;">
                            <option value=""><?php echo e(__('Choose referrer...')); ?></option>
                        </select>
                        <small class="text-muted"><?php echo e(__('Showing all available users. Use search below to filter.')); ?></small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Search Users')); ?></label>
                        <input type="text" id="userSearch" class="form-control" placeholder="<?php echo e(__('Type username or email to filter users...')); ?>">
                        <div id="searchResults" class="mt-2 border rounded p-2" style="max-height: 200px; overflow-y: auto; display: none;"></div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <button type="button" class="btn btn-primary" onclick="submitAssignReferrer()"><?php echo e(__('Assign Referrer')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Referral Tree Modal -->
<div class="modal fade" id="referralTreeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Referral Tree')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="referralTreeContent"></div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<style>
/* Enhance dropdown styling */
#referrerSelect {
    max-height: 200px;
    overflow-y: auto;
}

/* Search results styling */
.search-result-item {
    transition: background-color 0.2s ease;
    cursor: pointer;
}

.search-result-item:hover {
    background-color: #f8f9fa !important;
}

.hover-bg-light:hover {
    background-color: #f8f9fa !important;
}

/* Modal improvements */
.modal-dialog {
    max-width: 600px;
}

.modal-body {
    max-height: 70vh;
    overflow-y: auto;
}

/* Dropdown select styling */
.form-control:focus {
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    border-color: #80bdff;
}

/* Search results container */
#searchResults {
    border: 1px solid #dee2e6;
    border-radius: 0.375rem;
    background-color: #fff;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

#searchResults:empty {
    display: none !important;
}

/* User icon styling */
.fas.fa-user-circle {
    font-size: 1.5rem;
}

/* Scrollbar styling */
::-webkit-scrollbar {
    width: 8px;
}

::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 4px;
}

::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
let currentUserId = null;

function showAssignReferrerModal() {
    const modal = new bootstrap.Modal(document.getElementById('assignReferrerModal'));
    modal.show();
    loadAllUsers();
}

function assignReferrer(userId, username) {
    currentUserId = userId;
    $('#assignUserId').val(userId);
    $('#assignUsername').val(username);
    const modal = new bootstrap.Modal(document.getElementById('assignReferrerModal'));
    modal.show();
    loadAllUsers();
}

function loadAllUsers() {
    $.get('<?php echo e(route("admin.referral-management.search-users")); ?>', { q: '', limit: 50 })
        .done(function(users) {
            let options = '<option value=""><?php echo e(__("Choose referrer...")); ?></option>';
            users.forEach(function(user) {
                if (user.id != currentUserId) {
                    options += `<option value="${user.id}">${user.username} (${user.email})</option>`;
                }
            });
            
            if (users.length >= 50) {
                options += `<option disabled><?php echo e(__("... and more. Use search to find specific users.")); ?></option>`;
            }
            
            $('#referrerSelect').html(options);
        })
        .fail(function() {
            $('#referrerSelect').html('<option value=""><?php echo e(__("Error loading users")); ?></option>');
        });
}

$('#userSearch').on('input', function() {
    const query = $(this).val();
    const searchResults = $('#searchResults');
    
    if (query.length < 2) {
        searchResults.hide().html('');
        // Show all users in dropdown again
        loadAllUsers();
        return;
    }
    
    $.get('<?php echo e(route("admin.referral-management.search-users")); ?>', { q: query })
        .done(function(users) {
            let results = '';
            let options = '<option value=""><?php echo e(__("Choose referrer...")); ?></option>';
            
            users.forEach(function(user) {
                if (user.id != currentUserId) {
                    // Add to search results
                    results += `<div class="search-result-item p-2 border-bottom hover-bg-light" style="cursor: pointer;" onclick="selectUser(${user.id}, '${user.username}')">
                        <div class="d-flex align-items-center">
                            <div class="me-2">
                                <i class="fas fa-user-circle text-primary"></i>
                            </div>
                            <div>
                                <strong>${user.username}</strong><br>
                                <small class="text-muted">${user.email}</small>
                            </div>
                        </div>
                    </div>`;
                    
                    // Add to dropdown
                    options += `<option value="${user.id}">${user.username} (${user.email})</option>`;
                }
            });
            
            // Update both search results and dropdown
            if (results) {
                searchResults.html(results).show();
            } else {
                searchResults.html('<div class="p-2 text-muted"><?php echo e(__("No users found")); ?></div>').show();
            }
            
            $('#referrerSelect').html(options);
        })
        .fail(function() {
            searchResults.html('<div class="p-2 text-danger"><?php echo e(__("Error searching users")); ?></div>').show();
        });
});

function selectUser(userId, username) {
    $('#referrerSelect').val(userId);
    $('#searchResults').hide().html('');
    $('#userSearch').val(username);
    
    // Show success feedback
    new Notify({
        status: 'success',
        title: 'Selected',
        text: `${username} selected as referrer`,
        effect: 'fade',
        speed: 300,
        autoclose: true,
        autotimeout: 2000,
        position: 'right top'
    });
}

function submitAssignReferrer() {
    // Validate form
    const userId = $('#assignUserId').val();
    const referrerId = $('#referrerSelect').val();
    
    if (!userId) {
        new Notify({
            status: 'error',
            title: 'Error',
            text: '<?php echo e(__("Please select a user")); ?>',
            effect: 'fade',
            speed: 300,
            customClass: null,
            customIcon: null,
            showIcon: true,
            showCloseButton: true,
            autoclose: true,
            autotimeout: 3000,
            gap: 20,
            distance: 20,
            type: 1,
            position: 'right top'
        });
        return;
    }
    
    if (!referrerId) {
        new Notify({
            status: 'error',
            title: 'Error',
            text: '<?php echo e(__("Please select a referrer")); ?>',
            effect: 'fade',
            speed: 300,
            customClass: null,
            customIcon: null,
            showIcon: true,
            showCloseButton: true,
            autoclose: true,
            autotimeout: 3000,
            gap: 20,
            distance: 20,
            type: 1,
            position: 'right top'
        });
        return;
    }
    
    // Create form data manually to ensure proper data transmission
    const data = {
        user_id: userId,
        referrer_id: referrerId,
        _token: $('meta[name="csrf-token"]').attr('content')
    };
    
    $.ajax({
        url: '<?php echo e(route("admin.referral-management.assign-referrer")); ?>',
        type: 'POST',
        data: data,
        success: function(response) {
            if (response.success) {
                new Notify({
                    status: 'success',
                    title: 'Success',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    customClass: null,
                    customIcon: null,
                    showIcon: true,
                    showCloseButton: true,
                    autoclose: true,
                    autotimeout: 3000,
                    gap: 20,
                    distance: 20,
                    type: 1,
                    position: 'right top'
                });
                
                const modal = bootstrap.Modal.getInstance(document.getElementById('assignReferrerModal'));
                if (modal) {
                    modal.hide();
                }
                setTimeout(() => location.reload(), 1000);
            } else {
                new Notify({
                    status: 'error',
                    title: 'Error',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    customClass: null,
                    customIcon: null,
                    showIcon: true,
                    showCloseButton: true,
                    autoclose: true,
                    autotimeout: 3000,
                    gap: 20,
                    distance: 20,
                    type: 1,
                    position: 'right top'
                });
            }
        },
        error: function(xhr) {
            let errorMessage = '<?php echo e(__("An error occurred")); ?>';
            
            if (xhr.responseJSON) {
                if (xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                } else if (xhr.responseJSON.errors) {
                    errorMessage = Object.values(xhr.responseJSON.errors).flat().join(', ');
                }
            } else if (xhr.responseText) {
                errorMessage = xhr.responseText;
            }
            
            new Notify({
                status: 'error',
                title: 'Error',
                text: errorMessage,
                effect: 'fade',
                speed: 300,
                customClass: null,
                customIcon: null,
                showIcon: true,
                showCloseButton: true,
                autoclose: true,
                autotimeout: 5000,
                gap: 20,
                distance: 20,
                type: 1,
                position: 'right top'
            });
        }
    });
}

function removeReferrer(userId, username) {
    if (confirm(`<?php echo e(__('Are you sure you want to remove the referrer for')); ?> ${username}?`)) {
        $.post('<?php echo e(route("admin.referral-management.remove-referrer")); ?>', {
            user_id: userId,
            _token: $('meta[name="csrf-token"]').attr('content')
        })
        .done(function(response) {
            if (response.success) {
                new Notify({
                    status: 'success',
                    title: 'Success',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    autoclose: true,
                    autotimeout: 3000,
                    position: 'right top'
                });
                setTimeout(() => location.reload(), 1000);
            } else {
                new Notify({
                    status: 'error',
                    title: 'Error',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    autoclose: true,
                    autotimeout: 3000,
                    position: 'right top'
                });
            }
        })
        .fail(function(xhr) {
            let errorMessage = '<?php echo e(__("An error occurred")); ?>';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMessage = xhr.responseJSON.message;
            }
            new Notify({
                status: 'error',
                title: 'Error',
                text: errorMessage,
                effect: 'fade',
                speed: 300,
                autoclose: true,
                autotimeout: 3000,
                position: 'right top'
            });
        });
    }
}

function viewReferralTree(userId) {
    $.get(`<?php echo e(route("admin.referral-management.referral-tree", ":userId")); ?>`.replace(':userId', userId))
        .done(function(response) {
            if (response.success) {
                displayReferralTree(response.data);
                const modal = new bootstrap.Modal(document.getElementById('referralTreeModal'));
                modal.show();
            } else {
                new Notify({
                    status: 'error',
                    title: 'Error',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    autoclose: true,
                    autotimeout: 3000,
                    position: 'right top'
                });
            }
        });
}

function displayReferralTree(data) {
    let treeHtml = `
        <div class="referral-tree">
            <div class="root-user text-center p-3 bg-primary text-white rounded mb-3">
                <h5>${data.username}</h5>
                <small>${data.email}</small>
            </div>
    `;
    
    if (data.referrals.length > 0) {
        treeHtml += '<div class="referrals-list">';
        data.referrals.forEach(function(referral) {
            treeHtml += `
                <div class="referral-item p-2 border rounded mb-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <strong>${referral.username}</strong><br>
                            <small>${referral.email}</small>
                        </div>
                        <div class="text-end">
                            <span class="badge bg-info">${referral.referral_count} referrals</span><br>
                            <small>${referral.join_date}</small>
                        </div>
                    </div>
                </div>
            `;
        });
        treeHtml += '</div>';
    } else {
        treeHtml += '<p class="text-center text-muted"><?php echo e(__("No referrals found")); ?></p>';
    }
    
    treeHtml += '</div>';
    $('#referralTreeContent').html(treeHtml);
}

// Avatar Generation Functions
function generateAvatar(userId, username) {
    if (confirm(`<?php echo e(__('Generate new avatar for')); ?> ${username}?`)) {
        $.post(`<?php echo e(route("admin.referral-management.generate-avatar", ":userId")); ?>`.replace(':userId', userId), {
            _token: $('meta[name="csrf-token"]').attr('content')
        })
        .done(function(response) {
            if (response.success) {
                new Notify({
                    status: 'success',
                    title: 'Success',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    autoclose: true,
                    autotimeout: 3000,
                    position: 'right top'
                });
                setTimeout(() => location.reload(), 1000);
            } else {
                new Notify({
                    status: 'error',
                    title: 'Error',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    autoclose: true,
                    autotimeout: 3000,
                    position: 'right top'
                });
            }
        })
        .fail(function(xhr) {
            let errorMessage = '<?php echo e(__("An error occurred")); ?>';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMessage = xhr.responseJSON.message;
            }
            new Notify({
                status: 'error',
                title: 'Error',
                text: errorMessage,
                effect: 'fade',
                speed: 300,
                autoclose: true,
                autotimeout: 3000,
                position: 'right top'
            });
        });
    }
}

function generateAvatarsForAllUsers() {
    if (confirm('<?php echo e(__("Generate avatars for ALL users? This may take a few moments.")); ?>')) {
        // Show loading state
        const button = event.target;
        const originalText = button.innerHTML;
        button.innerHTML = '<i icon-name="loader-2" class="animate-spin"></i> <?php echo e(__("Generating...")); ?>';
        button.disabled = true;
        
        $.post('<?php echo e(route("admin.referral-management.generate-avatars-all")); ?>', {
            _token: $('meta[name="csrf-token"]').attr('content')
        })
        .done(function(response) {
            if (response.success) {
                new Notify({
                    status: 'success',
                    title: 'Success',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    autoclose: true,
                    autotimeout: 3000,
                    position: 'right top'
                });
                setTimeout(() => location.reload(), 2000);
            } else {
                new Notify({
                    status: 'error',
                    title: 'Error',
                    text: response.message,
                    effect: 'fade',
                    speed: 300,
                    autoclose: true,
                    autotimeout: 3000,
                    position: 'right top'
                });
            }
        })
        .fail(function(xhr) {
            let errorMessage = '<?php echo e(__("An error occurred")); ?>';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMessage = xhr.responseJSON.message;
            }
            new Notify({
                status: 'error',
                title: 'Error',
                text: errorMessage,
                effect: 'fade',
                speed: 300,
                autoclose: true,
                autotimeout: 3000,
                position: 'right top'
            });
        })
        .always(function() {
            // Restore button state
            button.innerHTML = originalText;
            button.disabled = false;
        });
    }
}
</script>

<style>
.stat-card {
    transition: transform 0.2s;
}
.stat-card:hover {
    transform: translateY(-2px);
}
.search-result-item {
    cursor: pointer;
    transition: background-color 0.2s;
}
.search-result-item:hover {
    background-color: #f8f9fa;
}
.referral-tree .root-user {
    position: relative;
}
.referral-tree .root-user::after {
    content: '';
    position: absolute;
    bottom: -10px;
    left: 50%;
    transform: translateX(-50%);
    width: 0;
    height: 0;
    border-left: 10px solid transparent;
    border-right: 10px solid transparent;
    border-top: 10px solid #007bff;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/backend/referral-management/index.blade.php ENDPATH**/ ?>