<?php

$allowedExtensions = ['jpg', 'php', 'jpeg', 'png', 'gif', 'pdf', 'zip'];


$uploadDir = 'uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}


$maxFileSize = 2 * 1024 * 1024;


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['fileToUpload'])) {
    $file = $_FILES['fileToUpload'];


    if ($file['error'] !== UPLOAD_ERR_OK) {
        echo "Error: " . $file['error'];
        exit;
    }


    if ($file['size'] > $maxFileSize) {
        echo "Error: File size exceeds 2MB limit.";
        exit;
    }


    $fileName = basename($file['name']);
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    $fileName = preg_replace('/[^a-zA-Z0-9._-]/', '', $fileName);


    if (!in_array($fileExt, $allowedExtensions)) {
        echo "Error: Invalid file type.";
        exit;
    }


    $uploadFile = $uploadDir . $fileName;


    if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
        echo "File successfully uploaded!";
    } else {
        echo "Error: File could not be uploaded.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loading</title>
</head>
<body>
    <h1>Upload-File</h1>
    <form action="exceptionseven.php" method="post" enctype="multipart/form-data">
        <input type="file" name="fileToUpload" id="fileToUpload" required>
        <input type="submit" value="Upload File" name="submit">
    </form>
</body>
</html>
